/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.comparch;

import com.lotus.sametime.core.comparch.ComponentListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.MessageDispatcher;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompEvent;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STEventListener;
import com.lotus.sametime.core.comparch.STSession;

public class STCompPart {
    private String m_name = null;
    private STSession m_session = null;
    private boolean m_active = false;
    private static int c_nextUniqueId = 1;

    public STCompPart(String string, STSession sTSession) throws DuplicateObjectException {
        this.m_session = sTSession;
        this.m_name = string;
        MessageDispatcher messageDispatcher = this.m_session.getDispatcher();
        messageDispatcher.addSTEventListener(new STEventListener(){

            public void processSTEvent(STEvent sTEvent) {
                STCompPart.this.processSTEvent(sTEvent);
            }
        });
        sTSession.addComponentListener(new ComponentListener(){

            public void componentLoaded(STCompApi sTCompApi) {
                STCompPart.this.componentLoaded(sTCompApi);
            }
        });
    }

    protected void start() {
    }

    protected void stop() {
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof STCompEvent) {
            switch (sTEvent.getId()) {
                case 0: {
                    this.start();
                    this.m_active = true;
                    sTEvent.setConsumed(true);
                    break;
                }
                case 1: {
                    this.m_active = false;
                    this.stop();
                    sTEvent.setConsumed(true);
                }
            }
        }
    }

    protected void componentLoaded(STCompApi sTCompApi) {
    }

    protected void sendEvent(STEvent sTEvent) {
        MessageDispatcher messageDispatcher = this.m_session.getDispatcher();
        messageDispatcher.sendEvent(sTEvent);
    }

    public String toString() {
        return "{" + this.m_name + "(part), STSession = " + this.m_session + "}";
    }

    public STSession getSession() {
        return this.m_session;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public static synchronized Integer getUniqueId() {
        Integer n = new Integer(c_nextUniqueId++);
        return n;
    }
}

