/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.comparch;

import com.lotus.sametime.core.comparch.DispatchingThreadPool;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STEventListener;
import com.lotus.sametime.core.util.Queue;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageDispatcher
extends Queue {
    private DispatchingThreadPool m_pool;
    private boolean m_started = false;
    private STEventListener[] m_listenerList = new STEventListener[0];
    private boolean m_swingThreadingEnabled = false;
    private Method m_swingInvocationMethod = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.comparch");

    public MessageDispatcher() {
        this(null);
    }

    public MessageDispatcher(DispatchingThreadPool dispatchingThreadPool) {
        this.m_pool = dispatchingThreadPool != null ? dispatchingThreadPool : new DispatchingThreadPool();
    }

    void start() {
        this.m_pool.registerQueue(this);
        this.m_started = true;
        if (!this.isEmpty()) {
            this.m_pool.dispatchLater(this);
        }
    }

    void stop() {
        this.m_started = false;
        this.m_pool.unregisterQueue(this);
    }

    public void flush() {
        while (!this.isEmpty()) {
            STEvent sTEvent = null;
            sTEvent = (STEvent)this.getNext();
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "flush", this + ": Dispatching event: " + (null != sTEvent ? sTEvent.toString() : "null event"));
            }
            this.dispatch(sTEvent);
        }
    }

    public void sendEvent(STEvent sTEvent) {
        if (this.m_swingThreadingEnabled) {
            this.postSwingEvent(sTEvent);
        } else {
            this.put(sTEvent);
            if (this.m_started) {
                this.m_pool.dispatchLater(this);
            }
        }
    }

    protected void postSwingEvent(STEvent sTEvent) {
        block2: {
            try {
                Object[] objectArray = new Object[]{new DispatchEvent(sTEvent)};
                this.getSwingInvocationMethod().invoke(null, objectArray);
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block2;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "postSwingEvent", "getSwingInvocationMethod", exception);
            }
        }
    }

    protected synchronized Method getSwingInvocationMethod() throws Exception {
        if (this.m_swingInvocationMethod == null) {
            Class[] classArray = new Class[]{Runnable.class};
            this.m_swingInvocationMethod = Class.forName("javax.swing.SwingUtilities").getMethod("invokeLater", classArray);
        }
        return this.m_swingInvocationMethod;
    }

    public synchronized void addSTEventListener(STEventListener sTEventListener) {
        boolean bl = false;
        for (int i = 0; i < this.m_listenerList.length; ++i) {
            if (sTEventListener != this.m_listenerList[i]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            int n = this.m_listenerList.length;
            STEventListener[] sTEventListenerArray = new STEventListener[n + 1];
            System.arraycopy(this.m_listenerList, 0, sTEventListenerArray, 0, n);
            sTEventListenerArray[n] = sTEventListener;
            this.m_listenerList = sTEventListenerArray;
        }
    }

    public synchronized void removeSTEventListener(STEventListener sTEventListener) {
        boolean bl = false;
        int n = this.m_listenerList.length;
        int n2 = 0;
        for (n2 = 0; n2 < this.m_listenerList.length; ++n2) {
            if (sTEventListener != this.m_listenerList[n2]) continue;
            bl = true;
            break;
        }
        if (bl) {
            STEventListener[] sTEventListenerArray = new STEventListener[n - 1];
            System.arraycopy(this.m_listenerList, 0, sTEventListenerArray, 0, n2);
            if (n2 < n - 1) {
                System.arraycopy(this.m_listenerList, n2 + 1, sTEventListenerArray, n2, n - n2 - 1);
            }
            this.m_listenerList = sTEventListenerArray;
        }
    }

    public DispatchingThreadPool getThreadPool() {
        return this.m_pool;
    }

    protected void dispatch(STEvent sTEvent) {
        STEventListener[] sTEventListenerArray = this.m_listenerList;
        for (int i = 0; i < sTEventListenerArray.length; ++i) {
            STEventListener sTEventListener = sTEventListenerArray[i];
            try {
                sTEventListener.processSTEvent(sTEvent);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void setSwingThreadingEnabled(boolean bl) {
        this.m_swingThreadingEnabled = bl;
    }

    class DispatchEvent
    implements Runnable {
        private STEvent event = null;

        public DispatchEvent(STEvent sTEvent) {
            this.event = sTEvent;
        }

        public void run() {
            MessageDispatcher.this.dispatch(this.event);
        }
    }
}

