/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.comparch;

import com.lotus.sametime.core.comparch.MessageDispatcher;
import com.lotus.sametime.core.comparch.MessageDispatchingThread;
import com.lotus.sametime.core.util.Queue;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DispatchingThreadPool {
    private static final long THREAD_SLEEP = 1000L;
    private int m_threadCount = 0;
    private int m_availableThreads = 0;
    private int m_queueCount = 0;
    private Queue m_waitingQueues = new Queue();
    private Hashtable m_activeQueues = new Hashtable();
    private int m_maxThreads;
    private int m_threadTimeout;
    private boolean m_stopped = false;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.comparch");

    public DispatchingThreadPool() {
        this(Integer.MAX_VALUE, -1);
    }

    public DispatchingThreadPool(int n, int n2) {
        this.m_maxThreads = n;
        this.m_threadTimeout = n2;
    }

    synchronized void dispatchLater(MessageDispatcher messageDispatcher) {
        if (this.m_waitingQueues.contains(messageDispatcher) || this.m_activeQueues.containsKey(messageDispatcher)) {
            return;
        }
        this.m_waitingQueues.put(messageDispatcher);
        if (this.m_availableThreads > 0) {
            this.notify();
        } else if (this.m_threadCount < this.m_maxThreads) {
            MessageDispatchingThread messageDispatchingThread = new MessageDispatchingThread(this);
            ++this.m_threadCount;
            messageDispatchingThread.start();
        }
    }

    synchronized MessageDispatcher getQueue() {
        ++this.m_availableThreads;
        long l = System.currentTimeMillis() / 1000L;
        while (this.m_waitingQueues.isEmpty() && !this.m_stopped) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l2 = System.currentTimeMillis() / 1000L;
            if (this.m_threadTimeout <= 0 || l2 - l < (long)this.m_threadTimeout) continue;
            this.m_stopped = true;
        }
        --this.m_availableThreads;
        if (this.m_waitingQueues.isEmpty()) {
            --this.m_threadCount;
            return null;
        }
        MessageDispatcher messageDispatcher = (MessageDispatcher)this.m_waitingQueues.getNext();
        this.m_activeQueues.put(messageDispatcher, messageDispatcher);
        return messageDispatcher;
    }

    synchronized void unlockQueue(MessageDispatcher messageDispatcher) {
        this.m_activeQueues.remove(messageDispatcher);
        if (!messageDispatcher.isEmpty()) {
            this.dispatchLater(messageDispatcher);
        }
    }

    synchronized void registerQueue(MessageDispatcher messageDispatcher) {
        if (this.m_stopped) {
            this.m_stopped = false;
        }
        ++this.m_queueCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterQueue(MessageDispatcher messageDispatcher) {
        DispatchingThreadPool dispatchingThreadPool = this;
        synchronized (dispatchingThreadPool) {
            --this.m_queueCount;
        }
        if (this.m_queueCount == 0) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "unregisterQueue", "Stopping pool threads");
            }
            this.m_stopped = true;
        }
    }
}

