/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.conf;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.ChannelServiceListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.conf.ConfEvent;
import com.lotus.sametime.conf.ConfInfo;
import com.lotus.sametime.conf.ConfsTable;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.DualKeyTable;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfImpl
extends STCompImpl
implements ChannelListener,
ChannelServiceListener,
LoginListener,
ServiceListener {
    private static final short CHAT_SNAPSHOT = 0;
    private static final short CHAT_INVITE = 1;
    private static final short CHAT_ENTER = 2;
    private static final short CHAT_LEAVE = 3;
    private static final short CHAT_SAY = 4;
    private static final short CHAT_INTRUDE = 5;
    private static final short CHAT_WHISPER = 6;
    private static final int WHISPER_INVITE_DECLINED = 0;
    private static final int CHAT_JOIN_OPT_NEW = 1;
    private static final int CHAT_INVITE_OPT_AUTO = 1;
    private static final int CHAT_OPT_NONE = 0;
    private static final int CONF_VPO_TEXT = 1;
    private static final int CONF_VPO_DATA = 2;
    private DualKeyTable m_channels = new DualKeyTable();
    private ConfsTable m_confsTable = new ConfsTable();
    private ChannelService m_channelService;
    private CommunityService m_commService;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.conf");

    public ConfImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.conf.ConfComp", sTSession);
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_channelService != null) {
            this.m_channelService.addChannelServiceListener(this);
        }
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_commService != null) {
            this.m_commService.addServiceListener(this);
            this.m_commService.addLoginListener(this);
        }
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
        this.m_commService.removeServiceListener(this);
        this.m_commService.removeLoginListener(this);
        this.m_channelService.removeChannelServiceListener(this);
        Enumeration enumeration = this.m_channels.keys();
        while (enumeration.hasMoreElements()) {
            Channel channel = (Channel)enumeration.nextElement();
            channel.removeChannelListener(this);
            if (!channel.isOpen()) continue;
            channel.close(0, null);
        }
        this.m_channels.clear();
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (this.m_channelService == null && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
            this.m_channelService.addChannelServiceListener(this);
        }
        if (this.m_commService == null && sTCompApi instanceof CommunityService) {
            this.m_commService = (CommunityService)sTCompApi;
            this.m_commService.addLoginListener(this);
            this.m_commService.addServiceListener(this);
        }
    }

    public void createConference(Integer n, ConfInfo confInfo, EncLevel encLevel) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            confInfo.writeConfInfo(ndrOutputStream);
            ndrOutputStream.writeInt(0);
            Channel channel = this.m_channelService.createChannel(-2147483632, 16, 2, encLevel, ndrOutputStream.toByteArray(), null);
            channel.addChannelListener(this);
            channel.open();
            this.m_channels.put(n, channel);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "createConference", "CONF: Failed to create channel");
            }
            iOException.printStackTrace();
        }
    }

    public void joinToConference(Integer n) {
        Channel channel = (Channel)this.m_channels.getValue(n);
        Debug.stAssert(channel != null && channel.isOpen());
        if (channel != null && channel.isOpen()) {
            channel.sendMsg((short)2, null, false);
        }
    }

    public void inviteToConference(Integer n, STId sTId, String string, STLoginId sTLoginId, String string2) {
        this.inviteConfCommon(n, sTId, sTLoginId, string, string2, false);
    }

    public void autoInviteToConference(Integer n, STId sTId, String string, STLoginId sTLoginId, String string2) {
        this.inviteConfCommon(n, sTId, sTLoginId, string, string2, true);
    }

    public void declineInvitation(Integer n, int n2) {
        Channel channel = (Channel)this.m_channels.removeKey(n);
        Debug.stAssert(channel != null && channel.isOpen());
        if (channel != null && channel.isOpen()) {
            channel.close(n2, null);
        }
    }

    public void sendText(Integer n, boolean bl, String string) {
        Channel channel = (Channel)this.m_channels.getValue(n);
        if (channel == null || !channel.isOpen()) {
            Debug.stAssert(false);
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(1);
            ndrOutputStream.writeUTF(string);
            channel.sendMsg((short)4, ndrOutputStream.toByteArray(), bl);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendText", "CONF: Failed to send text");
            }
            iOException.printStackTrace();
        }
    }

    public void sendData(Integer n, boolean bl, int n2, int n3, byte[] byArray) {
        Channel channel = (Channel)this.m_channels.getValue(n);
        if (channel == null || !channel.isOpen()) {
            Debug.stAssert(false);
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(2);
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.writeInt(n3);
            if (byArray != null) {
                ndrOutputStream.writeInt(byArray.length);
                ndrOutputStream.write(byArray);
            } else {
                ndrOutputStream.writeInt(0);
            }
            channel.sendMsg((short)4, ndrOutputStream.toByteArray(), bl);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendData", "CONF: Failed to send text");
            }
            iOException.printStackTrace();
        }
    }

    public void destroyConference(Integer n) {
        Channel channel = (Channel)this.m_channels.removeKey(n);
        if (channel == null || !channel.isOpen()) {
            Debug.stAssert(false);
            return;
        }
        channel.close(0, null);
    }

    public void channelOpened(ChannelEvent channelEvent) {
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
        Integer n = (Integer)this.m_channels.getKey(channel);
        try {
            switch (channelEvent.getMessageType()) {
                case 0: {
                    this.handleSnapshotMessage(ndrInputStream, channel);
                    break;
                }
                case 2: {
                    this.handleEnterMessage(ndrInputStream, n);
                    break;
                }
                case 3: {
                    this.handleLeaveMessage(ndrInputStream, n);
                    break;
                }
                case 4: {
                    this.handleSayMessage(ndrInputStream, n, channelEvent.isEncrypted());
                    break;
                }
                case 5: {
                    short s = ndrInputStream.readShort();
                    this.sendEvent(new ConfEvent((Object)this, -2147483644, n, s));
                    break;
                }
                case 6: {
                    this.handleWhisperMessage(ndrInputStream, n);
                }
            }
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelMsgReceived", "CONF: Failed to unpack the sent message");
            }
            iOException.printStackTrace();
        }
    }

    public void channelClosed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        int n = channelEvent.getReason();
        Integer n2 = (Integer)this.m_channels.removeValue(channel);
        if (n2 != null) {
            this.sendEvent(new ConfEvent((Object)this, -2147483643, n2, n));
        }
        if (n == -2147483635) {
            this.sendEvent(new ConfEvent(this, -2147483636));
            this.requestServiceUpNotification();
        }
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        int n = channelEvent.getReason();
        Integer n2 = (Integer)this.m_channels.removeValue(channel);
        if (n2 != null) {
            this.sendEvent(new ConfEvent((Object)this, -2147483642, n2, n));
        }
        if (n == -2147483635) {
            this.sendEvent(new ConfEvent(this, -2147483636));
            this.requestServiceUpNotification();
        }
    }

    public void channelReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        if (channel.getServiceType() != -2147483632 || channel.getProtocolType() != 16) {
            return;
        }
        STUserStatus sTUserStatus = this.m_commService.getLogin().getMyStatus();
        if (sTUserStatus.isStatus((short)128)) {
            channel.close(-2147475455, null);
            return;
        }
        if (this.isServerOld() && channel.getProtocolVersion() == 3) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelReceived", "CONF: Got an encrypted invitation while working with 1.0 server. DECLINING");
            }
            channel.close(-2147483619, null);
            return;
        }
        Integer n = ConfImpl.getUniqueId();
        this.m_channels.put(n, channel);
        channel.addChannelListener(this);
        byte[] byArray = channel.getCreateData();
        EncLevel encLevel = channel.getEncLevel();
        channel.accept(encLevel, byArray);
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            ndrInputStream.skip(4L);
            ConfInfo confInfo = ConfInfo.readConfInfo(ndrInputStream);
            STUserInstance sTUserInstance = new STUserInstance(ndrInputStream);
            int n2 = ndrInputStream.readInt();
            String string = ndrInputStream.readUTF();
            ConfEvent confEvent = new ConfEvent((Object)this, -2147483641, n, confInfo, sTUserInstance, encLevel, n2 == 1, string);
            this.sendEvent(confEvent);
            if (n2 == 1) {
                channel.sendMsg((short)2, null, false);
            }
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelReceived", "CONF: Failed to create accept message");
            }
            iOException.printStackTrace();
        }
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_channels.clear();
    }

    public void loggedIn(LoginEvent loginEvent) {
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        int n = serviceEvent.getServiceType();
        if (n != -2147483632) {
            return;
        }
        this.sendEvent(new ConfEvent(this, -2147483637));
    }

    private void handleSnapshotMessage(NdrInputStream ndrInputStream, Channel channel) throws IOException {
        Integer n = (Integer)this.m_channels.getKey(channel);
        EncLevel encLevel = channel.getEncLevel();
        ConfInfo confInfo = ConfInfo.readConfInfo(ndrInputStream);
        ndrInputStream.readShort();
        int n2 = ndrInputStream.readInt();
        STUserInstance[] sTUserInstanceArray = new STUserInstance[n2];
        for (int i = 0; i < n2; ++i) {
            short s = ndrInputStream.readShort();
            sTUserInstanceArray[i] = new STUserInstance(ndrInputStream);
            STLoginId sTLoginId = sTUserInstanceArray[i].getLoginId();
            this.m_confsTable.put(n, s, sTLoginId);
        }
        this.sendEvent(new ConfEvent((Object)this, -2147483639, n, confInfo, encLevel, sTUserInstanceArray));
    }

    private void handleEnterMessage(NdrInputStream ndrInputStream, Integer n) throws IOException {
        short s = ndrInputStream.readShort();
        STUserInstance sTUserInstance = new STUserInstance(ndrInputStream);
        STLoginId sTLoginId = sTUserInstance.getLoginId();
        this.m_confsTable.put(n, s, sTLoginId);
        this.sendEvent(new ConfEvent((Object)this, -2147483647, n, sTUserInstance));
    }

    private void handleLeaveMessage(NdrInputStream ndrInputStream, Integer n) throws IOException {
        short s = ndrInputStream.readShort();
        STLoginId sTLoginId = this.m_confsTable.remove(n, s);
        this.sendEvent(new ConfEvent((Object)this, -2147483646, n, sTLoginId));
    }

    private void handleSayMessage(NdrInputStream ndrInputStream, Integer n, boolean bl) throws IOException {
        short s = ndrInputStream.readShort();
        STLoginId sTLoginId = this.m_confsTable.get(n, s);
        ndrInputStream.skip(4L);
        ConfEvent confEvent = null;
        int n2 = ndrInputStream.readInt();
        switch (n2) {
            case 1: {
                String string = ndrInputStream.readUTF();
                confEvent = new ConfEvent((Object)this, -2147483645, n, bl, sTLoginId, string);
                break;
            }
            case 2: {
                int n3 = ndrInputStream.readInt();
                int n4 = ndrInputStream.readInt();
                int n5 = ndrInputStream.readInt();
                byte[] byArray = new byte[n5];
                if (ndrInputStream.read(byArray) == -1) {
                    byArray = null;
                }
                confEvent = new ConfEvent((Object)this, -2147483638, n, bl, sTLoginId, n3, n4, byArray);
            }
        }
        this.sendEvent(confEvent);
    }

    private void handleWhisperMessage(NdrInputStream ndrInputStream, Integer n) throws IOException {
        int n2 = ndrInputStream.readInt();
        if (n2 != 0) {
            return;
        }
        ndrInputStream.skip(4L);
        STUserInstance sTUserInstance = new STUserInstance(ndrInputStream);
        int n3 = ndrInputStream.readInt();
        this.sendEvent(new ConfEvent((Object)this, -2147483640, n, sTUserInstance, n3));
    }

    private void inviteConfCommon(Integer n, STId sTId, STLoginId sTLoginId, String string, String string2, boolean bl) {
        STUserInstance sTUserInstance;
        Channel channel = (Channel)this.m_channels.getValue(n);
        Debug.stAssert(channel != null && channel.isOpen());
        if (sTLoginId == null) {
            sTLoginId = new STLoginId("", "");
        }
        if (sTId.equals((sTUserInstance = this.m_commService.getLogin().getMyUserInstance()).getId())) {
            return;
        }
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeUTF(sTId.getId());
            ndrOutputStream.writeUTF(sTLoginId.getId());
            ndrOutputStream.writeUTF(sTId.getCommunityName());
            ndrOutputStream.writeInt(bl ? 1 : 0);
            ndrOutputStream.writeUTF(string2);
            ndrOutputStream.writeUTF(string);
            channel.sendMsg((short)1, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "inviteConfCommon", "CONF: Failed to create invite message");
            }
            iOException.printStackTrace();
        }
    }

    private void requestServiceUpNotification() {
        this.m_commService.senseService(-2147483632);
    }

    private boolean isServerOld() {
        int n = this.m_commService.getLogin().getServerVersion();
        short s = (short)(n >> 16);
        short s2 = (short)(n & 0xFFFF);
        return s == 30 && s2 == 23;
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof ConfEvent) {
            this.processConfEvent((ConfEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processConfEvent(ConfEvent confEvent) {
        switch (confEvent.getId()) {
            case 5: {
                this.createConference(confEvent.getConfId(), confEvent.getConfInfo(), confEvent.getEncLevel());
                confEvent.setConsumed(true);
                break;
            }
            case 4: {
                this.joinToConference(confEvent.getConfId());
                confEvent.setConsumed(true);
                break;
            }
            case 3: {
                this.destroyConference(confEvent.getConfId());
                confEvent.setConsumed(true);
                break;
            }
            case 6: {
                this.declineInvitation(confEvent.getConfId(), confEvent.getReason());
                confEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.sendText(confEvent.getConfId(), confEvent.getEncrypted(), confEvent.getText());
                confEvent.setConsumed(true);
                break;
            }
            case 7: {
                this.sendData(confEvent.getConfId(), confEvent.getEncrypted(), confEvent.getDataType(), confEvent.getDataSubType(), confEvent.getData());
                confEvent.setConsumed(true);
                break;
            }
            case 1: {
                if (confEvent.getAuto()) {
                    this.autoInviteToConference(confEvent.getConfId(), confEvent.getUserId(), confEvent.getUserName(), confEvent.getLoginId(), confEvent.getInvitation());
                } else {
                    this.inviteToConference(confEvent.getConfId(), confEvent.getUserId(), confEvent.getUserName(), confEvent.getLoginId(), confEvent.getInvitation());
                }
                confEvent.setConsumed(true);
            }
        }
    }
}

