/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.conf;

import com.lotus.sametime.conf.ConfEvent;
import com.lotus.sametime.conf.ConfImpl;
import com.lotus.sametime.conf.ConfInfo;
import com.lotus.sametime.conf.ConfListener;
import com.lotus.sametime.conf.ConfService;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STUserInstance;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfComp
extends STComp
implements ConfService {
    private Vector m_ConfListeners = new Vector();
    private ConfImpl m_impl = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.conf");

    public ConfComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.conf.ConfComp", sTSession);
        this.m_impl = new ConfImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public void addConfListener(ConfListener confListener) {
        this.m_ConfListeners.addElement(confListener);
    }

    public void removeConfListener(ConfListener confListener) {
        this.m_ConfListeners.removeElement(confListener);
    }

    public Integer createConference(ConfInfo confInfo, EncLevel encLevel) {
        Integer n = STCompPart.getUniqueId();
        ConfEvent confEvent = new ConfEvent((Object)this, 5, n, confInfo, encLevel);
        this.sendEvent(confEvent);
        return n;
    }

    public void joinToConference(Integer n) {
        ConfEvent confEvent = new ConfEvent(this, 4, n);
        this.sendEvent(confEvent);
    }

    public void destroyConference(Integer n) {
        ConfEvent confEvent = new ConfEvent((Object)this, 3, n, 0);
        this.sendEvent(confEvent);
    }

    public void inviteToConference(Integer n, STId sTId, String string, STLoginId sTLoginId, String string2) {
        ConfEvent confEvent = new ConfEvent((Object)this, 1, n, sTId, string, sTLoginId, string2, false);
        this.sendEvent(confEvent);
    }

    public void autoInviteToConference(Integer n, STId sTId, String string, STLoginId sTLoginId, String string2) {
        ConfEvent confEvent = new ConfEvent((Object)this, 1, n, sTId, string, sTLoginId, string2, true);
        this.sendEvent(confEvent);
    }

    public void declineInvitation(Integer n, int n2) {
        ConfEvent confEvent = new ConfEvent((Object)this, 6, n, n2);
        this.sendEvent(confEvent);
    }

    public void sendText(Integer n, boolean bl, String string) {
        ConfEvent confEvent = new ConfEvent((Object)this, 2, n, bl, string);
        this.sendEvent(confEvent);
    }

    public void sendData(Integer n, boolean bl, int n2, int n3, byte[] byArray) {
        ConfEvent confEvent = new ConfEvent(this, 7, n, bl, n2, n3, byArray);
        this.sendEvent(confEvent);
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof ConfEvent) {
            this.processConfEvent((ConfEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processConfEvent(ConfEvent confEvent) {
        switch (confEvent.getId()) {
            case -2147483639: {
                this.conferenceCreated(confEvent.getConfId(), confEvent.getConfInfo(), confEvent.getEncLevel(), confEvent.getParticipants());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483642: {
                this.conferenceDenied(confEvent.getConfId(), confEvent.getReason());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483643: {
                this.conferenceDestroyed(confEvent.getConfId(), confEvent.getReason());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483641: {
                this.invitedToConference(confEvent.getConfId(), confEvent.getConfInfo(), confEvent.getUserInfo(), confEvent.getEncLevel(), confEvent.getAuto(), confEvent.getInvitation());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483640: {
                this.invitationDeclined(confEvent.getConfId(), confEvent.getUserInfo(), confEvent.getReason());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483647: {
                this.userEntered(confEvent.getConfId(), confEvent.getUserInfo());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.userLeft(confEvent.getConfId(), confEvent.getLoginId());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483644: {
                this.conferenceIntruded(confEvent.getConfId(), confEvent.getUserInfo(), confEvent.getIntrudeCode());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483645: {
                this.textReceived(confEvent.getConfId(), confEvent.getEncrypted(), confEvent.getLoginId(), confEvent.getText());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483638: {
                this.dataReceived(confEvent.getConfId(), confEvent.getEncrypted(), confEvent.getLoginId(), confEvent.getDataType(), confEvent.getDataSubType(), confEvent.getData());
                confEvent.setConsumed(true);
                break;
            }
            case -2147483637: {
                this.serviceAvailable();
                confEvent.setConsumed(true);
                break;
            }
            case -2147483636: {
                this.serviceUnavailable();
                confEvent.setConsumed(true);
            }
        }
    }

    public void conferenceCreated(Integer n, ConfInfo confInfo, EncLevel encLevel, STUserInstance[] sTUserInstanceArray) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.conferenceCreated(n, confInfo, encLevel, sTUserInstanceArray);
        }
    }

    public void conferenceDenied(Integer n, int n2) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.conferenceDenied(n, n2);
        }
    }

    public void conferenceDestroyed(Integer n, int n2) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.conferenceDestroyed(n, n2);
        }
    }

    public void invitedToConference(Integer n, ConfInfo confInfo, STUserInstance sTUserInstance, EncLevel encLevel, boolean bl, String string) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.invitedToConference(n, confInfo, sTUserInstance, encLevel, bl, string);
        }
    }

    public void invitationDeclined(Integer n, STUserInstance sTUserInstance, int n2) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.invitationDeclined(n, sTUserInstance, n2);
        }
    }

    public void userEntered(Integer n, STUserInstance sTUserInstance) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.userEntered(n, sTUserInstance);
        }
    }

    public void userLeft(Integer n, STLoginId sTLoginId) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.userLeft(n, sTLoginId);
        }
    }

    public void textReceived(Integer n, boolean bl, STLoginId sTLoginId, String string) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.textReceived(n, bl, sTLoginId, string);
        }
    }

    public void dataReceived(Integer n, boolean bl, STLoginId sTLoginId, int n2, int n3, byte[] byArray) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.dataReceived(n, bl, sTLoginId, n2, n3, byArray);
        }
    }

    public void conferenceIntruded(Integer n, STUserInstance sTUserInstance, short s) {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.conferenceIntruded(n, sTUserInstance, s);
        }
    }

    public void serviceAvailable() {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.serviceAvailable();
        }
    }

    public void serviceUnavailable() {
        Enumeration enumeration = this.m_ConfListeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfListener confListener = (ConfListener)enumeration.nextElement();
            confListener.serviceUnavailable();
        }
    }
}

