/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel.enc.rc2_128;

import com.lotus.sametime.community.kernel.enc.EncParams;
import com.lotus.sametime.community.kernel.enc.rc2_128.EncMethodRc2_128;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.RandomGenerator;
import com.lotus.sametime.core.util.enc.DiffieHellman;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.IOException;
import java.util.Random;

public class EncParamsRc2_128
extends EncParams {
    private static final int RC2_KEY_LENGTH = 16;
    private byte[] m_publicKey;
    private byte[] m_privateKey;
    private byte[] m_agreedKey;
    DiffieHellman m_keyGenerator = new DiffieHellman(DiffieHellman.Default_Modulus, DiffieHellman.Default_Base);
    boolean m_isLocalParams = false;
    RC2Cipher m_encryptionCipher;
    RC2Cipher m_decryptionCipher;

    public EncParamsRc2_128(EncMethodRc2_128 encMethodRc2_128) {
        super(encMethodRc2_128);
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        super.dump(ndrOutputStream);
        ndrOutputStream.writeBytes(this.m_publicKey);
    }

    public void load(NdrInputStream ndrInputStream) throws IOException {
        Debug.stAssert(!this.m_isLocalParams);
        Debug.stAssert(this.m_privateKey == null && this.m_publicKey == null && this.m_agreedKey == null);
        this.m_publicKey = ndrInputStream.readBytes();
    }

    public void generateLocalKeys() {
        Debug.stAssert(this.m_privateKey == null && this.m_publicKey == null && this.m_agreedKey == null);
        Random random = RandomGenerator.getRandomGenerator();
        this.m_privateKey = this.m_keyGenerator.generatePrivateKey(random);
        this.m_publicKey = this.m_keyGenerator.generatePublicKey(this.m_privateKey);
        this.m_isLocalParams = true;
    }

    public void calculateAgreedKey(EncParamsRc2_128 encParamsRc2_128) {
        this.m_agreedKey = this.m_keyGenerator.generateAgreedValue(this.m_privateKey, encParamsRc2_128.getPublicKey());
        byte[] byArray = new byte[16];
        int n = this.m_agreedKey.length - byArray.length;
        Debug.stAssert(n >= 0);
        System.arraycopy(this.m_agreedKey, n, byArray, 0, byArray.length);
        this.m_encryptionCipher = new RC2Cipher();
        this.m_encryptionCipher.init(0, byArray);
        this.m_decryptionCipher = new RC2Cipher();
        this.m_decryptionCipher.init(1, byArray);
    }

    public byte[] getPublicKey() {
        return this.m_publicKey;
    }

    public RC2Cipher getEncryptionCipher() {
        Debug.stAssert(this.m_isLocalParams);
        Debug.stAssert(this.m_encryptionCipher != null);
        return this.m_encryptionCipher;
    }

    public RC2Cipher getDecryptionCipher() {
        Debug.stAssert(this.m_isLocalParams);
        Debug.stAssert(this.m_decryptionCipher != null);
        return this.m_decryptionCipher;
    }
}

