/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel.connhandler;

import com.lotus.sametime.community.kernel.connhandler.CnlMsgListener;
import com.lotus.sametime.core.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class CnlListenerTable {
    private Hashtable m_listenerTable = new Hashtable();
    private Hashtable m_cnlTable = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.community.kernel.connhandler");

    CnlListenerTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListenerForCnl(int n, CnlMsgListener cnlMsgListener) {
        Integer n2 = new Integer(n);
        Debug.stAssert(!this.m_listenerTable.containsKey(n2));
        CnlListenerTable cnlListenerTable = this;
        synchronized (cnlListenerTable) {
            this.m_listenerTable.put(n2, cnlMsgListener);
            Hashtable<Integer, Integer> hashtable = (Hashtable<Integer, Integer>)this.m_cnlTable.get(cnlMsgListener);
            if (hashtable == null) {
                hashtable = new Hashtable<Integer, Integer>();
                this.m_cnlTable.put(cnlMsgListener, hashtable);
            }
            hashtable.put(n2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListenerForCnl(int n) {
        Integer n2 = new Integer(n);
        CnlListenerTable cnlListenerTable = this;
        synchronized (cnlListenerTable) {
            CnlMsgListener cnlMsgListener = (CnlMsgListener)this.m_listenerTable.remove(n2);
            if (cnlMsgListener == null) {
                return;
            }
            Hashtable hashtable = (Hashtable)this.m_cnlTable.get(cnlMsgListener);
            if (hashtable != null) {
                hashtable.remove(n2);
                if (hashtable.isEmpty()) {
                    this.m_listenerTable.remove(cnlMsgListener);
                }
            }
        }
    }

    public synchronized void removeListener(CnlMsgListener cnlMsgListener) {
        if (null == cnlMsgListener) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.m_cnlTable.get(cnlMsgListener);
        if (hashtable != null) {
            this.m_cnlTable.remove(cnlMsgListener);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                Debug.stAssert(this.m_listenerTable.containsKey(n));
                this.m_listenerTable.remove(n);
            }
        }
    }

    public CnlMsgListener getListenerForChannel(int n) {
        Integer n2 = new Integer(n);
        return (CnlMsgListener)this.m_listenerTable.get(n2);
    }

    public Hashtable splitChListByListener(int[] nArray) {
        Hashtable<CnlMsgListener, Vector<Integer>> hashtable = new Hashtable<CnlMsgListener, Vector<Integer>>();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = new Integer(nArray[i]);
            CnlMsgListener cnlMsgListener = (CnlMsgListener)this.m_listenerTable.get(n);
            if (cnlMsgListener == null) {
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "splitChListByListener", "splitChListByListener: unassociated channel " + n);
                continue;
            }
            Vector<Integer> vector = (Vector<Integer>)hashtable.get(cnlMsgListener);
            if (vector == null) {
                vector = new Vector<Integer>();
                hashtable.put(cnlMsgListener, vector);
            }
            vector.addElement(n);
        }
        return hashtable;
    }
}

