/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community;

import com.lotus.sametime.community.AdminMsgEvent;
import com.lotus.sametime.community.AwarenessPermissionEvent;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.MultiCastEvent;
import com.lotus.sametime.community.MyNameEvent;
import com.lotus.sametime.community.MyPrivacyEvent;
import com.lotus.sametime.community.MyStatusEvent;
import com.lotus.sametime.community.OTMEvent;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.kernel.VpKernel;
import com.lotus.sametime.community.kernel.connhandler.ConnectionHandler;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.MessageDispatcher;
import com.lotus.sametime.core.comparch.STCompEvent;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STEventListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STPrivacyList;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Timer;
import com.lotus.sametime.core.util.TimerListener;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STBaseImpl
extends VpKernel
implements STEventListener,
TimerListener {
    private STSession m_session = null;
    private boolean m_active = false;
    private boolean m_loggingIn = false;
    private int m_reconnectAttempts;
    private int m_failedReconnectAttempts;
    private Timer m_reconnectTimer;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.community");

    public STBaseImpl(STSession sTSession) throws DuplicateObjectException {
        this.m_session = sTSession;
        MessageDispatcher messageDispatcher = this.m_session.getDispatcher();
        messageDispatcher.addSTEventListener(this);
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
        if (this.isLoggedIn() || this.m_loggingIn) {
            this.logout(0);
            this.m_loggingIn = false;
        }
    }

    public synchronized boolean loginByPassword(String string, String string2, String string3, String string4, ConnectionHandler connectionHandler, InetAddress inetAddress, String string5) {
        if (this.isLoggedIn() || this.m_loggingIn) {
            return false;
        }
        this.stopAutoReconnect();
        this.m_loggingIn = true;
        this.setConnectionHandler(connectionHandler);
        this.setIp(inetAddress);
        this.setLocation(string5);
        return super.loginByPassword(string, string2, string3, string4);
    }

    public synchronized boolean loginByToken(String string, String string2, String string3, String string4, ConnectionHandler connectionHandler, InetAddress inetAddress, String string5) {
        if (this.isLoggedIn() || this.m_loggingIn) {
            return false;
        }
        this.stopAutoReconnect();
        this.m_loggingIn = true;
        this.setConnectionHandler(connectionHandler);
        this.setIp(inetAddress);
        this.setLocation(string5);
        return super.loginByToken(string, string2, string3, string4);
    }

    public synchronized boolean loginAsAnon(String string, String string2, String string3, ConnectionHandler connectionHandler, InetAddress inetAddress, String string4) {
        if (this.isLoggedIn() || this.m_loggingIn) {
            return false;
        }
        this.stopAutoReconnect();
        this.m_loggingIn = true;
        this.setConnectionHandler(connectionHandler);
        this.setIp(inetAddress);
        this.setLocation(string4);
        return super.loginAsAnon(string, string2, string3);
    }

    public synchronized boolean loginAsServerApp(String string, short s, String string2, int[] nArray) {
        if (this.isLoggedIn() || this.m_loggingIn) {
            return false;
        }
        this.stopAutoReconnect();
        this.m_loggingIn = true;
        return super.loginAsServerApp(string, s, string2, nArray);
    }

    public boolean logout() {
        this.stopAutoReconnect();
        return super.logout();
    }

    protected void sendEvent(STEvent sTEvent) {
        MessageDispatcher messageDispatcher = this.m_session.getDispatcher();
        messageDispatcher.sendEvent(sTEvent);
    }

    public String toString() {
        return "{" + this.getName() + "(impl), STSession = " + this.m_session + "}";
    }

    public STSession getSession() {
        return this.m_session;
    }

    public String getName() {
        return "com.lotus.sametime.community.STBase";
    }

    public boolean isActive() {
        return this.m_active;
    }

    protected void onLogin() {
        super.onLogin();
        this.m_loggingIn = false;
        this.stopAutoReconnect();
        this.sendEvent(new LoginEvent((Object)this, -2147483647, this.getHost()));
    }

    protected void onLogout(int n) {
        super.onLogout(n);
        LoginEvent loginEvent = null;
        if (this.m_failedReconnectAttempts < this.m_reconnectAttempts) {
            if (this.m_failedReconnectAttempts == 0) {
                boolean bl = false;
                if (n == -2147483131 || n == -2147483125 || n == -2147483124 || n == -2147483116 || n == -2147483105 || n == -2147483106 || n == -2147483103 || n == -2147483101 || n == -2147483100 || n == -2147483099 || n == -2147483098 || n == -2147483623 || n == -2147483089) {
                    bl = true;
                    ++this.m_failedReconnectAttempts;
                    this.m_reconnectTimer.start();
                }
                loginEvent = new LoginEvent(this, -2147483646, n, this.getHost(), bl);
            } else {
                ++this.m_failedReconnectAttempts;
            }
        } else {
            this.stopAutoReconnect();
            loginEvent = new LoginEvent((Object)this, -2147483646, n, this.getHost());
        }
        this.m_loggingIn = false;
        this.sendEvent(loginEvent);
    }

    protected void onCreateChannel(int n, int n2, int n3, int n4, EncLevel encLevel, EncLevel encLevel2, byte[] byArray, STUserInstance sTUserInstance, byte by) {
        super.onCreateChannel(n, n2, n3, n4, encLevel, encLevel2, byArray, sTUserInstance, by);
        this.sendEvent(new ChannelEvent((Object)this, -2147483647, new Integer(n), n2, n3, n4, encLevel, encLevel2, byArray, sTUserInstance, by));
    }

    protected int onAcceptChannel(int n, int n2, int n3, int n4, EncLevel encLevel, byte[] byArray, byte[] byArray2, STUserInstance sTUserInstance, byte by, STId sTId) {
        super.onAcceptChannel(n, n2, n3, n4, encLevel, byArray, byArray2, sTUserInstance, by, sTId);
        STUser sTUser = new STUser(sTId, "", "");
        this.sendEvent(new ChannelEvent((Object)this, -2147483646, new Integer(n), n2, n3, n4, encLevel, byArray, sTUserInstance, by, sTUser));
        return 1;
    }

    protected void onDestroyChannel(int n, int n2, byte[] byArray) {
        super.onDestroyChannel(n, n2, byArray);
        this.sendEvent(new ChannelEvent(this, -2147483645, new Integer(n), n2, byArray));
    }

    protected void onSendOnChannel(int n, short s, byte[] byArray, boolean bl) {
        super.onSendOnChannel(n, s, byArray, bl);
        this.sendEvent(new ChannelEvent((Object)this, -2147483644, new Integer(n), s, byArray, bl));
    }

    protected void onMultiSendOnChannel(int[] nArray, short s, byte[] byArray) {
        super.onMultiSendOnChannel(nArray, s, byArray);
        this.sendEvent(new ChannelEvent((Object)this, -2147483643, nArray, s, byArray, false));
    }

    protected void onSendTo(int n, STId sTId, int n2, int n3, int n4, short s, byte[] byArray) {
        super.onSendTo(n, sTId, n2, n3, n4, s, byArray);
        this.sendEvent(new OTMEvent(this, -2147483647, new Integer(n), sTId, n2, n3, n4, s, byArray));
    }

    protected void onSendToDenied(int n, STId sTId, int n2) {
        super.onSendToDenied(n, sTId, n2);
        this.sendEvent(new OTMEvent(this, -2147483646, new Integer(n), sTId, n2));
    }

    protected void onSetStatus(STUserStatus sTUserStatus) {
        super.onSetStatus(sTUserStatus);
        this.sendEvent(new MyStatusEvent(this, -2147483647, sTUserStatus));
    }

    protected void onSetPrivacyList(STPrivacyList sTPrivacyList) {
        super.onSetPrivacyList(sTPrivacyList);
        STPrivacyList sTPrivacyList2 = null;
        sTPrivacyList2 = (STPrivacyList)sTPrivacyList.clone();
        this.sendEvent(new MyPrivacyEvent((Object)this, -2147483647, sTPrivacyList2));
    }

    protected void onSetPrivacyDenied(int n) {
        super.onSetPrivacyDenied(n);
        this.sendEvent(new MyPrivacyEvent((Object)this, -2147483646, new Integer(n)));
    }

    protected void onVisibilityRequested(STUser[] sTUserArray) {
        super.onVisibilityRequested(sTUserArray);
        this.sendEvent(new AwarenessPermissionEvent((Object)this, -2147483647, sTUserArray));
    }

    protected void onAckVisibilityAccepted(STUser[] sTUserArray) {
        this.sendEvent(new AwarenessPermissionEvent((Object)this, -2147483646, sTUserArray));
    }

    protected void onVisibilityCancelled(STUser[] sTUserArray) {
        this.sendEvent(new AwarenessPermissionEvent((Object)this, -2147483645, sTUserArray));
    }

    protected void onServiceSensed(int n) {
        super.onServiceSensed(n);
        this.sendEvent(new ServiceEvent(this, -2147483647, n));
    }

    protected void onAdminMsg(String string) {
        super.onAdminMsg(string);
        this.sendEvent(new AdminMsgEvent(this, -2147483647, string));
    }

    protected void onMultiCast(STUser sTUser, short s, byte[] byArray) {
        super.onMultiCast(sTUser, s, byArray);
        MultiCastEvent multiCastEvent = new MultiCastEvent((Object)this, -2147483647, sTUser, s, byArray);
        this.sendEvent(multiCastEvent);
    }

    protected void onSetUserName(String string) {
        super.onSetUserName(string);
        this.sendEvent(new MyNameEvent((Object)this, -2147483647, string));
    }

    protected void onSetUserNameDenied(int n) {
        super.onSetUserNameDenied(n);
        this.sendEvent(new MyNameEvent((Object)this, -2147483646, new Integer(n)));
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof ChannelEvent) {
            this.processChannelEvent((ChannelEvent)sTEvent);
        } else if (sTEvent instanceof LoginEvent) {
            this.processLoginEvent((LoginEvent)sTEvent);
        } else if (sTEvent instanceof OTMEvent) {
            this.processOtmEvent((OTMEvent)sTEvent);
        } else if (sTEvent instanceof ServiceEvent) {
            this.processServiceEvent((ServiceEvent)sTEvent);
        } else if (sTEvent instanceof MyPrivacyEvent) {
            this.processMyPrivacyEvent((MyPrivacyEvent)sTEvent);
        } else if (sTEvent instanceof MyStatusEvent) {
            this.processMyStatusEvent((MyStatusEvent)sTEvent);
        } else if (sTEvent instanceof MyNameEvent) {
            this.processNameEvent((MyNameEvent)sTEvent);
        } else if (sTEvent instanceof AdminMsgEvent) {
            this.processAdminEvent((AdminMsgEvent)sTEvent);
        } else if (sTEvent instanceof MultiCastEvent) {
            this.processMultiCastEvent((MultiCastEvent)sTEvent);
        } else if (sTEvent instanceof STCompEvent) {
            switch (sTEvent.getId()) {
                case 0: {
                    this.start();
                    this.m_active = true;
                    sTEvent.setConsumed(true);
                    break;
                }
                case 1: {
                    this.m_active = false;
                    this.stop();
                    sTEvent.setConsumed(true);
                }
            }
        }
    }

    protected void processChannelEvent(ChannelEvent channelEvent) {
        block9: {
            try {
                switch (channelEvent.getId()) {
                    case 1: {
                        this.createChannel(channelEvent.getChannelId(), channelEvent.getToId(), channelEvent.getServiceType(), channelEvent.getProtocolType(), channelEvent.getProtocolVersion(), channelEvent.getEncLevel(), channelEvent.getData(), channelEvent.getOptions(), channelEvent.getPriority(), channelEvent.getCreator());
                        channelEvent.setConsumed(true);
                        break;
                    }
                    case 2: {
                        this.destroyChannel(channelEvent.getChannelId(), channelEvent.getReason(), channelEvent.getData());
                        channelEvent.setConsumed(true);
                        break;
                    }
                    case 3: {
                        this.sendOnChannel(channelEvent.getChannelId(), channelEvent.getMessageType(), channelEvent.getData(), channelEvent.isEncrypted());
                        channelEvent.setConsumed(true);
                        break;
                    }
                    case 5: {
                        this.multiSendOnChannel(channelEvent.getChList(), channelEvent.getMessageType(), channelEvent.getData(), channelEvent.isEncrypted());
                        channelEvent.setConsumed(true);
                        break;
                    }
                    case 4: {
                        this.acceptChannel(channelEvent.getChannelId(), channelEvent.getServiceType(), channelEvent.getProtocolType(), channelEvent.getProtocolVersion(), channelEvent.getEncLevel(), channelEvent.getData(), channelEvent.getRemoteInfo(), channelEvent.getPriority(), channelEvent.getAccpetor());
                        channelEvent.setConsumed(true);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block9;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "processChannelEvent", exception.getMessage(), exception);
            }
        }
    }

    protected void processLoginEvent(LoginEvent loginEvent) {
        switch (loginEvent.getId()) {
            case 0: {
                this.loginByPassword(loginEvent.getHost(), loginEvent.getLoginName(), loginEvent.getPassword(), loginEvent.getCommunity(), loginEvent.getConnectionHandler(), loginEvent.getIp(), loginEvent.getLocation());
                loginEvent.setConsumed(true);
                break;
            }
            case 1: {
                this.loginByToken(loginEvent.getHost(), loginEvent.getLoginName(), loginEvent.getPassword(), loginEvent.getCommunity(), loginEvent.getConnectionHandler(), loginEvent.getIp(), loginEvent.getLocation());
                loginEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.loginAsAnon(loginEvent.getHost(), loginEvent.getLoginName(), loginEvent.getCommunity(), loginEvent.getConnectionHandler(), loginEvent.getIp(), loginEvent.getLocation());
                loginEvent.setConsumed(true);
                break;
            }
            case 3: {
                this.loginAsServerApp(loginEvent.getHost(), loginEvent.getLoginType(), loginEvent.getLoginName(), loginEvent.getServiceTypes());
                loginEvent.setConsumed(true);
                break;
            }
            case 5: {
                this.serviceUp(loginEvent.getServiceTypes());
                loginEvent.setConsumed(true);
                break;
            }
            case 6: {
                this.serviceDown(loginEvent.getServiceTypes());
                loginEvent.setConsumed(true);
                break;
            }
            case 4: {
                this.logout();
                loginEvent.setConsumed(true);
                break;
            }
            case 7: {
                this.disableAutomaticReconnect();
                loginEvent.setConsumed(true);
                break;
            }
            case 8: {
                this.enableAutomaticReconnect(loginEvent.getNumOfReconnectAttempts(), loginEvent.getSleepTimeBetweenReconnects());
            }
        }
    }

    protected void processOtmEvent(OTMEvent oTMEvent) {
        switch (oTMEvent.getId()) {
            case 1: {
                this.sendTo(oTMEvent.getReqId(), oTMEvent.getPartyId(), oTMEvent.getServiceType(), oTMEvent.getPrType(), oTMEvent.getPrVersion(), oTMEvent.getMsgType(), oTMEvent.getData());
                oTMEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.denySend(oTMEvent.getReqId(), oTMEvent.getPartyId(), oTMEvent.getReason());
                oTMEvent.setConsumed(true);
            }
        }
    }

    protected void processServiceEvent(ServiceEvent serviceEvent) {
        switch (serviceEvent.getId()) {
            case 1: {
                this.senseService(serviceEvent.getServiceType());
                serviceEvent.setConsumed(true);
            }
        }
    }

    protected void processMyPrivacyEvent(MyPrivacyEvent myPrivacyEvent) {
        switch (myPrivacyEvent.getId()) {
            case 1: {
                this.setPrivacyList(myPrivacyEvent.getPrivacyList());
                myPrivacyEvent.setConsumed(true);
            }
        }
    }

    protected void processMyStatusEvent(MyStatusEvent myStatusEvent) {
        switch (myStatusEvent.getId()) {
            case 1: {
                this.setUserStatus(myStatusEvent.getStatus());
                myStatusEvent.setConsumed(true);
            }
        }
    }

    protected void processNameEvent(MyNameEvent myNameEvent) {
        switch (myNameEvent.getId()) {
            case 1: {
                this.setUserName(myNameEvent.getName());
                myNameEvent.setConsumed(true);
            }
        }
    }

    protected void processAdminEvent(AdminMsgEvent adminMsgEvent) {
        switch (adminMsgEvent.getId()) {
            case 1: {
                this.adminMsg(adminMsgEvent.getMsgText());
                adminMsgEvent.setConsumed(true);
            }
        }
    }

    protected void processMultiCastEvent(MultiCastEvent multiCastEvent) {
        switch (multiCastEvent.getId()) {
            case 1: {
                this.sendMultiCastMsg(multiCastEvent.getRecipients(), multiCastEvent.getType(), multiCastEvent.getData());
                multiCastEvent.setConsumed(true);
            }
        }
    }

    private void enableAutomaticReconnect(int n, long l) {
        this.stopAutoReconnect();
        this.m_reconnectAttempts = n;
        this.m_failedReconnectAttempts = 0;
        this.m_reconnectTimer = new Timer(l, this);
    }

    private void disableAutomaticReconnect() {
        this.stopAutoReconnect();
        this.m_reconnectAttempts = 0;
    }

    public synchronized boolean timerTick() {
        if (this.m_loggingIn || this.isLoggedIn()) {
            return true;
        }
        this.m_loggingIn = true;
        this.reconnect();
        return true;
    }

    private void stopAutoReconnect() {
        if (null != this.m_reconnectTimer) {
            this.m_reconnectTimer.stop();
        }
        this.m_failedReconnectAttempts = 0;
    }
}

