/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community;

import com.lotus.sametime.community.AdminMsgEvent;
import com.lotus.sametime.community.AdminMsgListener;
import com.lotus.sametime.community.AwarenessPermissionEvent;
import com.lotus.sametime.community.AwarenessPermissionManager;
import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.ChannelServiceListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LightLoginService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.MultiCastEvent;
import com.lotus.sametime.community.MultiCastListener;
import com.lotus.sametime.community.MultiCastService;
import com.lotus.sametime.community.MultiChannelEventListener;
import com.lotus.sametime.community.MyNameEvent;
import com.lotus.sametime.community.MyPrivacyEvent;
import com.lotus.sametime.community.MyStatusEvent;
import com.lotus.sametime.community.OTMEvent;
import com.lotus.sametime.community.OTMServiceListener;
import com.lotus.sametime.community.OneTimeMsgService;
import com.lotus.sametime.community.STBaseImpl;
import com.lotus.sametime.community.ServerAppService;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.community.kernel.connhandler.ConnectionHandler;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STPrivacyList;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STBase
extends STComp
implements CommunityService,
ChannelService,
OneTimeMsgService,
ServerAppService,
LightLoginService,
MultiCastService {
    private Hashtable m_openChannels = new Hashtable();
    private Vector m_logEventListeners = new Vector();
    private Vector m_otmEventListeners = new Vector();
    private Vector m_adminMsgListeners = new Vector();
    private Vector m_multicastListeners = new Vector();
    private Vector m_serviceEventListeners = new Vector();
    private Vector m_channelServiceListeners = new Vector();
    private Vector m_multiChannelListeners = new Vector();
    private Login m_login;
    private AwarenessPermissionManager m_awarenessPermissionMgr;
    private STBaseImpl m_impl = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.community");

    public STBase(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.community.STBase", sTSession);
        this.m_impl = new STBaseImpl(sTSession);
        this.getSession().registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public synchronized void addLoginListener(LoginListener loginListener) {
        Vector vector = (Vector)this.m_logEventListeners.clone();
        vector.addElement(loginListener);
        this.m_logEventListeners = vector;
    }

    public synchronized void removeLoginListener(LoginListener loginListener) {
        Vector vector = (Vector)this.m_logEventListeners.clone();
        vector.removeElement(loginListener);
        this.m_logEventListeners = vector;
    }

    public synchronized void addOTMServiceListener(OTMServiceListener oTMServiceListener) {
        Vector vector = (Vector)this.m_otmEventListeners.clone();
        vector.addElement(oTMServiceListener);
        this.m_otmEventListeners = vector;
    }

    public synchronized void removeOTMServiceListener(OTMServiceListener oTMServiceListener) {
        Vector vector = (Vector)this.m_otmEventListeners.clone();
        vector.removeElement(oTMServiceListener);
        this.m_otmEventListeners = vector;
    }

    public synchronized void addAdminMsgListener(AdminMsgListener adminMsgListener) {
        Vector vector = (Vector)this.m_adminMsgListeners.clone();
        vector.addElement(adminMsgListener);
        this.m_adminMsgListeners = vector;
    }

    public synchronized void removeAdminMsgListener(AdminMsgListener adminMsgListener) {
        Vector vector = (Vector)this.m_adminMsgListeners.clone();
        vector.removeElement(adminMsgListener);
        this.m_adminMsgListeners = vector;
    }

    public synchronized void addMultiCastListener(MultiCastListener multiCastListener) {
        Vector vector = (Vector)this.m_multicastListeners.clone();
        vector.addElement(multiCastListener);
        this.m_multicastListeners = vector;
    }

    public synchronized void removeMultiCastListener(MultiCastListener multiCastListener) {
        Vector vector = (Vector)this.m_multicastListeners.clone();
        vector.removeElement(multiCastListener);
        this.m_multicastListeners = vector;
    }

    public synchronized void addServiceListener(ServiceListener serviceListener) {
        Vector vector = (Vector)this.m_serviceEventListeners.clone();
        vector.addElement(serviceListener);
        this.m_serviceEventListeners = vector;
    }

    public synchronized void removeServiceListener(ServiceListener serviceListener) {
        Vector vector = (Vector)this.m_serviceEventListeners.clone();
        vector.removeElement(serviceListener);
        this.m_serviceEventListeners = vector;
    }

    public synchronized void addChannelServiceListener(ChannelServiceListener channelServiceListener) {
        Vector vector = (Vector)this.m_channelServiceListeners.clone();
        vector.addElement(channelServiceListener);
        this.m_channelServiceListeners = vector;
    }

    public synchronized void removeChannelServiceListener(ChannelServiceListener channelServiceListener) {
        Vector vector = (Vector)this.m_channelServiceListeners.clone();
        vector.removeElement(channelServiceListener);
        this.m_channelServiceListeners = vector;
    }

    public void addMultiChannelEventListener(MultiChannelEventListener multiChannelEventListener) {
        Vector vector = (Vector)this.m_multiChannelListeners.clone();
        vector.addElement(multiChannelEventListener);
        this.m_multiChannelListeners = vector;
    }

    public void removeMultiChannelEventListener(MultiChannelEventListener multiChannelEventListener) {
        Vector vector = (Vector)this.m_multiChannelListeners.clone();
        vector.removeElement(multiChannelEventListener);
        this.m_multiChannelListeners = vector;
    }

    public boolean isLoggedIn() {
        return this.m_impl.isLoggedIn();
    }

    protected STUserInstance getUserInstance() {
        return this.m_impl.getLoginInfo();
    }

    protected STUserStatus getStatus() {
        return this.m_impl.getStatus();
    }

    protected STPrivacyList getPrivacy() {
        return this.m_impl.getPrivacyList();
    }

    protected int getServerVersion() {
        return this.m_impl.getServerVersion();
    }

    protected boolean isGroupPrivacySupported() {
        return this.m_impl.isGroupPrivacySupported();
    }

    protected STServer getConnectingServer() {
        return this.m_impl.getConnectingServer();
    }

    public void setLoginType(short s) {
        this.m_impl.setLoginType(s);
    }

    public short getLoginType() {
        return this.m_impl.getLoginType();
    }

    public ConnectionInfo getConnectionInfo() {
        return this.m_impl.getConnectionInfo();
    }

    public ConnectionHandler getConnectionHandler() {
        return this.m_impl.getConnectionHandler();
    }

    public void setConnectivity(Connection[] connectionArray) {
        this.m_impl.setConnectivity(connectionArray);
    }

    public void setKeepAliveRate(long l) {
        this.m_impl.setKeepAliveRate(l);
    }

    public Login getLogin() {
        return this.m_login;
    }

    public void setLoginStatus(boolean bl, STUserStatus sTUserStatus) {
        this.m_impl.setLoginStatus(bl, sTUserStatus);
    }

    public void loginByPassword(String string, String string2, String string3) {
        LoginEvent loginEvent = new LoginEvent(this, 0, string, string2, string3, null, null, null, null);
        this.sendEvent(loginEvent);
    }

    public void loginByPassword(String string, String string2, String string3, String string4) {
        LoginEvent loginEvent = new LoginEvent(this, 0, string, string2, string3, string4, null, null, null);
        this.sendEvent(loginEvent);
    }

    public void loginByPassword(String string, String string2, String string3, String string4, InetAddress inetAddress, String string5) {
        LoginEvent loginEvent = new LoginEvent(this, 0, string, string2, string3, string4, null, inetAddress, string5);
        this.sendEvent(loginEvent);
    }

    public void loginByToken(String string, String string2, String string3) {
        LoginEvent loginEvent = new LoginEvent(this, 1, string, string2, string3, null, null, null, null);
        this.sendEvent(loginEvent);
    }

    public void loginByToken(String string, String string2, String string3, String string4) {
        LoginEvent loginEvent = new LoginEvent(this, 1, string, string2, string3, string4, null, null, null);
        this.sendEvent(loginEvent);
    }

    public void loginByToken(String string, String string2, String string3, String string4, InetAddress inetAddress, String string5) {
        LoginEvent loginEvent = new LoginEvent(this, 1, string, string2, string3, string4, null, inetAddress, string5);
        this.sendEvent(loginEvent);
    }

    public void loginAsAnon(String string, String string2) {
        LoginEvent loginEvent = new LoginEvent(this, 2, string, string2, null, null, null, null);
        this.sendEvent(loginEvent);
    }

    public void loginAsAnon(String string, String string2, String string3) {
        LoginEvent loginEvent = new LoginEvent(this, 2, string, string2, string3, null, null, null);
        this.sendEvent(loginEvent);
    }

    public void loginAsAnon(String string, String string2, String string3, InetAddress inetAddress, String string4) {
        LoginEvent loginEvent = new LoginEvent(this, 2, string, string2, string3, null, inetAddress, string4);
        this.sendEvent(loginEvent);
    }

    public void loginByPassword(String string, String string2, ServerAppService serverAppService, InetAddress inetAddress) {
        STBase sTBase = (STBase)serverAppService;
        ConnectionHandler connectionHandler = sTBase.getConnectionHandler();
        LoginEvent loginEvent = new LoginEvent(this, 0, null, string, string2, null, connectionHandler, inetAddress, "");
        this.sendEvent(loginEvent);
    }

    public void loginByPassword(String string, String string2, String string3, ServerAppService serverAppService, InetAddress inetAddress) {
        STBase sTBase = (STBase)serverAppService;
        ConnectionHandler connectionHandler = sTBase.getConnectionHandler();
        LoginEvent loginEvent = new LoginEvent(this, 0, null, string, string2, string3, connectionHandler, inetAddress, "");
        this.sendEvent(loginEvent);
    }

    public void loginByPassword(String string, String string2, String string3, ServerAppService serverAppService, InetAddress inetAddress, String string4) {
        STBase sTBase = (STBase)serverAppService;
        ConnectionHandler connectionHandler = sTBase.getConnectionHandler();
        LoginEvent loginEvent = new LoginEvent(this, 0, null, string, string2, string3, connectionHandler, inetAddress, string4);
        this.sendEvent(loginEvent);
    }

    public void loginByToken(String string, String string2, ServerAppService serverAppService, InetAddress inetAddress) {
        STBase sTBase = (STBase)serverAppService;
        ConnectionHandler connectionHandler = sTBase.getConnectionHandler();
        LoginEvent loginEvent = new LoginEvent(this, 1, null, string, string2, null, connectionHandler, inetAddress, "");
        this.sendEvent(loginEvent);
    }

    public void loginByToken(String string, String string2, String string3, ServerAppService serverAppService, InetAddress inetAddress, String string4) {
        STBase sTBase = (STBase)serverAppService;
        ConnectionHandler connectionHandler = sTBase.getConnectionHandler();
        LoginEvent loginEvent = new LoginEvent(this, 1, null, string, string2, string3, connectionHandler, inetAddress, string4);
        this.sendEvent(loginEvent);
    }

    public void loginAsAnon(String string, ServerAppService serverAppService, InetAddress inetAddress) {
        STBase sTBase = (STBase)serverAppService;
        ConnectionHandler connectionHandler = sTBase.getConnectionHandler();
        LoginEvent loginEvent = new LoginEvent(this, 2, null, string, null, connectionHandler, inetAddress, "");
        this.sendEvent(loginEvent);
    }

    public void loginAsAnon(String string, ServerAppService serverAppService, String string2, InetAddress inetAddress, String string3) {
        STBase sTBase = (STBase)serverAppService;
        ConnectionHandler connectionHandler = sTBase.getConnectionHandler();
        LoginEvent loginEvent = new LoginEvent(this, 2, null, string, string2, connectionHandler, inetAddress, string3);
        this.sendEvent(loginEvent);
    }

    public void loginAsServerApp(String string, short s, String string2, int[] nArray) {
        LoginEvent loginEvent = new LoginEvent(this, 3, string, s, string2, nArray);
        this.sendEvent(loginEvent);
    }

    public void logout() {
        LoginEvent loginEvent = new LoginEvent(this, 4);
        this.sendEvent(loginEvent);
    }

    protected void setPrivacy(STPrivacyList sTPrivacyList) {
        MyPrivacyEvent myPrivacyEvent = new MyPrivacyEvent((Object)this, 1, sTPrivacyList);
        this.sendEvent(myPrivacyEvent);
    }

    protected void setStatus(STUserStatus sTUserStatus) {
        MyStatusEvent myStatusEvent = new MyStatusEvent(this, 1, sTUserStatus);
        this.sendEvent(myStatusEvent);
    }

    public void senseService(int n) {
        ServiceEvent serviceEvent = new ServiceEvent(this, 1, n);
        this.sendEvent(serviceEvent);
    }

    public void sendOTM(int n, STId sTId, int n2, int n3, int n4, short s, byte[] byArray) {
        OTMEvent oTMEvent = new OTMEvent(this, 1, new Integer(n), sTId, n2, n3, n4, s, byArray);
        this.sendEvent(oTMEvent);
    }

    public void denyOTM(int n, STId sTId, int n2) {
        OTMEvent oTMEvent = new OTMEvent(this, 2, new Integer(n), sTId, n2);
        this.sendEvent(oTMEvent);
    }

    protected void changeUserName(String string) {
        MyNameEvent myNameEvent = new MyNameEvent((Object)this, 1, string);
        this.sendEvent(myNameEvent);
    }

    public void serviceUp(int[] nArray) {
        LoginEvent loginEvent = new LoginEvent((Object)this, 5, nArray);
        this.sendEvent(loginEvent);
    }

    public void serviceDown(int[] nArray) {
        LoginEvent loginEvent = new LoginEvent((Object)this, 6, nArray);
        this.sendEvent(loginEvent);
    }

    public void sendMultiCast(STObject[] sTObjectArray, short s, byte[] byArray) {
        MultiCastEvent multiCastEvent = new MultiCastEvent((Object)this, 1, sTObjectArray, s, byArray);
        this.sendEvent(multiCastEvent);
    }

    protected void createChannel(Channel channel, STId sTId, int n, int n2, int n3, EncLevel encLevel, byte[] byArray, int n4, byte by) {
        this.m_openChannels.put(channel.getChannelId(), channel);
        ChannelEvent channelEvent = new ChannelEvent((Object)this, 1, channel.getChannelId(), sTId, n, n2, n3, encLevel, byArray, n4, by);
        this.sendEvent(channelEvent);
    }

    protected void createChannel(Channel channel, STId sTId, int n, int n2, int n3, EncLevel encLevel, byte[] byArray, int n4, byte by, STUserInstance sTUserInstance) {
        this.m_openChannels.put(channel.getChannelId(), channel);
        ChannelEvent channelEvent = new ChannelEvent(this, 1, channel.getChannelId(), sTId, n, n2, n3, encLevel, byArray, n4, by, sTUserInstance);
        this.sendEvent(channelEvent);
    }

    protected void acceptChannel(Channel channel, int n, int n2, int n3, EncLevel encLevel, byte[] byArray, STUserInstance sTUserInstance, byte by, STUserInstance sTUserInstance2) {
        ChannelEvent channelEvent = new ChannelEvent((Object)this, 4, channel.getChannelId(), n, n2, n3, encLevel, byArray, sTUserInstance, by, sTUserInstance2);
        this.sendEvent(channelEvent);
    }

    protected void destroyChannel(Channel channel, int n, byte[] byArray) {
        ChannelEvent channelEvent = new ChannelEvent(this, 2, channel.getChannelId(), n, byArray);
        this.sendEvent(channelEvent);
    }

    protected void sendOnChannel(Channel channel, short s, byte[] byArray, boolean bl) {
        ChannelEvent channelEvent = new ChannelEvent((Object)this, 3, channel.getChannelId(), s, byArray, bl);
        this.sendEvent(channelEvent);
    }

    public void sendOnChannels(Channel[] channelArray, short s, byte[] byArray, boolean bl) {
        int[] nArray = new int[channelArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = channelArray[i].getChannelId();
        }
        ChannelEvent channelEvent = new ChannelEvent((Object)this, 5, nArray, s, byArray, bl);
        this.sendEvent(channelEvent);
    }

    public Channel createChannel(int n, int n2, int n3, EncLevel encLevel, byte[] byArray, STId sTId) {
        return new Channel(this, n, n2, n3, encLevel, byArray, sTId, 7);
    }

    public Channel createChannel(int n, int n2, int n3, EncLevel encLevel, byte[] byArray, STId sTId, STUserInstance sTUserInstance) {
        return new Channel(this, n, n2, n3, encLevel, byArray, sTId, 7, sTUserInstance);
    }

    public Channel createChannel(int n, int n2, int n3, EncLevel encLevel, byte[] byArray, STId sTId, byte by) {
        if (by > 15 || by < 0) {
            by = (byte)7;
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "createChannel", "Create channel with invalid priority level, Using default level");
            }
        }
        return new Channel(this, n, n2, n3, encLevel, byArray, sTId, by);
    }

    public Channel createChannel(int n, int n2, int n3, EncLevel encLevel, byte[] byArray, STId sTId, byte by, STUserInstance sTUserInstance) {
        if (by > 15 || by < 0) {
            by = (byte)7;
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "createChannel", "Create channel with invalid priority level, Using default level");
            }
        }
        return new Channel(this, n, n2, n3, encLevel, byArray, sTId, by, sTUserInstance);
    }

    public void adminMsg(String string) {
        AdminMsgEvent adminMsgEvent = new AdminMsgEvent(this, 1, string);
        this.sendEvent(adminMsgEvent);
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof ChannelEvent) {
            this.processChannelEvent((ChannelEvent)sTEvent);
        } else if (sTEvent instanceof LoginEvent) {
            this.processLoginEvent((LoginEvent)sTEvent);
        } else if (sTEvent instanceof OTMEvent) {
            this.processOtmEvent((OTMEvent)sTEvent);
        } else if (sTEvent instanceof AdminMsgEvent) {
            this.processAdminEvent((AdminMsgEvent)sTEvent);
        } else if (sTEvent instanceof ServiceEvent) {
            this.processServiceEvent((ServiceEvent)sTEvent);
        } else if (sTEvent instanceof MyStatusEvent) {
            if (this.m_login != null) {
                this.m_login.processMyStatusEvent((MyStatusEvent)sTEvent);
            }
        } else if (sTEvent instanceof MyPrivacyEvent) {
            if (this.m_login != null) {
                this.m_login.processMyPrivacyEvent((MyPrivacyEvent)sTEvent);
            }
        } else if (sTEvent instanceof MyNameEvent) {
            if (this.m_login != null) {
                this.m_login.processMyNameEvent((MyNameEvent)sTEvent);
            }
        } else if (sTEvent instanceof MultiCastEvent) {
            this.processMultiCastEvent((MultiCastEvent)sTEvent);
        } else if (sTEvent instanceof AwarenessPermissionEvent) {
            this.m_awarenessPermissionMgr.processAwarenessPermissionsEvent((AwarenessPermissionEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processChannelEvent(ChannelEvent channelEvent) {
        switch (channelEvent.getId()) {
            case -2147483647: {
                this.channelCreated(channelEvent);
                channelEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.channelAccepted(channelEvent);
                channelEvent.setConsumed(true);
                break;
            }
            case -2147483644: {
                this.channelSent(channelEvent);
                channelEvent.setConsumed(true);
                break;
            }
            case -2147483643: {
                this.multiChannelSent(channelEvent);
                channelEvent.setConsumed(true);
                break;
            }
            case -2147483645: {
                this.channelDestroyed(channelEvent);
                channelEvent.setConsumed(true);
            }
        }
    }

    protected void processLoginEvent(LoginEvent loginEvent) {
        switch (loginEvent.getId()) {
            case -2147483647: {
                loginEvent.setSource(this);
                this.loggedIn(loginEvent);
                loginEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                loginEvent.setSource(this);
                this.loggedOut(loginEvent);
                loginEvent.setConsumed(true);
            }
        }
    }

    protected void processOtmEvent(OTMEvent oTMEvent) {
        Vector vector = this.m_otmEventListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            OTMServiceListener oTMServiceListener = (OTMServiceListener)enumeration.nextElement();
            switch (oTMEvent.getId()) {
                case -2147483647: {
                    oTMEvent.setSource(this);
                    oTMServiceListener.otmRecieved(oTMEvent);
                    oTMEvent.setConsumed(true);
                    break;
                }
                case -2147483646: {
                    oTMEvent.setSource(this);
                    oTMServiceListener.sendOTMDenied(oTMEvent);
                    oTMEvent.setConsumed(true);
                }
            }
        }
    }

    protected void processAdminEvent(AdminMsgEvent adminMsgEvent) {
        Vector vector = this.m_adminMsgListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AdminMsgListener adminMsgListener = (AdminMsgListener)enumeration.nextElement();
            switch (adminMsgEvent.getId()) {
                case -2147483647: {
                    adminMsgEvent.setSource(this);
                    adminMsgListener.adminMsgReceived(adminMsgEvent);
                    adminMsgEvent.setConsumed(true);
                }
            }
        }
    }

    protected void processMultiCastEvent(MultiCastEvent multiCastEvent) {
        Vector vector = this.m_multicastListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MultiCastListener multiCastListener = (MultiCastListener)enumeration.nextElement();
            switch (multiCastEvent.getId()) {
                case -2147483647: {
                    multiCastEvent.setSource(this);
                    multiCastListener.multiCastReceived(multiCastEvent);
                    multiCastEvent.setConsumed(true);
                }
            }
        }
    }

    protected void processServiceEvent(ServiceEvent serviceEvent) {
        Vector vector = this.m_serviceEventListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ServiceListener serviceListener = (ServiceListener)enumeration.nextElement();
            switch (serviceEvent.getId()) {
                case -2147483647: {
                    serviceEvent.setSource(this);
                    serviceListener.serviceAvailable(serviceEvent);
                    serviceEvent.setConsumed(true);
                }
            }
        }
    }

    protected void channelCreated(ChannelEvent channelEvent) {
        Channel channel = (Channel)this.m_openChannels.get(channelEvent.getChannelId());
        if (null != channel) {
            channel.channelCreated(channelEvent);
        }
    }

    protected void channelAccepted(ChannelEvent channelEvent) {
        Channel channel = new Channel(this, channelEvent);
        channelEvent.setSource(this);
        channelEvent.setChannel(channel);
        this.m_openChannels.put(channelEvent.getChannelId(), channel);
        Vector vector = this.m_channelServiceListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ChannelServiceListener channelServiceListener = (ChannelServiceListener)enumeration.nextElement();
            channelServiceListener.channelReceived(channelEvent);
        }
        if (!channel.isReceived()) {
            channel.close(0, null);
        }
    }

    protected void channelSent(ChannelEvent channelEvent) {
        Channel channel = (Channel)this.m_openChannels.get(channelEvent.getChannelId());
        if (channel != null) {
            channel.channelSent(channelEvent);
        }
    }

    protected void multiChannelSent(ChannelEvent channelEvent) {
        Vector vector = this.m_multiChannelListeners;
        if (vector == null || vector.isEmpty()) {
            int[] nArray = channelEvent.getChList();
            for (int i = 0; i < nArray.length; ++i) {
                Integer n = new Integer(nArray[i]);
                Channel channel = (Channel)this.m_openChannels.get(n);
                if (channel == null) continue;
                ChannelEvent channelEvent2 = new ChannelEvent((Object)this, -2147483644, n, channelEvent.getMessageType(), channelEvent.getData(), channelEvent.isEncrypted());
                channel.channelSent(channelEvent2);
            }
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MultiChannelEventListener multiChannelEventListener = (MultiChannelEventListener)enumeration.nextElement();
                multiChannelEventListener.multiChannelMsgReceived(channelEvent);
            }
        }
    }

    protected void channelDestroyed(ChannelEvent channelEvent) {
        if (channelEvent.getChannelId() == 0) {
            return;
        }
        Channel channel = (Channel)this.m_openChannels.remove(channelEvent.getChannelId());
        if (channel != null) {
            channel.channelDestroyed(channelEvent);
        }
    }

    protected void loggedIn(LoginEvent loginEvent) {
        this.m_login = new Login(this);
        loginEvent.setLogin(this.m_login);
        Vector vector = this.m_logEventListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LoginListener loginListener = (LoginListener)enumeration.nextElement();
            loginListener.loggedIn(loginEvent);
        }
    }

    protected void loggedOut(LoginEvent loginEvent) {
        Object object;
        Vector vector = this.m_logEventListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (LoginListener)enumeration.nextElement();
            object.loggedOut(loginEvent);
        }
        object = this.m_openChannels.keys();
        while (object.hasMoreElements()) {
            Integer n = (Integer)object.nextElement();
            this.channelDestroyed(new ChannelEvent(this, -2147483645, n, 0, null));
        }
        this.m_login = null;
    }

    public void enableAutomaticReconnect(int n, long l) {
        this.sendEvent(new LoginEvent((Object)this, 8, n, l));
    }

    public void disableAutomaticReconnect() {
        this.sendEvent(new LoginEvent(this, 7));
    }

    public AwarenessPermissionManager createAwarenessPermissionManager() {
        if (this.m_awarenessPermissionMgr == null) {
            this.m_awarenessPermissionMgr = new AwarenessPermissionManager(this);
        }
        return this.m_awarenessPermissionMgr;
    }

    public InetAddress getServerPovIp() {
        return this.m_impl.getServerPovIp();
    }
}

