/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.commui;

import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.STTextField;
import com.lotus.sametime.lookup.GroupContentEvent;
import com.lotus.sametime.lookup.GroupContentGetter;
import com.lotus.sametime.lookup.GroupContentListener;
import com.lotus.sametime.lookup.LookupService;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class GroupContentDialog
extends Dialog {
    private Button m_btnOK;
    private List m_lstMembers;
    private STTextField m_tfGroupName;
    private STBundle m_resourceFile;
    private GroupContentListener m_groupContentListener;

    public GroupContentDialog(Frame frame, STSession sTSession, STGroup sTGroup) {
        super(frame, false);
        LookupService lookupService = (LookupService)sTSession.getCompApi("com.lotus.sametime.lookup.LookupComp");
        this.m_resourceFile = ((ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/commui");
        Debug.stAssert(lookupService != null);
        GroupContentGetter groupContentGetter = lookupService.createGroupContentGetter();
        this.m_groupContentListener = new GroupContentListener(){

            public void groupContentQueried(GroupContentEvent groupContentEvent) {
                GroupContentDialog.this.groupContentQueried(groupContentEvent);
            }

            public void queryGroupContentFailed(GroupContentEvent groupContentEvent) {
                GroupContentDialog.this.queryGroupContentFailed(groupContentEvent);
            }
        };
        groupContentGetter.addGroupContentListener(this.m_groupContentListener);
        this.init(sTGroup.getName());
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        groupContentGetter.queryGroupContent(sTGroup);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left + 10, insets.bottom + 10, insets.right + 10);
    }

    protected void groupContentQueried(GroupContentEvent groupContentEvent) {
        STGroup sTGroup = groupContentEvent.getGroup();
        STObject[] sTObjectArray = groupContentEvent.getGroupContent();
        for (int i = 0; i < sTObjectArray.length; ++i) {
            String string = sTObjectArray[i].getName();
            this.addToListSorted(string);
        }
        ((GroupContentGetter)groupContentEvent.getSource()).removeGroupContentListener(this.m_groupContentListener);
    }

    protected void queryGroupContentFailed(GroupContentEvent groupContentEvent) {
        ((GroupContentGetter)groupContentEvent.getSource()).removeGroupContentListener(this.m_groupContentListener);
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    protected void init(String string) {
        this.setTitle(this.m_resourceFile.getString("FRM_TITLE_GROUP_CONTENT"));
        this.setLayout(new BorderLayout(10, 10));
        Label label = new Label(this.m_resourceFile.getString("LBL_GROUP_NAME"));
        Label label2 = new Label(this.m_resourceFile.getString("LBL_MEMBERS"));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(10, 10));
        panel.add("North", label);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("North", label2);
        panel.add("Center", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout(10, 10));
        this.m_tfGroupName = new STTextField(string);
        this.m_tfGroupName.setEditable(false);
        this.m_lstMembers = new List();
        panel3.add("North", this.m_tfGroupName);
        panel3.add("Center", this.m_lstMembers);
        String[] stringArray = new String[]{this.m_resourceFile.getString("BTN_LBL_OK")};
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupContentDialog.this.actionPerformed(actionEvent);
            }
        };
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, actionListener, 2);
        this.m_btnOK = buttonsPanel.getButton(this.m_resourceFile.getString("BTN_LBL_OK"));
        panel3.add("South", buttonsPanel);
        this.add("West", panel);
        this.add("Center", panel3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GroupContentDialog.this.setVisible(false);
            }
        });
        this.pack();
        Rectangle rectangle = this.getParent().getBounds();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (rectangle.x + rectangle.width + dimension.width < dimension2.width && rectangle.y < dimension2.height) {
            this.setBounds(rectangle.x + rectangle.width, rectangle.y, dimension.width, dimension.height);
        } else {
            this.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        }
        this.setVisible(true);
        this.m_btnOK.requestFocus();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.m_resourceFile.getInt("GROUP_CONTENT_DLG_WIDTH"), this.m_resourceFile.getInt("GROUP_CONTENT_DLG_HEIGHT"));
        return dimension;
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                GroupContentDialog.this.setVisible(false);
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                GroupContentDialog.this.setVisible(false);
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_OK"))){

            public void executeKeyMethod() {
                GroupContentDialog.this.setVisible(false);
            }
        });
        return new KeyHandler(vector);
    }

    private void addToListSorted(String string) {
        int n;
        String string2 = null;
        boolean bl = false;
        String[] stringArray = this.m_lstMembers.getItems();
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            if (string2.compareTo(string) < 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.m_lstMembers.add(string);
        } else {
            this.m_lstMembers.add(string, n);
        }
    }
}

