/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.commui;

import com.lotus.sametime.commui.CommUI;
import com.lotus.sametime.commui.CommUIEvent;
import com.lotus.sametime.commui.CommUIFactory;
import com.lotus.sametime.commui.CommUIListener;
import com.lotus.sametime.commui.ResolveViewEvent;
import com.lotus.sametime.commui.ResolveViewListener;
import com.lotus.sametime.community.AdminMsgEvent;
import com.lotus.sametime.community.AdminMsgListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.lookup.LookupService;
import com.lotus.sametime.lookup.ResolveEvent;
import com.lotus.sametime.lookup.ResolveListener;
import com.lotus.sametime.lookup.Resolver;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommUIComp
extends STComp
implements CommUI {
    private CommunityService m_commService;
    private LookupService m_lookupService;
    private CommUIFactory m_factory;
    private Vector m_listeners;
    private STBundle m_resourceFile;
    private ResolveViewListener m_resolveViewListener;
    private ResolveListener m_resolveListener;
    private LoginListener m_loginListener;
    private AdminMsgListener m_adminMsgListener;
    private boolean m_enableLoginPopups;
    private Logger m_logger;

    public CommUIComp(STSession sTSession) throws DuplicateObjectException {
        block7: {
            super("com.lotus.sametime.commui.CommUIComp", sTSession);
            this.m_listeners = new Vector();
            this.m_enableLoginPopups = true;
            this.m_logger = Logger.getLogger("com.lotus.sametime.commui");
            try {
                Class<?> clazz = Class.forName("com.lotus.sametime.commui.CommUIFactoryImpl");
                this.m_factory = (CommUIFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed to load class for default commui factory");
                }
            }
            catch (InstantiationException instantiationException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed instantiate default commui factory");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block7;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed instantiate default commui factory");
            }
        }
        sTSession.registerComponent(this.getName(), this);
        this.createListeners();
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_commService != null) {
            this.m_commService.addLoginListener(this.m_loginListener);
            this.m_commService.addAdminMsgListener(this.m_adminMsgListener);
        }
        this.m_lookupService = (LookupService)sTSession.getCompApi("com.lotus.sametime.lookup.LookupComp");
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
        Debug.stAssert(this.m_commService != null);
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)this.getSession().getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        Debug.stAssert(resourceLoaderService != null);
        this.m_resourceFile = resourceLoaderService.getBundle("properties/commui");
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
        this.m_commService.removeLoginListener(this.m_loginListener);
        this.m_commService.removeAdminMsgListener(this.m_adminMsgListener);
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (this.m_commService == null && sTCompApi instanceof CommunityService) {
            this.m_commService = (CommunityService)sTCompApi;
            this.m_commService.addLoginListener(this.m_loginListener);
            this.m_commService.addAdminMsgListener(this.m_adminMsgListener);
        }
        if (this.m_lookupService == null && sTCompApi instanceof LookupService) {
            this.m_lookupService = (LookupService)sTCompApi;
        }
    }

    public void addCommUIListener(CommUIListener commUIListener) {
        this.m_listeners.addElement(commUIListener);
    }

    public void removeCommUIListener(CommUIListener commUIListener) {
        this.m_listeners.removeElement(commUIListener);
    }

    public void setFactory(CommUIFactory commUIFactory) {
        this.m_factory = commUIFactory;
    }

    public void resolve(String string) {
        this.resolve(string, false, true);
    }

    public void resolve(String string, boolean bl, boolean bl2) {
        Debug.stAssert(this.m_lookupService != null);
        Resolver resolver = this.m_lookupService.createResolver(bl, bl2, true, false);
        resolver.addResolveListener(this.m_resolveListener);
        resolver.resolve(string);
    }

    protected void resolved(ResolveEvent resolveEvent) {
        this.notifyResolved(resolveEvent.getName(), (STUser)resolveEvent.getResolved());
    }

    protected void resolveConflict(ResolveEvent resolveEvent) {
        STObject[] sTObjectArray = resolveEvent.getResolvedList();
        STUser[] sTUserArray = new STUser[sTObjectArray.length];
        for (int i = 0; i < sTObjectArray.length; ++i) {
            sTUserArray[i] = (STUser)sTObjectArray[i];
        }
        this.m_factory.openResolveDialog(this.getSession(), this.m_resolveViewListener, sTUserArray, resolveEvent.getName());
    }

    protected void resolveFailed(ResolveEvent resolveEvent) {
        String[] stringArray = resolveEvent.getFailedNames();
        Debug.stAssert(stringArray.length == 1);
        this.notifyResolveFailed(stringArray[0], resolveEvent.getReason());
    }

    protected void loggedOut(LoginEvent loginEvent) {
        int n;
        if (this.m_enableLoginPopups && (n = loginEvent.getReason()) != 0) {
            String[] stringArray = this.getErrorMessage(n, loginEvent.getCommunity());
            if (stringArray == null) {
                return;
            }
            this.m_factory.showErrorMessage(this.getSession(), n, stringArray);
        }
    }

    public void enableLoginPopups(boolean bl) {
        this.m_enableLoginPopups = bl;
    }

    protected void loggedIn(LoginEvent loginEvent) {
    }

    protected void adminMsgReceived(AdminMsgEvent adminMsgEvent) {
        this.m_factory.showAdminMessage(this.getSession(), adminMsgEvent.getMsgText());
    }

    protected void resolved(ResolveViewEvent resolveViewEvent) {
        this.notifyResolved(resolveViewEvent.getResolvedName(), resolveViewEvent.getUser());
    }

    protected void resolveFailed(ResolveViewEvent resolveViewEvent) {
        this.notifyResolveFailed(resolveViewEvent.getResolvedName(), resolveViewEvent.getReason());
    }

    private void notifyResolved(String string, STUser sTUser) {
        Enumeration enumeration = this.m_listeners.elements();
        CommUIEvent commUIEvent = new CommUIEvent((Object)this, CommUIEvent.RESOLVE_SUCCESS, string, sTUser);
        while (enumeration.hasMoreElements()) {
            CommUIListener commUIListener = (CommUIListener)enumeration.nextElement();
            commUIListener.resolved(commUIEvent);
        }
    }

    private void notifyResolveFailed(String string, int n) {
        Enumeration enumeration = this.m_listeners.elements();
        CommUIEvent commUIEvent = new CommUIEvent((Object)this, CommUIEvent.RESOLVE_FAILURE, string, n);
        while (enumeration.hasMoreElements()) {
            CommUIListener commUIListener = (CommUIListener)enumeration.nextElement();
            commUIListener.resolveFailed(commUIEvent);
        }
    }

    protected String[] getErrorMessage(int n, String string) {
        String string2 = null;
        switch (n) {
            case -2147483131: {
                string2 = "CONNECT_NET_DOWN";
                break;
            }
            case -2147483126: {
                string2 = "CONNECT_PROXY_ERROR;";
                break;
            }
            case -2147483125: {
                string2 = "CONNECT_SERVER_IS_FULL";
                break;
            }
            case -2147483124: {
                string2 = "CONNECT_SERVER_NOT_RESPONDING";
                break;
            }
            case -2147483119: {
                string2 = "CONNECT_BAD_LOGIN";
                break;
            }
            case -2147483104: {
                string2 = "CONNECT_SERVER_NAME_NOT_FOUND";
                break;
            }
            case -2147483103: {
                string2 = "CONNECT_BROKEN";
                break;
            }
            case -2147483100: {
                string2 = "CONNECT_RESET";
                break;
            }
            case -2147483099: {
                string2 = "CONNECT_TIMEOUT";
                break;
            }
            case -2147483136: {
                string2 = "CONNECT_VERSION_MISMATCH";
                break;
            }
            case -2147483116: {
                string2 = "CONNECT_CANNOT_VERIFY";
                break;
            }
            case -2147483097: 
            case -2147483096: {
                string2 = "FORCE_LOGOUT_MULTI_SERVERS";
                break;
            }
            case -2147483095: {
                string2 = "FORCE_LOGOUT_NEWER_IP_WINNER";
                break;
            }
            case -2147483094: {
                string2 = "FORCE_LOGOUT_OLDER_IP_WINNER";
                break;
            }
            case -2147483130: 
            case -2147483129: {
                string2 = "CONNECT_HOST_ERROR";
                break;
            }
            case -2147483093: {
                string2 = "NO_HOME_SERVER";
                break;
            }
            case -2147483092: {
                string2 = "CONNECT_HOME_SERVER_TOO_OLD";
                break;
            }
            case -2147483128: 
            case -2147483127: 
            case -2147483123: 
            case -2147483121: 
            case -2147483072: 
            case -2147483071: 
            case -2147483070: 
            case -2147483069: {
                string2 = "CONNECT_ERROR";
                break;
            }
            case -2147483091: {
                return null;
            }
            default: {
                string2 = "CONNECT_DEFAULT";
            }
        }
        Object[] objectArray = new Object[]{new Integer(n & Integer.MAX_VALUE), string};
        return this.m_resourceFile.formatStringArray(string2, objectArray);
    }

    protected void createListeners() {
        this.m_resolveViewListener = new ResolveViewListener(){

            public void resolveFailed(ResolveViewEvent resolveViewEvent) {
                CommUIComp.this.resolveFailed(resolveViewEvent);
            }

            public void resolved(ResolveViewEvent resolveViewEvent) {
                CommUIComp.this.resolved(resolveViewEvent);
            }
        };
        this.m_resolveListener = new ResolveListener(){

            public void resolved(ResolveEvent resolveEvent) {
                CommUIComp.this.resolved(resolveEvent);
            }

            public void resolveConflict(ResolveEvent resolveEvent) {
                CommUIComp.this.resolveConflict(resolveEvent);
            }

            public void resolveFailed(ResolveEvent resolveEvent) {
                CommUIComp.this.resolveFailed(resolveEvent);
            }
        };
        this.m_loginListener = new LoginListener(){

            public void loggedIn(LoginEvent loginEvent) {
                CommUIComp.this.loggedIn(loginEvent);
            }

            public void loggedOut(LoginEvent loginEvent) {
                CommUIComp.this.loggedOut(loginEvent);
            }
        };
        this.m_adminMsgListener = new AdminMsgListener(){

            public void adminMsgReceived(AdminMsgEvent adminMsgEvent) {
                CommUIComp.this.adminMsgReceived(adminMsgEvent);
            }
        };
    }
}

