/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.invitation;

import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.invitation.InviterListener;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.post.Post;
import com.lotus.sametime.post.PostEvent;
import com.lotus.sametime.post.PostListener;
import com.lotus.sametime.post.PostService;
import java.io.IOException;

public class Inviter
implements PostListener {
    private Integer m_requestId;
    private PostService m_postService;
    private InviterListener m_listener;
    private MeetingInfo m_meetingInfo;
    private boolean m_autoInvite;
    private String m_inviteText;

    protected Inviter(PostService postService) {
        this.m_postService = postService;
    }

    public void setListener(InviterListener inviterListener) {
        this.m_listener = inviterListener;
    }

    public void invite(MeetingInfo meetingInfo, String string, STUser[] sTUserArray, boolean bl, boolean bl2) {
        this.m_meetingInfo = meetingInfo;
        this.m_autoInvite = bl;
        this.m_inviteText = string;
        boolean bl3 = sTUserArray.length == 1;
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.startMark();
            meetingInfo.dump(ndrOutputStream, bl3);
            ndrOutputStream.writeBoolean(bl);
            ndrOutputStream.writeBoolean(false);
            ndrOutputStream.writeUTF("");
            ndrOutputStream.writeUTF("");
            ndrOutputStream.writeUTF("");
            ndrOutputStream.writeInt(this.m_meetingInfo.getSSLPort());
            ndrOutputStream.writeUTF(this.m_meetingInfo.getURL());
            ndrOutputStream.dumpMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Post post = this.m_postService.createPost(25, meetingInfo.getDisplayName(), string, 0, ndrOutputStream.toByteArray(), sTUserArray, bl2);
        post.addPostListener(this);
        post.send();
    }

    public void sendToUserFailed(PostEvent postEvent) {
        switch (postEvent.getReason()) {
            case 0: {
                return;
            }
            case -2147471355: {
                this.m_listener.invitationToOldClient(this, postEvent.getPostedUser());
                break;
            }
            default: {
                this.m_listener.invitationDeclined(this, postEvent.getPostedUser(), postEvent.getReason());
            }
        }
    }

    public void userResponded(PostEvent postEvent) {
    }

    public String getInviteText() {
        return this.m_inviteText;
    }

    public MeetingInfo getMeetingInfo() {
        return this.m_meetingInfo;
    }

    public boolean getAutoInvite() {
        return this.m_autoInvite;
    }
}

