/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.im;

import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.chatui.ChatConstants;
import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.MeetingHandler;
import com.lotus.sametime.chatui.im.ImModel;
import com.lotus.sametime.chatui.im.ImModelListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImListener;
import com.lotus.sametime.im.ImServiceListener;
import com.lotus.sametime.im.InstantMessagingService;
import com.lotus.sametime.names.NamesEvent;
import com.lotus.sametime.names.NamesService;
import com.lotus.sametime.names.NamesServiceListener;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImModelImpl
implements ImModel,
ImListener,
ImServiceListener,
LoginListener,
NamesServiceListener {
    private CommunityService m_CommunityService;
    private InstantMessagingService m_ImService;
    private AwarenessService m_awarenessService;
    private NamesService m_namesService;
    private STUser m_partnerInfo;
    private STUser m_ourInfo;
    private Im m_im;
    private Vector m_Listeners = new Vector();
    private EncLevel m_encLevel = EncLevel.ENC_LEVEL_RC2_40;
    private STSession m_session;
    private Vector unsentMessagesList = new Vector();
    private Vector messagesList;
    private static final int RESPONSE_DATA_TYPE = 1;
    private static final int RESPONSE_STARTED_DATA_SUB_TYPE = 0;
    private static final int RESPONSE_CANCELED_DATA_SUB_TYPE = 1;
    private STUserStatus m_partnerStatus;
    private boolean m_waitingForMessage = false;
    private boolean m_closeChatRequested = false;
    private boolean m_isViewEnabled = true;
    private boolean m_originator;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui.im");

    public ImModelImpl(STSession sTSession, STUser sTUser, Im im, boolean bl, boolean bl2) {
        this.m_im = im;
        this.m_session = sTSession;
        this.m_originator = bl;
        this.m_encLevel = im.getEncLevel();
        this.m_awarenessService = (AwarenessService)sTSession.getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        this.m_ImService = (InstantMessagingService)sTSession.getCompApi("com.lotus.sametime.im.ImComp");
        this.m_ImService.addImServiceListener(this);
        this.m_CommunityService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_CommunityService.addLoginListener(this);
        this.m_ourInfo = this.m_CommunityService.getLogin().getMyUserInstance();
        this.m_partnerInfo = sTUser;
        this.m_namesService = (NamesService)sTSession.getCompApi("com.lotus.sametime.names.NamesComp");
        if (null != this.m_namesService) {
            this.m_namesService.addNamesServiceListener(this);
            this.refreshNickNames();
        }
        this.m_im.addImListener(this);
        if (bl2) {
            this.messagesList = new Vector(50);
        }
    }

    public void init() {
        if (this.m_originator) {
            this.m_im.open();
            this.m_waitingForMessage = true;
        }
    }

    public synchronized void addImModelListener(ImModelListener imModelListener) {
        Vector vector = (Vector)this.m_Listeners.clone();
        vector.addElement(imModelListener);
        this.m_Listeners = vector;
    }

    public synchronized void removeImModelListener(ImModelListener imModelListener) {
        Vector vector = (Vector)this.m_Listeners.clone();
        vector.removeElement(imModelListener);
        this.m_Listeners = vector;
    }

    public synchronized void sendMessage(String string) {
        if (this.isOmActive()) {
            this.m_im.sendText(true, string);
        } else {
            if (!this.m_waitingForMessage) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendMessage", "sendMessage: creating message");
                }
                this.m_waitingForMessage = true;
                this.m_im.open();
            }
            this.unsentMessagesList.addElement(string);
        }
        this.messageReceived(true, string);
    }

    public synchronized void sendResponseStarted() {
        if (this.isOmActive()) {
            this.m_im.sendData(false, 1, 0, null);
        }
    }

    public void sendResponseCleared() {
        if (this.isOmActive()) {
            this.m_im.sendData(false, 1, 1, null);
        }
    }

    public void closeChat() {
        this.closeChat(true, false);
    }

    public void closeChat(boolean bl, boolean bl2) {
        if (bl) {
            this.requestShowView(false);
        } else if (bl2) {
            this.enableSendMessage(false);
        }
        if (!this.m_waitingForMessage) {
            if (this.isOmActive()) {
                this.m_im.close(0);
            }
            this.m_im.removeImListener(this);
            this.m_ImService.removeImServiceListener(this);
            this.m_CommunityService.removeLoginListener(this);
            if (null != this.m_namesService) {
                this.m_namesService.removeNamesServiceListener(this);
            }
        } else {
            this.m_closeChatRequested = true;
        }
    }

    public void setEncLevel(EncLevel encLevel) {
        if (encLevel != this.m_encLevel && !this.isOmActive()) {
            this.m_im.removeImListener(this);
            this.m_im = this.m_ImService.createIm(this.m_partnerInfo, encLevel, 1);
            this.m_waitingForMessage = true;
            this.m_im.addImListener(this);
            this.m_im.open();
        }
    }

    public void requestShowView(boolean bl) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.setVisible(bl);
        }
    }

    public void requestToFront() {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatMessage[] getChatTranscript() {
        Object[] objectArray = null;
        if (null != this.messagesList) {
            Vector vector = this.messagesList;
            synchronized (vector) {
                objectArray = new ChatMessage[this.messagesList.size()];
                this.messagesList.copyInto(objectArray);
            }
        } else {
            objectArray = new ChatMessage[]{};
        }
        return objectArray;
    }

    public boolean isEncrypted() {
        return !this.m_encLevel.isLower(EncLevel.ENC_LEVEL_ALL);
    }

    public STSession getSession() {
        return this.m_session;
    }

    public String getPartnerName() {
        return this.m_partnerInfo.getName();
    }

    public STUser getPartner() {
        return this.m_partnerInfo;
    }

    public STUserStatus getPartnerStatus() {
        STUserStatus sTUserStatus;
        if (null != this.m_awarenessService && null != (sTUserStatus = this.m_awarenessService.findUserStatus(this.m_partnerInfo))) {
            this.m_partnerStatus = sTUserStatus;
        }
        return this.m_partnerStatus;
    }

    public boolean isOmActive() {
        return this.m_im.isOpen();
    }

    public boolean isViewEnabled() {
        return this.m_isViewEnabled;
    }

    public void imReceived(ImEvent imEvent) {
        Im im = imEvent.getIm();
        if (im.getType() != this.m_im.getType()) {
            return;
        }
        if (im.getPartnerDetails().getId().equals(this.m_partnerInfo.getId())) {
            if (this.isOmActive()) {
                this.m_im.close(0);
                this.m_im.removeImListener(this);
            }
            this.m_im = im;
            this.m_im.addImListener(this);
            this.m_partnerInfo = im.getPartnerDetails();
        }
    }

    public void imOpened(ImEvent imEvent) {
        Im im = imEvent.getIm();
        Debug.stAssert(im.getType() == 1);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "imOpened", "Im Model Im Opened");
        }
        this.m_waitingForMessage = false;
        this.m_partnerInfo = im.getPartnerDetails();
        this.m_partnerStatus = im.getAcceptingSideStatus();
        this.refreshNickNames();
        this.requestShowView(true);
        Enumeration enumeration = this.unsentMessagesList.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.m_im.sendText(true, string);
        }
        this.unsentMessagesList.removeAllElements();
        EncLevel encLevel = im.getEncLevel();
        if (encLevel != this.m_encLevel) {
            this.m_encLevel = encLevel;
            this.encryptionModeChanged();
        }
        if (this.m_closeChatRequested) {
            this.closeChat();
            this.m_closeChatRequested = false;
        }
    }

    public void openImFailed(ImEvent imEvent) {
        this.m_waitingForMessage = false;
        this.sendFailed(imEvent.getReason());
        this.enableSendMessage(false);
    }

    public void imClosed(ImEvent imEvent) {
        this.m_waitingForMessage = false;
        this.responseCleared();
    }

    public void textReceived(ImEvent imEvent) {
        if (this.isSelfChat()) {
            return;
        }
        this.messageReceived(false, imEvent.getText());
    }

    public void dataReceived(ImEvent imEvent) {
        if (imEvent.getDataType() == 1) {
            if (imEvent.getDataSubType() == 0) {
                this.responseStarted();
            } else if (imEvent.getDataSubType() == 1) {
                this.responseCleared();
            }
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        STUserInstance sTUserInstance = this.m_CommunityService.getLogin().getMyUserInstance();
        if (!this.m_ourInfo.getId().equals(sTUserInstance.getId())) {
            this.closeChat();
        } else {
            this.m_ourInfo = this.m_CommunityService.getLogin().getMyUserInstance();
            this.refreshNickNames();
            this.enableSendMessage(true);
        }
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.enableSendMessage(false);
    }

    private void enableSendMessage(boolean bl) {
        this.m_isViewEnabled = bl;
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.enableSendMessage(bl);
        }
    }

    private void messageReceived(boolean bl, String string) {
        if (!bl && !this.m_isViewEnabled) {
            this.enableSendMessage(true);
        }
        STUser sTUser = bl ? this.m_ourInfo : this.m_partnerInfo;
        ChatMessage chatMessage = new ChatMessage(sTUser, string, bl);
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.messageReceived(chatMessage);
        }
        if (null != this.messagesList) {
            this.messagesList.addElement(chatMessage);
        }
    }

    private void responseCleared() {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.responseCleared(this.m_partnerInfo);
        }
    }

    private void responseStarted() {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.responseStarted(this.m_partnerInfo);
        }
    }

    private void sendFailed(int n) {
        Enumeration enumeration = ((Vector)this.m_Listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.sendFailed(n);
        }
    }

    private void encryptionModeChanged() {
        Enumeration enumeration = this.m_Listeners.elements();
        boolean bl = false;
        bl = this.isEncrypted();
        while (enumeration.hasMoreElements()) {
            ImModelListener imModelListener = (ImModelListener)enumeration.nextElement();
            imModelListener.encryptionModeChanged(bl);
        }
    }

    public void nameChanged(NamesEvent namesEvent) {
        STUser sTUser = namesEvent.getUser();
        if (sTUser.getId().equals(this.m_ourInfo.getId())) {
            this.m_ourInfo.setNickName(sTUser.getNickName());
        }
        if (sTUser.getId().equals(this.m_partnerInfo.getId())) {
            this.m_partnerInfo.setNickName(sTUser.getNickName());
        }
    }

    public void nameDelimiterChanged(NamesEvent namesEvent) {
        this.m_ourInfo.setNameDelimiter(namesEvent.getNameDelimiter());
        this.m_partnerInfo.setNameDelimiter(namesEvent.getNameDelimiter());
    }

    private void refreshNickNames() {
        if (null != this.m_namesService) {
            this.m_partnerInfo.setNickName(this.m_namesService.getNickname(this.m_partnerInfo));
            this.m_ourInfo.setNickName(this.m_namesService.getNickname(this.m_ourInfo));
        }
    }

    private boolean isSelfChat() {
        return this.m_ourInfo.getId().equals(this.m_partnerInfo.getId());
    }

    public void upgradeToMeeting(Vector vector, boolean bl) {
        EncLevel encLevel = this.m_encLevel.isLower(EncLevel.ENC_LEVEL_RC2_128) ? this.m_encLevel : EncLevel.ENC_LEVEL_RC2_40;
        new MeetingHandler(ChatConstants.getMeetingType(vector), "Meeting", vector, encLevel, this.m_session, this.m_partnerInfo, this.isOmActive(), this.getChatTranscript());
        this.enableSendMessage(false);
    }
}

