/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.conf;

import com.lotus.sametime.awarenessui.AwarenessView;
import com.lotus.sametime.awarenessui.ChatController;
import com.lotus.sametime.awarenessui.av.AVController;
import com.lotus.sametime.awarenessui.list.AwarenessList;
import com.lotus.sametime.awarenessui.placelist.PlaceAwarenessList;
import com.lotus.sametime.chatui.ChatEditEvent;
import com.lotus.sametime.chatui.ChatEditListener;
import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.ServerAttributes;
import com.lotus.sametime.chatui.TextModifier;
import com.lotus.sametime.chatui.conf.ConfController;
import com.lotus.sametime.chatui.conf.ConfModel;
import com.lotus.sametime.chatui.conf.ConfModelImpl;
import com.lotus.sametime.chatui.conf.ConfModelListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.guiutils.chat.ChatArea;
import com.lotus.sametime.guiutils.chat.ChatAreaEvent;
import com.lotus.sametime.guiutils.chat.ChatAreaListener;
import com.lotus.sametime.guiutils.chat.ChatSendField;
import com.lotus.sametime.guiutils.chat.ChatSendFieldEvent;
import com.lotus.sametime.guiutils.chat.ChatSendFieldListener;
import com.lotus.sametime.guiutils.misc.BorderPanel;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.ContentProvider;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfPanel
extends Panel
implements ConfModelListener,
ChatSendFieldListener,
ChatAreaListener,
FocusListener,
ContentProvider {
    private static final Integer MY_LINE = new Integer(0);
    private static final Integer PARTNER_LINE = new Integer(1);
    private static final Color MY_TEXT_COLOR = Color.blue;
    private static final Color PARTNER_TEXT_COLOR = Color.black;
    private ConfModel m_confModel;
    private ChatArea m_chatArea;
    private ChatSendField m_sendField;
    private AwarenessView m_peopleList;
    private Panel m_peoplePanel;
    private TextModifier m_textModifier = null;
    private CardLayout m_listLayout;
    private Panel m_cardPanel;
    private Font m_font;
    private STBundle m_resourceFile;
    private boolean m_chatAreaSelected = false;
    private boolean m_sendFieldSelected = false;
    private boolean m_chatAreaHasContent = false;
    private boolean m_sendFieldHasContent = false;
    private final int NOT_ON_CHAT_FOCUS = 0;
    private final int CHAT_AREA_FOCUS = 1;
    private final int SEND_FIELD_FOCUS = 2;
    private int m_currentFocus = 0;
    private Clipboard m_clipboard;
    private Vector m_editListenersList = new Vector();
    private Image m_typingImg;
    private Vector m_waitingChatAreaListeners = new Vector();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui.conf");

    public ConfPanel(ConfModel confModel) {
        this.m_confModel = confModel;
        this.init(confModel.getSession());
    }

    public ConfPanel(STSession sTSession, String string, EncLevel encLevel, STUser[] sTUserArray, String string2) {
        this.m_confModel = new ConfModelImpl(sTSession, string, encLevel, sTUserArray, string2);
        this.init(sTSession);
    }

    private void init(STSession sTSession) {
        Object object;
        Object object2;
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = resourceLoaderService.getBundle("properties/chatui");
        this.m_typingImg = resourceLoaderService.getImage("images/typing.gif");
        this.m_font = this.m_resourceFile.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE");
        if (null == this.m_font) {
            object2 = Toolkit.getDefaultToolkit().getFontList();
            this.m_font = new Font(object2[0], 0, 10);
        }
        try {
            this.m_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (SecurityException securityException) {
            System.out.println("Security violation on getSystemClipboard");
        }
        this.setLayout(new BorderLayout(10, 2));
        this.setBackground(SystemColor.control);
        this.m_chatArea = new ChatArea(this.m_resourceFile.getInt("CHATAREA_MAX_PARAGRAPH_NUM"), this.m_font, this.m_resourceFile.getInt("CHATTRANS_NAME_MAXWIDTH"), this.m_resourceFile);
        this.m_chatArea.addChatAreaListener(this);
        this.m_chatArea.addFocusListener(this);
        object2 = this.m_waitingChatAreaListeners.elements();
        while (object2.hasMoreElements()) {
            object = (ChatAreaListener)object2.nextElement();
            this.m_chatArea.addChatAreaListener((ChatAreaListener)object);
        }
        this.m_waitingChatAreaListeners.removeAllElements();
        object = new Panel();
        ((Container)object).setLayout(new BorderLayout());
        Label label = new Label();
        label.setBackground(SystemColor.control);
        ((Container)object).add("North", label);
        this.m_sendField = new ChatSendField(2, 2, this.m_font, this.m_resourceFile);
        this.m_sendField.addFocusListener(this);
        ((Container)object).add("Center", this.m_sendField);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", this.m_chatArea);
        panel.add("South", (Component)object);
        label.setText(this.m_resourceFile.getString("LBL_TYPEHERE"));
        this.add("Center", panel);
        this.m_peopleList = this.createList();
        this.m_cardPanel = new Panel();
        this.m_peoplePanel = new PeoplePanel();
        this.m_peoplePanel.setLayout(new BorderLayout(3, 0));
        this.m_listLayout = new CardLayout();
        this.m_cardPanel.setLayout(this.m_listLayout);
        this.m_cardPanel.add("Enabled", this.m_peopleList);
        Panel panel2 = new Panel();
        panel2.setBackground(SystemColor.control);
        this.m_cardPanel.add("Disabled", new BorderPanel(panel2));
        Label label2 = new Label(this.m_resourceFile.getString("LBL_PEOPLEHERE"));
        label2.setBackground(SystemColor.control);
        this.m_peoplePanel.add("North", label2);
        this.m_peoplePanel.add("Center", this.m_cardPanel);
        this.add("East", this.m_peoplePanel);
        this.m_sendField.addSendFieldListener(this);
        this.m_confModel.addConfModelListener(this);
        STUser[] sTUserArray = this.m_confModel.getPeople();
        for (int i = 0; i < sTUserArray.length; ++i) {
            this.userEntered(sTUserArray[i]);
        }
        ChatMessage[] chatMessageArray = this.m_confModel.getChatTranscript();
        for (int i = 0; i < chatMessageArray.length; ++i) {
            this.messageReceived(chatMessageArray[i]);
        }
        if (!this.m_confModel.isViewEnabled()) {
            this.enableSendMessage(false);
        }
    }

    private AwarenessView createList() {
        ChatController chatController;
        AwarenessView awarenessView;
        if (this.m_confModel.getPlace() != null) {
            int[] nArray = new int[]{8};
            ColumnAttributes columnAttributes = new ColumnAttributes(nArray, -1, this);
            ColumnAttributes[] columnAttributesArray = new ColumnAttributes[]{columnAttributes};
            awarenessView = new PlaceAwarenessList(this.m_confModel.getSession(), true, columnAttributesArray);
            ((PlaceAwarenessList)awarenessView).bindPlace(this.m_confModel.getPlace());
            chatController = new AVController(awarenessView.getModel());
        } else {
            awarenessView = new AwarenessList(this.m_confModel.getSession(), true);
            chatController = new ConfController(this.m_confModel.getSession(), awarenessView.getModel());
        }
        awarenessView.setController(chatController);
        return awarenessView;
    }

    public void requestFocus() {
        this.m_sendField.requestFocus();
    }

    public STUser[] getSelectedUsers() {
        if (this.m_confModel.getPlace() != null) {
            return ((PlaceAwarenessList)this.m_peopleList).getSelectedItems();
        }
        return ((AwarenessList)this.m_peopleList).getSelectedItems();
    }

    public synchronized void contentChanged(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_sendFieldHasContent = !chatSendFieldEvent.getIsEmpty();
        this.updateEditStatus();
    }

    public synchronized void startedResponse(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_confModel.sendResponseStarted();
    }

    public synchronized void stoppedResponse(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_confModel.sendResponseCleared();
    }

    public synchronized void textSubmitted(ChatSendFieldEvent chatSendFieldEvent) {
        String string = chatSendFieldEvent.getMsg();
        if (this.m_textModifier != null) {
            string = this.m_textModifier.TextSubmitted(string);
        }
        this.m_confModel.sendMessage(string);
    }

    public void selectionChanged(ChatSendFieldEvent chatSendFieldEvent) {
        this.m_sendFieldSelected = chatSendFieldEvent.getIsSelected();
        this.updateEditStatus();
    }

    public void setVisible(boolean bl) {
    }

    public void setTextModifier(TextModifier textModifier) {
        this.m_textModifier = textModifier;
    }

    public void toFront() {
    }

    public void enableSendMessage(boolean bl) {
        this.m_sendField.setEnabled(bl);
        this.m_listLayout.show(this.m_cardPanel, bl ? "Enabled" : "Disabled");
    }

    public void toolsEnabled(ServerAttributes serverAttributes) {
    }

    public void messageReceived(ChatMessage chatMessage) {
        this.m_chatArea.write(chatMessage.getName(), chatMessage.getText(), chatMessage.isMyText() ? MY_TEXT_COLOR : PARTNER_TEXT_COLOR);
    }

    public void responseStarted(STUser sTUser) {
    }

    public void responseCleared(STUser sTUser) {
    }

    public void sendFailed(int n) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendFailed", "Failed to send message, reason:" + n);
        }
    }

    public void userEntered(STUser sTUser) {
        if (this.m_confModel.getPlace() == null) {
            STUser[] sTUserArray = new STUser[]{sTUser};
            ((AwarenessList)this.m_peopleList).addUsers(sTUserArray);
        }
    }

    public void userLeft(STUser sTUser) {
        if (this.m_confModel.getPlace() == null) {
            STUser[] sTUserArray = new STUser[]{sTUser};
            ((AwarenessList)this.m_peopleList).removeUsers(sTUserArray);
        }
    }

    public void encryptionModeChanged(boolean bl) {
    }

    public void sendAllText() {
        this.m_sendField.submitText();
    }

    public void invitationDeclined(STUser sTUser, int n) {
    }

    public void cut() {
        if (this.m_currentFocus != 2 || this.m_sendField.getSelectedText().length() == 0) {
            return;
        }
        this.m_sendField.cut();
    }

    public void copy() {
        if (this.m_currentFocus == 1) {
            this.m_chatArea.copy();
        } else if (this.m_currentFocus == 2) {
            this.m_sendField.copy();
        }
    }

    public void paste() {
        if (this.m_currentFocus == 2) {
            this.m_sendField.paste();
        }
    }

    public void clearAll() {
        if (this.m_currentFocus == 1) {
            this.m_chatArea.clear();
        } else if (this.m_currentFocus == 2) {
            this.m_sendField.clear();
        }
    }

    public void addChatEditListener(ChatEditListener chatEditListener) {
        this.m_editListenersList.addElement(chatEditListener);
    }

    public void removeChatEditListener(ChatEditListener chatEditListener) {
        this.m_editListenersList.removeElement(chatEditListener);
    }

    public Vector getChatEditListeners() {
        Vector vector = new Vector();
        for (int i = 0; i < this.m_editListenersList.size(); ++i) {
            vector.addElement(this.m_editListenersList.elementAt(i));
        }
        return vector;
    }

    public void removeAllChatEditListeners() {
        this.m_editListenersList.removeAllElements();
    }

    public void addChatAreaListener(ChatAreaListener chatAreaListener) {
        if (this.m_chatArea != null) {
            this.m_chatArea.addChatAreaListener(chatAreaListener);
        } else {
            this.m_waitingChatAreaListeners.addElement(chatAreaListener);
        }
    }

    public void removeChatAreaListener(ChatAreaListener chatAreaListener) {
        if (this.m_chatArea != null) {
            this.m_chatArea.removeChatAreaListener(chatAreaListener);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.m_sendField)) {
            this.m_currentFocus = 2;
        } else if (focusEvent.getSource().equals(this.m_chatArea.getEventSource())) {
            this.m_currentFocus = 1;
        }
        this.updateEditStatus();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.m_sendField)) {
            this.m_currentFocus = 0;
            this.m_sendField.removeSelection();
        } else if (focusEvent.getSource().equals(this.m_chatArea.getEventSource())) {
            this.m_currentFocus = 0;
        }
    }

    public void chatAreaStatusChanged(ChatAreaEvent chatAreaEvent) {
        this.m_chatAreaSelected = chatAreaEvent.getSelectionStatus();
        this.updateEditStatus();
    }

    public void chatURLClicked(ChatAreaEvent chatAreaEvent) {
    }

    public void chatAreaContentChanged(ChatAreaEvent chatAreaEvent) {
        this.m_chatAreaHasContent = chatAreaEvent.getContentStatus();
        this.updateEditStatus();
    }

    protected void updateEditStatus() {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.m_sendField.hasClipboardAccess()) {
            bl = null == this.m_clipboard || null == this.m_clipboard.getContents(this);
            bl3 = this.m_currentFocus == 2 & this.m_sendFieldSelected || this.m_currentFocus == 1 & this.m_chatAreaSelected;
            bl2 = this.m_currentFocus == 2 & this.m_sendFieldSelected;
            bl4 = this.m_currentFocus == 2 & !bl;
        }
        bl = this.m_currentFocus == 2 & this.m_sendFieldHasContent || this.m_currentFocus == 1 & this.m_chatAreaHasContent;
        ChatEditEvent chatEditEvent = new ChatEditEvent(this, bl2, bl3, bl4, bl);
        for (int i = 0; i < this.m_editListenersList.size(); ++i) {
            ChatEditListener chatEditListener = (ChatEditListener)this.m_editListenersList.elementAt(i);
            chatEditListener.editStatusChanged(chatEditEvent);
        }
    }

    public CellData getColumnHeader(ColumnAttributes columnAttributes) {
        return new CellData("");
    }

    public CellData getContent(ColumnAttributes columnAttributes, Hashtable hashtable) {
        CellData cellData = new CellData(this.m_typingImg, 1);
        return cellData;
    }

    public CellData getEmptyContent(ColumnAttributes columnAttributes) {
        return new CellData("");
    }

    public void switchToMeeting(MeetingInfo meetingInfo) {
    }

    public ChatSendField getChatSendField() {
        return this.m_sendField;
    }

    private class PeoplePanel
    extends Panel
    implements FocusListener {
        public PeoplePanel() {
            this.addFocusListener(this);
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void focusGained(FocusEvent focusEvent) {
            ConfPanel.this.m_peopleList.requestFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

