/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.ChatConstants;
import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.chatui.ChatUIComp;
import com.lotus.sametime.chatui.DialogListener;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.ServerAttributes;
import com.lotus.sametime.chatui.ServerWatcher;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceEvent;
import com.lotus.sametime.places.PlaceListener;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlacesService;
import com.lotus.sametime.places.Section;
import com.lotus.sametime.places.SectionAdapter;
import com.lotus.sametime.places.SectionEvent;
import com.lotus.sametime.places.UserInPlace;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeetingHandler
implements PlaceListener {
    static final int MEETING_PLACE_TYPE = 0;
    static final int SEND_TRANSCRIPT_DATA_TYPE = 9051;
    Place m_place;
    ChatUI m_chat;
    MeetingInfo m_meetingInfo;
    STUser[] m_users;
    String m_inviteText;
    Vector m_activities = new Vector();
    boolean m_initiator;
    boolean m_omUpgrade;
    boolean m_autoInvite = false;
    ChatMessage[] m_transcript;
    boolean m_moveToSection;
    Section m_backSection;
    STSession m_session;
    private ServerWatcher m_serverWatcher;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui");

    MeetingHandler(MeetingTypes meetingTypes, String string, Vector vector, String string2, STUser[] sTUserArray, EncLevel encLevel, STSession sTSession) {
        this.m_session = sTSession;
        this.m_users = sTUserArray;
        this.m_inviteText = string2;
        this.m_initiator = true;
        this.m_omUpgrade = false;
        this.m_activities = vector;
        this.m_chat = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        PlacesService placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        String string3 = String.valueOf((long)string.hashCode() + System.currentTimeMillis());
        this.m_place = placesService.createPlace(string3, string, encLevel, 0, (short)2);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Place Name : " + this.m_place.getName());
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Number of activities in place: " + this.m_place.getActivitiesNum() + "place type: " + this.m_place.getPlaceType());
        }
        this.m_meetingInfo = new MeetingInfo(meetingTypes, string, encLevel, string3, "", "", this.m_chat.getSSLPort(), this.m_chat.getMeetingURL());
        this.m_place.addPlaceListener(this);
        this.m_place.enter("", (short)0, true);
    }

    MeetingHandler(MeetingTypes meetingTypes, String string, STUser[] sTUserArray, EncLevel encLevel, STSession sTSession) {
        this.m_session = sTSession;
        this.m_users = sTUserArray;
        this.m_initiator = true;
        this.m_omUpgrade = false;
        this.m_chat = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        PlacesService placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        String string2 = String.valueOf((long)string.hashCode() + System.currentTimeMillis());
        this.m_place = placesService.createPlace(string2, string, encLevel, 0, (short)2);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Place Name : " + this.m_place.getName());
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Number of activities in place: " + this.m_place.getActivitiesNum() + "place type: " + this.m_place.getPlaceType());
        }
        this.m_meetingInfo = new MeetingInfo(meetingTypes, string, encLevel, string2, "", "", this.m_chat.getSSLPort(), this.m_chat.getMeetingURL());
        this.m_place.addPlaceListener(this);
        this.m_place.enter("", (short)0, true);
    }

    public MeetingHandler(MeetingInfo meetingInfo, STSession sTSession, Place place, ChatMessage[] chatMessageArray, Vector vector, boolean bl) {
        this.m_session = sTSession;
        this.m_initiator = bl;
        this.m_omUpgrade = false;
        this.m_meetingInfo = meetingInfo;
        this.m_activities = vector;
        this.m_transcript = chatMessageArray;
        this.m_chat = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_place = place;
        this.m_place.addPlaceListener(this);
        if (this.m_initiator) {
            this.setPlaceParams();
        }
        this.finish();
    }

    public MeetingHandler(MeetingTypes meetingTypes, String string, Vector vector, EncLevel encLevel, STSession sTSession, STUser sTUser, boolean bl, ChatMessage[] chatMessageArray) {
        this.m_session = sTSession;
        this.m_initiator = true;
        this.m_omUpgrade = true;
        this.m_transcript = chatMessageArray;
        this.m_autoInvite = bl;
        this.m_activities = vector;
        this.m_chat = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        PlacesService placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        String string2 = String.valueOf((long)string.hashCode() + System.currentTimeMillis());
        this.m_place = placesService.createPlace(string2, string, encLevel, 0, (short)2);
        this.m_meetingInfo = new MeetingInfo(meetingTypes, string, encLevel, string2, "", "", this.m_chat.getSSLPort(), this.m_chat.getMeetingURL());
        this.m_users = new STUser[1];
        this.m_users[0] = sTUser;
        this.m_place.addPlaceListener(this);
        this.m_place.enter("", (short)0, true);
    }

    public MeetingHandler(MeetingInfo meetingInfo, STSession sTSession, ChatMessage[] chatMessageArray) {
        this.m_session = sTSession;
        this.m_initiator = false;
        this.m_omUpgrade = true;
        this.m_transcript = chatMessageArray;
        this.m_meetingInfo = meetingInfo;
        this.m_chat = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        PlacesService placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        this.finish();
    }

    public void entered(PlaceEvent placeEvent) {
        this.m_meetingInfo.setServerName(placeEvent.getPlace().getServer().getName());
        if (this.m_meetingInfo.getType().equals(MeetingTypes.ST_AUDIO_CALL)) {
            this.setPlaceParamsAudioCall();
        } else {
            this.setPlaceParams();
        }
        this.finish();
    }

    public void enterFailed(PlaceEvent placeEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "enterFailed", "CHATUI: Can't enter the place");
        }
        ((ChatUIComp)this.m_chat).sendFailed(placeEvent.getReason(), true);
    }

    public void left(PlaceEvent placeEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "left", "CHATUI: Place Left");
        }
    }

    public void sectionAdded(PlaceEvent placeEvent) {
        Section section = placeEvent.getSection();
        if (section.isStage()) {
            section.addSectionListener(new SectionAdapter(){

                public void usersEntered(SectionEvent sectionEvent) {
                    MeetingHandler.this.handleUsersEntered(sectionEvent.getUsers());
                }
            });
        } else {
            this.m_backSection = section;
            if (this.m_moveToSection) {
                this.m_moveToSection = false;
                this.moveToBackSection();
            }
        }
    }

    public void activityAdded(PlaceEvent placeEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "activityAdded", "activity Added: " + placeEvent.getActivityType());
        }
    }

    public void addActivityFailed(PlaceEvent placeEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "addActivityFailed", "CHATUI: Add Activity Failed " + placeEvent.getActivityType());
        }
    }

    private void setPlaceParamsAudioCall() {
        AudioCallParticipantXMLGenerator audioCallParticipantXMLGenerator = new AudioCallParticipantXMLGenerator(this.m_users);
        String string = audioCallParticipantXMLGenerator.getParticipantXML();
        this.m_place.changeAttribute(new STExtendedAttribute(23126, string));
        this.m_place.close();
    }

    private void setPlaceParams() {
        if (this.m_activities == null || this.m_activities.size() == 0) {
            this.m_activities = ChatConstants.getActivities(this.m_meetingInfo.getType(), false);
        }
        this.removeActivities();
        String string = this.getRequestedActivities();
        STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(9002, string);
        this.m_place.changeAttribute(sTExtendedAttribute);
        sTExtendedAttribute = new STExtendedAttribute(9001, this.m_meetingInfo.getDisplayName());
        this.m_place.changeAttribute(sTExtendedAttribute);
        sTExtendedAttribute = new STExtendedAttribute(9004, 1);
        this.m_place.changeAttribute(sTExtendedAttribute);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            this.m_place.getMyselfInPlace().getId().dump(ndrOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        sTExtendedAttribute = new STExtendedAttribute(9005, ndrOutputStream.toByteArray());
        this.m_place.changeAttribute(sTExtendedAttribute);
        long l = System.currentTimeMillis();
        sTExtendedAttribute = new STExtendedAttribute(9006, l);
        this.m_place.changeAttribute(sTExtendedAttribute);
        Enumeration enumeration = this.m_activities.elements();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            this.m_place.addActivity(n, null);
        }
        if (this.m_activities.size() == 1 && this.m_activities.contains(new Integer(38101))) {
            this.m_place.close();
        } else if (this.m_activities.size() == 2 && this.m_activities.contains(new Integer(38101)) && this.m_activities.contains(new Integer(37126))) {
            this.m_place.close();
        }
    }

    private void moveToBackSection() {
        if (this.m_backSection != null) {
            this.m_place.getMyselfInPlace().changeSection(this.m_backSection);
        } else {
            this.m_moveToSection = true;
        }
    }

    private void finish() {
        if (!this.m_meetingInfo.getType().equals(MeetingTypes.ST_AUDIO_CALL)) {
            if (this.m_users != null) {
                if (!this.m_omUpgrade) {
                    ((ChatUIComp)this.m_chat).inviteToMeeting(this.m_meetingInfo, this.m_place, this.m_inviteText, this.m_users, false, false, true);
                } else {
                    ((ChatUIComp)this.m_chat).inviteToMeeting(this.m_meetingInfo, this.m_place, "", this.m_users, false, this.m_autoInvite, true);
                }
            }
            this.showRelaxDialog(this.m_initiator);
        }
        if (this.m_initiator) {
            this.launchBrowser();
        }
    }

    void launchBrowser() {
        ((ChatUIComp)this.m_chat).launchMeeting(this.m_meetingInfo, false, this.m_initiator);
        if (this.m_users == null && this.m_place != null) {
            this.m_place.close();
        }
    }

    private void showRelaxDialog(boolean bl) {
        this.m_chat.getChatFactory().showMeetingInfoDialog(bl, new DialogHandler());
    }

    private String getRequestedActivities() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.m_activities.elements();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            stringBuffer.append(n);
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private void handleUsersEntered(UserInPlace[] userInPlaceArray) {
    }

    private String createTranscriptString() {
        String string = "";
        for (int i = 0; i < this.m_transcript.length; ++i) {
            string = string + this.m_transcript[i].getUser().getDisplayName() + "   ";
            string = string + this.m_transcript[i].getText() + "\n";
        }
        return string;
    }

    public void sendFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void attributeChanged(PlaceMemberEvent placeMemberEvent) {
    }

    public void attributeRemoved(PlaceMemberEvent placeMemberEvent) {
    }

    public void changeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "changeAttributeFailed", "Meeting handler was unabled to set attribute " + placeMemberEvent.getAttributeKey());
        }
    }

    public void removeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void sectionRemoved(PlaceEvent placeEvent) {
    }

    public void invite15UserFailed(PlaceEvent placeEvent) {
    }

    public void activityRemoved(PlaceEvent placeEvent) {
    }

    public void addAllowedUsersFailed(PlaceEvent placeEvent) {
    }

    public void removeAllowedUsersFailed(PlaceEvent placeEvent) {
    }

    public void queryAttrContentFailed(PlaceMemberEvent placeMemberEvent) {
    }

    void removeActivities() {
        ChatUIComp chatUIComp = (ChatUIComp)this.m_session.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        ServerWatcher serverWatcher = chatUIComp.getServerWatcher();
        CommunityService communityService = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
        STServer sTServer = communityService.getLogin().getServer();
        ServerAttributes serverAttributes = serverWatcher.getServerAttributes(sTServer);
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration enumeration = this.m_activities.elements();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (n == 37129) {
                if (!serverAttributes.isUrlPushEnabled()) continue;
                vector.addElement(n);
                continue;
            }
            if (n == 37130) {
                if (!serverAttributes.isQuestionsAndAnswersEnabled()) continue;
                vector.addElement(n);
                continue;
            }
            vector.addElement(n);
        }
        this.m_activities = vector;
    }

    class AudioCallParticipantXMLGenerator {
        final String XML_VERSION = "<?xml version=\"1.0\" ?>";
        final String PARTICIPANTS = "participants";
        final String PARTICIPANT = "participant";
        final String NAME = "name";
        final String CANONICAL_NAME = "canonicalname";
        final String PHONENUMBER = "phonenumber";
        final String LABEL = "label";
        final String VALUE = "value";
        STUser[] users = null;

        public AudioCallParticipantXMLGenerator(STUser[] sTUserArray) {
            this.users = sTUserArray;
        }

        public String getParticipantXML() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" ?>");
            stringBuffer.append(this.getOpeningKey("participants"));
            for (int i = 0; i < this.users.length; ++i) {
                stringBuffer.append(this.getOpeningKey("participant"));
                STUser sTUser = this.users[i];
                stringBuffer.append(this.getOpeningKey("name"));
                stringBuffer.append(sTUser.getDisplayName());
                stringBuffer.append(this.getClosingKey("name"));
                stringBuffer.append(this.getOpeningKey("canonicalname"));
                stringBuffer.append(sTUser.getId().getId());
                stringBuffer.append(this.getClosingKey("canonicalname"));
                stringBuffer.append(this.getClosingKey("participant"));
            }
            stringBuffer.append(this.getClosingKey("participants"));
            return stringBuffer.toString();
        }

        protected String getOpeningKey(String string) {
            String string2 = "<";
            string2 = string2 + string;
            string2 = string2 + ">";
            return string2;
        }

        protected String getClosingKey(String string) {
            String string2 = "</";
            string2 = string2 + string;
            string2 = string2 + ">";
            return string2;
        }
    }

    class DialogHandler
    implements DialogListener {
        int OK = 1;

        DialogHandler() {
        }

        public void dialogClosed(int n) {
            if (!MeetingHandler.this.m_initiator && n == this.OK) {
                MeetingHandler.this.launchBrowser();
            }
        }
    }
}

