/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.AddToListListener;
import com.lotus.sametime.chatui.ChatConstants;
import com.lotus.sametime.chatui.ChatFactory;
import com.lotus.sametime.chatui.ChatFrame;
import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.ChatModel;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.chatui.DialogListener;
import com.lotus.sametime.chatui.JoinDialogInfo;
import com.lotus.sametime.chatui.JoinMeetingListener;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.TextModifier;
import com.lotus.sametime.chatui.UbqDialogHandler;
import com.lotus.sametime.chatui.UrlClickEvent;
import com.lotus.sametime.chatui.UrlClickListener;
import com.lotus.sametime.chatui.invitation.InviteDialog;
import com.lotus.sametime.chatui.invitation.InviteDialogListener;
import com.lotus.sametime.chatui.invitation.JoinDialog;
import com.lotus.sametime.chatui.invitation.JoinDialogListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.guiutils.chat.ChatAreaAdapter;
import com.lotus.sametime.guiutils.chat.ChatAreaEvent;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TooManyListenersException;
import java.util.Vector;

public class DefaultChatFactory
implements ChatFactory {
    public static final int TOP_PANEL = 1;
    public static final int CENTER_PANEL = 2;
    public static final int BOTTOM_PANEL = 3;
    private Hashtable m_joinDialogs = new Hashtable();
    private Hashtable m_inviteDialogs = new Hashtable();
    private STBundle m_resourceFile;
    private int m_cascadingIterator = 0;
    private int m_cascadingDirection = 0;
    private Vector m_frameMenuItems = new Vector();
    private Vector m_urlClickListeners = new Vector();
    AddToListListener m_addToListListener;
    private STSession m_session;
    private chatAreaListenerImpl m_chatAreaListener;
    private inviteDialogListenerImpl m_inviteDialogListener;
    private joinDialogListenerImpl m_joinListener;
    protected ChatModel m_chatModel;
    protected ChatFrame m_chatFrame;

    public DefaultChatFactory(STSession sTSession) {
        this.m_session = sTSession;
        this.createListeners();
    }

    public Panel getCustomizedPanels(int n, ChatFrame chatFrame) {
        return null;
    }

    public void getCustomizedMenu(MenuBar menuBar) {
    }

    public void createView(ChatModel chatModel, String string, boolean bl) {
        this.m_chatModel = chatModel;
        ChatFrame chatFrame = chatModel.isInConfMode() ? new ChatFrame(chatModel) : new ChatFrame(chatModel, bl, string);
        this.m_chatFrame = chatFrame;
        chatFrame.addChatAreaListener(this.m_chatAreaListener);
        this.position(chatFrame);
    }

    public void showJoinDialog(STSession sTSession, MeetingInfo meetingInfo, STUser sTUser, String string, JoinMeetingListener joinMeetingListener) {
        this.checkResourceFile();
        Object[] objectArray = new Object[]{sTUser.getDisplayName(), DateFormat.getDateInstance().format(new Date(System.currentTimeMillis()))};
        String string2 = this.m_resourceFile.formatString("INVITATION_FROM", objectArray);
        boolean bl = !meetingInfo.getEncLevel().isLower(EncLevel.ENC_LEVEL_ALL);
        JoinDialog joinDialog = new JoinDialog(this.getMainFrame(sTSession), string2, sTUser.getName(), meetingInfo.getType(), meetingInfo.getDisplayName(), string, bl, sTSession, this.m_joinListener, sTUser);
        this.m_joinDialogs.put(joinDialog, new JoinDialogInfo(meetingInfo, sTUser, joinMeetingListener));
    }

    public Dialog doInviteDialog(STSession sTSession, MeetingTypes meetingTypes, String string, String string2, STUser[] sTUserArray, boolean bl, InviteDialogListener inviteDialogListener) {
        this.checkResourceFile();
        Vector vector = ChatConstants.getActivities(meetingTypes, true);
        InviteDialog inviteDialog = new InviteDialog(this.getMainFrame(sTSession), sTSession, string, string2, EncLevel.ENC_LEVEL_RC2_40, sTUserArray, vector, bl);
        inviteDialog.setListener(this.m_inviteDialogListener);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = inviteDialog.getLocation();
        if (point.x < 0) {
            inviteDialog.setLocation(200, 200);
        }
        inviteDialog.setVisible(true);
        inviteDialog.toFront();
        inviteDialog.requestFocus();
        this.m_inviteDialogs.put(inviteDialog, inviteDialogListener);
        return inviteDialog;
    }

    public void displayErrorMessage(STSession sTSession, int n, boolean bl) {
        this.checkResourceFile();
        UbqDialog ubqDialog = null;
        Frame frame = this.getMainFrame(sTSession);
        if (n == -2147482363) {
            ubqDialog = new UbqDialog(frame, this.m_resourceFile.getString("FRM_TITLE_ALERT"), this.m_resourceFile.formatStringArray("MISSING_LISTENER"), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
        } else if (bl) {
            ubqDialog = new UbqDialog(frame, this.m_resourceFile.getString("FRM_TITLE_ALERT"), this.m_resourceFile.formatStringArray("CONF_NOTAVAIL"), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
        } else if (n == -2147483642) {
            ubqDialog = new UbqDialog(frame, this.m_resourceFile.getString("FRM_TITLE_ALERT"), this.m_resourceFile.formatStringArray("USER_NOT_ONLINE"), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
        } else if (n == -2147475455) {
            ubqDialog = new UbqDialog(frame, this.m_resourceFile.getString("FRM_TITLE_ALERT"), this.m_resourceFile.formatStringArray("USER_DND_OM"), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
        } else if (n != -2147483615) {
            Object[] objectArray = new Object[]{new Integer(n)};
            ubqDialog = new UbqDialog(frame, this.m_resourceFile.getString("FRM_TITLE_ALERT"), this.m_resourceFile.formatStringArray("CREATE_OM_DENIED", objectArray), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
        }
        ubqDialog.setVisible(true);
    }

    public void closeAllWindows() {
        Hashtable hashtable = (Hashtable)this.m_inviteDialogs.clone();
        Hashtable hashtable2 = (Hashtable)this.m_joinDialogs.clone();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            InviteDialog inviteDialog = (InviteDialog)enumeration.nextElement();
            inviteDialog.setVisible(false);
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            JoinDialog joinDialog = (JoinDialog)enumeration.nextElement();
            joinDialog.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinDlgJoinButtonPressed(JoinDialog joinDialog) {
        JoinDialogInfo joinDialogInfo = (JoinDialogInfo)this.m_joinDialogs.get(joinDialog);
        joinDialogInfo.m_listener.acceptMeeting(joinDialogInfo.m_meetingInfo);
        DefaultChatFactory defaultChatFactory = this;
        synchronized (defaultChatFactory) {
            this.m_joinDialogs.remove(joinDialog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinDlgCloseButtonPressed(JoinDialog joinDialog) {
        JoinDialogInfo joinDialogInfo = (JoinDialogInfo)this.m_joinDialogs.get(joinDialog);
        joinDialogInfo.m_listener.declineMeeting(joinDialogInfo.m_meetingInfo);
        DefaultChatFactory defaultChatFactory = this;
        synchronized (defaultChatFactory) {
            this.m_joinDialogs.remove(joinDialog);
        }
    }

    private void joinDlgRespondButtonPressed(JoinDialog joinDialog) {
        JoinDialogInfo joinDialogInfo = (JoinDialogInfo)this.m_joinDialogs.get(joinDialog);
        Debug.stAssert(joinDialogInfo != null);
        this.createResponse(joinDialogInfo.m_inviter, this.m_session);
    }

    private void chatURLClicked(ChatAreaEvent chatAreaEvent) {
        Vector vector = this.m_urlClickListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UrlClickListener urlClickListener = (UrlClickListener)enumeration.nextElement();
            urlClickListener.urlClicked(new UrlClickEvent(this, chatAreaEvent.getURL()));
        }
    }

    protected void createResponse(STUser sTUser, STSession sTSession) {
        this.checkResourceFile();
        ChatUI chatUI = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        chatUI.create1On1ChatById(sTUser);
    }

    public void position(Window window) {
        int n = this.m_cascadingIterator * 24;
        int n2 = this.m_cascadingIterator * 24;
        if (this.m_cascadingDirection == 1) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n3 = dimension.width;
            Dimension dimension2 = window.getSize();
            int n4 = dimension2.width;
            n = n3 - n - n4;
        }
        window.setLocation(n, n2);
        ++this.m_cascadingIterator;
        this.m_cascadingIterator %= 10;
    }

    public Dimension getFrameSize() {
        return new Dimension();
    }

    public void setCascadingDirection(int n) {
        this.m_cascadingDirection = n;
    }

    public int getCascadingDirection() {
        return this.m_cascadingDirection;
    }

    public void addFrameMenuItem(MenuItem menuItem) {
        this.m_frameMenuItems.addElement(menuItem);
    }

    public void removeFrameMenuItem(MenuItem menuItem) {
        this.m_frameMenuItems.removeElement(menuItem);
    }

    public Enumeration getFrameMenuItems() {
        return this.m_frameMenuItems.elements();
    }

    public synchronized void addUrlClickListener(UrlClickListener urlClickListener) {
        Vector vector = (Vector)this.m_urlClickListeners.clone();
        vector.addElement(urlClickListener);
        this.m_urlClickListeners = vector;
    }

    public synchronized void removeUrlClickListener(UrlClickListener urlClickListener) {
        Vector vector = (Vector)this.m_urlClickListeners.clone();
        vector.removeElement(urlClickListener);
        this.m_urlClickListeners = vector;
    }

    public void addAddToListListener(AddToListListener addToListListener) throws TooManyListenersException {
        if (this.m_addToListListener != null) {
            throw new TooManyListenersException();
        }
        this.m_addToListListener = addToListListener;
    }

    public void removeAddToListListener(AddToListListener addToListListener) {
        Debug.stAssert(this.m_addToListListener == addToListListener);
        this.m_addToListListener = null;
    }

    public TextModifier getTextModifier(ChatFrame chatFrame) {
        return null;
    }

    public AddToListListener getAddToListListener() {
        return this.m_addToListListener;
    }

    public void showMeetingInfoDialog(boolean bl) {
        this.showMeetingInfoDialog(bl, null);
    }

    public void showMeetingInfoDialog(boolean bl, DialogListener dialogListener) {
        this.checkResourceFile();
        String string = this.m_resourceFile.getString("ALERT_TITLE");
        String string2 = bl ? "ALERT_TEXT" : "UPGRADE_TEXT";
        String[] stringArray = this.m_resourceFile.formatStringArray(string2);
        String[] stringArray2 = new String[]{this.m_resourceFile.getString("BTN_LBL_OK")};
        Frame frame = (Frame)this.m_session.getSessionProperty("mainFrame");
        if (frame == null) {
            frame = new Frame();
        }
        UbqDialog ubqDialog = new UbqDialog(frame, string, stringArray, stringArray2);
        if (dialogListener != null) {
            ubqDialog.addListener(new UbqDialogHandler(dialogListener));
        }
        ubqDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inviteDialogCanceled(Dialog dialog) {
        InviteDialogListener inviteDialogListener;
        DefaultChatFactory defaultChatFactory = this;
        synchronized (defaultChatFactory) {
            inviteDialogListener = (InviteDialogListener)this.m_inviteDialogs.remove(dialog);
        }
        inviteDialogListener.inviteDialogCanceled(dialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inviteDlgSendClicked(Dialog dialog, String string, String string2, STUser[] sTUserArray, EncLevel encLevel, Vector vector) {
        InviteDialogListener inviteDialogListener;
        DefaultChatFactory defaultChatFactory = this;
        synchronized (defaultChatFactory) {
            inviteDialogListener = (InviteDialogListener)this.m_inviteDialogs.remove(dialog);
        }
        inviteDialogListener.inviteDlgSendClicked(dialog, string, string2, sTUserArray, encLevel, vector);
    }

    Frame getMainFrame(STSession sTSession) {
        Frame frame = (Frame)sTSession.getSessionProperty("mainFrame");
        return frame == null ? new Frame() : frame;
    }

    private void checkResourceFile() {
        if (this.m_resourceFile == null) {
            this.m_resourceFile = ((ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/chatui");
        }
    }

    private void createListeners() {
        this.m_inviteDialogListener = new inviteDialogListenerImpl();
        this.m_joinListener = new joinDialogListenerImpl();
        this.m_chatAreaListener = new chatAreaListenerImpl();
    }

    public void messageReceived(ChatMessage chatMessage, boolean bl) {
        if (!chatMessage.isMyText() && bl) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class chatAreaListenerImpl
    extends ChatAreaAdapter {
        chatAreaListenerImpl() {
        }

        public void chatURLClicked(ChatAreaEvent chatAreaEvent) {
            DefaultChatFactory.this.chatURLClicked(chatAreaEvent);
        }
    }

    class inviteDialogListenerImpl
    implements InviteDialogListener {
        inviteDialogListenerImpl() {
        }

        public void inviteDialogCanceled(Dialog dialog) {
            DefaultChatFactory.this.inviteDialogCanceled(dialog);
        }

        public void inviteDlgSendClicked(Dialog dialog, String string, String string2, STUser[] sTUserArray, EncLevel encLevel, Vector vector) {
            DefaultChatFactory.this.inviteDlgSendClicked(dialog, string, string2, sTUserArray, encLevel, vector);
        }
    }

    class joinDialogListenerImpl
    implements JoinDialogListener {
        joinDialogListenerImpl() {
        }

        public void joinDlgJoinButtonPressed(JoinDialog joinDialog) {
            DefaultChatFactory.this.joinDlgJoinButtonPressed(joinDialog);
        }

        public void joinDlgCloseButtonPressed(JoinDialog joinDialog) {
            DefaultChatFactory.this.joinDlgCloseButtonPressed(joinDialog);
        }

        public void joinDlgRespondButtonPressed(JoinDialog joinDialog) {
            DefaultChatFactory.this.joinDlgRespondButtonPressed(joinDialog);
        }
    }
}

