/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.buddylist;

import com.lotus.sametime.buddylist.BLGroup;
import com.lotus.sametime.buddylist.BLServiceImpl;
import com.lotus.sametime.buddylist.BLUser;
import com.lotus.sametime.buddylist.PrivateGroup;
import com.lotus.sametime.buddylist.PublicGroup;
import com.lotus.sametime.buddylist.STBLUser;
import com.lotus.sametime.core.types.STId;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BLXMLParser
extends DefaultHandler {
    private final String BL_FILE_VERSION_71 = "7.1";
    private String m_version;
    private String m_communityType;
    private String m_communityID;
    private String m_communityName;
    private String m_groupID;
    private String m_groupType;
    private String m_groupName;
    private String m_groupExpanded;
    private String m_userCommunityID;
    private String m_userID;
    private String m_userName;
    private String m_userDisplayName;
    Vector m_groupsList = null;
    Vector m_usersList = new Vector();
    BLGroup m_blGroup = null;
    BLUser m_blUser = null;
    boolean m_isEmptyList = true;
    boolean m_isFirstGroup = true;
    Object m_obj = null;
    BLServiceImpl m_blService = null;

    public static void main(String[] stringArray) throws Exception {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("file name = " + stringArray[0]);
                FileReader fileReader = new FileReader(stringArray[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public BLXMLParser(BLServiceImpl bLServiceImpl) {
        this.m_blService = bLServiceImpl;
    }

    public void InitXmlParser(String string) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            StringReader stringReader = new StringReader(string);
            xMLReader.parse(new InputSource(stringReader));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startDocument() {
        System.out.println("Start document");
        this.m_groupsList = new Vector(0);
        this.m_isEmptyList = true;
        this.m_isFirstGroup = true;
        this.m_obj = null;
    }

    public void endDocument() {
        System.out.println("End document");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("imclientconfig")) {
            this.m_version = attributes.getValue(1);
        } else if (string3.equals("community")) {
            this.m_communityID = attributes.getValue(0);
            this.m_communityType = attributes.getValue(1);
            this.m_communityName = attributes.getValue(2);
            this.m_blService.addCommunity(this.m_communityID, this.m_communityType, this.m_communityName);
        } else if (string3.equals("group")) {
            this.m_groupID = attributes.getValue(0);
            this.m_groupType = attributes.getValue(1);
            this.m_groupName = attributes.getValue(2);
            this.m_groupExpanded = attributes.getValue(3);
            if (this.m_groupType.equals("private")) {
                this.m_obj = new PrivateGroup(this.m_groupID, this.m_groupName, "", this.m_groupExpanded.equals("expanded"), null);
            } else if (this.m_groupType.equals("public")) {
                this.m_obj = new PublicGroup(new STId(this.m_groupID, this.m_blService.m_commService.getLogin().getMyUserInstance().getCommunityName()), this.m_groupName, "", this.m_groupExpanded.equals("true"));
            }
        } else if (string3.equals("user")) {
            this.m_userCommunityID = attributes.getValue(0);
            this.m_userID = attributes.getValue(1);
            this.m_userName = attributes.getValue(2);
            this.m_userDisplayName = attributes.getValue(3);
            STId sTId = new STId(this.m_userID, this.m_blService.getCommunityName(this.m_userCommunityID));
            this.m_obj = new STBLUser(sTId, this.m_userName, "", this.m_userDisplayName);
        }
        if (this.m_obj != null && this.m_obj instanceof BLGroup) {
            this.m_usersList = new Vector();
            this.m_blGroup = (BLGroup)this.m_obj;
            this.m_isEmptyList = false;
            this.m_isFirstGroup = false;
        } else if (this.m_obj != null && this.m_obj instanceof BLUser) {
            this.m_blUser = (BLUser)this.m_obj;
            this.m_usersList.addElement(this.m_blUser);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equals("group") && !this.m_isEmptyList) {
            this.m_groupsList.addElement(this.m_blService.createGroupWithUsers(this.m_blGroup, this.m_usersList));
            System.out.println("Adding group in End Element");
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        block7: for (int i = n; i < n + n2; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    continue block7;
                }
                case '\"': {
                    continue block7;
                }
                case '\n': {
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case '\t': {
                    continue block7;
                }
            }
        }
    }
}

