/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.tree;

import com.lotus.sametime.announcementui.AnnouncementUI;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.av.AVController;
import com.lotus.sametime.awarenessui.av.ToolsDialog;
import com.lotus.sametime.awarenessui.tree.STTreeControllerUtil;
import com.lotus.sametime.awarenessui.tree.STTreeGroup;
import com.lotus.sametime.awarenessui.tree.STTreeModel;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.ImageResources;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.TreeNode;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;

public class STTreeAVController
extends AVController {
    protected boolean m_isChatMenuEnabled = false;
    protected boolean m_isAnnouncementMenuEnabled = false;
    protected boolean m_isAudioBridgeMenuEnabled = false;
    protected boolean m_isAudioMenuEnabled = false;
    protected boolean m_isVideoMenuEnabled = false;
    protected boolean m_isShareMenuEnabled = false;
    protected boolean m_isCollaborateMenuEnabled = false;
    protected boolean m_isAudioCallMenuEnabled = false;
    protected boolean m_isAvailableToolsMenuEnabled = false;
    protected boolean m_isFileTransferMenuEnabled = false;
    protected boolean m_isStartPhoneCallMenuEnabled = false;
    protected boolean onlineUser = false;

    public STTreeAVController(AwarenessModel awarenessModel) {
        super(awarenessModel);
        STTreeControllerUtil.m_model = (STTreeModel)awarenessModel;
        STTreeControllerUtil.m_resource = this.m_resource;
    }

    protected void handleNodeExpanded(TreeNode treeNode) {
        STTreeControllerUtil.nodeExpanded(treeNode);
    }

    protected void handleNodeCollapsed(TreeNode treeNode) {
        STTreeControllerUtil.nodeCollapsed(treeNode);
    }

    public void nodeDoubleClicked(TreeNode treeNode) {
        if (this.m_model.isGroup((ModelNode)treeNode)) {
            return;
        }
        Vector<TreeNode> vector = new Vector<TreeNode>();
        vector.addElement(treeNode);
        this.createMessage(vector);
    }

    public void deletePressed(Vector vector) {
        STTreeControllerUtil.deletePressed(vector, this.m_deleteEnabled);
    }

    public void createMessage(STUser sTUser) {
        if (sTUser == null) {
            return;
        }
        this.m_chat.create1On1ChatById(sTUser);
    }

    public void createAnnouncement(Vector vector) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        STTreeGroup[] sTTreeGroupArray = ((STTreeModel)this.m_model).getSelectedGroups(vector);
        for (int i = 0; i < sTTreeGroupArray.length; ++i) {
            STTreeGroup sTTreeGroup = sTTreeGroupArray[i];
            if (sTTreeGroup.isShortcut()) {
                vector2.addElement(sTTreeGroup);
                continue;
            }
            object = ((STTreeModel)this.m_model).getUsersInGroup(sTTreeGroup);
            for (int j = 0; j < ((STUser[])object).length; ++j) {
                STUserStatus sTUserStatus = ((STWatchedUser)object[j]).getStatus();
                if (sTUserStatus.isStatus((short)0) || sTUserStatus.isStatus((short)128) || ((STUser)object[j]).isExternalUser() || vector2.contains(object[j])) continue;
                vector2.addElement(object[j]);
            }
        }
        STWatchedUser[] sTWatchedUserArray = ((STTreeModel)this.m_model).getSelectedUsers(vector);
        for (int i = 0; i < sTWatchedUserArray.length; ++i) {
            object = sTWatchedUserArray[i].getStatus();
            if (((STUserStatus)object).isStatus((short)0) || ((STUserStatus)object).isStatus((short)128) || sTWatchedUserArray[i].isExternalUser() || vector2.contains(sTWatchedUserArray[i])) continue;
            vector2.addElement(sTWatchedUserArray[i]);
        }
        Object[] objectArray = new STObject[vector2.size()];
        vector2.copyInto(objectArray);
        object = (AnnouncementUI)this.m_model.getSession().getCompApi("com.lotus.sametime.announcementui.AnnouncementUIComp");
        object.sendAnnouncement((STObject[])objectArray);
    }

    public void removeSelectedNodes(Vector vector) {
        STTreeControllerUtil.removeSelectedNodes(vector);
    }

    protected void enablePopupItems(Vector vector) {
        this.m_popup.removeAll();
        if (this.m_messageEnabled) {
            this.m_popup.add(this.m_message);
        }
        if (this.m_audioCallEnabled) {
            this.m_popup.add(this.m_audioCall);
        }
        if (this.m_phoneServiceId != null) {
            this.m_popup.add(this.m_startPhoneCall);
            this.m_startPhoneCall.setEnabled(this.m_isStartPhoneCallMenuEnabled);
        }
        if (this.m_announcementEnabled) {
            this.m_popup.add(this.m_announcement);
        }
        if (this.m_audioEnabled && this.m_meetingEnabled) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_audio);
        }
        if (this.m_videoEnabled && this.m_meetingEnabled) {
            this.m_popup.add(this.m_video);
        }
        if ((this.m_chat.isAppShareEnabled() || this.m_chat.isWhiteBoardEnabled()) && this.m_meetingEnabled) {
            this.m_popup.add(this.m_share);
        }
        if (this.m_meetingEnabled && (this.m_videoEnabled || this.m_audioEnabled)) {
            this.m_popup.add(this.m_collaborate);
        }
        if (this.m_fileTransferEnabled) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_fileTransfer);
        }
        if (this.m_meetingEnabled && (this.m_videoEnabled || this.m_audioEnabled)) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_availableTools);
        }
        this.m_message.setEnabled(this.m_isChatMenuEnabled);
        this.m_announcement.setEnabled(this.m_isAnnouncementMenuEnabled);
        this.m_audio.setEnabled(this.m_isAudioMenuEnabled);
        this.m_video.setEnabled(this.m_isVideoMenuEnabled);
        this.m_share.setEnabled(this.m_isShareMenuEnabled);
        this.m_collaborate.setEnabled(this.m_isCollaborateMenuEnabled);
        this.m_audioCall.setEnabled(this.m_isAudioCallMenuEnabled);
        this.m_availableTools.setEnabled(this.m_isAvailableToolsMenuEnabled);
        this.m_fileTransfer.setEnabled(this.m_isFileTransferMenuEnabled);
    }

    protected void handleSelectionChanged(Vector vector) {
        AwarenessNode awarenessNode;
        this.m_isChatMenuEnabled = false;
        this.m_isAnnouncementMenuEnabled = false;
        this.m_isAudioBridgeMenuEnabled = false;
        this.m_isAudioMenuEnabled = false;
        this.m_isVideoMenuEnabled = false;
        this.m_isShareMenuEnabled = false;
        this.m_isCollaborateMenuEnabled = false;
        this.m_isAvailableToolsMenuEnabled = false;
        this.m_isFileTransferMenuEnabled = false;
        this.m_isStartPhoneCallMenuEnabled = false;
        this.onlineUser = false;
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            awarenessNode = (AwarenessNode)enumeration.nextElement();
            if (this.m_model.isGroup(awarenessNode)) {
                n += STTreeControllerUtil.numOfOnlineUsersInGroup(awarenessNode);
                n2 += STTreeControllerUtil.numOfOnlineExternalUsersInGroup(awarenessNode);
                if (this.m_phoneServiceId == null || awarenessNode.getChilds().size() <= 0) continue;
                this.m_isStartPhoneCallMenuEnabled = true;
                continue;
            }
            if (this.m_phoneServiceId != null) {
                this.m_isStartPhoneCallMenuEnabled = true;
            }
            if (!awarenessNode.isOnline()) continue;
            ++n;
            if (!((STUser)awarenessNode.getKey()).isExternalUser()) continue;
            ++n2;
        }
        int n3 = n - n2;
        this.m_isChatMenuEnabled = this.m_messageEnabled && (n3 > 0 || n2 == 1);
        this.m_isAudioMenuEnabled = this.m_messageEnabled && this.m_meetingEnabled && (n3 > 0 || n2 == 1);
        this.m_isVideoMenuEnabled = this.m_messageEnabled && this.m_meetingEnabled && (n3 > 0 || n2 == 1);
        this.m_isAnnouncementMenuEnabled = this.m_messageEnabled && n3 > 0;
        this.m_isShareMenuEnabled = this.m_messageEnabled && this.m_meetingEnabled && n3 > 0;
        this.m_isCollaborateMenuEnabled = this.m_messageEnabled && this.m_meetingEnabled && n3 > 0;
        this.m_isAvailableToolsMenuEnabled = this.m_messageEnabled && this.m_meetingEnabled && n3 > 0;
        this.m_isAudioCallMenuEnabled = this.m_audioCallEnabled;
        if (vector.size() == 1 && !this.m_model.isGroup(awarenessNode = (AwarenessNode)vector.elementAt(0)) && awarenessNode.isOnline() && !((STUser)awarenessNode.getKey()).isExternalUser()) {
            this.m_isFileTransferMenuEnabled = true;
        }
        if (StaticProps.m_bUnixOS) {
            this.m_isAudioMenuEnabled = false;
            this.m_isVideoMenuEnabled = false;
            this.m_isAvailableToolsMenuEnabled = false;
        }
    }

    protected void displayAvailableTools() {
        STBoolean sTBoolean = new STBoolean(false);
        Vector vector = this.getOnlineUsers(this.m_selectedNodes, true, sTBoolean);
        if (sTBoolean.getValue()) {
            // empty if block
        }
        STUser[] sTUserArray = new STUser[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            AwarenessNode awarenessNode = (AwarenessNode)vector.elementAt(i);
            sTUserArray[i] = (STUser)awarenessNode.getKey();
        }
        ToolsDialog toolsDialog = new ToolsDialog(this.m_model.getSession(), sTUserArray);
        toolsDialog.setVisible(true);
    }

    protected void createMeeting(MeetingTypes meetingTypes) {
        AwarenessNode awarenessNode;
        Object object;
        Object object2;
        String string = this.m_commService.getLogin().getMyUserInstance().getName();
        String string2 = this.m_resource.getString("PLEASE_JOIN_THIS_MEETING");
        String string3 = this.m_resource.formatString("'S_MEETING", string);
        Vector vector = this.getOnlineUsers(this.m_selectedNodes);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode2 = (AwarenessNode)enumeration.nextElement();
            if (!awarenessNode2.isOnline()) continue;
            ++n;
            if (!((STUser)awarenessNode2.getKey()).isExternalUser()) continue;
            ++n2;
        }
        n3 = n - n2;
        boolean bl = true;
        boolean bl2 = false;
        String string4 = "";
        Object object3 = null;
        if (meetingTypes.equals(MeetingTypes.ST_AUDIO_CALL)) {
            object2 = new Vector();
            object = this.m_selectedNodes.elements();
            while (object.hasMoreElements()) {
                awarenessNode = (AwarenessNode)object.nextElement();
                if (!(awarenessNode.getKey() instanceof STUser)) continue;
                ((Vector)object2).addElement(awarenessNode);
            }
            object3 = object2;
            if (((Vector)object3).size() == 0) {
                bl = false;
            }
        } else if (meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING) || meetingTypes.equals(MeetingTypes.ST_AUDIO_MEETING)) {
            if (n3 > 0) {
                object2 = new STBoolean(false);
                object3 = this.getOnlineUsers(vector, true, (STBoolean)object2);
                if (((STBoolean)object2).getValue()) {
                    bl2 = true;
                }
            } else if (n2 == 1) {
                object3 = vector;
            } else {
                bl = false;
                bl2 = true;
            }
            string4 = meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING) ? "NON_ST_USERS_IN_VIDEO_MEETING" : "NON_ST_USERS_IN_AUDIO_MEETING";
        }
        if (meetingTypes.equals(MeetingTypes.ST_AUDIOBRIDGE_MEETING)) {
            if (n3 > 0) {
                object2 = new STBoolean(false);
                object3 = this.getOnlineUsers(vector, true, (STBoolean)object2);
                if (((STBoolean)object2).getValue()) {
                    bl2 = true;
                }
            } else if (n2 == 1) {
                object3 = vector;
            } else {
                bl = false;
                bl2 = true;
            }
            string4 = "NON_ST_USERS_IN_AUDIOBRIDGE_MEETING";
        } else if (meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING) || meetingTypes.equals(MeetingTypes.ST_SHARE_MEETING)) {
            object2 = new STBoolean(false);
            object3 = this.getOnlineUsers(vector, true, (STBoolean)object2);
            if (((STBoolean)object2).getValue()) {
                bl2 = true;
                string4 = meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING) ? "NON_ST_USERS_IN_COLLABORATION_MEETING" : "NON_ST_USERS_IN_APPSHARE_MEETING";
            }
        }
        if (bl) {
            object2 = new STUser[((Vector)object3).size()];
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                awarenessNode = (AwarenessNode)((Vector)object3).elementAt(i);
                object2[i] = (STUser)awarenessNode.getKey();
            }
            this.m_chat.createMeeting(meetingTypes, string3, string2, true, (STUser[])object2);
        }
        if (bl2) {
            object2 = ImageResources.getInstance().getImage("images/alert.gif");
            object = new UbqDialog(this.getMainFrame(), this.m_resource.getString("SAMETIME_TITLE"), this.m_resource.formatStringArray(string4), this.m_resource.formatStringArray("BTN_LBL_OK"));
            ((UbqDialog)object).setImage((Image)object2);
            ((UbqDialog)object).setVisible(true);
        }
    }

    protected void loggedOut(LoginEvent loginEvent) {
        this.m_isAudioBridgeMenuEnabled = false;
        this.m_isChatMenuEnabled = false;
        this.m_isAnnouncementMenuEnabled = false;
        this.m_isAudioMenuEnabled = false;
        this.m_isAudioCallMenuEnabled = false;
        this.m_isVideoMenuEnabled = false;
        this.m_isShareMenuEnabled = false;
        this.m_isCollaborateMenuEnabled = false;
        this.m_isAvailableToolsMenuEnabled = false;
        this.m_isFileTransferMenuEnabled = false;
        this.m_isStartPhoneCallMenuEnabled = false;
        super.loggedOut(loginEvent);
    }
}

