/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.av;

import com.lotus.sametime.awarenessui.av.CapabilitiesList;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.TextPanel;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class ToolsDialog
extends Frame {
    private CapabilitiesList m_list;
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 300;
    private ResourceLoaderService m_loader;
    private STBundle m_res;

    public ToolsDialog(STSession sTSession, STUser[] sTUserArray) {
        this.initLayout(sTSession);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ToolsDialog.this.setVisible(false);
            }
        });
        this.m_list.addUsers(sTUserArray);
    }

    protected void initLayout(STSession sTSession) {
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_res = resourceLoaderService.getBundle("properties/awarenessui");
        this.setSize(350, 300);
        this.setLayout(new BorderLayout(0, 0));
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setTitle(this.m_res.getString("AVAILABLE_TOOLS_DLG_TITLE"));
        this.setBackground(SystemColor.control);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 6));
        String[] stringArray = new String[]{this.m_res.getString("TOOLS_DLG_TEXT_1")};
        TextPanel textPanel = new TextPanel(stringArray);
        textPanel.setVGap(2);
        textPanel.setHGap(2);
        panel.add((Component)textPanel, "North");
        stringArray = new String[]{this.m_res.getString("TOOLS_DLG_TEXT_2")};
        textPanel = new TextPanel(stringArray);
        textPanel.setVGap(0);
        textPanel.setHGap(2);
        panel.add((Component)textPanel, "Center");
        this.add((Component)panel, "North");
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(0, 5));
        this.m_list = new CapabilitiesList(sTSession, false);
        panel2.add((Component)this.m_list, "Center");
        String[] stringArray2 = new String[]{this.m_res.getString("BTN_LBL_CLOSE")};
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsDialog.this.actionPerformed(actionEvent);
            }
        };
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray2, actionListener, 2);
        panel2.add((Component)buttonsPanel, "South");
        this.add((Component)panel2, "Center");
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top, insets.left, insets.bottom + 5, insets.right);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.m_list != null) {
            this.m_list.dispose();
            this.m_list = null;
            this.dispose();
        }
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                ToolsDialog.this.setVisible(false);
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                ToolsDialog.this.setVisible(false);
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_CLOSE"))){

            public void executeKeyMethod() {
                ToolsDialog.this.setVisible(false);
            }
        });
        return new KeyHandler(vector);
    }
}

