/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.announcement;

import com.lotus.sametime.announcement.AnnouncementEvent;
import com.lotus.sametime.announcement.AnnouncementListener;
import com.lotus.sametime.announcement.AnnouncementService;
import com.lotus.sametime.community.MultiCastEvent;
import com.lotus.sametime.community.MultiCastListener;
import com.lotus.sametime.community.MultiCastService;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnouncementComp
extends STComp
implements AnnouncementService {
    private Vector m_listeners = new Vector();
    private MultiCastService m_mcService;
    private MultiCastListener m_mcListener;
    private static final short ANNOUNCEMENT_MSG = 0;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.announcement");

    public AnnouncementComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.announcement.AnnouncementComp", sTSession);
        sTSession.registerComponent(this.getName(), this);
        this.m_mcListener = new MultiCastListener(){

            public void multiCastReceived(MultiCastEvent multiCastEvent) {
                AnnouncementComp.this.multiCastReceived(multiCastEvent);
            }
        };
        this.m_mcService = (MultiCastService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_mcService) {
            this.m_mcService.addMultiCastListener(this.m_mcListener);
        }
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
        if (null != this.m_mcService) {
            this.m_mcService.removeMultiCastListener(this.m_mcListener);
        }
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_mcService && sTCompApi instanceof MultiCastService) {
            this.m_mcService = (MultiCastService)sTCompApi;
            this.m_mcService.addMultiCastListener(this.m_mcListener);
        }
    }

    public synchronized void addAnnouncementListener(AnnouncementListener announcementListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(announcementListener);
        this.m_listeners = vector;
    }

    public synchronized void removeAnnouncementListener(AnnouncementListener announcementListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(announcementListener);
        this.m_listeners = vector;
    }

    public void sendAnnouncement(STObject[] sTObjectArray, boolean bl, String string) {
        for (int i = 0; i < sTObjectArray.length; ++i) {
            if (!(sTObjectArray[i] instanceof STUserInstance)) continue;
            sTObjectArray[i] = new STUser(sTObjectArray[i].getId(), sTObjectArray[i].getName(), sTObjectArray[i].getDesc());
        }
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeBoolean(bl);
            ndrOutputStream.writeUTF(string);
            this.m_mcService.sendMultiCast(sTObjectArray, (short)0, ndrOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void multiCastReceived(MultiCastEvent multiCastEvent) {
        if (multiCastEvent.getType() == 0 && this.m_listeners.size() > 0) {
            try {
                NdrInputStream ndrInputStream = new NdrInputStream(multiCastEvent.getData());
                boolean bl = ndrInputStream.readBoolean();
                String string = ndrInputStream.readUTF();
                AnnouncementEvent announcementEvent = new AnnouncementEvent(this, -2147483647, multiCastEvent.getSender(), string, bl);
                Enumeration enumeration = this.m_listeners.elements();
                while (enumeration.hasMoreElements()) {
                    AnnouncementListener announcementListener = (AnnouncementListener)enumeration.nextElement();
                    announcementListener.announcementReceived(announcementEvent);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

