/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.VariableScope;
import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.RequestOptions;
import coldfusion.saml.SAMLServiceImpl;
import coldfusion.saml.SamlAuth;
import coldfusion.saml.SamlCacheHelper;
import coldfusion.saml.SamlHelper;
import coldfusion.saml.SamlState;
import coldfusion.saml.SpConfiguration;
import coldfusion.saml.util.SignatureVerifier;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SamlResponseHandler {
    private static final String INRESPONSETO = "InResponseTo";
    private static final String LOGIN_NAMEID = "NAMEID";
    private static final String LOGIN_NAMEID_FORMAT = "NAMEIDFORMAT";
    private static final String LOGIN_NAMEIDQUALIFIER = "NAMEIDQUALIFIER";
    private static final String LOGIN_NAMEIDSPQUALIFIER = "NAMEIDSPQUALIFIER";
    private static final String LOGIN_SESSIONINDEX = "SESSIONINDEX";
    private static final String LOGIN_AUTHENTICATED = "AUTHENTICATED";
    private static final String LOGIN_ATTRIBUTES = "ATTRIBUTES";
    private static final String LOGOUT_SUCCESS = "SUCCESSFULLOGOUT";
    private static final String RELAYSTATE = "RELAYSTATE";
    private static final String LOGOUT_PREFIX = "LOGOUT";
    private static final String SAML_REQUEST = "SAMLRequest";
    private static final String SAML_RESPONSE = "SAMLResponse";
    private RequestOptions requestOptions;
    private SamlAuth auth;
    private String id;
    private String idpName;
    private String spName;

    public SamlResponseHandler(boolean request, String idpName, String spName) {
        String key = this.getId(request);
        SpConfiguration spConfig = this.getSp(spName);
        if (key != null) {
            this.id = key;
            this.requestOptions = SamlCacheHelper.getCacheValue(key, spConfig, "SAML Response");
        }
        this.idpName = idpName;
        this.spName = spName;
    }

    private String getId(boolean request) {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)FusionContext.getCurrent().getRequest());
        try {
            String text = new String(Util.base64decoder((String)(request ? httpRequest.getParameter(SAML_REQUEST) : httpRequest.getParameter(SAML_RESPONSE))), "UTF-8");
            int start = 0;
            int end = 0;
            String[] parts = text.split(INRESPONSETO);
            if (parts.length > 1) {
                start = parts[1].indexOf("\"");
                int i = start + 1;
                while (parts[1].charAt(i) != '\"') {
                    ++i;
                }
                end = i;
                return parts[1].substring(start + 1, end);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map handleResponse() {
        Map map = null;
        this.checkReplayAttack();
        if (this.isLoginResponse()) {
            map = this.handleLoginResponse();
        } else if (this.isLogoutResponse()) {
            map = this.handleLogoutResponse();
        }
        return map;
    }

    private void checkReplayAttack() {
        if (this.requestOptions == null) {
            CFLogs.APPLICATION_LOG.warn((Object)RB.getString((Object)this, (String)"ReplayAttack"));
            throw new SamlResponseException(RB.getString((Object)this, (String)"ReplayAttack"));
        }
    }

    private boolean isLoginResponse() {
        return this.requestOptions != null && this.requestOptions.getSamlState() == SamlState.LOGIN_PENDING;
    }

    private boolean isLogoutResponse() {
        return this.requestOptions != null && this.requestOptions.getSamlState() == SamlState.LOGOUT_PENDING;
    }

    public Map handleLoginResponse() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FusionContext fc = FusionContext.getCurrent();
        SpConfiguration spConfiguration = this.getSp(this.spName);
        this.auth = new SamlAuth(this.getSettings(), fc.getRequest(), fc.getResponse(), this.requestOptions, spConfiguration);
        String exceptionMessage = null;
        if (this.auth != null) {
            block12: {
                try {
                    if (this.id == null) {
                        throw new SamlResponseException(RB.getString((Object)this, (String)"InvalidResponseID"));
                    }
                    if (this.id != null && this.requestOptions == null || this.id != null && this.requestOptions != null && this.requestOptions.getSamlState() != SamlState.LOGIN_PENDING) {
                        throw new SamlResponseException(RB.getString((Object)this, (String)"LifetimeExpired"));
                    }
                    this.auth.processResponse();
                    if (this.auth.getErrors().size() > 0) {
                        if (StringUtils.equals((CharSequence)this.auth.getErrors().get(0), (CharSequence)"invalid_response")) {
                            exceptionMessage = this.auth.getLastErrorReason();
                        } else if (StringUtils.equals((CharSequence)this.auth.getErrors().get(0), (CharSequence)"invalid_binding")) {
                            exceptionMessage = RB.getString((Object)this, (String)"InvalidBinding");
                        }
                        break block12;
                    }
                    SamlCacheHelper.removeCacheValue(this.id, this.getSp(this.spName), "SAML Login");
                    map.put(LOGIN_NAMEID, this.auth.getNameId());
                    map.put(LOGIN_NAMEID_FORMAT, this.auth.getNameIdFormat());
                    map.put(LOGIN_NAMEIDQUALIFIER, this.auth.getNameIdNameQualifier());
                    map.put(LOGIN_NAMEIDSPQUALIFIER, this.auth.getNameIdSPNameQualifier());
                    map.put(LOGIN_SESSIONINDEX, this.auth.getSessionIndex());
                    map.put(LOGIN_AUTHENTICATED, this.auth.isAuthenticated());
                    map.put(LOGIN_ATTRIBUTES, this.auth.getAttributes());
                    map.put(RELAYSTATE, fc.getRequest().getParameter("RelayState"));
                    return map;
                }
                catch (SamlAuth.XXEException e1) {
                    throw e1;
                }
                catch (SettingsException s) {
                    throw new SamlResponseException(s.getLocalizedMessage());
                }
                catch (Throwable e) {
                    SamlCacheHelper.removeCacheValue(this.id, this.getSp(this.spName), "SAML Login");
                    CFLogs.APPLICATION_LOG.error((Object)e.getLocalizedMessage(), e);
                    throw new SamlResponseException(e.getLocalizedMessage(), e);
                }
            }
            if (exceptionMessage != null) {
                throw new SamlResponseException(exceptionMessage);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map handleLogoutResponse() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        FusionContext fc = FusionContext.getCurrent();
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)fc.getRequest());
        String samlResponseParameter = httpRequest.getParameter(SAML_RESPONSE);
        if (samlResponseParameter == null) throw new InvalidBindingException();
        Saml2Settings settings = this.getSettings();
        if (settings.getWantMessagesSigned()) {
            try {
                new SignatureVerifier().validateLogoutSignature(settings);
            }
            catch (Throwable t) {
                throw new SamlResponseException(t.getMessage(), t);
            }
        }
        settings.setWantMessagesSigned(false);
        this.auth = new SamlAuth(settings, fc.getRequest(), fc.getResponse(), this.requestOptions, this.getSp(this.spName));
        if (this.auth == null) return null;
        if (this.id == null) {
            throw new SamlResponseException(RB.getString((Object)this, (String)"InvalidResponseID"));
        }
        if (this.id != null && this.requestOptions == null || this.id != null && this.requestOptions != null && this.requestOptions.getSamlState() != SamlState.LOGOUT_PENDING) {
            throw new SamlResponseException(RB.getString((Object)this, (String)"LifetimeExpired"));
        }
        try {
            this.auth.processSLO(this.getId(false));
        }
        catch (Exception e) {
            throw new SamlResponseException(RB.getString((Object)this, (String)"GenericResponseException"));
        }
        if (this.auth.getErrors().size() > 0) {
            if (StringUtils.equals((CharSequence)this.auth.getErrors().get(0), (CharSequence)"invalid_logout_response")) {
                throw new SamlResponseException(this.auth.getLastErrorReason());
            }
            if (StringUtils.equals((CharSequence)this.auth.getErrors().get(0), (CharSequence)"invalid_binding")) {
                throw new SamlResponseException(RB.getString((Object)this, (String)"InvalidBinding"));
            }
            if (!StringUtils.equals((CharSequence)this.auth.getErrors().get(0), (CharSequence)"logout_not_success")) return null;
            map.put(LOGOUT_SUCCESS, false);
            return map;
        }
        map.put(LOGOUT_SUCCESS, this.auth.getLogoutSuccess());
        return map;
    }

    public Map handleLogoutRequest() {
        Map requestStruct = null;
        FusionContext fc = FusionContext.getCurrent();
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)fc.getRequest());
        String samlRequestParameter = httpRequest.getParameter(SAML_REQUEST);
        RequestOptions rq = new RequestOptions(this.idpName, this.spName, SamlState.LOGOUT_REQUEST_PROCESSING);
        if (samlRequestParameter != null) {
            String exceptionMessage = null;
            this.auth = new SamlAuth(this.getSettings(this.idpName, this.spName), fc.getRequest(), fc.getResponse(), rq, this.getSp(this.spName));
            try {
                requestStruct = this.auth.processIdpInitatedSLO();
                if (this.auth.getErrors().size() > 0) {
                    if (StringUtils.equals((CharSequence)this.auth.getErrors().get(0), (CharSequence)"invalid_logout_request")) {
                        exceptionMessage = this.auth.getLastErrorReason();
                    } else if (StringUtils.equals((CharSequence)this.auth.getErrors().get(0), (CharSequence)"invalid_binding")) {
                        exceptionMessage = RB.getString((Object)this, (String)"InvalidBinding");
                    }
                } else {
                    VariableScope varScope = FusionContext.getCurrent().pageContext.getVariableScope();
                    String sessionIndex = (String)requestStruct.get(LOGIN_SESSIONINDEX);
                    SamlCacheHelper.updateCache(LOGOUT_PREFIX + sessionIndex, rq, this.getSp(this.spName));
                }
            }
            catch (Exception e) {
                throw new SamlResponseException(RB.getString((Object)this, (String)"GenericRequestException"));
            }
            if (exceptionMessage != null) {
                throw new SamlResponseException(exceptionMessage);
            }
            return requestStruct;
        }
        throw new InvalidBindingException();
    }

    public void sendLogoutResponse(String sessionIndex) {
        FusionContext fc = FusionContext.getCurrent();
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)fc.getRequest());
        String samlRequestParameter = httpRequest.getParameter(SAML_REQUEST);
        VariableScope varScope = FusionContext.getCurrent().pageContext.getVariableScope();
        RequestOptions rq = SamlCacheHelper.getCacheValue(LOGOUT_PREFIX + sessionIndex, this.getSp(this.spName), "SAML Logout Response");
        if (samlRequestParameter != null) {
            this.auth = new SamlAuth(this.getSettings(rq.getIdpConfig(), rq.getSpConfig()), fc.getRequest(), fc.getResponse(), null, this.getSp(this.spName));
            try {
                if (rq != null && rq.getSamlState() == SamlState.LOGOUT_REQUEST_PROCESSING) {
                    this.auth.performLogoutRequestRedirect();
                }
            }
            catch (Exception e) {
                throw new SamlResponseException(RB.getString((Object)this, (String)"LogoutResponseSendException"));
            }
        }
    }

    private Saml2Settings getSettings() {
        return this.getSettings(this.idpName, this.spName);
    }

    private Saml2Settings getSettings(String idpName, String spName) {
        IdpConfiguration idpConfig = this.getIdp(idpName);
        SpConfiguration spConfig = this.getSp(spName);
        return SamlHelper.getSamlSettings(idpConfig, spConfig);
    }

    private IdpConfiguration getIdp(String idpName) {
        IdpConfiguration idpConfig = null;
        Map appStruct = SamlHelper.getStructFromAppScope("IDP", idpName);
        if (appStruct != null) {
            idpConfig = SamlHelper.createIdpConfigFromStruct(appStruct);
        }
        if (idpConfig == null) {
            idpConfig = (IdpConfiguration)ServiceFactory.getSamlService().getIdpMetadata(idpName);
        }
        if (idpConfig == null) {
            throw new IdpNotFoundException();
        }
        List<String> errors = SamlHelper.validateIdpSettings(idpConfig);
        if (!errors.isEmpty()) {
            throw new SAMLServiceImpl.IdpException(errors);
        }
        return idpConfig;
    }

    private SpConfiguration getSp(String spName) {
        SpConfiguration spConfig = null;
        Map appStruct = SamlHelper.getStructFromAppScope("SP", spName);
        if (appStruct != null) {
            spConfig = SamlHelper.createSpConfigFromStruct(appStruct);
        }
        if (spConfig == null) {
            spConfig = (SpConfiguration)ServiceFactory.getSamlService().getSpMetadata(spName);
        }
        if (spConfig == null) {
            throw new SpNotFoundException();
        }
        List<String> errors = SamlHelper.validateSpSettings(spConfig);
        if (!errors.isEmpty()) {
            throw new SAMLServiceImpl.SpException(errors);
        }
        return spConfig;
    }

    public class SpNotFoundException
    extends ApplicationException {
    }

    public class IdpNotFoundException
    extends ApplicationException {
    }

    public class InvalidBindingException
    extends ApplicationException {
    }

    public class SamlResponseException
    extends ApplicationException {
        public String message;

        public SamlResponseException(String message) {
            this.message = "";
            this.message = message;
        }

        public SamlResponseException(String message, Throwable t) {
            super(t);
            this.message = "";
            this.message = message;
        }
    }
}

