/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLEncoder {
    private static final int CASE_DIFF = 32;
    private static final BitSet dontNeedEncoding;

    private URLEncoder() {
    }

    public static String encode(String target, String encoding) {
        if (encoding != null) {
            try {
                return URLEncoder.doEncode(target, encoding);
            }
            catch (UnsupportedEncodingException exception) {
                return java.net.URLEncoder.encode(target);
            }
        }
        return java.net.URLEncoder.encode(target);
    }

    private static String doEncode(String s, String encoding) throws UnsupportedEncodingException {
        boolean _needToChange = false;
        boolean _wroteUnencodedChar = false;
        int _maxBytesPerChar = 10;
        int _length = s.length();
        StringBuffer _stringBuffer = new StringBuffer(_length);
        ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream(_maxBytesPerChar);
        OutputStreamWriter _outputStreamWriter = new OutputStreamWriter((OutputStream)_byteArrayOutputStream, encoding);
        for (int i = 0; i < _length; ++i) {
            int _char = s.charAt(i);
            if (dontNeedEncoding.get(_char)) {
                if (_char == 32) {
                    _char = 43;
                    _needToChange = true;
                }
                _stringBuffer.append((char)_char);
                _wroteUnencodedChar = true;
                continue;
            }
            try {
                char _nextChar;
                if (_wroteUnencodedChar) {
                    _outputStreamWriter = new OutputStreamWriter((OutputStream)_byteArrayOutputStream, encoding);
                    _wroteUnencodedChar = false;
                }
                _outputStreamWriter.write(_char);
                if (_char >= 55296 && _char <= 56319 && i + 1 < _length && (_nextChar = s.charAt(i + 1)) >= '\udc00' && _nextChar <= '\udfff') {
                    _outputStreamWriter.write(_nextChar);
                    ++i;
                }
                _outputStreamWriter.flush();
            }
            catch (IOException exception) {
                _byteArrayOutputStream.reset();
                continue;
            }
            byte[] _bytes = _byteArrayOutputStream.toByteArray();
            for (int j = 0; j < _bytes.length; ++j) {
                _stringBuffer.append('%');
                char _character = Character.forDigit(_bytes[j] >> 4 & 0xF, 16);
                if (Character.isLetter(_character)) {
                    _character = (char)(_character - 32);
                }
                _stringBuffer.append(_character);
                _character = Character.forDigit(_bytes[j] & 0xF, 16);
                if (Character.isLetter(_character)) {
                    _character = (char)(_character - 32);
                }
                _stringBuffer.append(_character);
            }
            _byteArrayOutputStream.reset();
            _needToChange = true;
        }
        return _needToChange ? _stringBuffer.toString() : s;
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(128);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

