/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.presentation;

import coldfusion.document.presentation.core.PresentationExceptions;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.presentation.PresentationTag;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.util.IOUtils;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class PresenterTag
extends ChildTag {
    private String name;
    private String title;
    private String image;
    private String email;
    private String biography;
    private String logo;
    private PresentationTag presentationTag;

    public PresenterTag() {
        super(PresentationTag.class);
    }

    protected void setAncestor(Tag ancestor) {
        this.presentationTag = (PresentationTag)ancestor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image.trim();
        if (this.image.length() == 0) {
            throw new PresentationExceptions.InvalidImageException(image);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public String getBiography() {
        return this.biography;
    }

    public void setBiography(String biography) {
        this.biography = biography;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo.trim();
        if (this.logo.length() == 0) {
            throw new PresentationExceptions.InvalidLogoException(logo);
        }
    }

    public void setEmail(String email) {
        this.email = email.trim();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (this.image != null) {
            File imageFile = VFSFileFactory.getFileObject((String)Utils.expandPath((String)this.image, (PageContext)this.pageContext));
            if (!imageFile.exists()) {
                throw new PresentationExceptions.InvalidImageException(this.image);
            }
            try {
                IOUtils.copyFile((File)imageFile, (File)this.presentationTag.getDataDirectory());
            }
            catch (IOException e) {
                throw new PresentationExceptions.InvalidImageException(this.image);
            }
        }
        if (this.logo != null) {
            File logoFile = VFSFileFactory.getFileObject((String)Utils.expandPath((String)this.logo, (PageContext)this.pageContext));
            if (!logoFile.exists()) {
                throw new PresentationExceptions.InvalidLogoException(this.logo);
            }
            try {
                IOUtils.copyFile((File)logoFile, (File)this.presentationTag.getDataDirectory());
            }
            catch (IOException e) {
                throw new PresentationExceptions.InvalidLogoException(this.image);
            }
        }
        if (this.email != null) {
            try {
                CFTypeValidatorFactory.getExtendedValidator((String)"email").validate((Object)this.email);
            }
            catch (CFTypeValidationException e) {
                throw new PresentationExceptions.InvalidEmailException(this.email);
            }
        }
        this.presentationTag.addPresenter(new Presenter(this.name, this.title, this.image, this.email, this.biography, this.logo));
        return 0;
    }

    public void release() {
        this.name = null;
        this.title = null;
        this.image = null;
        this.email = null;
        this.biography = null;
        this.logo = null;
        super.release();
        this.onTagEnd();
    }

    public static class Presenter {
        private String name;
        private String title;
        private String image;
        private String email;
        private String biography;
        private String logo;

        public Presenter(String name, String title, String image, String email, String biography, String logo) {
            this.name = name;
            this.title = title;
            this.image = image;
            this.email = email;
            this.biography = biography;
            this.logo = logo;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getImage() {
            return this.image;
        }

        public String getEmail() {
            return this.email;
        }

        public String getBiography() {
            return this.biography;
        }

        public String getLogo() {
            return this.logo;
        }
    }
}

