/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.codecs;

import coldfusion.nosql.mongo.codecs.CFMongoCodec;
import coldfusion.runtime.Array;
import java.util.List;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class CFListCodec
implements CFMongoCodec<List> {
    private CodecRegistry codecRegistry;

    public CFListCodec(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    public void encode(BsonWriter writer, List array, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Object value : array) {
            Codec codec = this.codecRegistry.get(value.getClass());
            encoderContext.encodeWithChildContext((Encoder)codec, writer, value);
        }
        writer.writeEndArray();
    }

    public Class<List> getEncoderClass() {
        return List.class;
    }

    public Array decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        Array array = new Array(1);
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            array.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return array;
    }

    protected Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        return this.codecRegistry.get(bsonTypeClassMap.get(bsonType)).decode(reader, decoderContext);
    }
}

