/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.nosql.NoSQLFactory;
import coldfusion.nosql.NoSQLPasswordDecryptor;
import coldfusion.nosql.NoSQLServiceHandle;
import coldfusion.nosql.mongo.CFMongoServiceHandle;
import coldfusion.nosql.mongo.MongoConfigException;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.bson.types.CFBsonJS;
import coldfusion.nosql.mongo.bson.types.CFBsonMaxKey;
import coldfusion.nosql.mongo.bson.types.CFBsonMinKey;
import coldfusion.nosql.mongo.bson.types.CFMongoDBRef;
import coldfusion.nosql.mongo.bson.types.CFMongoRegExp;
import coldfusion.server.MongoService;
import coldfusion.server.ServiceBase;
import coldfusion.util.RB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class CFMongoServiceImpl
extends ServiceBase
implements MongoService,
NoSQLFactory {
    public static final String MONGODB = "mongodb";

    public Object newMongoObjectID(Object objId) {
        return MongoUtils.getObjectId(objId);
    }

    public Object newBsonJS(String code, Map scope) {
        return new CFBsonJS(code, scope);
    }

    public Object newBsonMaxKey() {
        return CFBsonMaxKey.get();
    }

    public Object newBsonMinKey() {
        return CFBsonMinKey.get();
    }

    public Object newBsonRegExp(String pattern, String options) {
        return new CFMongoRegExp(pattern, options);
    }

    public Object newMongoDbRef(String collectionName, Object objId, String dbName) {
        return new CFMongoDBRef(collectionName, objId, dbName);
    }

    public NoSQLServiceHandle getServiceHandle(Object config) {
        return this.getServiceHandle(config, true);
    }

    public NoSQLServiceHandle getServiceHandle(Object config, boolean initService) {
        return new CFMongoServiceHandle(config, initService);
    }

    public NoSQLServiceHandle getServiceHandle(Object config, boolean initService, NoSQLPasswordDecryptor passwordDecryptor) {
        return new CFMongoServiceHandle(config, initService, passwordDecryptor);
    }

    public String getName() {
        return MONGODB;
    }

    private static boolean isMongoConnectionString(String temp) {
        return temp != null && (temp.toLowerCase().startsWith("mongodb://") || temp.startsWith("mongodb+srv://"));
    }

    private String getHostName(String host) {
        return host.substring(host.indexOf("//") + 2, host.lastIndexOf(":"));
    }

    public boolean verifyConnection(Map dataSource) {
        MongoClient mongo = null;
        MongoClientOptions.Builder builder = MongoClientOptions.builder().connectTimeout(3000);
        builder.serverSelectionTimeout(3000);
        String connectionString = (String)dataSource.get("host");
        String host = CFMongoServiceImpl.isMongoConnectionString(connectionString) ? this.getHostName(connectionString) : (String)dataSource.get("host");
        Integer port = dataSource.get("port") instanceof String ? Integer.valueOf(Integer.parseInt((String)dataSource.get("port"))) : (dataSource.get("port") instanceof Double ? Integer.valueOf(((Double)dataSource.get("port")).intValue()) : (Integer)dataSource.get("port"));
        try {
            mongo = new MongoClient(new ServerAddress(host, port.intValue()), builder.build());
        }
        catch (Exception e) {
            throw new MongoConfigException("DatasourceConnectionError", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.datasourceconnectionerror", (Object)host, (Object)port.toString()));
        }
        try {
            BsonDocument document = new BsonDocument();
            document.put("ping", (BsonValue)new BsonInt32(1));
            mongo.getDatabase((String)dataSource.get("name")).runCommand((Bson)document);
        }
        catch (Exception e) {
            mongo.close();
            throw new MongoConfigException("DatasourceConnectionError", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.datasourceconnectionerror", (Object)host, (Object)port.toString()));
        }
        mongo.close();
        return true;
    }
}

