/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.test;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.GatewayServices;
import java.util.Hashtable;
import java.util.Map;

public class TestGateway
implements Gateway {
    private GatewayServices gatewayService = null;
    private String gatewayID = "";
    private String[] listeners = null;
    private boolean shutdown = false;
    private String cfcEntryPoint = "onIncomingMessage";
    private int status = 4;
    private Thread listener = null;

    public TestGateway(String id) {
        this.gatewayID = id;
        this.gatewayService = GatewayServices.getGatewayServices();
    }

    public String outgoingMessage(CFEvent cfmsg) {
        Map data = cfmsg.getData();
        String message = (String)data.get("MESSAGE");
        System.out.println("Output Message: " + message);
        return "OK";
    }

    public void setCFCListeners(String[] listeners) {
        this.listeners = listeners;
    }

    public GatewayHelper getHelper() {
        return null;
    }

    public void setGatewayID(String id) {
        this.gatewayID = id;
    }

    public String getGatewayID() {
        return this.gatewayID;
    }

    public void start() {
        this.status = 1;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TestGateway.this.eventGenerator();
            }
        };
        this.listener = new Thread(r);
        this.shutdown = false;
        this.listener.start();
        this.status = 2;
    }

    public void stop() {
        this.status = 3;
        this.shutdown = true;
        if (this.listener.isAlive()) {
            try {
                this.listener.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.status = 4;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public int getStatus() {
        return this.status;
    }

    protected void eventGenerator() {
        for (int count = 0; !this.shutdown && count < 5; ++count) {
            CFEvent event = new CFEvent(this.gatewayID);
            event.setCfcMethod(this.cfcEntryPoint);
            event.setCfcTimeOut(10);
            Hashtable<String, String> mydata = new Hashtable<String, String>();
            mydata.put("MESSAGE", "Here is the event data " + count);
            event.setData(mydata);
            event.setGatewayType("TestGateway");
            event.setOriginatorID("message" + count);
            this.gatewayService.addEvent(event);
        }
    }
}

