/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.sms;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.GatewayServices;
import coldfusion.eventgateway.Logger;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.smpp.Connection;
import org.smpp.ServerPDUEvent;
import org.smpp.ServerPDUEventListener;
import org.smpp.Session;
import org.smpp.SmppObject;
import org.smpp.TCPIPConnection;
import org.smpp.pdu.Address;
import org.smpp.pdu.AddressRange;
import org.smpp.pdu.BindReceiver;
import org.smpp.pdu.BindRequest;
import org.smpp.pdu.BindResponse;
import org.smpp.pdu.BindTransciever;
import org.smpp.pdu.BindTransmitter;
import org.smpp.pdu.DataSM;
import org.smpp.pdu.DataSMResp;
import org.smpp.pdu.DeliverSM;
import org.smpp.pdu.DestinationAddress;
import org.smpp.pdu.EnquireLink;
import org.smpp.pdu.EnquireLinkResp;
import org.smpp.pdu.PDU;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.SubmitMultiSM;
import org.smpp.pdu.SubmitMultiSMResp;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.SubmitSMResp;
import org.smpp.pdu.Unbind;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.Queue;

public class SMSGateway
implements Gateway {
    private final String CONVERT_SMS_ID_TO_DECIMAL = "coldfusion.convertsmsidtodecimal";
    private GatewayServices gatewayService = null;
    private Logger logger = null;
    private Collection cfcListeners = new ArrayList();
    private String propsFilePath = "";
    private Session session = null;
    private Properties properties = new Properties();
    private boolean bound = false;
    private String bindingType = null;
    private String ipAddress = null;
    private int port = 0;
    private String systemId = null;
    private String password = null;
    private PDUEventListener pduListener = null;
    private AddressRange addressRange = new AddressRange();
    private String systemType = "";
    private String default_srcAddr = "";
    private byte default_srcAdd_ton = 1;
    private byte default_srcAdd_npi = 1;
    private String default_destAddr = "";
    private byte default_destAdd_ton = 1;
    private byte default_destAdd_npi = 1;
    private String default_serviceType = "";
    byte default_replaceIfPresentFlag = 0;
    private byte default_smDefaultMsgId = 0;
    private String gatewayID = "";
    private int status = 4;
    private Thread monitorThread = null;
    private boolean monitorShutdown = false;
    private final int ONE_MINUTE = 60;
    private long pingInterval = 60L;
    private Thread lazyRetryThread = null;
    private boolean lazyRetryShutdown = false;
    private long lazyRetryInterval = 60L;
    private int maxRestart = -1;
    private int retryInterval = 10;
    private boolean doRetry = true;
    private boolean ESMEProhibitedRetry = false;
    private float DEFAULT_MESSAGE_RATE;
    private float messageRate = this.DEFAULT_MESSAGE_RATE = 100.0f;
    private boolean throttle = false;
    private int backoffTime = 15;
    private long lastMessage = 0L;
    private boolean networkRetry = false;
    private boolean transientRetry = false;
    private Queue unprocessedMessages = new Queue();
    private Queue lazyRetryQueue = new Queue();
    private String cfcEntryPoint = "onIncomingMessage";
    private long receiveTimeout = 30000L;
    private HashMap waiterMap = new HashMap();
    private boolean synchronous = true;
    private static final int MAX_USERS = 3;
    private static final String TRANSCIEVER = "transciever";
    private static final String TRANSMITTER = "transmitter";
    private static final String RECEIVER = "receiver";
    private static FastHashtable DeveloperVersionUserList = new FastHashtable();
    private boolean convertMessageID2Decimal = false;
    private static FastHashtable submitOptions = new FastHashtable();
    private static FastHashtable data_options;

    public SMSGateway(String id, String configPath) {
        this.gatewayID = id;
        this.gatewayService = GatewayServices.getGatewayServices();
        this.logger = this.gatewayService.getLogger();
        this.propsFilePath = configPath;
        this.logger.info(RB.getString((Object)this, (String)"SMSGateway.init", (Object)this.gatewayID, (Object)this.propsFilePath));
        this.loadconfig();
        this.convertMessageID2Decimal = Boolean.getBoolean("coldfusion.convertsmsidtodecimal");
    }

    private void loadconfig() throws ServiceRuntimeException {
        try {
            FileInputStream propsFile = new FileInputStream(this.propsFilePath);
            this.properties.load(propsFile);
            propsFile.close();
            this.loadProperties();
        }
        catch (IOException e) {
            String error = RB.getString((Object)this, (String)"SMSGateway.badProp", (Object)this.gatewayID, (Object)this.propsFilePath);
            throw new ServiceRuntimeException(error, (Throwable)e);
        }
    }

    public String outgoingMessage(CFEvent cfmsg) {
        String ret;
        block11: {
            String command = (String)cfmsg.getData().get("command");
            if (command == null) {
                command = "submit";
            }
            this.throttle();
            ret = "";
            try {
                if (command.equalsIgnoreCase("submit")) {
                    ret = this.submit(cfmsg);
                } else if (command.equalsIgnoreCase("submitMulti")) {
                    ret = this.submitMulti(cfmsg);
                } else if (command.equalsIgnoreCase("data")) {
                    ret = this.data(cfmsg);
                } else {
                    this.logger.warn(RB.getString((Object)this, (String)"SMSGateway.badCommand", (Object)this.gatewayID, (Object)command));
                }
            }
            catch (ServiceRuntimeException sre) {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.commandErr", (Object)this.gatewayID, (Object)command, (Object)((Object)sre)));
            }
            catch (Exception e) {
                if (this.networkRetry) {
                    this.unprocessedMessages.enqueue((Object)cfmsg);
                }
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.commandErr", (Object)this.gatewayID, (Object)command, (Object)e), (Throwable)e);
                if (this.monitorThread == null || this.status != 2) break block11;
                this.monitorThread.interrupt();
            }
        }
        return ret;
    }

    public void setGatewayID(String id) {
        this.gatewayID = id;
    }

    public String getGatewayID() {
        return this.gatewayID;
    }

    public void start() {
        Runnable r;
        if (this.bound) {
            return;
        }
        int count = 0;
        this.status = 1;
        this.doRetry = true;
        this.ESMEProhibitedRetry = false;
        this.bound = this.bind();
        int restartLimit = this.maxRestart;
        int interval = this.retryInterval;
        if (this.ESMEProhibitedRetry) {
            restartLimit = 15;
            interval = 60;
        }
        if (!this.bound && this.doRetry) {
            String msg = restartLimit != -1 ? RB.getString((Object)this, (String)"SMSGateway.retryCount", (Object)this.gatewayID, (Object)Integer.toString(restartLimit)) : RB.getString((Object)this, (String)"SMSGateway.retryForever", (Object)this.gatewayID);
            this.logger.info(msg);
        }
        while (!this.bound && this.doRetry && this.status != 4 && (count < restartLimit || restartLimit == -1)) {
            this.logger.debug("Sleeping for " + interval + " seconds before retry");
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException e) {
                this.logger.info(RB.getString((Object)this, (String)"SMSGateway.interrupted", (Object)this.gatewayID));
                break;
            }
            this.logger.debug("Attempting reconnect - attempt " + count);
            this.bound = this.bind();
            ++count;
            if (!Thread.currentThread().isInterrupted()) continue;
        }
        if (this.bound) {
            this.status = 2;
        } else if (this.status == 1) {
            this.status = 5;
        }
        if (this.bound && this.monitorThread == null) {
            r = new Runnable(){

                @Override
                public void run() {
                    SMSGateway.this.monitor();
                }
            };
            this.monitorThread = new Thread(r);
            this.monitorThread.setName("SMS monitor (" + this.gatewayID + ")");
            this.monitorShutdown = false;
            this.monitorThread.start();
        }
        if (this.bound && this.transientRetry) {
            r = new Runnable(){

                @Override
                public void run() {
                    SMSGateway.this.lazyRetryThread();
                }
            };
            this.lazyRetryThread = new Thread(r);
            this.lazyRetryThread.setName("SMS retry (" + this.gatewayID + ")");
            this.lazyRetryShutdown = false;
            this.lazyRetryThread.start();
        }
        while (this.bound && !this.unprocessedMessages.isEmpty()) {
            this.outgoingMessage((CFEvent)this.unprocessedMessages.dequeue());
        }
    }

    public void stop() {
        this.status = 3;
        if (this.monitorThread != null && !Thread.currentThread().equals(this.monitorThread)) {
            this.monitorShutdown = true;
            this.monitorThread.interrupt();
            this.monitorThread = null;
        }
        if (this.lazyRetryThread != null) {
            this.lazyRetryShutdown = true;
            this.lazyRetryThread.interrupt();
            this.lazyRetryThread = null;
        }
        this.unbind();
        this.status = 4;
    }

    public void restart() {
        this.stop();
        this.logger.info(RB.getString((Object)this, (String)"SMSGateway.reloadProp", (Object)this.gatewayID, (Object)this.propsFilePath));
        this.loadconfig();
        this.start();
    }

    public int getStatus() {
        return this.status;
    }

    public GatewayHelper getHelper() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCFCListeners(String[] listeners) {
        ArrayList<String> aListeners = new ArrayList<String>();
        for (int i = 0; i < listeners.length; ++i) {
            aListeners.add(listeners[i]);
        }
        Collection collection = this.cfcListeners;
        synchronized (collection) {
            this.cfcListeners = aListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incomingMessage(PDU pdu) {
        block18: {
            if (pdu != null) {
                try {
                    String[] listeners;
                    String SMSmessage;
                    if (pdu instanceof EnquireLink) {
                        Response response = ((EnquireLink)pdu).getResponse();
                        this.logger.debug("SMSGateway (" + this.gatewayID + ") Going to send default response for enquirelink " + response.debugString());
                        this.session.respond(response);
                        break block18;
                    }
                    if (pdu instanceof Unbind) {
                        Response response = ((Unbind)pdu).getResponse();
                        this.logger.info(RB.getString((Object)this, (String)"SMSGateway.unbindRestart", (Object)this.gatewayID));
                        this.session.respond(response);
                        this.restart();
                        break block18;
                    }
                    if (pdu.isRequest()) {
                        Response response = ((Request)pdu).getResponse();
                        this.logger.debug("SMSGateway (" + this.gatewayID + ") Going to send default response for request message " + response.debugString());
                        this.session.respond(response);
                    }
                    if (!(pdu instanceof DeliverSM)) break block18;
                    DeliverSM deliverSM = (DeliverSM)pdu;
                    String desAddr = deliverSM.getDestAddr().getAddress();
                    String sourceAddr = deliverSM.getSourceAddr().getAddress();
                    String esmClass = Byte.toString(deliverSM.getEsmClass());
                    String protocolID = Byte.toString(deliverSM.getProtocolId());
                    String priority = Byte.toString(deliverSM.getPriorityFlag());
                    String registeredDelivery = Byte.toString(deliverSM.getRegisteredDelivery());
                    String messageLength = Short.toString(deliverSM.getSmLength());
                    byte coding = deliverSM.getDataCoding();
                    String dataCoding = Byte.toString(coding);
                    String charset = this.getEncoding(coding);
                    try {
                        SMSmessage = deliverSM.getShortMessage(charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        charset = "UTF8";
                        SMSmessage = deliverSM.getShortMessage(charset);
                    }
                    if ((SMSmessage == null || SMSmessage.length() == 0) && deliverSM.hasMessagePayload()) {
                        byte[] buf = deliverSM.getMessagePayload().getBuffer();
                        SMSmessage = new String(buf, charset);
                    }
                    Map optParams = this.processOptionalParams(deliverSM);
                    this.logger.debug("SMSGateway (" + this.gatewayID + ") Received SMS Message: " + SMSmessage);
                    this.logger.debug("SMSGateway (" + this.gatewayID + ")  DestAddr: " + desAddr);
                    this.logger.debug("SMSGateway (" + this.gatewayID + ")  SourceAddr: " + sourceAddr);
                    if (this.checkDeveloperLimitation(desAddr, sourceAddr)) {
                        return;
                    }
                    int size = this.cfcListeners.size();
                    if (size > 0) {
                        Collection collection = this.cfcListeners;
                        synchronized (collection) {
                            listeners = new String[size];
                            this.cfcListeners.toArray(listeners);
                        }
                    } else {
                        listeners = new String[]{null};
                    }
                    for (int i = 0; i < listeners.length; ++i) {
                        boolean sent;
                        String path = listeners[i];
                        CFEvent cfmsg = new CFEvent(this.gatewayID);
                        cfmsg.setOriginatorID(sourceAddr);
                        cfmsg.setCfcMethod(this.cfcEntryPoint);
                        FastHashtable event = new FastHashtable();
                        event.put("MESSAGE", SMSmessage);
                        event.put("sourceAddress", sourceAddr);
                        event.put("destAddress", desAddr);
                        event.put("esmClass", esmClass);
                        event.put("protocol", protocolID);
                        event.put("priority", priority);
                        event.put("registeredDelivery", registeredDelivery);
                        event.put("dataCoding", dataCoding);
                        event.put("messageLength", messageLength);
                        if (optParams != null) {
                            event.put("optionalParameters", optParams);
                        }
                        cfmsg.setData((Map)event);
                        cfmsg.setGatewayType("SMS");
                        if (path != null) {
                            cfmsg.setCfcPath(path);
                        }
                        if (sent = this.gatewayService.addEvent(cfmsg)) continue;
                        this.logger.error(RB.getString((Object)this, (String)"SMSGateway.cantAddToQueue", (Object)this.gatewayID, (Object)(path != null ? path : "default"), (Object)Integer.toString(this.gatewayService.getQueueSize()), (Object)Integer.toString(this.gatewayService.getMaxQueueSize())));
                    }
                }
                catch (Exception e) {
                    this.logger.error(RB.getString((Object)this, (String)"SMSGateway.incomingException", (Object)this.gatewayID, (Object)e), (Throwable)e);
                }
            }
        }
    }

    private String getEncoding(byte coding) {
        String charset = "UTF8";
        if (coding == 1) {
            charset = "ASCII";
        } else if (coding == 3) {
            charset = "ISO8859_1";
        } else if (coding == 5) {
            charset = "JIS208";
        } else if (coding == 7) {
            charset = "ISO8859_8";
        } else if (coding == 8) {
            charset = "UTF-16";
        } else if (coding == 13) {
            charset = "JIS212";
        }
        return charset;
    }

    private synchronized boolean bind() {
        this.logger.info(RB.getString((Object)this, (String)"SMSGateway.binding", (Object)this.gatewayID));
        boolean success = false;
        try {
            if (this.bound) {
                this.logger.debug("SMSGateway (" + this.gatewayID + ") Already bound, unbind first.");
                return true;
            }
            Object request = RECEIVER.equalsIgnoreCase(this.bindingType) ? new BindReceiver() : (TRANSMITTER.equalsIgnoreCase(this.bindingType) ? new BindTransmitter() : new BindTransciever());
            TCPIPConnection connection = new TCPIPConnection(this.ipAddress, this.port);
            connection.setReceiveTimeout(this.receiveTimeout);
            this.session = new Session((Connection)connection);
            this.session.enableStateChecking();
            request.setSystemId(this.systemId);
            request.setPassword(this.password);
            request.setSystemType(this.systemType);
            request.setInterfaceVersion((byte)52);
            request.setAddressRange(this.addressRange);
            this.pduListener = new PDUEventListener(this.session, this);
            this.logger.debug("SMSGateway (" + this.gatewayID + ") Bind request " + request.debugString());
            BindResponse response = this.session.bind((BindRequest)request, (ServerPDUEventListener)this.pduListener);
            this.logger.debug("SMSGateway (" + this.gatewayID + ") Bind response " + response.debugString());
            int commandStatus = response.getCommandStatus();
            switch (commandStatus) {
                case 0: {
                    success = true;
                    this.logger.info(RB.getString((Object)this, (String)"SMSGateway.bindOK", (Object)this.gatewayID));
                    break;
                }
                case 15: {
                    this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badSysID", (Object)this.gatewayID, (Object)this.systemId));
                    this.doRetry = false;
                    break;
                }
                case 14: {
                    this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badPassword", (Object)this.gatewayID));
                    this.doRetry = false;
                    break;
                }
                case 83: 
                case 1041: {
                    this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badSystemType", (Object)this.gatewayID, (Object)this.systemType));
                    this.doRetry = false;
                    break;
                }
                case 10: {
                    this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badSourceAddr", (Object)this.gatewayID, (Object)this.addressRange.getAddressRange()));
                    this.doRetry = false;
                    break;
                }
                case 5: {
                    this.logger.error(RB.getString((Object)this, (String)"SMSGateway.alreadyBound", (Object)this.gatewayID));
                    this.doRetry = false;
                    break;
                }
                case 257: 
                case 1043: {
                    this.ESMEProhibitedRetry = true;
                    this.doRetry = true;
                    break;
                }
                default: {
                    this.logger.info(RB.getString((Object)this, (String)"SMSGateway.bindFailed", (Object)this.gatewayID, (Object)("command status: 0x" + Integer.toString(commandStatus, 16))));
                    this.doRetry = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.info(RB.getString((Object)this, (String)"SMSGateway.bindFailed", (Object)this.gatewayID, (Object)e));
            this.logger.debug((Throwable)e);
            success = false;
        }
        return success;
    }

    private synchronized void unbind() {
        this.logger.info(RB.getString((Object)this, (String)"SMSGateway.unbind", (Object)this.gatewayID));
        try {
            if (!this.bound) {
                this.logger.debug("SMSGateway (" + this.gatewayID + ") Not bound, cannot unbind.");
                return;
            }
            this.logger.debug("SMSGateway (" + this.gatewayID + ") Going to unbind.");
            this.session.unbind();
            this.bound = false;
            this.logger.info(RB.getString((Object)this, (String)"SMSGateway.unbindOK", (Object)this.gatewayID));
        }
        catch (Exception e) {
            this.bound = false;
            this.logger.info(RB.getString((Object)this, (String)"SMSGateway.unbindFailed", (Object)this.gatewayID, (Object)e));
        }
    }

    private void monitor() {
        this.logger.debug("SMSGateway (" + this.gatewayID + ") Monitor thread starting");
        while (!this.monitorShutdown) {
            try {
                Thread.sleep(this.pingInterval * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.monitorShutdown) continue;
            try {
                this.logger.debug("SMSGateway (" + this.gatewayID + ") Pinging the connection with EnquireLink...");
                EnquireLink request = new EnquireLink();
                request.assignSequenceNumber();
                int sequenceNumber = request.getSequenceNumber();
                ResponseWaiter rw = new ResponseWaiter(sequenceNumber);
                Integer key = new Integer(sequenceNumber);
                this.waiterMap.put(key, rw);
                this.session.enquireLink(request);
                try {
                    EnquireLinkResp response = (EnquireLinkResp)rw.getResponse(this.receiveTimeout);
                    this.waiterMap.remove(key);
                    if (response == null || response.getCommandStatus() != 0) {
                        this.logger.info(RB.getString((Object)this, (String)"SMSGateway.pingRestart", (Object)this.gatewayID));
                        this.restart();
                    }
                    this.logger.debug(RB.getString((Object)this, (String)"SMSGateway.pingOK", (Object)this.gatewayID));
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception ex) {
                this.logger.info(RB.getString((Object)this, (String)"SMSGateway.pingException", (Object)this.gatewayID, (Object)ex), (Throwable)ex);
                this.logger.info(RB.getString((Object)this, (String)"SMSGateway.restarting", (Object)this.gatewayID));
                this.restart();
            }
        }
        this.logger.debug("SMSGateway (" + this.gatewayID + ") Monitor thread exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyRetryThread() {
        this.logger.debug("SMSGateway (" + this.gatewayID + ") Lazy Retry thread starting");
        while (!this.lazyRetryShutdown) {
            CFEvent event;
            Object o;
            try {
                this.logger.debug("SMSGateway (" + this.gatewayID + ") Lazy Retry thread sleeping");
                Queue queue = this.lazyRetryQueue;
                synchronized (queue) {
                    this.lazyRetryQueue.wait(this.lazyRetryInterval * 1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.lazyRetryShutdown || this.lazyRetryQueue.isEmpty() || (o = (event = (CFEvent)this.lazyRetryQueue.dequeue()).getData().get("timestamp")) == null || !(o instanceof Long)) continue;
            long ts = (Long)o;
            long diff = System.currentTimeMillis() - ts;
            if (diff > this.lazyRetryInterval * 1000L) {
                this.logger.debug("SMSGateway (" + this.gatewayID + ") Lazy Retry thread delivering message");
                this.outgoingMessage(event);
                continue;
            }
            this.lazyRetryQueue.enqueue((Object)event);
        }
        this.logger.debug("SMSGateway (" + this.gatewayID + ") Lazy Retry thread exiting");
    }

    private void processResponse(Response response, CFEvent msg) {
        if (!response.isResponse()) {
            return;
        }
        int commandStatus = response.getCommandStatus();
        if (commandStatus == 0) {
            return;
        }
        String dest = "unavailable";
        String message = "";
        if (msg != null) {
            if (response instanceof SubmitMultiSMResp) {
                dest = "";
                List addrs = (List)msg.getData().get("destAddresses");
                for (int i = 0; i < addrs.size(); ++i) {
                    dest = dest + (String)addrs.get(0);
                    dest = dest + ",";
                }
            } else {
                dest = (String)msg.getData().get("destAddress");
            }
            if ((message = (String)msg.getData().get("shortMessage")) != null && message.length() > 20) {
                message = message.substring(0, 20) + "...";
            } else if (message == null) {
                message = "[no message]";
            }
        }
        switch (commandStatus) {
            case 258: 
            case 1040: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.serviceTypeUnvail", (Object)this.gatewayID, (Object)dest, (Object)message));
                if (msg == null) break;
                msg.getData().put("timestamp", new Long(System.currentTimeMillis()));
                if (!this.transientRetry) break;
                this.lazyRetryQueue.enqueue((Object)msg);
                break;
            }
            case 259: 
            case 1042: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.serviceDenied", (Object)this.gatewayID, (Object)dest, (Object)message));
                break;
            }
            case 256: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.serviceUnauth", (Object)this.gatewayID, (Object)dest, (Object)message));
                break;
            }
            case 21: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.serviceInvalid", (Object)this.gatewayID, (Object)dest, (Object)message));
                break;
            }
            case 88: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.throttle", (Object)this.gatewayID, (Object)dest, (Object)message));
                this.throttle = true;
                break;
            }
            case 69: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.submitFailed", (Object)this.gatewayID, (Object)dest, (Object)message));
                if (msg == null) break;
                msg.getData().put("timestamp", new Long(System.currentTimeMillis()));
                if (!this.transientRetry) break;
                this.lazyRetryQueue.enqueue((Object)msg);
                break;
            }
            case 11: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.destInvalid", (Object)this.gatewayID, (Object)dest, (Object)message));
                break;
            }
            default: {
                this.logger.error(RB.getString((Object)this, (String)"SMSGateway.unknownError", (Object)this.gatewayID, (Object)dest, (Object)message, (Object)Integer.toString(commandStatus, 16)));
            }
        }
    }

    private String submit(CFEvent event) throws Exception {
        this.logger.debug("SMSGateway (" + this.gatewayID + ") SMS submit");
        String ret = "";
        Map cfmsg = event.getData();
        SubmitSM request = new SubmitSM();
        request.assignSequenceNumber(true);
        String shortMessage = (String)cfmsg.get("shortMessage");
        if (shortMessage == null && cfmsg.get("MessagePayload") == null) {
            this.logger.error(RB.getString((Object)this, (String)"SMSGateway.missingShortMessage", (Object)this.gatewayID));
            return ret;
        }
        byte ton = this.getByteSetting(cfmsg, "sourceAddress_ton", this.default_srcAdd_ton);
        byte npi = this.getByteSetting(cfmsg, "sourceAddress_npi", this.default_srcAdd_npi);
        String address = this.getStringSetting(cfmsg, "sourceAddress", this.default_srcAddr);
        Address sourceAddress = new Address();
        this.setAddressParameter("sourceAddress", sourceAddress, ton, npi, address);
        ton = this.getByteSetting(cfmsg, "destAddress_ton", this.default_destAdd_ton);
        npi = this.getByteSetting(cfmsg, "destAddress_npi", this.default_destAdd_npi);
        address = (String)cfmsg.get("destAddress");
        if (address == null) {
            this.logger.error(RB.getString((Object)this, (String)"SMSGateway.missingDestAddress", (Object)this.gatewayID));
            return ret;
        }
        Address destAddress = new Address();
        this.setAddressParameter("destAddress", destAddress, ton, npi, address);
        request.setSourceAddr(sourceAddress);
        request.setDestAddr(destAddress);
        if (this.checkDeveloperLimitation(sourceAddress.getAddress(), destAddress.getAddress())) {
            return ret;
        }
        block44: for (String key : cfmsg.keySet()) {
            Integer index = (Integer)submitOptions.get((Object)key);
            if (index == null) continue;
            switch (index) {
                default: {
                    continue block44;
                }
                case 0: {
                    boolean boolval = this.getBooleanSetting(cfmsg, key, false);
                    request.setAlertOnMsgDelivery(boolval);
                    continue block44;
                }
                case 1: {
                    Object o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setCallbackNum(bbuf);
                    continue block44;
                }
                case 2: {
                    Object o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setCallbackNumAtag(bbuf);
                    continue block44;
                }
                case 3: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setCallbackNumPresInd(byteval);
                    continue block44;
                }
                case 4: {
                    byte dataCoding = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDataCoding(dataCoding);
                    continue block44;
                }
                case 5: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDestAddrSubunit(byteval);
                    continue block44;
                }
                case 6: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setDestinationPort(shortval);
                    continue block44;
                }
                case 7: {
                    Object o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setDestSubaddress(bbuf);
                    continue block44;
                }
                case 8: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDisplayTime(byteval);
                    continue block44;
                }
                case 9: {
                    byte esmClass = this.getByteSetting(cfmsg, "esmClass", (byte)0);
                    request.setEsmClass(esmClass);
                    continue block44;
                }
                case 10: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setItsReplyType(byteval);
                    continue block44;
                }
                case 11: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setItsSessionInfo(shortval);
                    continue block44;
                }
                case 12: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setLanguageIndicator(byteval);
                    continue block44;
                }
                case 13: {
                    Object o = cfmsg.get(key);
                    if (o == null || !(o instanceof byte[])) {
                        this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badMessagePayload", (Object)this.gatewayID, (Object)"submit"));
                        return ret;
                    }
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setMessagePayload(bbuf);
                    continue block44;
                }
                case 14: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMoreMsgsToSend(byteval);
                    continue block44;
                }
                case 15: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMsMsgWaitFacilities(byteval);
                    continue block44;
                }
                case 16: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMsValidity(byteval);
                    continue block44;
                }
                case 17: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setNumberOfMessages(byteval);
                    continue block44;
                }
                case 18: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setPayloadType(byteval);
                    continue block44;
                }
                case 19: {
                    byte priorityFlag = this.getByteSetting(cfmsg, "priority", (byte)0);
                    request.setPriorityFlag(priorityFlag);
                    continue block44;
                }
                case 20: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setPrivacyIndicator(byteval);
                    continue block44;
                }
                case 21: {
                    byte protocolId = this.getByteSetting(cfmsg, "protocol", (byte)0);
                    request.setProtocolId(protocolId);
                    continue block44;
                }
                case 22: {
                    byte registeredDelivery = this.getByteSetting(cfmsg, "registeredDelivery", (byte)0);
                    request.setRegisteredDelivery(registeredDelivery);
                    continue block44;
                }
                case 23: {
                    byte replaceIfPresentFlag = this.getByteSetting(cfmsg, "replaceIfPresent", this.default_replaceIfPresentFlag);
                    request.setReplaceIfPresentFlag(replaceIfPresentFlag);
                    continue block44;
                }
                case 24: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarMsgRefNum(shortval);
                    continue block44;
                }
                case 25: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarSegmentSeqnum(shortval);
                    continue block44;
                }
                case 26: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarTotalSegments(shortval);
                    continue block44;
                }
                case 27: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSmsSignal(shortval);
                    continue block44;
                }
                case 28: {
                    String scheduleDeliveryTime = this.getStringSetting(cfmsg, "scheduleDeliveryTime", "");
                    request.setScheduleDeliveryTime(scheduleDeliveryTime);
                    continue block44;
                }
                case 29: {
                    String serviceType = this.getStringSetting(cfmsg, "serviceType", this.default_serviceType);
                    request.setServiceType(serviceType);
                    continue block44;
                }
                case 30: {
                    byte smDefaultMsgId = this.getByteSetting(cfmsg, "smDefaultMsgId", this.default_smDefaultMsgId);
                    request.setSmDefaultMsgId(smDefaultMsgId);
                    continue block44;
                }
                case 31: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setSourceAddrSubunit(byteval);
                    continue block44;
                }
                case 32: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSourcePort(shortval);
                    continue block44;
                }
                case 33: {
                    Object o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setSourceSubaddress(bbuf);
                    continue block44;
                }
                case 34: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setUserMessageReference(shortval);
                    continue block44;
                }
                case 35: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setUserResponseCode(byteval);
                    continue block44;
                }
                case 36: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setUssdServiceOp(byteval);
                    continue block44;
                }
                case 37: 
            }
            String validityPeriod = this.getStringSetting(cfmsg, "validityPeriod", "");
            request.setValidityPeriod(validityPeriod);
        }
        String charset = "UTF8";
        if (cfmsg.get("dataCoding") != null) {
            charset = this.getEncoding(request.getDataCoding());
        }
        charset = this.getStringSetting(cfmsg, "charset", charset);
        if (shortMessage != null) {
            request.setShortMessage(shortMessage, charset);
        }
        this.setOptionalParameters(cfmsg, (PDU)request);
        this.logger.debug("SMSGateway (" + this.gatewayID + ") Submit request " + request.debugString());
        if (!this.synchronous) {
            this.session.submit(request);
        } else {
            int sequenceNumber = request.getSequenceNumber();
            ResponseWaiter w = new ResponseWaiter(sequenceNumber);
            Integer key = new Integer(sequenceNumber);
            this.waiterMap.put(key, w);
            this.session.submit(request);
            SubmitSMResp resp = (SubmitSMResp)w.getResponse(this.receiveTimeout);
            if (resp != null) {
                ret = resp.getMessageId();
                if (this.convertMessageID2Decimal) {
                    try {
                        Integer x = Integer.valueOf(ret, 16);
                        ret = x.toString();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.processResponse((Response)resp, event);
            }
            this.waiterMap.remove(key);
        }
        return ret;
    }

    private String submitMulti(CFEvent event) throws Exception {
        this.logger.debug("SMSGateway (" + this.gatewayID + ") SMS submitMulti");
        String ret = "";
        Map cfmsg = event.getData();
        SubmitMultiSM request = new SubmitMultiSM();
        request.assignSequenceNumber(true);
        String shortMessage = (String)cfmsg.get("shortMessage");
        if (shortMessage == null && cfmsg.get("MessagePayload") == null) {
            this.logger.error(RB.getString((Object)this, (String)"SMSGateway.missingMulitMessage", (Object)this.gatewayID));
            return ret;
        }
        byte ton = this.getByteSetting(cfmsg, "sourceAddress_ton", this.default_srcAdd_ton);
        byte npi = this.getByteSetting(cfmsg, "sourceAddress_npi", this.default_srcAdd_npi);
        String address = this.getStringSetting(cfmsg, "sourceAddress", this.default_srcAddr);
        Address sourceAddress = new Address();
        this.setAddressParameter("sourceAddress", sourceAddress, ton, npi, address);
        request.setSourceAddr(sourceAddress);
        Object o = cfmsg.get("destAddresses");
        if (o == null || !(o instanceof List)) {
            this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badDestAddresses", (Object)this.gatewayID));
            return ret;
        }
        ListIterator dests = ((List)o).listIterator();
        while (dests != null && dests.hasNext()) {
            DestinationAddress destAddress;
            try {
                destAddress = new DestinationAddress(this.default_destAdd_ton, this.default_destAdd_npi, (String)dests.next());
            }
            catch (WrongLengthOfStringException e) {
                throw new ServiceRuntimeException(RB.getString((Object)this, (String)"SMSGateway.badParam", (Object)this.gatewayID, (Object)"destAddresses"), (Throwable)e);
            }
            request.addDestAddress(destAddress);
            if (!this.checkDeveloperLimitation(sourceAddress.getAddress(), destAddress.getAddress().getAddress())) continue;
            return ret;
        }
        block41: for (String key : cfmsg.keySet()) {
            Integer index = (Integer)submitOptions.get((Object)key);
            if (index == null) continue;
            switch (index) {
                default: {
                    continue block41;
                }
                case 0: {
                    boolean boolval = this.getBooleanSetting(cfmsg, key, false);
                    request.setAlertOnMsgDelivery(boolval);
                    continue block41;
                }
                case 1: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setCallbackNum(bbuf);
                    continue block41;
                }
                case 2: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setCallbackNumAtag(bbuf);
                    continue block41;
                }
                case 3: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setCallbackNumPresInd(byteval);
                    continue block41;
                }
                case 4: {
                    byte dataCoding = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDataCoding(dataCoding);
                    continue block41;
                }
                case 5: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDestAddrSubunit(byteval);
                    continue block41;
                }
                case 6: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setDestinationPort(shortval);
                    continue block41;
                }
                case 7: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setDestSubaddress(bbuf);
                    continue block41;
                }
                case 8: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDisplayTime(byteval);
                    continue block41;
                }
                case 9: {
                    byte esmClass = this.getByteSetting(cfmsg, "esmClass", (byte)0);
                    request.setEsmClass(esmClass);
                    continue block41;
                }
                case 12: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setLanguageIndicator(byteval);
                    continue block41;
                }
                case 13: {
                    o = cfmsg.get(key);
                    if (o == null || !(o instanceof byte[])) {
                        this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badMessagePayload", (Object)this.gatewayID, (Object)"submitMulti"));
                        return ret;
                    }
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setMessagePayload(bbuf);
                    continue block41;
                }
                case 15: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMsMsgWaitFacilities(byteval);
                    continue block41;
                }
                case 16: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMsValidity(byteval);
                    continue block41;
                }
                case 18: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setPayloadType(byteval);
                    continue block41;
                }
                case 19: {
                    byte priorityFlag = this.getByteSetting(cfmsg, "priority", (byte)0);
                    request.setPriorityFlag(priorityFlag);
                    continue block41;
                }
                case 20: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setPrivacyIndicator(byteval);
                    continue block41;
                }
                case 21: {
                    byte protocolId = this.getByteSetting(cfmsg, "protocol", (byte)0);
                    request.setProtocolId(protocolId);
                    continue block41;
                }
                case 22: {
                    byte registeredDelivery = this.getByteSetting(cfmsg, "registeredDelivery", (byte)0);
                    request.setRegisteredDelivery(registeredDelivery);
                    continue block41;
                }
                case 23: {
                    byte replaceIfPresentFlag = this.getByteSetting(cfmsg, "replaceIfPresent", this.default_replaceIfPresentFlag);
                    request.setReplaceIfPresentFlag(replaceIfPresentFlag);
                    continue block41;
                }
                case 24: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarMsgRefNum(shortval);
                    continue block41;
                }
                case 25: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarSegmentSeqnum(shortval);
                    continue block41;
                }
                case 26: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarTotalSegments(shortval);
                    continue block41;
                }
                case 27: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSmsSignal(shortval);
                    continue block41;
                }
                case 28: {
                    String scheduleDeliveryTime = this.getStringSetting(cfmsg, "scheduleDeliveryTime", "");
                    request.setScheduleDeliveryTime(scheduleDeliveryTime);
                    continue block41;
                }
                case 29: {
                    String serviceType = this.getStringSetting(cfmsg, "serviceType", this.default_serviceType);
                    request.setServiceType(serviceType);
                    continue block41;
                }
                case 30: {
                    byte smDefaultMsgId = this.getByteSetting(cfmsg, "smDefaultMsgId", this.default_smDefaultMsgId);
                    request.setSmDefaultMsgId(smDefaultMsgId);
                    continue block41;
                }
                case 31: {
                    byte byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setSourceAddrSubunit(byteval);
                    continue block41;
                }
                case 32: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSourcePort(shortval);
                    continue block41;
                }
                case 33: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setSourceSubaddress(bbuf);
                    continue block41;
                }
                case 34: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setUserMessageReference(shortval);
                    continue block41;
                }
                case 37: 
            }
            String validityPeriod = this.getStringSetting(cfmsg, "validityPeriod", "");
            request.setValidityPeriod(validityPeriod);
        }
        String charset = "UTF8";
        if (cfmsg.get("dataCoding") != null) {
            charset = this.getEncoding(request.getDataCoding());
        }
        charset = this.getStringSetting(cfmsg, "charset", charset);
        if (shortMessage != null) {
            request.setShortMessage(shortMessage, charset);
        }
        this.setOptionalParameters(cfmsg, (PDU)request);
        this.logger.debug("SMSGateway (" + this.gatewayID + ") Submit Multi request " + request.debugString());
        if (!this.synchronous) {
            this.session.submitMulti(request);
        } else {
            int sequenceNumber = request.getSequenceNumber();
            ResponseWaiter w = new ResponseWaiter(sequenceNumber);
            Integer key = new Integer(sequenceNumber);
            this.waiterMap.put(key, w);
            this.session.submitMulti(request);
            SubmitMultiSMResp resp = (SubmitMultiSMResp)w.getResponse(this.receiveTimeout);
            this.waiterMap.remove(key);
            if (resp != null) {
                ret = resp.getMessageId();
                if (this.convertMessageID2Decimal) {
                    try {
                        Integer x = Integer.valueOf(ret, 16);
                        ret = x.toString();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.processResponse((Response)resp, event);
            }
        }
        return ret;
    }

    private String data(CFEvent event) throws Exception {
        String ret = "";
        DataSM request = new DataSM();
        request.assignSequenceNumber(true);
        Map cfmsg = event.getData();
        Object o = cfmsg.get("messagePayload");
        if (o == null || !(o instanceof byte[])) {
            this.logger.error(RB.getString((Object)this, (String)"SMSGateway.badMessagePayload", (Object)this.gatewayID, (Object)"data"));
            return ret;
        }
        byte[] b = (byte[])o;
        request.setMessagePayload(new ByteBuffer(b));
        byte ton = this.getByteSetting(cfmsg, "sourceAddress_ton", this.default_srcAdd_ton);
        byte npi = this.getByteSetting(cfmsg, "sourceAddress_npi", this.default_srcAdd_npi);
        String address = this.getStringSetting(cfmsg, "sourceAddress", this.default_srcAddr);
        Address sourceAddress = new Address();
        this.setAddressParameter("sourceAddress", sourceAddress, ton, npi, address);
        request.setSourceAddr(sourceAddress);
        ton = this.getByteSetting(cfmsg, "destAddress_ton", this.default_destAdd_ton);
        npi = this.getByteSetting(cfmsg, "destAddress_npi", this.default_destAdd_npi);
        address = (String)cfmsg.get("destAddress");
        if (address == null) {
            this.logger.error(RB.getString((Object)this, (String)"SMSGateway.missingDataDest", (Object)this.gatewayID));
            return ret;
        }
        Address destAddress = new Address();
        this.setAddressParameter("destAddress", destAddress, ton, npi, address);
        request.setDestAddr(destAddress);
        if (this.checkDeveloperLimitation(sourceAddress.getAddress(), destAddress.getAddress())) {
            return ret;
        }
        block47: for (String key : cfmsg.keySet()) {
            byte byteval;
            Integer index = (Integer)data_options.get((Object)key);
            if (index == null) continue;
            switch (index) {
                default: {
                    continue block47;
                }
                case 0: {
                    boolean boolval = this.getBooleanSetting(cfmsg, key, false);
                    request.setAlertOnMsgDelivery(boolval);
                    continue block47;
                }
                case 1: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setCallbackNum(bbuf);
                    continue block47;
                }
                case 2: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setCallbackNumAtag(bbuf);
                    continue block47;
                }
                case 3: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setCallbackNumPresInd(byteval);
                    continue block47;
                }
                case 4: {
                    byte dataCoding = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDataCoding(dataCoding);
                    continue block47;
                }
                case 5: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDestAddrSubunit(byteval);
                    continue block47;
                }
                case 6: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setDestinationPort(shortval);
                    continue block47;
                }
                case 7: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setDestSubaddress(bbuf);
                    continue block47;
                }
                case 8: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDisplayTime(byteval);
                    continue block47;
                }
                case 9: {
                    byte esmClass = this.getByteSetting(cfmsg, "esmClass", (byte)0);
                    request.setEsmClass(esmClass);
                    continue block47;
                }
                case 10: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setItsReplyType(byteval);
                    continue block47;
                }
                case 11: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setItsSessionInfo(shortval);
                    continue block47;
                }
                case 12: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setLanguageIndicator(byteval);
                    continue block47;
                }
                case 14: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMoreMsgsToSend(byteval);
                    continue block47;
                }
                case 15: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMsMsgWaitFacilities(byteval);
                    continue block47;
                }
                case 16: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMsValidity(byteval);
                    continue block47;
                }
                case 17: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setNumberOfMessages(byteval);
                    continue block47;
                }
                case 18: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setPayloadType(byteval);
                    continue block47;
                }
                case 20: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setPrivacyIndicator(byteval);
                    continue block47;
                }
                case 22: {
                    byte registeredDelivery = this.getByteSetting(cfmsg, "registeredDelivery", (byte)0);
                    request.setRegisteredDelivery(registeredDelivery);
                    continue block47;
                }
                case 24: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarMsgRefNum(shortval);
                    continue block47;
                }
                case 25: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarSegmentSeqnum(shortval);
                    continue block47;
                }
                case 26: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSarTotalSegments(shortval);
                    continue block47;
                }
                case 27: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSmsSignal(shortval);
                    continue block47;
                }
                case 29: {
                    String serviceType = this.getStringSetting(cfmsg, "serviceType", this.default_serviceType);
                    request.setServiceType(serviceType);
                    continue block47;
                }
                case 31: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setSourceAddrSubunit(byteval);
                    continue block47;
                }
                case 32: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setSourcePort(shortval);
                    continue block47;
                }
                case 33: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setSourceSubaddress(bbuf);
                    continue block47;
                }
                case 34: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setUserMessageReference(shortval);
                    continue block47;
                }
                case 35: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setUserResponseCode(byteval);
                    continue block47;
                }
                case 50: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDestBearerType(byteval);
                    continue block47;
                }
                case 51: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setDestNetworkType(byteval);
                    continue block47;
                }
                case 52: {
                    short shortval = this.getShortSetting(cfmsg, key, (short)0);
                    request.setDestTelematicsId(shortval);
                    continue block47;
                }
                case 53: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setMessageState(byteval);
                    continue block47;
                }
                case 54: {
                    o = cfmsg.get(key);
                    ByteBuffer bbuf = new ByteBuffer((byte[])o);
                    request.setNetworkErrorCode(bbuf);
                    continue block47;
                }
                case 55: {
                    int x = Integer.parseInt((String)cfmsg.get(key));
                    request.setQosTimeToLive(x);
                    continue block47;
                }
                case 56: {
                    String rcptID = this.getStringSetting(cfmsg, key, "");
                    request.setReceiptedMessageId(rcptID);
                    continue block47;
                }
                case 57: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setSetDpf(byteval);
                    continue block47;
                }
                case 58: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setSourceBearerType(byteval);
                    continue block47;
                }
                case 59: {
                    byteval = this.getByteSetting(cfmsg, key, (byte)0);
                    request.setSourceNetworkType(byteval);
                    continue block47;
                }
                case 60: 
            }
            byteval = this.getByteSetting(cfmsg, key, (byte)0);
            request.setSourceTelematicsId(byteval);
        }
        this.logger.debug("SMSGateway (" + this.gatewayID + ") Data request " + request.debugString());
        if (!this.synchronous) {
            this.session.data(request);
        } else {
            int sequenceNumber = request.getSequenceNumber();
            ResponseWaiter w = new ResponseWaiter(sequenceNumber);
            Integer key = new Integer(sequenceNumber);
            this.waiterMap.put(key, w);
            this.session.data(request);
            DataSMResp resp = (DataSMResp)w.getResponse(this.receiveTimeout);
            this.waiterMap.remove(key);
            if (resp != null) {
                ret = resp.getMessageId();
                if (this.convertMessageID2Decimal) {
                    try {
                        Integer x = Integer.valueOf(ret, 16);
                        ret = x.toString();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.processResponse((Response)resp, event);
            }
        }
        return ret;
    }

    private void loadProperties() {
        float r;
        this.bindingType = this.properties.getProperty("binding", TRANSCIEVER);
        this.cfcEntryPoint = this.properties.getProperty("cfc-method", this.cfcEntryPoint);
        this.ipAddress = this.properties.getProperty("ip-address");
        this.port = this.getIntProperty("port", this.port);
        this.systemId = this.properties.getProperty("system-id");
        this.password = this.properties.getProperty("password");
        this.pingInterval = this.getIntProperty("ping-interval", 60);
        this.retryInterval = this.getIntProperty("retry-interval", this.retryInterval);
        this.maxRestart = this.getIntProperty("retries", this.maxRestart);
        this.messageRate = this.DEFAULT_MESSAGE_RATE;
        String rate = this.properties.getProperty("message-rate");
        if (rate != null && (r = Float.parseFloat(rate)) > 0.0f) {
            this.messageRate = r;
        }
        this.networkRetry = this.getBooleanSetting(this.properties, "network-retry", this.networkRetry);
        this.transientRetry = this.getBooleanSetting(this.properties, "transient-retry", this.transientRetry);
        String mode = this.properties.getProperty("mode", "synchronous");
        if (mode.equalsIgnoreCase("asynchronous")) {
            this.synchronous = false;
        }
        byte ton = this.getByteProperty("addr-ton", this.addressRange.getTon());
        byte npi = this.getByteProperty("addr-npi", this.addressRange.getNpi());
        String addr = this.properties.getProperty("address-range", this.addressRange.getAddressRange());
        this.addressRange.setTon(ton);
        this.addressRange.setNpi(npi);
        try {
            this.addressRange.setAddressRange(addr);
        }
        catch (WrongLengthOfStringException e) {
            throw new ServiceRuntimeException(RB.getString((Object)this, (String)"SMSGateway.badLength", (Object)this.gatewayID), (Throwable)e);
        }
        this.default_srcAdd_ton = this.getByteProperty("source-ton", this.default_srcAdd_ton);
        this.default_srcAdd_npi = this.getByteProperty("source-npi", this.default_srcAdd_npi);
        this.default_srcAddr = this.properties.getProperty("source-address", "");
        this.setAddressParameter("source-address", new Address(), this.default_srcAdd_ton, this.default_srcAdd_npi, this.default_srcAddr);
        this.default_destAdd_ton = this.getByteProperty("destination-ton", this.default_destAdd_ton);
        this.default_destAdd_npi = this.getByteProperty("destination-npi", this.default_destAdd_npi);
        this.default_destAddr = this.properties.getProperty("destination-address", "");
        this.setAddressParameter("destination-address", new Address(), this.default_destAdd_ton, this.default_destAdd_npi, this.default_destAddr);
        this.default_serviceType = this.properties.getProperty("service-type", this.default_serviceType);
        this.systemType = this.properties.getProperty("system-type", this.systemType);
        int rcvTimeout = this.receiveTimeout == -1L ? -1 : (int)this.receiveTimeout / 1000;
        rcvTimeout = this.getIntProperty("receive-timeout", rcvTimeout);
        this.receiveTimeout = rcvTimeout == -1 ? -1L : (long)(rcvTimeout * 1000);
    }

    private byte getByteProperty(String propName, byte defaultValue) {
        return Byte.parseByte(this.properties.getProperty(propName, Byte.toString(defaultValue)));
    }

    private int getIntProperty(String propName, int defaultValue) {
        return Integer.parseInt(this.properties.getProperty(propName, Integer.toString(defaultValue)));
    }

    private void setAddressParameter(String descr, Address address, byte ton, byte npi, String addr) {
        address.setTon(ton);
        address.setNpi(npi);
        try {
            address.setAddress(addr);
        }
        catch (WrongLengthOfStringException e) {
            throw new ServiceRuntimeException(RB.getString((Object)this, (String)"SMSGateway.badParam", (Object)this.gatewayID, (Object)descr), (Throwable)e);
        }
    }

    private String getStringSetting(Map props, String setting, String def) {
        String value = (String)props.get(setting);
        if (value == null) {
            value = def;
        }
        return value;
    }

    private byte getByteSetting(Map props, String setting, byte def) {
        byte ret = def;
        String value = (String)props.get(setting);
        if (value != null) {
            try {
                ret = Byte.decode(value);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return ret;
    }

    private short getShortSetting(Map props, String setting, short def) {
        short ret = def;
        String value = (String)props.get(setting);
        if (value != null) {
            try {
                ret = Short.decode(value);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return ret;
    }

    private boolean getBooleanSetting(Map props, String setting, boolean def) {
        boolean ret = def;
        String value = (String)props.get(setting);
        if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equals("1"))) {
            ret = true;
        }
        return ret;
    }

    private synchronized void throttle() {
        if (this.messageRate <= 0.0f) {
            return;
        }
        try {
            long now;
            long diff;
            long minDelay = Math.round(1000.0f / this.messageRate);
            if (this.throttle) {
                minDelay = this.backoffTime * 1000;
            }
            if ((diff = (now = System.currentTimeMillis()) - this.lastMessage) < minDelay) {
                long millis = minDelay - diff;
                Thread.sleep(millis);
                if (this.throttle) {
                    this.throttle = false;
                    this.messageRate /= 2.0f;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.lastMessage = System.currentTimeMillis();
    }

    private boolean checkDeveloperLimitation(String mynumber, String theirnumber) {
        boolean bIgnoreEvent = false;
        if (ServiceFactory.getLicenseService().isDeveloper()) {
            bIgnoreEvent = true;
            String[] mybuddies = (String[])DeveloperVersionUserList.get((Object)mynumber);
            if (mybuddies == null) {
                mybuddies = new String[3];
                mybuddies[0] = theirnumber;
                DeveloperVersionUserList.put((Object)mynumber, (Object)mybuddies);
                bIgnoreEvent = false;
            } else {
                for (int i = 0; i < mybuddies.length; ++i) {
                    String addr = mybuddies[i];
                    if (addr == null) {
                        mybuddies[i] = theirnumber;
                        bIgnoreEvent = false;
                        break;
                    }
                    if (!theirnumber.equals(addr)) continue;
                    bIgnoreEvent = false;
                    break;
                }
            }
            if (bIgnoreEvent) {
                StringBuffer nameList = new StringBuffer();
                for (int i = 0; i < mybuddies.length; ++i) {
                    nameList.append(mybuddies[i]);
                    if (i == mybuddies.length - 1) continue;
                    nameList.append(',');
                }
                this.logger.info(RB.getString((Object)this, (String)"SMSGateway.DeveloperLicense", (Object)this.gatewayID, (Object)Integer.toString(3), (Object)nameList, (Object)theirnumber));
            }
        }
        return bIgnoreEvent;
    }

    private void setOptionalParameters(Map cfmsg, PDU message) throws TLVException {
        String values;
        short tag;
        Object paramObj = cfmsg.get("optionalParameters");
        if (paramObj != null && paramObj instanceof Map) {
            Map paramMap = (Map)paramObj;
            Iterator iKeys = paramMap.keySet().iterator();
            while (iKeys.hasNext()) {
                short tag2;
                String key = iKeys.next().toString();
                try {
                    tag2 = Short.decode(key);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                Object value = paramMap.get(key);
                if (!(value instanceof byte[])) continue;
                ByteBuffer data = new ByteBuffer((byte[])value);
                message.setExtraOptional(tag2, data);
            }
        }
        if ((tag = this.getShortSetting(cfmsg, "optionalParameter", (short)0)) > 0 && (values = this.getStringSetting(cfmsg, "optionalParameterValue", null)) != null) {
            StringTokenizer tok = new StringTokenizer(values, ",");
            int len = tok.countTokens();
            byte[] bytes = new byte[len];
            int i = 0;
            while (tok.hasMoreTokens()) {
                String b = tok.nextToken().trim();
                bytes[i++] = Byte.decode(b);
            }
            ByteBuffer buf = new ByteBuffer(bytes);
            message.setExtraOptional(tag, buf);
        }
    }

    Map processOptionalParams(DeliverSM message) {
        FastHashtable params = null;
        Vector pList = message.getAllExtraOptional();
        for (int i = 0; i < pList.size(); ++i) {
            TLV tlv = (TLV)pList.elementAt(i);
            if (tlv == null || !tlv.hasValue()) continue;
            if (params == null) {
                params = new FastHashtable();
            }
            try {
                params.put(Integer.toHexString(tlv.getTag()), tlv.getData().getBuffer());
                continue;
            }
            catch (ValueNotSetException valueNotSetException) {
                // empty catch block
            }
        }
        return params;
    }

    static {
        submitOptions.put((Object)"alertOnMsgDelivery", (Object)new Integer(0));
        submitOptions.put((Object)"callbackNum", (Object)new Integer(1));
        submitOptions.put((Object)"callbackNumAtag", (Object)new Integer(2));
        submitOptions.put((Object)"callbackNumPresInd", (Object)new Integer(3));
        submitOptions.put((Object)"dataCoding", (Object)new Integer(4));
        submitOptions.put((Object)"DestAddrSubunit", (Object)new Integer(5));
        submitOptions.put((Object)"DestinationPort", (Object)new Integer(6));
        submitOptions.put((Object)"DestSubaddress", (Object)new Integer(7));
        submitOptions.put((Object)"DisplayTime", (Object)new Integer(8));
        submitOptions.put((Object)"EsmClass", (Object)new Integer(9));
        submitOptions.put((Object)"ItsReplyType", (Object)new Integer(10));
        submitOptions.put((Object)"ItsSessionInfo", (Object)new Integer(11));
        submitOptions.put((Object)"LanguageIndicator", (Object)new Integer(12));
        submitOptions.put((Object)"MessagePayload", (Object)new Integer(13));
        submitOptions.put((Object)"MoreMsgsToSend", (Object)new Integer(14));
        submitOptions.put((Object)"MsMsgWaitFacilities", (Object)new Integer(15));
        submitOptions.put((Object)"MsValidity", (Object)new Integer(16));
        submitOptions.put((Object)"NumberOfMessages", (Object)new Integer(17));
        submitOptions.put((Object)"PayloadType", (Object)new Integer(18));
        submitOptions.put((Object)"priority", (Object)new Integer(19));
        submitOptions.put((Object)"PrivacyIndicator", (Object)new Integer(20));
        submitOptions.put((Object)"protocol", (Object)new Integer(21));
        submitOptions.put((Object)"registeredDelivery", (Object)new Integer(22));
        submitOptions.put((Object)"replaceIfPresent", (Object)new Integer(23));
        submitOptions.put((Object)"SarMsgRefNum", (Object)new Integer(24));
        submitOptions.put((Object)"SarSegmentSeqnum", (Object)new Integer(25));
        submitOptions.put((Object)"SarTotalSegments", (Object)new Integer(26));
        submitOptions.put((Object)"SmsSignal", (Object)new Integer(27));
        submitOptions.put((Object)"scheduleDeliveryTime", (Object)new Integer(28));
        submitOptions.put((Object)"serviceType", (Object)new Integer(29));
        submitOptions.put((Object)"smDefaultMsgId", (Object)new Integer(30));
        submitOptions.put((Object)"SourceAddrSubunit", (Object)new Integer(31));
        submitOptions.put((Object)"SourcePort", (Object)new Integer(32));
        submitOptions.put((Object)"SourceSubaddress", (Object)new Integer(33));
        submitOptions.put((Object)"UserMessageReference", (Object)new Integer(34));
        submitOptions.put((Object)"UserResponseCode", (Object)new Integer(35));
        submitOptions.put((Object)"UssdServiceOp", (Object)new Integer(36));
        submitOptions.put((Object)"validityPeriod", (Object)new Integer(37));
        data_options = new FastHashtable();
        data_options.putAll((Map)submitOptions);
        data_options.put((Object)"DestBearerType", (Object)new Integer(50));
        data_options.put((Object)"DestNetworkType", (Object)new Integer(51));
        data_options.put((Object)"DestTelematicsId", (Object)new Integer(52));
        data_options.put((Object)"MessageState", (Object)new Integer(53));
        data_options.put((Object)"NetworkErrorCode", (Object)new Integer(54));
        data_options.put((Object)"QosTimeToLive", (Object)new Integer(55));
        data_options.put((Object)"ReceiptedMessageId", (Object)new Integer(56));
        data_options.put((Object)"SetDpf", (Object)new Integer(57));
        data_options.put((Object)"SourceBearerType", (Object)new Integer(58));
        data_options.put((Object)"SourceNetworkType", (Object)new Integer(59));
        data_options.put((Object)"SourceTelematicsId", (Object)new Integer(60));
    }

    private class PDUEventListener
    extends SmppObject
    implements ServerPDUEventListener {
        Session session;
        Queue requestEvents = new Queue();
        SMSGateway gw = null;

        public PDUEventListener(Session session, SMSGateway gw) {
            this.session = session;
            this.gw = gw;
        }

        public void handleEvent(ServerPDUEvent event) {
            PDU pdu = event.getPDU();
            if (pdu.isRequest()) {
                SMSGateway.this.logger.debug("SMSGateway (" + SMSGateway.this.gatewayID + ") async request received, enqueuing " + pdu.debugString());
                this.gw.incomingMessage(pdu);
            } else if (pdu.isResponse()) {
                Object o = SMSGateway.this.waiterMap.get(new Integer(pdu.getSequenceNumber()));
                if (o != null) {
                    ResponseWaiter rw = (ResponseWaiter)o;
                    rw.setResponse((Response)pdu);
                } else if (!SMSGateway.this.synchronous && pdu instanceof SubmitSMResp || pdu instanceof SubmitMultiSMResp || pdu instanceof DataSMResp) {
                    this.gw.processResponse((Response)pdu, null);
                } else {
                    SMSGateway.this.logger.debug("SMSGateway (" + SMSGateway.this.gatewayID + ") async response received " + pdu.debugString());
                }
            } else {
                SMSGateway.this.logger.info(RB.getString((Object)((Object)this), (String)"SMSGateway.unknownPDU", (Object)SMSGateway.this.gatewayID, (Object)pdu.debugString()));
            }
        }
    }

    protected class ResponseWaiter {
        private int seq = 0;
        private Response result = null;
        private boolean ready = false;

        public ResponseWaiter(int sequenceNum) {
            this.seq = sequenceNum;
        }

        public synchronized Response getResponse(long timeout) throws InterruptedException {
            if (!this.ready) {
                this.wait(timeout);
            }
            return this.result;
        }

        public synchronized void setResponse(Response r) {
            if (r.getSequenceNumber() != this.seq) {
                return;
            }
            this.result = r;
            this.ready = true;
            this.notify();
        }
    }
}

