/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.flex;

import coldfusion.eventgateway.flex.rmi.CFToDataManagementProxyServer;
import coldfusion.flex.rmi.DataServicesCFProxy;
import coldfusion.flex.rmi.DataServicesRMIRegistry;
import flex.data.DataServiceTransaction;
import flex.data.DataSyncException;
import flex.data.adapters.AdapterException;
import flex.data.adapters.ChangeObjectList;
import flex.data.adapters.JavaAdapter;
import flex.data.messages.DataMessage;
import flex.messaging.FlexContext;
import flex.messaging.FlexRemoteCredentials;
import flex.messaging.FlexSession;
import flex.messaging.MessageException;
import flex.messaging.config.ConfigMap;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.Message;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CFDataServicesAdapter
extends JavaAdapter {
    private String template;
    private CFFillMethod fillMethod;
    private String cfhost = null;
    private boolean localCF = true;
    private String location;
    private HashMap configMap;
    private int rmiport = DataServicesRMIRegistry.getDefaultPort();
    private String rmiId = "default";
    private String[] allowedIPs = null;
    private String scope = "request";
    private String LOG_CATEGORY = "DataService.coldfusion";
    private Logger log = Log.getLogger((String)this.LOG_CATEGORY);
    DataServicesCFProxy localCFProxy;
    private static final String SCOPE = "scope";
    public static final String ACCESS = "access";
    public static final String PROPERTY_CASE = "property-case";
    public static final String USE_MAPPINGS = "use-mappings";
    public static final String METHOD_ACCESS_LEVEL = "method-access-level";
    public static final String REMOTE_USERNAME = "remote-username";
    public static final String REMOTE_PASSWORD = "remote-password";
    public static final String METADATA = "metadata";
    public static final String QUERY_ROW_TYPE = "query-row-type";
    private static final String COMPONENT = "component";
    private static final String HOST_ATTR = "hostname";
    private static final String FORCE_CFC_LOWERCASE = "force-cfc-lowercase";
    private static final String FORCE_QUERY_LOWERCASE = "force-query-lowercase";
    private static final String FORCE_STRUCT_LOWERCASE = "force-struct-lowercase";
    private static final String USE_FILL_CONTAINS = "use-fill-contains";
    private static final String RMI_ID = "identity";
    private static final String ALLOWEDIPS = "allowedIPs";
    private static final String USE_GETSET = "use-accessors";
    private static final String USE_STRUCTS = "use-structs";
    private final String CLIENTID = "clientId";

    public CFDataServicesAdapter() {
        super(false);
    }

    public void initialize(String id, ConfigMap properties) {
        ConfigMap metadata;
        String iplist;
        ConfigMap caseProperties;
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.log.info("[CFDataServicesAdapter] Configuring CFC adapter for destination " + this.getDestination().getId());
        this.template = properties.getPropertyAsString(COMPONENT, this.template);
        this.scope = properties.getPropertyAsString(SCOPE, this.scope);
        this.cfhost = properties.getPropertyAsString(HOST_ATTR, this.cfhost);
        if (this.cfhost != null) {
            this.localCF = false;
            this.cfhost = this.cfhost.trim();
        }
        this.rmiId = properties.getPropertyAsString(RMI_ID, this.rmiId);
        ConfigMap server = properties.getPropertyAsMap("server", null);
        if (server != null) {
            ConfigMap fillProperties = server.getPropertyAsMap("fill-method", null);
            this.fillMethod = this.generateFillMethod(fillProperties);
        }
        if (this.configMap == null) {
            this.configMap = new HashMap();
        }
        this.configMap.put(SCOPE, this.scope);
        ConfigMap accessProperties = properties.getPropertyAsMap(ACCESS, null);
        if (accessProperties != null) {
            HashMap<String, String> accessMap = (HashMap<String, String>)this.configMap.get(ACCESS);
            if (accessMap == null) {
                accessMap = new HashMap<String, String>();
                this.configMap.put(ACCESS, accessMap);
            }
            accessMap.put(USE_MAPPINGS, accessProperties.getProperty(USE_MAPPINGS));
            accessMap.put(METHOD_ACCESS_LEVEL, accessProperties.getProperty(METHOD_ACCESS_LEVEL));
        }
        if ((caseProperties = properties.getPropertyAsMap(PROPERTY_CASE, null)) != null) {
            HashMap<String, String> caseMap = (HashMap<String, String>)this.configMap.get(PROPERTY_CASE);
            if (caseMap == null) {
                caseMap = new HashMap<String, String>();
                this.configMap.put(PROPERTY_CASE, caseMap);
            }
            caseMap.put(FORCE_CFC_LOWERCASE, caseProperties.getProperty(FORCE_CFC_LOWERCASE));
            caseMap.put(FORCE_QUERY_LOWERCASE, caseProperties.getProperty(FORCE_QUERY_LOWERCASE));
            caseMap.put(FORCE_STRUCT_LOWERCASE, caseProperties.getProperty(FORCE_STRUCT_LOWERCASE));
        }
        this.configMap.put(USE_GETSET, properties.getProperty(USE_GETSET));
        this.configMap.put(USE_STRUCTS, properties.getProperty(USE_STRUCTS));
        String username = properties.getPropertyAsString(REMOTE_USERNAME, null);
        String password = properties.getPropertyAsString(REMOTE_PASSWORD, null);
        if (username != null) {
            this.configMap.put(REMOTE_USERNAME, username);
        }
        if (password != null) {
            this.configMap.put(REMOTE_PASSWORD, password);
        }
        if ((iplist = properties.getProperty(ALLOWEDIPS)) != null) {
            StringTokenizer tok = new StringTokenizer(iplist, ",");
            String[] ipArray = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                ipArray[i++] = tok.nextToken().trim();
            }
            this.allowedIPs = ipArray.length > 0 ? ipArray : null;
        }
        if ((metadata = properties.getPropertyAsMap(METADATA, null)) != null) {
            HashMap<String, String> metaMap = (HashMap<String, String>)this.configMap.get(METADATA);
            if (metaMap == null) {
                metaMap = new HashMap<String, String>();
                this.configMap.put(METADATA, metaMap);
            }
            metaMap.put(QUERY_ROW_TYPE, metadata.getProperty(QUERY_ROW_TYPE));
        }
    }

    public boolean fillNeedsAutoRefresh(Object object) {
        return this.fillMethod.autoRefresh;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        if (this.localCF) {
            this.setupLocalProxy();
        } else {
            DataServicesRMIRegistry.startRegistry();
            this.registerAdapter();
        }
    }

    public void stop() {
        super.stop();
        if (!this.localCF) {
            this.unregisterAdapter();
        }
    }

    protected Object getAssemblerObject() throws AdapterException {
        return null;
    }

    protected void initMethods() {
    }

    protected void validateInstanceSettings() {
    }

    protected void initializeFactoryInstance() {
    }

    protected Integer invokeCountOperation(DataMessage dataMessage, Object template) {
        Integer result;
        this.log.debug("[CFDataServicesAdapter] destination: " + this.getDestination().getId() + " invoking COUNT method...");
        this.constraintManager.assertCountAuthorization((Message)dataMessage);
        HashMap conf = new HashMap(this.configMap);
        DataServicesCFProxy proxy = this.findProxy();
        try {
            this.setupCredentials(conf);
            List params = this.getParamsFromClientArray(dataMessage.getBody());
            params = this.checkForMapSize(params);
            result = proxy.count(this.template, params.toArray(), conf);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ServerException) {
                throwable = ((ServerException)throwable).detail;
            }
            AdapterException aex = new AdapterException();
            aex.setMessage("Error invoking count for destination " + this.getDestination().getId() + ": " + throwable.getMessage());
            aex.setRootCause(throwable);
            throw aex;
        }
        if (result == null) {
            result = new Integer(0);
        }
        return result;
    }

    private List checkForMapSize(List params) {
        for (int i = params.size() - 1; i >= 0; --i) {
            Object param = params.get(i);
            if (!(param instanceof Map) || ((Map)param).size() != 0) continue;
            params.remove(i);
        }
        return params;
    }

    protected Object invokeFillOperation(DataMessage dataMessage, Object template, boolean singleValue) {
        List result;
        this.log.debug("[CFDataServicesAdapter] destination: " + this.getDestination().getId() + " invoking Fill method...");
        this.constraintManager.assertReadAuthorization((Message)dataMessage);
        HashMap conf = new HashMap(this.configMap);
        DataServicesCFProxy proxy = this.findProxy();
        try {
            this.setupCredentials(conf);
            List params = this.getParamsFromClientArray(dataMessage.getBody());
            result = proxy.fill(this.template, params.toArray(), conf);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ServerException) {
                throwable = ((ServerException)throwable).detail;
            }
            AdapterException aex = new AdapterException();
            aex.setMessage("Error invoking fill-method 'fill' for destination " + this.getDestination().getId() + ": " + throwable.getMessage());
            aex.setRootCause(throwable);
            throw aex;
        }
        return result;
    }

    protected Integer invokeRefreshFillOperation(DataMessage dataMessage, Object object) {
        if (this.fillMethod.useFillContains) {
            boolean result;
            this.log.debug("[CFDataServicesAdapter] destination: " + this.getDestination().getId() + " invoking FILL-CONTAINS method...");
            HashMap conf = new HashMap(this.configMap);
            DataServicesCFProxy proxy = this.findProxy();
            try {
                this.setupCredentials(conf);
                Object[] args = (Object[])dataMessage.getBody();
                List params = this.getParamsFromClientArray(args[0]);
                Object theTestObj = args[1];
                Boolean isCreate = (Boolean)args[2];
                result = proxy.fillContains(this.template, params.toArray(), theTestObj, isCreate, conf);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ServerException) {
                    throwable = ((ServerException)throwable).detail;
                }
                AdapterException aex = new AdapterException();
                aex.setMessage("Error invoking fillContains for destination " + this.getDestination().getId() + ": " + throwable.getMessage());
                aex.setRootCause(throwable);
                throw aex;
            }
            if (result) {
                if (this.fillMethod.ordered) {
                    return EXECUTE_FILL;
                }
                return APPEND_TO_FILL;
            }
            return DO_NOT_EXECUTE_FILL;
        }
        if (this.fillMethod.autoRefresh) {
            return EXECUTE_FILL;
        }
        return DO_NOT_EXECUTE_FILL;
    }

    protected Object invokeGetOperation(DataMessage dataMessage, Object template) {
        Object result;
        this.log.debug("[CFDataServicesAdapter] destination: " + this.getDestination().getId() + " invoking GET method...");
        this.constraintManager.assertReadAuthorization((Message)dataMessage);
        HashMap conf = new HashMap(this.configMap);
        DataServicesCFProxy proxy = this.findProxy();
        try {
            this.setupCredentials(conf);
            result = proxy.get(this.template, dataMessage.getIdentity(), conf);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ServerException) {
                throwable = ((ServerException)throwable).detail;
            }
            AdapterException aex = new AdapterException();
            aex.setMessage("Error invoking get-method for destination " + this.getDestination().getId() + ": " + throwable.getMessage());
            aex.setRootCause(throwable);
            throw aex;
        }
        return result;
    }

    protected synchronized void invokeSyncOperation(Object template, List changes) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.log.debug("[CFDataServicesAdapter] destination: " + this.getDestination().getId() + " invoking SYNC method, " + changes.size() + " change(s) to process.");
        HashMap conf = new HashMap(this.configMap);
        DataServicesCFProxy proxy = this.findProxy();
        try {
            this.setupCredentials(conf);
            List newChanges = proxy.sync(this.template, changes, conf);
            ((ChangeObjectList)changes).copyFrom(newChanges);
        }
        catch (DataSyncException dse) {
            throw dse;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ServerException) {
                throwable = ((ServerException)throwable).detail;
            }
            AdapterException aex = new AdapterException();
            aex.setMessage("Error invoking sync-method for destination " + this.getDestination().getId() + ": " + throwable.getMessage());
            aex.setRootCause(throwable);
            throw aex;
        }
    }

    protected void validate() {
        if (this.isValid()) {
            return;
        }
        if (this.template == null || this.template.trim().length() == 0) {
            AdapterException ae = new AdapterException();
            ae.setMessage("Destination [" + this.getDestination().getId() + "]: Missing <component> element in ColdFusion Data Management destination configuration");
            throw ae;
        }
        if ("session".equals(this.scope)) {
            AdapterException ae = new AdapterException();
            ae.setMessage("Destination [" + this.getDestination().getId() + "]: The ColdFusion Data Management adapter does not currently support components with session scope.");
            throw ae;
        }
        if (this.fillMethod == null) {
            this.fillMethod = this.generateFillMethod(null);
        }
        if (this.cfhost != null) {
            this.localCF = false;
            this.location = "//" + this.cfhost + ":" + this.rmiport + "/" + "cfassembler/" + this.rmiId;
        }
        super.validate();
    }

    private void setupCredentials(Map map) {
        FlexSession session = FlexContext.getFlexSession();
        if (session != null) {
            String clientid = session.getId();
            map.put("clientId", clientid);
            Service service = (Service)this.getDestination().getParent();
            FlexRemoteCredentials creds = session.getRemoteCredentials(service.getId(), this.getDestination().getId());
            if (creds != null) {
                String username = creds.getUsername();
                Object credentials = creds.getCredentials();
                map.put(REMOTE_USERNAME, username);
                map.put(REMOTE_PASSWORD, credentials);
            }
        }
    }

    private void registerAdapter() throws MessageException {
        try {
            CFToDataManagementProxyServer proxy = new CFToDataManagementProxyServer(this);
            String name = "//localhost:" + this.rmiport + "/" + "cfdataserviceadapter/" + this.getDestination().getId();
            Naming.rebind(name, proxy);
            this.log.debug("[CFDataServicesAdapter] Registered ColdFusion DataService adapter at " + name);
        }
        catch (Exception e) {
            String msg = "Problem registering RMI proxy for destination '" + this.getDestination().getId() + "': " + e.toString();
            this.log.error(msg, (Throwable)e);
            throw new MessageException(msg, (Throwable)e);
        }
    }

    private void unregisterAdapter() throws MessageException {
        try {
            String name = "//localhost:" + this.rmiport + "/" + "cfdataserviceadapter/" + this.getDestination().getId();
            Naming.unbind(name);
            this.log.debug("[CFDataServicesAdapter] Unregistered ColdFusion DataService adapter at " + name);
        }
        catch (Exception e) {
            String msg = "Problem unregistering RMI proxy for destination '" + this.getDestination().getId() + "': " + e.toString();
            this.log.debug(msg, (Throwable)e);
        }
    }

    private void setupLocalProxy() throws ServiceException {
        try {
            Class<?> pClass = Class.forName("coldfusion.flex.DataServicesLocalProxy");
            this.localCFProxy = (DataServicesCFProxy)pClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            ServiceException se = new ServiceException();
            se.setDetails("[CFDataServicesAdapter] Unable to find ColdFusion in this server, perhaps you need to set <hostname> in the '" + this.getDestination().getId() + "' destination config?");
            throw se;
        }
        catch (Exception e) {
            ServiceException se = new ServiceException();
            se.setDetails("[CFDataServicesAdapter] Unable to create ColdFusion proxy class: " + e);
            se.setRootCause((Throwable)e);
            throw se;
        }
    }

    public void performDataServiceTransaction(Map msg) throws Exception {
        String action = (String)msg.get("action");
        if (action == null || action.length() == 0) {
            throw new Exception("Missing parameter: action");
        }
        DataServiceTransaction dst = DataServiceTransaction.begin((boolean)false);
        try {
            if (!"batch".equalsIgnoreCase(action)) {
                this.doAction(msg, dst);
            } else {
                Object list = msg.get("changes");
                if (list == null || !list.getClass().isArray()) {
                    throw new Exception("For batch action, you must provide 'changes' as an array of structures");
                }
                Object[] listArray = (Object[])list;
                for (int i = 0; i < listArray.length; ++i) {
                    Object ae = listArray[i];
                    if (!(ae instanceof Map)) {
                        throw new Exception("Element " + i + " of 'changes' array is not a struct");
                    }
                    Map change = (Map)ae;
                    this.doAction(change, dst);
                }
            }
            dst.commit();
        }
        catch (Exception e) {
            try {
                dst.rollback();
            }
            catch (Exception rollbackex) {
                this.log.warn("Error rolling back Data Service Transaction: " + rollbackex.toString(), (Throwable)rollbackex);
            }
            throw e;
        }
    }

    private void doAction(Map change, DataServiceTransaction dst) throws Exception {
        String dest = this.getDestination().getId();
        String action = (String)change.get("action");
        if ("update".equalsIgnoreCase(action)) {
            Object newVersion = change.get("newversion");
            if (newVersion == null) {
                throw new Exception("update action requires 'newversion' parameter.");
            }
            Object previous = change.get("previousversion");
            String[] changes = null;
            Object o = change.get("changes");
            if (o != null) {
                if (!o.getClass().isArray()) {
                    throw new Exception("'changes' must be an array of property names");
                }
                Object[] oa = (Object[])o;
                changes = new String[oa.length];
                for (int i = 0; i < oa.length; ++i) {
                    changes[i] = oa[i].toString();
                }
            }
            dst.updateItem(dest, newVersion, previous, changes);
        } else if ("create".equalsIgnoreCase(action)) {
            Object item = change.get("item");
            if (item == null) {
                throw new Exception("create action requires 'item' parameter.");
            }
            dst.createItem(dest, item);
        } else if ("delete".equalsIgnoreCase(action)) {
            Object item = change.get("item");
            if (item == null) {
                throw new Exception("delete action requires 'item' parameter.");
            }
            dst.deleteItem(dest, item);
        } else if ("deleteid".equalsIgnoreCase(action)) {
            Map identity = (Map)change.get(RMI_ID);
            if (identity == null) {
                throw new Exception("deleteId action requires 'identity' parameter.");
            }
            dst.deleteItemWithId(dest, identity);
        } else if ("refreshfill".equalsIgnoreCase(action)) {
            List param = null;
            Object o = change.get("fillparameters");
            if (o != null) {
                if (o.getClass().isArray()) {
                    param = Arrays.asList((Object[])o);
                } else if (o instanceof List) {
                    param = (List)o;
                } else {
                    throw new Exception("refreshfill parameter " + o.getClass() + " is not List or Array");
                }
            }
            dst.refreshFill(dest, param);
        }
    }

    private synchronized DataServicesCFProxy findProxy() throws MessageException {
        if (this.localCF) {
            if (this.localCFProxy == null) {
                throw new MessageException("Unable to find ColdFusion in this server, perhaps you need to set <hostname> in the '" + this.getDestination().getId() + "' destination config?");
            }
            return this.localCFProxy;
        }
        try {
            return (DataServicesCFProxy)Naming.lookup(this.location);
        }
        catch (NotBoundException nbe) {
            String msg = "Unable to find the ColdFusion Data Management Service in RMI registry on '" + this.cfhost + ":" + this.rmiport + "'. Flex Data Management support may not be enabled.";
            throw new MessageException(msg);
        }
        catch (RemoteException remex) {
            throw new MessageException("Unable to contact the RMI registry on  '" + this.cfhost + ":" + this.rmiport + "' to look for the ColdFusion Data Management Service: " + remex.toString());
        }
        catch (Exception e) {
            String msg = "Unable to find ColdFusion Data Management Service in RMI registry on '" + this.cfhost + ":" + this.rmiport + "': " + e.toString();
            throw new MessageException(msg, (Throwable)e);
        }
    }

    public boolean verifyHost(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            String remote = addr.getHostAddress();
            if (this.allowedIPs != null && this.allowedIPs.length > 0) {
                for (int i = 0; i < this.allowedIPs.length; ++i) {
                    if (!this.allowedIPs[i].equals(remote)) continue;
                    return true;
                }
            } else {
                InetAddress localhost = InetAddress.getLocalHost();
                if (localhost.getHostAddress().equals(remote)) {
                    return true;
                }
            }
            return false;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private CFFillMethod generateFillMethod(ConfigMap methodProperties) {
        CFFillMethod fm = new CFFillMethod();
        if (methodProperties != null) {
            fm.autoRefresh = methodProperties.getPropertyAsBoolean("auto-refresh", true);
            fm.ordered = methodProperties.getPropertyAsBoolean("ordered", true);
            fm.useFillContains = methodProperties.getPropertyAsBoolean(USE_FILL_CONTAINS, false);
            if (fm.useFillContains && !fm.autoRefresh) {
                AdapterException exception = new AdapterException();
                exception.setMessage("auto-refresh can be false only if use-fill-contains is also false for destination " + this.getDestination().getId());
                throw exception;
            }
        }
        return fm;
    }

    public class CFFillMethod {
        public boolean useFillContains = false;
        public boolean autoRefresh = true;
        public boolean ordered = false;
    }
}

