/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.codecs;

import coldfusion.nosql.mongo.SimpleReference;
import coldfusion.nosql.mongo.bson.types.CFBsonJS;
import coldfusion.nosql.mongo.bson.types.CFMongoDBRef;
import coldfusion.nosql.mongo.codecs.CFBigDecimalCodec;
import coldfusion.nosql.mongo.codecs.CFBigIntegerCodec;
import coldfusion.nosql.mongo.codecs.CFBinaryCodec;
import coldfusion.nosql.mongo.codecs.CFBooleanCodec;
import coldfusion.nosql.mongo.codecs.CFBsonJSCodec;
import coldfusion.nosql.mongo.codecs.CFBsonTimeStampCodec;
import coldfusion.nosql.mongo.codecs.CFDoubleCodec;
import coldfusion.nosql.mongo.codecs.CFDynamicObjectCodec;
import coldfusion.nosql.mongo.codecs.CFIntegerCodec;
import coldfusion.nosql.mongo.codecs.CFJSONBasedCodec;
import coldfusion.nosql.mongo.codecs.CFListCodec;
import coldfusion.nosql.mongo.codecs.CFLongCodec;
import coldfusion.nosql.mongo.codecs.CFMapCodec;
import coldfusion.nosql.mongo.codecs.CFMongoDBRefCodec;
import coldfusion.nosql.mongo.codecs.CFMongoMaxKeyCodec;
import coldfusion.nosql.mongo.codecs.CFMongoMinKeyCodec;
import coldfusion.nosql.mongo.codecs.CFMongoObjectIDCodec;
import coldfusion.nosql.mongo.codecs.CFMongoRegexpCodec;
import coldfusion.nosql.mongo.codecs.CFStringCodec;
import coldfusion.nosql.mongo.codecs.CFXMLDocCodec;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.xml.DocumentQueryBeanAdapter;
import coldfusion.sql.imq.imqTable;
import coldfusion.util.Key;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.QueryBean;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.w3c.dom.Document;

public class CFMongoCodecProvider
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private static final Codec<Class<Object>> jsonBasedCodec = new CFJSONBasedCodec<Class<Object>>();
    private static final Codec<Class<Object>> stringBasedCodec = new CFStringCodec<Class<Object>>();
    private static final Codec<Class<Object>> binaryBasedCodec = new CFBinaryCodec<Class<Object>>();
    private static final Codec<Document> xmlDocCodec = new CFXMLDocCodec();
    private boolean caseSensitivity;
    private static Set<String> binaryClasses = new HashSet<String>(Arrays.asList("coldfusion.pdf.PDFDocWrapper", "coldfusion.excel.ExcelInfo", "coldfusion.image.Image"));

    public CFMongoCodecProvider() {
        this.addCodecs();
    }

    public CFMongoCodecProvider(boolean caseSensitivity) {
        this.addCodecs();
        this.caseSensitivity = caseSensitivity;
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        Codec<?> codec = this.codecs.get(clazz);
        if (codec != null) {
            return codec;
        }
        if (TemplateProxy.class.isAssignableFrom(clazz)) {
            return jsonBasedCodec;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (this.caseSensitivity) {
                return new CFMapCodec(registry, this.caseSensitivity);
            }
            return new CFMapCodec(registry);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new CFListCodec(registry);
        }
        if (clazz == CFMongoDBRef.class) {
            return new CFMongoDBRefCodec(registry);
        }
        if (clazz == CFBsonJS.class) {
            return new CFBsonJSCodec(registry);
        }
        if (clazz == SimpleReference.class) {
            return new CFDynamicObjectCodec(registry);
        }
        if (imqTable.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz)) {
            return jsonBasedCodec;
        }
        if (Document.class.isAssignableFrom(clazz)) {
            return xmlDocCodec;
        }
        if (binaryClasses.contains(clazz.getName())) {
            return binaryBasedCodec;
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new CFIntegerCodec());
        this.addCodec(new CFLongCodec());
        this.addCodec(new CFDoubleCodec());
        this.addCodec(new CFBigIntegerCodec());
        this.addCodec(new CFBigDecimalCodec());
        this.addCodec(new CFBooleanCodec());
        this.addCodec(new CFMongoMaxKeyCodec());
        this.addCodec(new CFMongoMinKeyCodec());
        this.addCodec(new CFMongoObjectIDCodec());
        this.addCodec(new CFMongoRegexpCodec());
        this.addCodec(new CFBsonTimeStampCodec());
        this.codecs.put(XmlNodeList.class, stringBasedCodec);
        this.codecs.put(Key.class, stringBasedCodec);
        this.codecs.put(TemplateProxy.class, jsonBasedCodec);
        this.codecs.put(QueryBean.class, jsonBasedCodec);
        this.codecs.put(imqTable.class, jsonBasedCodec);
        this.codecs.put(DocumentQueryBeanAdapter.class, jsonBasedCodec);
        this.codecs.put(DocumentQueryBean.class, jsonBasedCodec);
    }

    private <T> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }
}

