/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.nosql.mongo.CFMongoClientSession;
import coldfusion.nosql.mongo.CFMongoUpdateOptions;
import coldfusion.nosql.mongo.ConsumerMap;
import coldfusion.nosql.mongo.MongoConfigException;
import coldfusion.nosql.mongo.bson.BsonUtils;
import coldfusion.nosql.mongo.bson.types.CFBsonTimeStamp;
import coldfusion.nosql.mongo.bson.types.CFMongoObjectID;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructOrdered;
import coldfusion.util.RB;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.TaggableReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.client.model.changestream.FullDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public final class MongoUtils {
    private static final ConsumerMap<Collation.Builder> collationOptions = new ConsumerMap<Collation.Builder>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"locale", (T options, Object value) -> options.locale(MongoUtils.getStringProperty("collation locale", value)));
            this.put((Object)"caseLevel", (T options, Object value) -> options.caseLevel(MongoUtils.getBooleanProperty("collation caseLevel", value)));
            this.put((Object)"caseFirst", (T options, Object value) -> options.collationCaseFirst(CollationCaseFirst.fromString((String)MongoUtils.getStringProperty("collation caseFirst", value))));
            this.put((Object)"strength", (T options, Object value) -> {
                int val = MongoUtils.getIntegerProperty("collation strength", value);
                if (val > CollationStrength.IDENTICAL.getIntRepresentation()) {
                    throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.illegalcollationstrength", (Object)val));
                }
                options.collationStrength(CollationStrength.fromInt((int)val));
            });
            this.put((Object)"numericOrdering", (T options, Object value) -> options.numericOrdering(MongoUtils.getBooleanProperty("collation numericOrdering", value)));
            this.put((Object)"normalization", (T options, Object value) -> options.normalization(MongoUtils.getBooleanProperty("collation normalization", value)));
            this.put((Object)"backwards", (T options, Object value) -> options.backwards(MongoUtils.getBooleanProperty("collation backwards", value)));
            this.put((Object)"maxVariable", (T options, Object value) -> options.collationMaxVariable(CollationMaxVariable.fromString((String)MongoUtils.getStringProperty("collation maxVariable", value))));
            this.put((Object)"alternate", (T options, Object value) -> options.collationAlternate(CollationAlternate.fromString((String)MongoUtils.getStringProperty("collation alternate", value))));
        }
    };
    private static final ConsumerMap<CreateCollectionOptions> createCollectionOptions = new ConsumerMap<CreateCollectionOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"capped", (T options, Object value) -> options.capped(MongoUtils.getBooleanProperty("capped", value).booleanValue()));
            this.put((Object)"autoIndexId", (T options, Object value) -> options.autoIndex(MongoUtils.getBooleanProperty("autoIndexId", value).booleanValue()));
            this.put((Object)"size", (T options, Object value) -> options.sizeInBytes(MongoUtils.getLongProperty("size", value).longValue()));
            this.put((Object)"max", (T options, Object value) -> options.maxDocuments(MongoUtils.getLongProperty("max", value).longValue()));
            this.put((Object)"usePowerOf2Sizes", (T options, Object value) -> options.usePowerOf2Sizes(MongoUtils.getBooleanProperty("usePowerOf2Sizes", value)));
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"validationLevel", (T options, Object value) -> options.getValidationOptions().validationLevel(ValidationLevel.fromString((String)MongoUtils.getStringProperty("validationLevel", value))));
            this.put((Object)"validationAction", (T options, Object value) -> options.getValidationOptions().validationAction(ValidationAction.fromString((String)MongoUtils.getStringProperty("validationAction", value))));
            this.put((Object)"validator", (T options, Object value) -> {
                Map<?, ?> validatorMap = MongoUtils.getMapProperty("validator", value);
                BsonDocument bsonDocument = BsonUtils.to(validatorMap);
                options.getValidationOptions().validator((Bson)bsonDocument);
            });
            this.put((Object)"storageEngineOptions", (T options, Object value) -> {
                Map<?, ?> validatorMap = MongoUtils.getMapProperty("storageEngineOptions", value);
                BsonDocument bsonDocument = BsonUtils.to(validatorMap);
                options.storageEngineOptions((Bson)bsonDocument);
            });
            this.put((Object)"indexOptionDefaults", (T options, Object value) -> {
                Map<?, ?> validatorMap = MongoUtils.getMapProperty("indexOptionDefaults", value);
                Object obj = validatorMap.get("storageEngine");
                if (obj != null) {
                    Map<?, ?> storageEngineMap = MongoUtils.getMapProperty("storageEngine", obj);
                    BsonDocument bsonDocument = BsonUtils.to(storageEngineMap);
                    options.getIndexOptionDefaults().storageEngine((Bson)bsonDocument);
                }
            });
        }
    };
    private static final ConsumerMap<CreateViewOptions> createViewOptions = new ConsumerMap<CreateViewOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
        }
    };
    private static final ConsumerMap<ListIndexesIterable> listIndexesIterable = new ConsumerMap<ListIndexesIterable>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"batchSize", (T options, Object value) -> options.batchSize(MongoUtils.getIntegerProperty("batchSize", value).intValue()));
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
        }
    };
    private static final ConsumerMap<ListCollectionsIterable> listCollectionsIterable = new ConsumerMap<ListCollectionsIterable>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"batchSize", (T options, Object value) -> options.batchSize(MongoUtils.getIntegerProperty("batchSize", value).intValue()));
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
        }
    };
    private static final ConsumerMap<AggregateIterable> aggregateIterable = new ConsumerMap<AggregateIterable>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"batchSize", (T options, Object value) -> options.batchSize(MongoUtils.getIntegerProperty("batchSize", value).intValue()));
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxAwaitTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxAwaitTime", value);
                options.maxAwaitTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxAwaitTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxAwaitTimems", value);
                options.maxAwaitTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"allowDiskUse", (T options, Object value) -> options.allowDiskUse(MongoUtils.getBooleanProperty("allowDiskUse", value)));
            this.put((Object)"bypassDocumentValidation", (T options, Object value) -> options.bypassDocumentValidation(MongoUtils.getBooleanProperty("bypassDocumentValidation", value)));
            this.put((Object)"hint", (T options, Object value) -> {
                Map<?, ?> validatorMap = MongoUtils.getMapProperty("hint", value);
                BsonDocument bsonDocument = BsonUtils.to(validatorMap);
                options.hint((Bson)bsonDocument);
            });
            this.put((Object)"comment", (T options, Object value) -> options.comment(MongoUtils.getStringProperty("comment", value)));
        }
    };
    private static final ConsumerMap<MapReduceIterable> mapReduceIterable = new ConsumerMap<MapReduceIterable>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"batchSize", (T options, Object value) -> options.batchSize(MongoUtils.getIntegerProperty("batchSize", value).intValue()));
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"bypassDocumentValidation", (T options, Object value) -> options.bypassDocumentValidation(MongoUtils.getBooleanProperty("bypassDocumentValidation", value)));
            this.put((Object)"jsMode", (T options, Object value) -> options.jsMode(MongoUtils.getBooleanProperty("jsMode", value).booleanValue()));
            this.put((Object)"verbose", (T options, Object value) -> options.verbose(MongoUtils.getBooleanProperty("verbose", value).booleanValue()));
            this.put((Object)"sharded", (T options, Object value) -> options.sharded(MongoUtils.getBooleanProperty("sharded", value).booleanValue()));
            this.put((Object)"nonAtomic", (T options, Object value) -> options.nonAtomic(MongoUtils.getBooleanProperty("nonAtomic", value).booleanValue()));
            this.put((Object)"limit", (T options, Object value) -> {
                int val = MongoUtils.getIntegerProperty("limit", value);
                options.limit(val);
            });
            this.put((Object)"finalize", (T options, Object value) -> options.finalizeFunction(MongoUtils.getStringProperty("finalize", value)));
            this.put((Object)"collection", (T options, Object value) -> options.collectionName(MongoUtils.getStringProperty("collection", value)));
            this.put((Object)"database", (T options, Object value) -> options.databaseName(MongoUtils.getStringProperty("database", value)));
            this.put((Object)"action", (T options, Object value) -> options.action(MapReduceAction.valueOf((String)MongoUtils.getStringProperty("action", value).toUpperCase())));
            this.put((Object)"sort", (T options, Object value) -> options.sort((Bson)BsonUtils.to(MongoUtils.getMapProperty("sort", value))));
            this.put((Object)"scope", (T options, Object value) -> options.scope((Bson)BsonUtils.to(MongoUtils.getMapProperty("scope", value))));
            this.put((Object)"query", (T options, Object value) -> options.filter((Bson)BsonUtils.to(MongoUtils.getMapProperty("query", value))));
        }
    };
    private static final ConsumerMap<ChangeStreamIterable> changeStreamIterable = new ConsumerMap<ChangeStreamIterable>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"resumeAfter", (T options, Object value) -> {
                Map<?, ?> resumeAfterMap = MongoUtils.getMapProperty("resumeAfter", value);
                BsonDocument resumeAfterDoc = new BsonDocument("resumeAfter", (BsonValue)value);
                options.resumeAfter(resumeAfterDoc);
            });
            this.put((Object)"startAfter", (T options, Object value) -> {
                Map<?, ?> startAfterMap = MongoUtils.getMapProperty("startAfter", value);
                BsonDocument startAfterDoc = new BsonDocument("startAfter", (BsonValue)value);
                options.startAfter(startAfterDoc);
            });
            this.put((Object)"fullDocument", (T options, Object value) -> {
                FullDocument fullDocument = MongoUtils.fullDocumentFromString(MongoUtils.getStringProperty("fullDocument", value));
                options.fullDocument(fullDocument);
            });
            this.put((Object)"batchSize", (T options, Object value) -> options.batchSize(MongoUtils.getIntegerProperty("batchSize", value).intValue()));
            this.put((Object)"maxAwaitTimeMS", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxAwaitTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"startAtOperationTime", (T options, Object value) -> {
                if (value instanceof CFBsonTimeStamp) {
                    CFBsonTimeStamp cfBsonTimeStamp = (CFBsonTimeStamp)((Object)((Object)value));
                    options.startAtOperationTime(new BsonTimestamp((int)(((Date)value).getTime() / 1000L), cfBsonTimeStamp.getInc()));
                } else {
                    Date date = Cast._Date((Object)value);
                    if (date != null) {
                        options.startAtOperationTime(new BsonTimestamp(date.getTime() / 1000L));
                    }
                }
            });
        }
    };
    private static final ConsumerMap<DistinctIterable> distinctIterable = new ConsumerMap<DistinctIterable>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"batchSize", (T options, Object value) -> options.batchSize(MongoUtils.getIntegerProperty("batchSize", value).intValue()));
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
        }
    };
    private static final String COUNT_OPTIONS_SPACE = "Count Options ";
    private static final ConsumerMap<CountOptions> countOptions = new ConsumerMap<CountOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"limit", (T options, Object value) -> {
                int val = MongoUtils.getIntegerProperty("Count Options limit", value);
                options.limit(val);
            });
            this.put((Object)"skip", (T options, Object value) -> {
                int val = MongoUtils.getIntegerProperty("Count Options skip", value);
                options.skip(val);
            });
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"hint", (T options, Object value) -> {
                Map<?, ?> validatorMap = MongoUtils.getMapProperty("Count Options hint", value);
                BsonDocument bsonDocument = BsonUtils.to(validatorMap);
                options.hint((Bson)bsonDocument);
            });
            this.put((Object)"hintString", (T options, Object value) -> options.hintString(MongoUtils.getStringProperty("Count Options hintString", value)));
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
        }
    };
    private static final ConsumerMap<EstimatedDocumentCountOptions> estimatedDocCountOptions = new ConsumerMap<EstimatedDocumentCountOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
        }
    };
    private static final ConsumerMap<BulkWriteOptions> bulkWriteOptions = new ConsumerMap<BulkWriteOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"ordered", (T options, Object value) -> options.ordered(MongoUtils.getBooleanProperty("ordered", value).booleanValue()));
            this.put((Object)"bypassDocumentValidation", (T options, Object value) -> options.bypassDocumentValidation(MongoUtils.getBooleanProperty("bypassDocumentValidation", value)));
        }
    };
    private static final ConsumerMap<DeleteOptions> deleteOptions = new ConsumerMap<DeleteOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
        }
    };
    private static final ConsumerMap<CFMongoUpdateOptions> updateOptions = new ConsumerMap<CFMongoUpdateOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"upsert", (T options, Object value) -> options.upsert(MongoUtils.getBooleanProperty("upsert", value)));
            this.put((Object)"multi", (T options, Object value) -> options.multi(MongoUtils.getBooleanProperty("multi", value)));
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"arrayFilters", (T options, Object value) -> {
                List<?> listMap = MongoUtils.getListProperty("arrayFilters", value);
                ArrayList<BsonDocument> arrayFilters = new ArrayList<BsonDocument>();
                for (Object filterMap : listMap) {
                    arrayFilters.add(BsonUtils.to((Map)filterMap));
                }
                options.arrayFilters(arrayFilters);
            });
            this.put((Object)"bypassDocumentValidation", (T options, Object value) -> options.bypassDocumentValidation(MongoUtils.getBooleanProperty("bypassDocumentValidation", value)));
        }
    };
    private static final ConsumerMap<ReplaceOptions> replaceOptions = new ConsumerMap<ReplaceOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"upsert", (T options, Object value) -> options.upsert(MongoUtils.getBooleanProperty("upsert", value).booleanValue()));
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"bypassDocumentValidation", (T options, Object value) -> options.bypassDocumentValidation(MongoUtils.getBooleanProperty("bypassDocumentValidation", value)));
        }
    };
    private static final ConsumerMap<RenameCollectionOptions> renameCollectionOptions = new ConsumerMap<RenameCollectionOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"dropTarget", (T options, Object value) -> options.dropTarget(MongoUtils.getBooleanProperty("dropTarget", value).booleanValue()));
        }
    };
    private static final ConsumerMap<IndexOptions> indexOptions = new ConsumerMap<IndexOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"background", (T options, Object value) -> options.background(MongoUtils.getBooleanProperty("background", value).booleanValue()));
            this.put((Object)"unique", (T options, Object value) -> options.unique(MongoUtils.getBooleanProperty("unique", value).booleanValue()));
            this.put((Object)"sparse", (T options, Object value) -> options.sparse(MongoUtils.getBooleanProperty("sparse", value).booleanValue()));
            this.put((Object)"defaultLanguage", (T options, Object value) -> options.defaultLanguage(MongoUtils.getStringProperty("defaultLanguage", value)));
            this.put((Object)"languageOverride", (T options, Object value) -> options.languageOverride(MongoUtils.getStringProperty("languageOverride", value)));
            this.put((Object)"name", (T options, Object value) -> options.name(MongoUtils.getStringProperty("name", value)));
            this.put((Object)"expireAfterSeconds", (T options, Object value) -> options.expireAfter(MongoUtils.getLongProperty("expireAfterSeconds", value), TimeUnit.SECONDS));
            this.put((Object)"textIndexVersion", (T options, Object value) -> options.textVersion(MongoUtils.getPositiveIntegerProperty("textIndexVersion", value)));
            this.put((Object)"2dsphereIndexVersion", (T options, Object value) -> options.sphereVersion(MongoUtils.getPositiveIntegerProperty("2dsphereIndexVersion", value)));
            this.put((Object)"version", (T options, Object value) -> options.version(MongoUtils.getPositiveIntegerProperty("version", value)));
            this.put((Object)"bits", (T options, Object value) -> options.bits(MongoUtils.getPositiveIntegerProperty("bits", value)));
            this.put((Object)"min", (T options, Object value) -> options.min(MongoUtils.getDoubleProperty("min", value)));
            this.put((Object)"max", (T options, Object value) -> options.max(MongoUtils.getDoubleProperty("max", value)));
            this.put((Object)"bucketSize", (T options, Object value) -> options.bucketSize(MongoUtils.getDoubleProperty("bucketSize", value)));
            this.put((Object)"weights", (T options, Object value) -> options.weights((Bson)BsonUtils.to(MongoUtils.getMapProperty("weights", value))));
            this.put((Object)"partialFilterExpression", (T options, Object value) -> options.partialFilterExpression((Bson)BsonUtils.to(MongoUtils.getMapProperty("partialFilterExpression", value))));
            this.put((Object)"storageEngine", (T options, Object value) -> options.storageEngine((Bson)BsonUtils.to(MongoUtils.getMapProperty("storageEngine", value))));
        }
    };
    private static final ConsumerMap<CreateIndexOptions> createIndexOptions = new ConsumerMap<CreateIndexOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
        }
    };
    private static final ConsumerMap<DropIndexOptions> dropIndexOptions = new ConsumerMap<DropIndexOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
        }
    };
    private static final ConsumerMap<FindOneAndDeleteOptions> findOneAndDeleteOptions = new ConsumerMap<FindOneAndDeleteOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"projection", (T options, Object value) -> options.projection((Bson)BsonUtils.to(MongoUtils.getMapProperty("projection", value))));
            this.put((Object)"sort", (T options, Object value) -> options.sort((Bson)BsonUtils.to(MongoUtils.getMapProperty("sort", value))));
        }
    };
    private static final ConsumerMap<FindOneAndReplaceOptions> findOneAndReplaceOptions = new ConsumerMap<FindOneAndReplaceOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"upsert", (T options, Object value) -> options.upsert(MongoUtils.getBooleanProperty("upsert", value).booleanValue()));
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"projection", (T options, Object value) -> options.projection((Bson)BsonUtils.to(MongoUtils.getMapProperty("projection", value))));
            this.put((Object)"sort", (T options, Object value) -> options.sort((Bson)BsonUtils.to(MongoUtils.getMapProperty("sort", value))));
            this.put((Object)"bypassDocumentValidation", (T options, Object value) -> options.bypassDocumentValidation(MongoUtils.getBooleanProperty("bypassDocumentValidation", value)));
            this.put((Object)"returnNewDocument", (T options, Object value) -> options.returnDocument(MongoUtils.getBooleanProperty("returnNewDocument", value) != false ? ReturnDocument.AFTER : ReturnDocument.BEFORE));
        }
    };
    private static final ConsumerMap<FindOneAndUpdateOptions> findOneAndUpdateOptions = new ConsumerMap<FindOneAndUpdateOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"upsert", (T options, Object value) -> options.upsert(MongoUtils.getBooleanProperty("upsert", value).booleanValue()));
            this.put((Object)"maxTime", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTime", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"maxTimems", (T options, Object value) -> {
                Long val = MongoUtils.getLongProperty("Count Options maxTimems", value);
                options.maxTime(val.longValue(), TimeUnit.MILLISECONDS);
            });
            this.put((Object)"collation", (T options, Object value) -> {
                Map<?, ?> collationMap = MongoUtils.getMapProperty("collation", value);
                Collation collation = MongoUtils.getCollation(collationMap);
                options.collation(collation);
            });
            this.put((Object)"projection", (T options, Object value) -> options.projection((Bson)BsonUtils.to(MongoUtils.getMapProperty("projection", value))));
            this.put((Object)"sort", (T options, Object value) -> options.sort((Bson)BsonUtils.to(MongoUtils.getMapProperty("sort", value))));
            this.put((Object)"bypassDocumentValidation", (T options, Object value) -> options.bypassDocumentValidation(MongoUtils.getBooleanProperty("bypassDocumentValidation", value)));
            this.put((Object)"returnNewDocument", (T options, Object value) -> options.returnDocument(MongoUtils.getBooleanProperty("returnNewDocument", value) != false ? ReturnDocument.AFTER : ReturnDocument.BEFORE));
            this.put((Object)"arrayFilters", (T options, Object value) -> {
                List<?> listMap = MongoUtils.getListProperty("arrayFilters", value);
                ArrayList<BsonDocument> arrayFilters = new ArrayList<BsonDocument>();
                for (Object filterMap : listMap) {
                    arrayFilters.add(BsonUtils.to((Map)filterMap));
                }
                options.arrayFilters(arrayFilters);
            });
        }
    };
    private static final ConsumerMap<GridFSUploadOptions> gridFSUploadOptions = new ConsumerMap<GridFSUploadOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"chunkSizeBytes", (T options, Object value) -> options.chunkSizeBytes(MongoUtils.getPositiveIntegerProperty("chunkSizeBytes", value)));
            this.put((Object)"metadata", (T options, Object value) -> {
                Map<?, ?> val = MongoUtils.getMapProperty("metadata", value);
                options.metadata(new Document(val));
            });
        }
    };
    private static final ConsumerMap<GridFSDownloadOptions> gridFSDownloadOptions = new ConsumerMap<GridFSDownloadOptions>(){
        private static final long serialVersionUID = 1L;
        {
            this.put((Object)"revision", (T options, Object value) -> options.revision(Cast._int((Object)value, (boolean)false)));
        }
    };

    private static FullDocument fullDocumentFromString(String changeStreamFullDocument) {
        if (changeStreamFullDocument != null) {
            for (FullDocument fullDocument : FullDocument.values()) {
                if (!changeStreamFullDocument.equalsIgnoreCase(fullDocument.getValue())) continue;
                return fullDocument;
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid ChangeStreamFullDocument", changeStreamFullDocument));
    }

    public static CreateCollectionOptions getCreateCollectionOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new CreateCollectionOptions(), configMap, createCollectionOptions);
    }

    public static CreateViewOptions getCreateViewOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new CreateViewOptions(), configMap, createViewOptions);
    }

    public static CountOptions getCountOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new CountOptions(), configMap, countOptions);
    }

    public static <T> DistinctIterable<T> getDistinctIterable(Map<?, ?> configMap, DistinctIterable<T> itr) {
        if (configMap == null || configMap.size() == 0) {
            return itr;
        }
        return MongoUtils.fillObject(itr, configMap, distinctIterable);
    }

    public static EstimatedDocumentCountOptions getEstimatedCountOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new EstimatedDocumentCountOptions(), configMap, estimatedDocCountOptions);
    }

    public static BulkWriteOptions getBulkWriteOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new BulkWriteOptions(), configMap, bulkWriteOptions);
    }

    public static CFMongoUpdateOptions getUpdateOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new CFMongoUpdateOptions(), configMap, updateOptions);
    }

    public static ReplaceOptions getReplaceOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new ReplaceOptions(), configMap, replaceOptions);
    }

    public static DeleteOptions getDeleteOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new DeleteOptions(), configMap, deleteOptions);
    }

    public static FindOneAndDeleteOptions getFindOneAndDeleteOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new FindOneAndDeleteOptions(), configMap, findOneAndDeleteOptions);
    }

    public static FindOneAndReplaceOptions getFindOneAndReplaceOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new FindOneAndReplaceOptions(), configMap, findOneAndReplaceOptions);
    }

    public static FindOneAndUpdateOptions getFindOneAndUpdateOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new FindOneAndUpdateOptions(), configMap, findOneAndUpdateOptions);
    }

    public static IndexOptions getIndexOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new IndexOptions(), configMap, indexOptions);
    }

    public static CreateIndexOptions getCreateIndexOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new CreateIndexOptions(), configMap, createIndexOptions);
    }

    public static DropIndexOptions getDropIndexOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new DropIndexOptions(), configMap, dropIndexOptions);
    }

    public static ListIndexesIterable getListIndexesIterable(Map<?, ?> configMap, ListIndexesIterable itr) {
        if (configMap == null || configMap.size() == 0) {
            return itr;
        }
        return MongoUtils.fillObject(itr, configMap, listIndexesIterable);
    }

    public static ListCollectionsIterable getListCollectionsIterable(Map<?, ?> configMap, ListCollectionsIterable itr) {
        if (configMap == null || configMap.size() == 0) {
            return itr;
        }
        return MongoUtils.fillObject(itr, configMap, listCollectionsIterable);
    }

    public static AggregateIterable getAggregateIterable(Map<?, ?> configMap, AggregateIterable itr) {
        if (configMap == null || configMap.size() == 0) {
            return itr;
        }
        return MongoUtils.fillObject(itr, configMap, aggregateIterable);
    }

    public static MapReduceIterable getMapReduceIterable(Map<?, ?> configMap, MapReduceIterable itr) {
        if (configMap == null || configMap.size() == 0) {
            return itr;
        }
        return MongoUtils.fillObject(itr, configMap, mapReduceIterable);
    }

    public static ChangeStreamIterable getChangeStreamIterable(Map<?, ?> configMap, ChangeStreamIterable itr) {
        if (configMap == null || configMap.size() == 0) {
            return itr;
        }
        return MongoUtils.fillObject(itr, configMap, changeStreamIterable);
    }

    public static ClientSessionOptions getClientSessionOptions(Map<?, ?> configMap) {
        if (configMap != null && configMap.size() > 0) {
            ClientSessionOptions.Builder builder = ClientSessionOptions.builder();
            Boolean temp = MongoUtils.getBooleanProperty("causalConsistency", configMap);
            if (temp != null) {
                builder.causallyConsistent(temp.booleanValue());
                if (configMap.size() == 1) {
                    return builder.build();
                }
            }
            TransactionOptions transOptions = MongoUtils.getTransactionOptions(configMap);
            if (temp == null && transOptions == null) {
                return null;
            }
            if (transOptions != null) {
                builder.defaultTransactionOptions(transOptions);
            }
            return builder.build();
        }
        return null;
    }

    public static TransactionOptions getTransactionOptions(Map<?, ?> configMap) {
        if (configMap != null && configMap.size() > 0) {
            ReadConcern readConcern = MongoUtils.getReadConcern(configMap);
            ReadPreference readPreference = MongoUtils.getReadPreference(configMap, null);
            WriteConcern wConcern = MongoUtils.getWriteConcern(configMap, null);
            return TransactionOptions.builder().readConcern(readConcern).readPreference(readPreference).writeConcern(wConcern).build();
        }
        return null;
    }

    public static GridFSUploadOptions getGridFSUploadOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new GridFSUploadOptions(), configMap, gridFSUploadOptions);
    }

    public static GridFSDownloadOptions getGridFSDownloadOptions(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(new GridFSDownloadOptions(), configMap, gridFSDownloadOptions);
    }

    public static List<? extends Bson> getPipeline(List<?> pipeline) {
        ArrayList<BsonDocument> bson = new ArrayList<BsonDocument>();
        for (Object pipelineItem : pipeline) {
            if (!(pipelineItem instanceof Map)) {
                throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidmap", (Object)"pipeline"));
            }
            BsonDocument bsonDoc = BsonUtils.to((Map)pipelineItem);
            bson.add(bsonDoc);
        }
        return bson;
    }

    public static Collation getCollation(Map<?, ?> configMap) {
        if (configMap == null || configMap.size() == 0) {
            return null;
        }
        return MongoUtils.fillObject(Collation.builder(), configMap, collationOptions).build();
    }

    private static <T> T fillObject(T filler, Map<?, ?> configMap, ConsumerMap<T> consumerMap) {
        configMap.forEach((key, value) -> {
            Object biConsumer;
            if (value != null && (biConsumer = consumerMap.get(key)) != null) {
                biConsumer.accept(filler, value);
            }
        });
        return filler;
    }

    public static CFMongoClientSession getSession(Map<?, ?> configMap) {
        if (configMap == null) {
            return null;
        }
        Object object = configMap.get("session");
        if (object != null) {
            if (object instanceof CFMongoClientSession) {
                return (CFMongoClientSession)((Object)object);
            }
            throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidsession"));
        }
        return null;
    }

    public static Boolean getRetryWrites(Map<?, ?> configMap) {
        return MongoUtils.getBooleanProperty("retryWrites", configMap);
    }

    public static WriteConcern getWriteConcern(Map<?, ?> configMap) {
        Object value = configMap.get("writeConcern");
        if (value == null) {
            return null;
        }
        Map<?, ?> wConcernMap = MongoUtils.getMapProperty("writeConcern", value);
        return MongoUtils.getWriteConcern(wConcernMap, null);
    }

    public static WriteConcern getWriteConcern(Map<?, ?> configMap, WriteConcern wConcern) {
        if (configMap == null || configMap.size() == 0) {
            return wConcern;
        }
        Object w = configMap.get("w");
        Integer wTimeOut = null;
        Object[] temp = MongoUtils.getTimeSetting(configMap, "wtimeout");
        if (temp != null) {
            wTimeOut = MongoUtils.getIntegerProperty("wtimeout", temp);
        } else if (wConcern != null) {
            wTimeOut = wConcern.getWTimeout(TimeUnit.MILLISECONDS);
        }
        temp = MongoUtils.getAny(configMap, "j", "journal");
        Boolean journal = null;
        if (temp != null) {
            journal = MongoUtils.getBooleanProperty((String)temp[0], temp[1]);
        } else if (wConcern != null) {
            journal = wConcern.getJournal();
        }
        Boolean fsync = MongoUtils.getBooleanProperty("fsync", configMap);
        if (fsync == null && wConcern != null && wConcern.getFsync()) {
            fsync = Boolean.TRUE;
        }
        if (w != null || wTimeOut != null || fsync != null || journal != null) {
            WriteConcern toReturn = null;
            if (w == null) {
                toReturn = wConcern == null ? WriteConcern.ACKNOWLEDGED : wConcern;
            } else if (w instanceof String) {
                try {
                    toReturn = new WriteConcern(Integer.parseInt((String)w));
                }
                catch (NumberFormatException e) {
                    toReturn = new WriteConcern((String)w);
                }
            } else if (w instanceof Integer) {
                toReturn = new WriteConcern(MongoUtils.getIntegerProperty("w", w).intValue());
            } else {
                throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidw"));
            }
            if (wTimeOut != null) {
                toReturn = toReturn.withWTimeout((long)wTimeOut.intValue(), TimeUnit.MILLISECONDS);
            }
            if (journal != null) {
                toReturn = toReturn.withJournal(journal);
            }
            if (fsync != null) {
                toReturn = toReturn.withFsync(fsync.booleanValue());
            }
            return toReturn;
        }
        return wConcern;
    }

    public static ReadConcern getReadConcern(Map<?, ?> configMap) {
        if (configMap == null) {
            return null;
        }
        String temp = MongoUtils.getStringProperty("readConcern", configMap);
        if (temp != null) {
            return new ReadConcern(ReadConcernLevel.fromString((String)temp));
        }
        return null;
    }

    public static ReadPreference getReadPreference(Map<?, ?> configMap) {
        if (configMap == null) {
            return null;
        }
        return MongoUtils.getReadPreference(configMap, null);
    }

    public static ReadPreference getReadPreference(Map<?, ?> configMap, ReadPreference rPref) {
        TaggableReadPreference tRef = rPref instanceof TaggableReadPreference ? (TaggableReadPreference)rPref : null;
        String readPref = MongoUtils.getStringProperty("readPreference", configMap);
        if (readPref != null) {
            if (readPref.equalsIgnoreCase("primary")) {
                return ReadPreference.primary();
            }
            ReadPreference temp = ReadPreference.valueOf((String)readPref);
            if (temp instanceof TaggableReadPreference && tRef != null) {
                rPref = ReadPreference.valueOf((String)readPref, (List)tRef.getTagSetList(), (long)tRef.getMaxStaleness(TimeUnit.SECONDS), (TimeUnit)TimeUnit.SECONDS);
            }
        }
        Object readPreferenceTags = configMap.get("readPreferenceTags");
        Long maxStaleness = MongoUtils.getLongProperty("maxStalenessSeconds", configMap);
        if (maxStaleness != null || tRef == null || (maxStaleness = tRef.getMaxStaleness(TimeUnit.SECONDS)) != null) {
            // empty if block
        }
        if (readPreferenceTags != null) {
            if (maxStaleness == null) {
                return ReadPreference.valueOf((String)rPref.getName(), MongoUtils.getReadPreferenceTagSet(readPreferenceTags));
            }
            return ReadPreference.valueOf((String)rPref.getName(), MongoUtils.getReadPreferenceTagSet(readPreferenceTags), (long)maxStaleness, (TimeUnit)TimeUnit.SECONDS);
        }
        if (maxStaleness != null && rPref != null) {
            return ReadPreference.valueOf((String)rPref.getName(), MongoUtils.getReadPreferenceTagSet(readPreferenceTags));
        }
        return rPref;
    }

    public static ObjectId getObjectId(Object objId) {
        if (objId instanceof String) {
            return new ObjectId((String)objId);
        }
        if (objId instanceof Date) {
            return new ObjectId((Date)objId);
        }
        if (objId instanceof ObjectId) {
            return (ObjectId)objId;
        }
        if (objId instanceof byte[]) {
            return new ObjectId((byte[])objId);
        }
        if (objId instanceof CFMongoObjectID) {
            return ((CFMongoObjectID)objId).getId();
        }
        if (objId instanceof BsonObjectId) {
            return ((BsonObjectId)objId).getValue();
        }
        throw new IllegalArgumentException();
    }

    private static List<TagSet> getReadPreferenceTagSet(Object readPreferenceTags) {
        if (readPreferenceTags == null) {
            return Collections.emptyList();
        }
        if (readPreferenceTags instanceof List) {
            List readPrefTagList = (List)readPreferenceTags;
            ArrayList<TagSet> tagSetList = new ArrayList<TagSet>();
            for (int i = 0; i < readPrefTagList.size(); ++i) {
                Object tagsMapObj = readPrefTagList.get(i);
                if (tagsMapObj instanceof Map) {
                    ArrayList<Tag> tagSet = new ArrayList<Tag>();
                    for (Map.Entry entry : ((Map)tagsMapObj).entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (!(key instanceof String) || !(value instanceof String)) {
                            MongoUtils.throwInvalidTagsetException();
                        }
                        tagSet.add(new Tag((String)key, (String)value));
                    }
                    tagSetList.add(new TagSet(tagSet));
                    continue;
                }
                MongoUtils.throwInvalidTagsetException();
            }
            return tagSetList;
        }
        MongoUtils.throwInvalidTagsetException();
        return null;
    }

    private static void throwInvalidTagsetException() {
        throw new MongoConfigException("InvalidReadPreferenceTagset", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidtagsetstructure"));
    }

    private static Object[] getAny(Map<?, ?> map, String ... keys) {
        for (String key : keys) {
            Object obj = map.get(key);
            if (obj == null) continue;
            return new Object[]{key, obj};
        }
        return null;
    }

    public static Object getTimeSetting(Map<?, ?> map, String key) {
        Object obj = map.get(key);
        if (obj == null && !key.toLowerCase().endsWith("ms")) {
            obj = map.get(key + "MS");
        }
        return obj;
    }

    public static String getStringProperty(String key, Map<?, ?> configMap) {
        try {
            return (String)configMap.get(key);
        }
        catch (ClassCastException e) {
            throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidstring", (Object)key));
        }
    }

    public static String getStringProperty(String key, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidstring", (Object)key));
    }

    public static Boolean getBooleanProperty(String key, Map<?, ?> configMap) {
        Object temp = configMap.get(key);
        if (temp != null) {
            return MongoUtils.getBooleanProperty(key, temp);
        }
        return null;
    }

    public static Boolean getBooleanProperty(String key, Object value) {
        try {
            return Cast._boolean((Object)value);
        }
        catch (Cast.BooleanConversionException e) {
            throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidboolean", (Object)key));
        }
    }

    public static Integer getIntegerProperty(String key, Map<?, ?> configMap) {
        Object temp = configMap.get(key);
        if (temp != null) {
            return MongoUtils.getIntegerProperty(key, temp);
        }
        return null;
    }

    public static Integer getIntegerProperty(String key, Object value) {
        try {
            int intValue = Cast._int((Object)value, (boolean)false);
            if (intValue < 0) {
                throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidinteger", (Object)key));
            }
            return intValue;
        }
        catch (Cast.NumberConversionException | Cast.OutOfBoundsException e) {
            throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidinteger", (Object)key));
        }
    }

    public static Integer getPositiveIntegerProperty(String key, Map<?, ?> configMap) {
        Object temp = configMap.get(key);
        if (temp != null) {
            return MongoUtils.getPositiveIntegerProperty(key, temp);
        }
        return null;
    }

    public static Integer getPositiveIntegerProperty(String key, Object value) {
        try {
            int intValue = Cast._int((Object)value, (boolean)false);
            if (intValue < 1) {
                throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidpositiveinteger", (Object)key));
            }
            return intValue;
        }
        catch (Cast.NumberConversionException | Cast.OutOfBoundsException e) {
            throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidpositiveinteger", (Object)key));
        }
    }

    public static Long getLongProperty(String key, Map<?, ?> configMap) {
        Object temp = configMap.get(key);
        if (temp != null) {
            return MongoUtils.getLongProperty(key, temp);
        }
        return null;
    }

    public static Long getLongProperty(String key, Object value) {
        try {
            long l = Cast._long((Object)value, (boolean)false);
            if (l < 0L) {
                throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidpositivenumeric", (Object)key));
            }
            return l;
        }
        catch (Cast.NumberConversionException e) {
            throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidpositivenumeric", (Object)key));
        }
    }

    public static Double getDoubleProperty(String key, Map<?, ?> configMap) {
        Object temp = configMap.get(key);
        if (temp != null) {
            return MongoUtils.getDoubleProperty(key, temp);
        }
        return null;
    }

    public static Double getDoubleProperty(String key, Object value) {
        try {
            return Cast._double((Object)value, (boolean)false);
        }
        catch (Cast.NumberConversionException e) {
            throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidpositivenumeric", (Object)key));
        }
    }

    public static Map<?, ?> getMapProperty(String key, Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidmap", (Object)key));
    }

    public static List<?> getListProperty(String key, Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        throw new MongoConfigException("ConfigTypeMisMatch", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.invalidarray", (Object)key));
    }

    public static Map toMap(ServerAddress serverAddress) {
        if (serverAddress == null) {
            return Collections.EMPTY_MAP;
        }
        Struct map = new Struct();
        map.put("host", serverAddress.getHost());
        map.put("port", serverAddress.getPort());
        return map;
    }

    public static List<Map> toMap(List<BulkWriteError> bulkWriteErrors) {
        if (bulkWriteErrors != null) {
            return bulkWriteErrors.stream().map(error -> MongoUtils.toMap(error)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Map toMap(BulkWriteError bulkWriteError) {
        StructOrdered map = new StructOrdered();
        map.put("index", bulkWriteError.getIndex());
        map.put("code", bulkWriteError.getCode());
        map.put("category", bulkWriteError.getCategory().toString().toLowerCase());
        map.put("errmsg", bulkWriteError.getMessage());
        map.put("details", bulkWriteError.getDetails());
        return map;
    }

    public static Map toMap(WriteConcernError writeConcernError) {
        StructOrdered map = new StructOrdered();
        map.put("code", writeConcernError.getCode());
        map.put("codeName", writeConcernError.getCodeName());
        map.put("errmsg", writeConcernError.getMessage());
        map.put("errInfo", writeConcernError.getDetails());
        return map;
    }

    public static Map toMap(BsonTimestamp ts) {
        HashMap<String, Serializable> wConcernMap = new HashMap<String, Serializable>();
        wConcernMap.put("inc", Integer.valueOf(ts.getInc()));
        wConcernMap.put("value", Long.valueOf(ts.getValue()));
        wConcernMap.put("time", new Date((long)ts.getTime() * 1000L));
        return wConcernMap;
    }

    public static Map toMap(WriteConcern wConcern) {
        if (wConcern == null) {
            return null;
        }
        HashMap<String, Object> wConcernMap = new HashMap<String, Object>();
        wConcernMap.put("w", wConcern.getWObject() == null ? "ACKNOWLEDGED" : wConcern.getWObject());
        wConcernMap.put("journal", wConcern.getJournal());
        wConcernMap.put("wtimeoutMS", wConcern.getWTimeout(TimeUnit.MILLISECONDS));
        return wConcernMap;
    }

    public static Map toMap(ReadPreference readPreference) {
        if (readPreference == null) {
            return null;
        }
        HashMap<String, Object> readPrefMap = new HashMap<String, Object>();
        readPrefMap.put("name", readPreference.getName());
        if (readPreference instanceof TaggableReadPreference) {
            TaggableReadPreference tReadPref = (TaggableReadPreference)readPreference;
            readPrefMap.put("maxStalenessSeconds", tReadPref.getMaxStaleness(TimeUnit.SECONDS));
            List tagSetList = tReadPref.getTagSetList();
            Array list = new Array();
            tagSetList.forEach(arg_0 -> MongoUtils.lambda$toMap$3((List)list, arg_0));
            readPrefMap.put("readPreferenceTags", list);
        }
        return readPrefMap;
    }

    public static Map to(GridFSFile gridFSFile) {
        if (gridFSFile == null) {
            return null;
        }
        Struct gridFsFileInfo = new Struct();
        gridFsFileInfo.put("filename", gridFSFile.getFilename());
        gridFsFileInfo.put("id", new CFMongoObjectID(MongoUtils.getObjectId(gridFSFile.getId())));
        gridFsFileInfo.put("uploaddate", gridFSFile.getUploadDate());
        gridFsFileInfo.put("size", gridFSFile.getLength());
        gridFsFileInfo.put("md5", gridFSFile.getMD5());
        gridFsFileInfo.put("metadata", gridFSFile.getMetadata());
        gridFsFileInfo.put("chunkSize", gridFSFile.getChunkSize());
        gridFsFileInfo.put("extraElements", gridFSFile.getExtraElements());
        return gridFsFileInfo;
    }

    private static /* synthetic */ void lambda$toMap$3(List list, TagSet tagSet) {
        HashMap tagMap = new HashMap();
        tagSet.forEach(tag -> tagMap.put(tag.getName(), tag.getValue()));
        list.add(tagMap);
    }
}

