/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.nosql.NoSQLQueryDetails;
import coldfusion.nosql.mongo.CFBulkWriteResult;
import coldfusion.nosql.mongo.CFMongoClientSession;
import coldfusion.nosql.mongo.CFMongoContext;
import coldfusion.nosql.mongo.CFMongoDatabase;
import coldfusion.nosql.mongo.CFMongoUpdateOptions;
import coldfusion.nosql.mongo.MongoException;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.SimpleReference;
import coldfusion.nosql.mongo.bson.BsonUtils;
import coldfusion.nosql.mongo.cursor.CFMongoChangeStreamCursor;
import coldfusion.nosql.mongo.cursor.CFMongoFindIterator;
import coldfusion.nosql.mongo.cursor.CFMongoFindIteratorImpl;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructOrdered;
import coldfusion.server.NoSQLService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.CFDumpable;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.jsp.PageContext;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class CFMongoCollection
implements CFDumpable,
NamedInvokable {
    private MongoCollection collection;
    private CFMongoClientSession csDelegate;
    private CFMongoDatabase db;
    private NoSQLQueryDetails noSQLQueryDetails;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)"MONGO_DB");
    private static final Map<String, Function<Map, WriteModel<Object>>> writeModelMap = new HashMap<String, Function<Map, WriteModel<Object>>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("insertone", document -> {
                Object object = document.get("document");
                if (object == null) {
                    throw new MongoException("BulkWriteError", "The operation insertone does not contain document key");
                }
                return new InsertOneModel(object);
            });
            this.put("updateone", document -> {
                Object filterObj = document.get("filter");
                if (filterObj == null) {
                    throw new MongoException("BulkWriteError", "The operation updateone is missing the required attribute filter");
                }
                Bson filter = BsonUtils.to(filterObj);
                Object updateObj = document.get("update");
                if (updateObj == null) {
                    throw new MongoException("BulkWriteError", "The operation updateone is missing the required attribute update");
                }
                Bson update = BsonUtils.to(updateObj);
                CFMongoUpdateOptions updateOptions = MongoUtils.getUpdateOptions(document);
                return updateOptions != null ? new UpdateOneModel(filter, update, (UpdateOptions)updateOptions) : new UpdateOneModel(filter, update);
            });
            this.put("updatemany", document -> {
                Object filterObj = document.get("filter");
                if (filterObj == null) {
                    throw new MongoException("BulkWriteError", "The operation updatemany is missing the required attribute filter");
                }
                Bson filter = BsonUtils.to(filterObj);
                Object updateObj = document.get("update");
                if (updateObj == null) {
                    throw new MongoException("BulkWriteError", "The operation updatemany is missing the required attribute update");
                }
                Bson update = BsonUtils.to(updateObj);
                CFMongoUpdateOptions updateOptions = MongoUtils.getUpdateOptions(document);
                return updateOptions != null ? new UpdateManyModel(filter, update, (UpdateOptions)updateOptions) : new UpdateManyModel(filter, update);
            });
            this.put("deleteone", document -> {
                Object filterObj = document.get("filter");
                if (filterObj == null) {
                    throw new MongoException("BulkWriteError", "The operation deleteone is missing the required attribute filter");
                }
                Bson filter = BsonUtils.to(filterObj);
                DeleteOptions deleteOptions = MongoUtils.getDeleteOptions(document);
                return deleteOptions != null ? new DeleteOneModel(filter, deleteOptions) : new DeleteOneModel(filter);
            });
            this.put("deletemany", document -> {
                Object filterObj = document.get("filter");
                if (filterObj == null) {
                    throw new MongoException("BulkWriteError", "The operation deletemany is missing the required attribute filter");
                }
                Bson filter = BsonUtils.to(filterObj);
                DeleteOptions deleteOptions = MongoUtils.getDeleteOptions(document);
                return deleteOptions != null ? new DeleteManyModel(filter, deleteOptions) : new DeleteManyModel(filter);
            });
            this.put("replaceone", document -> {
                Object filterObj = document.get("filter");
                if (filterObj == null) {
                    throw new MongoException("BulkWriteError", "The operation replaceone is missing the required attribute filter");
                }
                Bson filter = BsonUtils.to(filterObj);
                Object replacementObj = document.get("replacement");
                if (replacementObj == null) {
                    throw new MongoException("BulkWriteError", "The operation replaceone is replaceone the required attribute replacement");
                }
                Bson replacement = BsonUtils.to(replacementObj);
                ReplaceOptions replaceOptions = MongoUtils.getReplaceOptions(document);
                return replaceOptions != null ? new ReplaceOneModel(filter, (Object)replacement, replaceOptions) : new ReplaceOneModel(filter, (Object)replacement);
            });
        }
    };
    private static InvokeNamedMethodInvocationMap<CFMongoCollection> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public CFMongoCollection(CFMongoDatabase db, MongoCollection collection) {
        this.db = db;
        this.collection = collection;
        this.noSQLQueryDetails = new NoSQLQueryDetails();
        this.tagAttributeList.addTagAttribute("collection", (Object)collection.getNamespace().getFullName());
        this.tagAttributeList.addTagAttribute("db", (Object)db.getName());
    }

    public CFMongoCollection(CFMongoDatabase db, MongoCollection collection, CFMongoClientSession cs) {
        this(db, collection);
        this.csDelegate = cs;
        this.tagAttributeList.addTagAttribute("collection", (Object)collection.getNamespace());
        this.tagAttributeList.addTagAttribute("db", (Object)db.getName());
    }

    public CFMongoDatabase getDb() {
        return this.db;
    }

    public long count() {
        RequestMonitorEventProcessor.onFunctionStart((String)"count", (boolean)true);
        long res = this.csDelegate == null ? this.collection.countDocuments() : this.collection.countDocuments(this.csDelegate.getClientSession());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"count", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public long count(Object query) {
        RequestMonitorEventProcessor.onFunctionStart((String)"count", (boolean)true);
        long res = this.__countDocuments(query, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"count", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public long count(Object query, Map countOptionsMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"count", (boolean)true);
        long res = this.__countDocuments(query, countOptionsMap);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"count", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public long countDocuments() {
        RequestMonitorEventProcessor.onFunctionStart((String)"countDocuments", (boolean)true);
        long res = this.csDelegate == null ? this.collection.countDocuments() : this.collection.countDocuments(this.csDelegate.getClientSession());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"countDocuments", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public long countDocuments(Object query) {
        return this.countDocuments(query, null);
    }

    public long countDocuments(Object query, Map countOptionsMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"countDocuments", (boolean)true);
        long res = this.__countDocuments(query, countOptionsMap);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"countDocuments", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private long __countDocuments(Object query, Map countOptionsMap) {
        CFMongoClientSession clientSession = MongoUtils.getSession(countOptionsMap);
        CountOptions countOptions = null;
        if (clientSession != null && countOptionsMap.size() > 1 || clientSession == null) {
            countOptions = MongoUtils.getCountOptions(countOptionsMap);
        }
        Bson queryFilter = BsonUtils.to(query);
        CFMongoClientSession cFMongoClientSession = clientSession = clientSession == null ? this.csDelegate : clientSession;
        if (clientSession != null) {
            if (countOptions != null) {
                return this.collection.countDocuments(clientSession.getClientSession(), queryFilter, countOptions);
            }
            return this.collection.countDocuments(clientSession.getClientSession(), queryFilter);
        }
        if (countOptions != null) {
            return this.collection.countDocuments(queryFilter, countOptions);
        }
        return this.collection.countDocuments(queryFilter);
    }

    public long __count(CountOptions countOptions, Bson queryFilter) {
        CFMongoClientSession clientSession;
        CFMongoClientSession cFMongoClientSession = clientSession = this.csDelegate == null ? null : this.csDelegate;
        if (clientSession != null) {
            if (countOptions != null) {
                return this.collection.countDocuments(clientSession.getClientSession(), queryFilter, countOptions);
            }
            return this.collection.countDocuments(clientSession.getClientSession(), queryFilter);
        }
        if (countOptions != null) {
            return this.collection.countDocuments(queryFilter, countOptions);
        }
        return this.collection.countDocuments(queryFilter);
    }

    public long estimatedDocumentCount() {
        return this.estimatedDocumentCount(null);
    }

    public long estimatedDocumentCount(Map optionsMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"estimatedDocumentCount", (boolean)true);
        EstimatedDocumentCountOptions options = MongoUtils.getEstimatedCountOptions(optionsMap);
        long res = 0L;
        res = options != null ? this.collection.estimatedDocumentCount(options) : this.collection.estimatedDocumentCount();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"estimatedDocumentCount", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private void fillNoSQLQueryDetails(Map<?, ?> options) {
        if (this.noSQLQueryDetails == null) {
            this.noSQLQueryDetails = new NoSQLQueryDetails();
        }
        this.noSQLQueryDetails.setDsnName((String)this.getDb().getSvc().getDataSourceSettings().get("NAME"));
        this.noSQLQueryDetails.setDbType((String)this.getDb().getSvc().getDataSourceSettings().get("TYPE"));
        this.noSQLQueryDetails.setCacheId((String)options.get("cacheId"));
        this.noSQLQueryDetails.setParameterObj(options);
        this.noSQLQueryDetails.setHashCode();
    }

    private boolean toBeCached(Map<?, ?> options) {
        boolean toBeCached = false;
        if (options.get("cachedAfter") != null && System.currentTimeMillis() > ((Date)options.get("cachedAfter")).getTime()) {
            toBeCached = true;
        }
        if (options.get("cachedWithin") != null) {
            toBeCached = true;
        }
        return toBeCached;
    }

    public Array distinct(String field) {
        return this.distinct(field, null);
    }

    public Array distinct(String field, Object query) {
        RequestMonitorEventProcessor.onFunctionStart((String)"distinct", (boolean)true);
        Array res = this._distinct(field, query, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"distinct", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Array distinct(String field, Object query, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"distinct", (boolean)true);
        if (this.toBeCached(options)) {
            NoSQLService noSQLService;
            Object results;
            this.fillNoSQLQueryDetails(options);
            Long cachedWithin = null;
            if (options.get("cachedWithin") != null) {
                cachedWithin = new Double((Double)options.get("cachedWithin") * 8.64E7).longValue();
            }
            if ((results = (noSQLService = ServiceFactory.getNoSQLService((boolean)true)).getCachedQuery(this.noSQLQueryDetails, (String)options.get("cacheRegion"), cachedWithin)) == null) {
                results = this._distinct(field, query, options);
                noSQLService.setCachedQuery(this.noSQLQueryDetails, this.noSQLQueryDetails.getHashCode(), results, cachedWithin, (Date)options.get("cachedAfter") != null, (String)options.get("cacheId"), (String)options.get("cacheRegion"));
            }
            return (Array)results;
        }
        return this._distinct(field, query, options);
    }

    private Array _distinct(String field, Object query, Map<?, ?> options) {
        DistinctIterable<SimpleReference> itr = this.getDistinctIterable(field, query, options);
        MongoIterable distinct = options == null || options.size() == 0 ? itr.map(s -> s.get()) : MongoUtils.getDistinctIterable(options, itr).map(s -> s.get());
        Array a = new Array(1);
        distinct.iterator().forEachRemaining(arg_0 -> ((Array)a).add(arg_0));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"distinct", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return a;
    }

    private DistinctIterable<SimpleReference> getDistinctIterable(String field, Object query, Map<?, ?> options) {
        Bson filter = query != null ? BsonUtils.to(query) : null;
        ClientSession cs = this.getClientSession(options);
        if (cs == null) {
            if (filter == null) {
                return this.collection.distinct(field, SimpleReference.class);
            }
            return this.collection.distinct(field, filter, SimpleReference.class);
        }
        if (filter == null) {
            return this.collection.distinct(cs, field, SimpleReference.class);
        }
        return this.collection.distinct(cs, field, filter, SimpleReference.class);
    }

    public CFMongoFindIterator<Map> find() {
        RequestMonitorEventProcessor.onFunctionStart((String)"find", (boolean)true);
        CFMongoFindIterator<Map> res = this._find();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"find", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoFindIterator<Map> find(Map<?, ?> query) {
        RequestMonitorEventProcessor.onFunctionStart((String)"find", (boolean)true);
        CFMongoFindIterator<Map> res = this._find(query);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"find", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoFindIterator<Map> find(Map<?, ?> query, Map<?, ?> projection) {
        RequestMonitorEventProcessor.onFunctionStart((String)"find", (boolean)true);
        CFMongoFindIterator<Map> res = this._find(query).projection(projection);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"find", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private CFMongoFindIterator<Map> _find() {
        FindIterable findIterator = this.csDelegate != null ? this.collection.find(this.csDelegate.getClientSession(), CFMongoDatabase.DOCUMENT_CLASS) : this.collection.find(CFMongoDatabase.DOCUMENT_CLASS);
        return new CFMongoFindIteratorImpl<Map>(this, findIterator);
    }

    private CFMongoFindIterator<Map> _find(Map<?, ?> query) {
        BsonDocument filter = BsonUtils.to(query);
        FindIterable findIterator = this.csDelegate != null ? this.collection.find(this.csDelegate.getClientSession(), (Bson)filter, CFMongoDatabase.DOCUMENT_CLASS) : this.collection.find((Bson)filter, CFMongoDatabase.DOCUMENT_CLASS);
        return new CFMongoFindIteratorImpl<Map>(this, findIterator, (Bson)filter);
    }

    public Map findOne() {
        RequestMonitorEventProcessor.onFunctionStart((String)"findOne", (boolean)true);
        Map res = (Map)this._find().limit(1).first();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"findOne", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map findOne(Map<?, ?> query) {
        RequestMonitorEventProcessor.onFunctionStart((String)"findOne", (boolean)true);
        Map res = (Map)this._find(query).limit(1).first();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"findOne", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map findOne(Map<?, ?> query, Map<?, ?> projection) {
        RequestMonitorEventProcessor.onFunctionStart((String)"findOne", (boolean)true);
        Map res = (Map)this._find(query).projection(projection).limit(1).first();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"findOne", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Array aggregate(List<?> pipeline) {
        return this.aggregate(pipeline, null);
    }

    public Array aggregate(List<?> pipeline, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"aggregate", (boolean)true);
        List<? extends Bson> mongoPipeline = MongoUtils.getPipeline(pipeline);
        ClientSession cs = this.getClientSession(options);
        AggregateIterable itr = cs == null ? this.getCollection(options, cs, true).aggregate(mongoPipeline, CFMongoDatabase.DOCUMENT_CLASS) : this.getCollection(options, this.collection).aggregate(cs, mongoPipeline, CFMongoDatabase.DOCUMENT_CLASS);
        itr = MongoUtils.getAggregateIterable(options, itr);
        Array a = new Array(1);
        itr.iterator().forEachRemaining(arg_0 -> ((Array)a).add(arg_0));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"aggregate", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return a;
    }

    public CFMongoChangeStreamCursor watch() {
        return this.watch(null, null);
    }

    public CFMongoChangeStreamCursor watch(List<?> pipeline) {
        return this.watch(pipeline, null);
    }

    public CFMongoChangeStreamCursor watch(List<?> pipeline, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"watch", (boolean)true);
        List<? extends Bson> mongoPipeline = pipeline == null ? null : MongoUtils.getPipeline(pipeline);
        ClientSession cs = this.getClientSession(options);
        ChangeStreamIterable itr = cs == null ? (mongoPipeline == null ? this.getCollection(options, cs, true).watch(CFMongoDatabase.DOCUMENT_CLASS) : this.getCollection(options, cs, true).watch(mongoPipeline, CFMongoDatabase.DOCUMENT_CLASS)) : (mongoPipeline == null ? this.getCollection(options, this.collection).watch(cs, CFMongoDatabase.DOCUMENT_CLASS) : this.getCollection(options, this.collection).watch(cs, mongoPipeline, CFMongoDatabase.DOCUMENT_CLASS));
        CFMongoChangeStreamCursor cursor = new CFMongoChangeStreamCursor(itr);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"watch", (TagAttributeList)this.tagAttributeList);
        return cursor;
    }

    public Array mapReduce(String mapFunc, String reduceFunc) {
        return this.mapReduce(mapFunc, reduceFunc, null);
    }

    public Array mapReduce(String mapFunc, String reduceFunc, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"mapReduce", (boolean)true);
        ClientSession cs = this.getClientSession(options);
        MapReduceIterable itr = cs == null ? this.getCollection(options, cs).mapReduce(mapFunc, reduceFunc, CFMongoDatabase.DOCUMENT_CLASS) : this.getCollection(options, this.collection).mapReduce(cs, mapFunc, reduceFunc, CFMongoDatabase.DOCUMENT_CLASS);
        itr = MongoUtils.getMapReduceIterable(options, itr);
        Array a = new Array(1);
        if (options.containsKey("out")) {
            itr.collectionName((String)options.get("out"));
        }
        itr.toCollection();
        itr.iterator().forEachRemaining(arg_0 -> ((Array)a).add(arg_0));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"mapReduce", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return a;
    }

    public Map insertOne(Object document) {
        return this.insertOne(document, null);
    }

    public Map insertOne(Object document, Map<?, ?> insertOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"insertOne", (boolean)true);
        if (document instanceof String) {
            document = Document.parse((String)((String)document));
        }
        Map res = this.insert(document, insertOptions);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"insertOne", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map insertMany(Object document) {
        return this.insertMany(document, null);
    }

    public Map insertMany(Object document, Map<?, ?> insertOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"insertMany", (boolean)true);
        Map res = this.insert(document, insertOptions);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"insertMany", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map insert(Object document) {
        return this.insert(document, null);
    }

    public Map insert(Object document, Map<?, ?> insertOptions) {
        List<Object> insertedIds;
        RequestMonitorEventProcessor.onFunctionStart((String)"insert", (boolean)true);
        if (document instanceof String) {
            document = BsonUtils.to((String)document);
        }
        List<Object> requests = document instanceof List ? ((List)document).stream().map(obj -> new InsertOneModel(obj)).collect(Collectors.toList()) : Collections.singletonList(new InsertOneModel(document));
        CFBulkWriteResult cfwriteResult = this._bulkWrite(requests, insertOptions);
        BulkWriteResult writeResult = cfwriteResult.getResult();
        Struct struct = new Struct();
        struct.put((Object)"acknowledged", (Object)writeResult.wasAcknowledged());
        if (writeResult.wasAcknowledged()) {
            struct.put((Object)"insertedCount", (Object)writeResult.getInsertedCount());
        }
        if ((insertedIds = cfwriteResult.getInsertedIds()) != null) {
            struct.put((Object)"insertedIds", insertedIds);
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"insert", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return struct;
    }

    public Struct deleteOne(Object Filter) {
        return this.deleteOne(Filter, null);
    }

    public Struct deleteOne(Object Filter, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteOne", (boolean)true);
        Bson filter = BsonUtils.to(Filter);
        DeleteOptions deleteOptions = MongoUtils.getDeleteOptions(options);
        ClientSession cs = this.getClientSession(options);
        DeleteResult deleteResult = cs == null ? (deleteOptions == null ? this.getCollection(options, cs).deleteOne(filter) : this.getCollection(options, cs).deleteOne(filter, deleteOptions)) : (deleteOptions == null ? this.collection.deleteOne(cs, filter) : this.collection.deleteOne(cs, filter, deleteOptions));
        Struct struct = new Struct();
        struct.put((Object)"acknowledged", (Object)deleteResult.wasAcknowledged());
        if (deleteResult.wasAcknowledged()) {
            struct.put((Object)"deletedCount", (Object)deleteResult.getDeletedCount());
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteOne", (String)"delete", null, (TagAttributeList)this.tagAttributeList);
        return struct;
    }

    public Map deleteMany(Object Filter) {
        return this.deleteMany(Filter, null);
    }

    public Map deleteMany(Object Filter, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteMany", (boolean)true);
        Bson filter = BsonUtils.to(Filter);
        DeleteOptions deleteOptions = MongoUtils.getDeleteOptions(options);
        ClientSession cs = this.getClientSession(options);
        DeleteResult deleteResult = cs == null ? (deleteOptions == null ? this.getCollection(options, cs).deleteMany(filter) : this.getCollection(options, cs).deleteMany(filter, deleteOptions)) : (deleteOptions == null ? this.collection.deleteMany(cs, filter) : this.collection.deleteMany(cs, filter, deleteOptions));
        Struct struct = new Struct();
        struct.put((Object)"acknowledged", (Object)deleteResult.wasAcknowledged());
        if (deleteResult.wasAcknowledged()) {
            struct.put((Object)"deletedCount", (Object)deleteResult.getDeletedCount());
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteMany", (String)"delete", null, (TagAttributeList)this.tagAttributeList);
        return struct;
    }

    public Map updateOne(Object filter, Object update) {
        RequestMonitorEventProcessor.onFunctionStart((String)"updateOne", (boolean)true);
        Map res = this._update(filter, update, null, 2);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"updateOne", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map updateOne(Object filter, Object update, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"updateOne", (boolean)true);
        Map res = this._update(filter, update, options, 2);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"updateOne", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map updateMany(Object filter, Object update) {
        RequestMonitorEventProcessor.onFunctionStart((String)"updateMany", (boolean)true);
        Map res = this._update(filter, update, null, 1);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"updateMany", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map updateMany(Object filter, Object update, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"updateMany", (boolean)true);
        Map res = this._update(filter, update, options, 1);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"updateMany", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map update(Object query, Object update) {
        RequestMonitorEventProcessor.onFunctionStart((String)"update", (boolean)true);
        Map res = this._update(query, update, null, 3);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"update", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map update(Object query, Object update, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"update", (boolean)true);
        Map res = this._update(query, update, options, 3);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"update", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map replaceOne(Object filter, Object replacement) {
        RequestMonitorEventProcessor.onFunctionStart((String)"replaceOne", (boolean)true);
        Map res = this._update(filter, replacement, null, 4);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"replaceOne", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map replaceOne(Object filter, Object replacement, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"replaceOne", (boolean)true);
        Map res = this._update(filter, replacement, options, 4);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"replaceOne", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private Map _update(Object filter, Object toUpdate, Map<?, ?> options, int multiState) {
        UpdateResult updateResult;
        Object bsonToUpdate;
        Bson bsonFilter = BsonUtils.to(filter);
        CFMongoUpdateOptions updateOptions = MongoUtils.getUpdateOptions(options);
        ClientSession cs = this.getClientSession(options);
        if (multiState == 4) {
            bsonToUpdate = BsonUtils.to(toUpdate);
            updateResult = this._replaceOne(bsonFilter, (Bson)bsonToUpdate, options, MongoUtils.getReplaceOptions(options), cs);
        } else {
            updateResult = multiState == 1 || updateOptions != null && updateOptions.isMulti() ? ((bsonToUpdate = BsonUtils.toBsonListorBson(toUpdate)) instanceof List ? this._updateMany(bsonFilter, (List)bsonToUpdate, options, updateOptions, cs) : this._updateMany(bsonFilter, (Bson)bsonToUpdate, options, updateOptions, cs)) : ((bsonToUpdate = BsonUtils.toBsonListorBson(toUpdate)) instanceof List ? this._updateOne(bsonFilter, (List)bsonToUpdate, options, updateOptions, cs) : this._updateOne(bsonFilter, (Bson)bsonToUpdate, options, updateOptions, cs));
        }
        Struct struct = new Struct();
        struct.put((Object)"acknowledged", (Object)updateResult.wasAcknowledged());
        if (updateResult.wasAcknowledged()) {
            struct.put((Object)"matchedCount", (Object)updateResult.getMatchedCount());
            struct.put((Object)"modifiedCount", (Object)updateResult.getModifiedCount());
            BsonValue upsertedId = updateResult.getUpsertedId();
            if (upsertedId != null) {
                struct.put((Object)"upsertedId", BsonUtils.getValue(upsertedId));
            }
        }
        return struct;
    }

    private UpdateResult _updateMany(Bson bsonFilter, Bson bsonToUpdate, Map<?, ?> options, CFMongoUpdateOptions updateOptions, ClientSession cs) {
        if (cs == null) {
            if (updateOptions == null) {
                return this.getCollection(options, cs).updateMany(bsonFilter, bsonToUpdate);
            }
            return this.getCollection(options, cs).updateMany(bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
        }
        if (updateOptions == null) {
            return this.collection.updateMany(cs, bsonFilter, bsonToUpdate);
        }
        return this.collection.updateMany(cs, bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
    }

    private UpdateResult _updateMany(Bson bsonFilter, List<? extends Bson> bsonToUpdate, Map<?, ?> options, CFMongoUpdateOptions updateOptions, ClientSession cs) {
        if (cs == null) {
            if (updateOptions == null) {
                return this.getCollection(options, cs).updateMany(bsonFilter, bsonToUpdate);
            }
            return this.getCollection(options, cs).updateMany(bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
        }
        if (updateOptions == null) {
            return this.collection.updateMany(cs, bsonFilter, bsonToUpdate);
        }
        return this.collection.updateMany(cs, bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
    }

    private UpdateResult _updateOne(Bson bsonFilter, Bson bsonToUpdate, Map<?, ?> options, CFMongoUpdateOptions updateOptions, ClientSession cs) {
        if (cs == null) {
            if (updateOptions == null) {
                return this.getCollection(options, cs).updateOne(bsonFilter, bsonToUpdate);
            }
            return this.getCollection(options, cs).updateOne(bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
        }
        if (updateOptions == null) {
            return this.collection.updateOne(cs, bsonFilter, bsonToUpdate);
        }
        return this.collection.updateOne(cs, bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
    }

    private UpdateResult _updateOne(Bson bsonFilter, List<? extends Bson> bsonToUpdate, Map<?, ?> options, CFMongoUpdateOptions updateOptions, ClientSession cs) {
        if (cs == null) {
            if (updateOptions == null) {
                return this.getCollection(options, cs).updateOne(bsonFilter, bsonToUpdate);
            }
            return this.getCollection(options, cs).updateOne(bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
        }
        if (updateOptions == null) {
            return this.collection.updateOne(cs, bsonFilter, bsonToUpdate);
        }
        return this.collection.updateOne(cs, bsonFilter, bsonToUpdate, (UpdateOptions)updateOptions);
    }

    private UpdateResult _replaceOne(Bson bsonFilter, Bson bsonToUpdate, Map<?, ?> options, ReplaceOptions replaceOptions, ClientSession cs) {
        if (cs == null) {
            if (replaceOptions == null) {
                return this.getCollection(options, cs).replaceOne(bsonFilter, (Object)bsonToUpdate);
            }
            return this.getCollection(options, cs).replaceOne(bsonFilter, (Object)bsonToUpdate, replaceOptions);
        }
        if (replaceOptions == null) {
            return this.collection.replaceOne(cs, bsonFilter, (Object)bsonToUpdate);
        }
        return this.collection.replaceOne(cs, bsonFilter, (Object)bsonToUpdate, replaceOptions);
    }

    public Map bulkWrite(List<?> operations) {
        return this.bulkWrite(operations, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map bulkWrite(List<?> operations, Map<?, ?> writeOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"bulkWrite", (boolean)true);
        LinkedList requests = new LinkedList();
        operations.forEach(entryObj -> {
            if (entryObj instanceof Map) {
                Map entry = (Map)entryObj;
                if (entry.size() > 1) {
                    throw new MongoException("BulkWriteError", "The requests structure contains an invalid operation");
                }
                Object key = entry.keySet().iterator().next();
                Function<Map, WriteModel<Object>> function = writeModelMap.get(((String)key).toLowerCase());
                if (function == null) {
                    throw new MongoException("BulkWriteError", "The requests structure contains an invalid operation : " + key);
                }
                requests.add(function.apply((Map)entry.get(key)));
            }
        });
        CFBulkWriteResult cfwriteResult = null;
        try {
            cfwriteResult = this._bulkWrite(requests, writeOptions);
            Map map = this.getBulkResult(cfwriteResult);
            return map;
        }
        catch (MongoBulkWriteException e) {
            Map result = this.getBulkResult(e.getWriteResult());
            result.put("address", MongoUtils.toMap(e.getServerAddress()));
            result.put("writeErrors", MongoUtils.toMap(e.getWriteErrors()));
            result.put("WriteConcernErrors", e.getWriteConcernError() != null ? Collections.singletonList(MongoUtils.toMap(e.getWriteConcernError())) : Collections.emptyList());
            Map map = result;
            return map;
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"bulkWrite", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        }
    }

    protected Map getBulkResult(CFBulkWriteResult writeResult) {
        Map result = this.getBulkResult(writeResult.getResult());
        result.put("insertedIds", writeResult.getInsertedIds());
        return result;
    }

    protected Map getBulkResult(BulkWriteResult writeResult) {
        Struct result = new Struct();
        result.put((Object)"acknowledged", (Object)writeResult.wasAcknowledged());
        if (writeResult.wasAcknowledged()) {
            List upserts;
            result.put((Object)"insertedCount", (Object)writeResult.getInsertedCount());
            result.put((Object)"deletedCount", (Object)writeResult.getDeletedCount());
            result.put((Object)"matchedCount", (Object)writeResult.getMatchedCount());
            if (writeResult.isModifiedCountAvailable()) {
                result.put((Object)"modifiedCount", (Object)writeResult.getModifiedCount());
            }
            if ((upserts = writeResult.getUpserts()) != null) {
                result.put((Object)"upsertedCount", (Object)upserts.size());
                StructOrdered upsertedIds = new StructOrdered();
                upserts.forEach(arg_0 -> CFMongoCollection.lambda$getBulkResult$4((Map)upsertedIds, arg_0));
                result.put((Object)"upsertedIds", (Object)upsertedIds);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CFBulkWriteResult _bulkWrite(List<? extends WriteModel<Object>> requests, Map<?, ?> writeOptions) throws MongoBulkWriteException {
        BulkWriteOptions bulkWriteOptions = MongoUtils.getBulkWriteOptions(writeOptions);
        CFMongoContext cfMongoContext = new CFMongoContext();
        CFMongoContext oldcfMongoContext = CFMongoContext.setCurrent(cfMongoContext);
        try {
            requests.stream().filter(x -> x instanceof InsertOneModel).forEach(x -> {
                Map document;
                if (Optional.of(x).isPresent() && (document = (Map)((InsertOneModel)Optional.of(x).get()).getDocument()).containsKey("_id")) {
                    cfMongoContext.addInsertedId(document.get("_id"));
                }
            });
            ClientSession cs = this.getClientSession(writeOptions);
            BulkWriteResult bulkWriteResult = cs == null ? (bulkWriteOptions == null ? this.getCollection(writeOptions, cs).bulkWrite(requests) : this.getCollection(writeOptions, cs).bulkWrite(requests, bulkWriteOptions)) : (bulkWriteOptions == null ? this.collection.bulkWrite(cs, requests) : this.collection.bulkWrite(cs, requests, bulkWriteOptions));
            CFBulkWriteResult cFBulkWriteResult = new CFBulkWriteResult(bulkWriteResult, cfMongoContext.getInsertedIds());
            return cFBulkWriteResult;
        }
        finally {
            CFMongoContext.setCurrent(oldcfMongoContext);
        }
    }

    public CFMongoCollection renameCollection(String target) {
        RequestMonitorEventProcessor.onFunctionStart((String)"renameCollection", (boolean)true);
        CFMongoCollection res = this._renameCollection(target, false, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"renameCollection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection renameCollection(String target, boolean dropTarget) {
        RequestMonitorEventProcessor.onFunctionStart((String)"renameCollection", (boolean)true);
        CFMongoCollection res = this._renameCollection(target, dropTarget, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"renameCollection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection renameCollection(String target, boolean dropTarget, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"renameCollection", (boolean)true);
        CFMongoCollection res = this._renameCollection(target, dropTarget, options);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"renameCollection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private CFMongoCollection _renameCollection(String target, boolean dropTarget, Map<?, ?> options) {
        MongoNamespace nameSpace = target.contains(".") ? new MongoNamespace(target) : new MongoNamespace(this.collection.getNamespace().getDatabaseName(), target);
        RenameCollectionOptions renameCollectionOptions = new RenameCollectionOptions();
        renameCollectionOptions.dropTarget(dropTarget);
        ClientSession cs = this.getClientSession(options);
        if (cs == null) {
            if (renameCollectionOptions == null) {
                this.collection.renameCollection(nameSpace);
            } else {
                this.collection.renameCollection(nameSpace, renameCollectionOptions);
            }
        } else if (renameCollectionOptions == null) {
            this.collection.renameCollection(cs, nameSpace);
        } else {
            this.collection.renameCollection(cs, nameSpace, renameCollectionOptions);
        }
        return this;
    }

    public Map findOneAndDelete(Object filter) {
        return this.findOneAndDelete(filter, null);
    }

    public Map findOneAndDelete(Object filter, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"findOneAndDelete", (boolean)true);
        Bson bsonFilter = BsonUtils.to(filter);
        FindOneAndDeleteOptions findOneAndDeleteOptions = MongoUtils.getFindOneAndDeleteOptions(options);
        ClientSession cs = this.getClientSession(options);
        Map res = cs == null ? (findOneAndDeleteOptions == null ? (Map)this.getCollection(options, cs).findOneAndDelete(bsonFilter) : (Map)this.getCollection(options, cs).findOneAndDelete(bsonFilter, findOneAndDeleteOptions)) : (findOneAndDeleteOptions == null ? (Map)this.collection.findOneAndDelete(cs, bsonFilter) : (Map)this.collection.findOneAndDelete(cs, bsonFilter, findOneAndDeleteOptions));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"findOneAndDelete", (String)"delete", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map findOneAndReplace(Object filter, Object replacement) {
        return this.findOneAndReplace(filter, replacement, null);
    }

    public Map findOneAndReplace(Object filter, Object replacement, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"findOneAndReplace", (boolean)true);
        Bson bsonFilter = BsonUtils.to(filter);
        FindOneAndReplaceOptions findOneAndReplaceOptions = MongoUtils.getFindOneAndReplaceOptions(options);
        ClientSession cs = this.getClientSession(options);
        Map res = cs == null ? (findOneAndReplaceOptions == null ? (Map)this.getCollection(options, cs).findOneAndReplace(bsonFilter, replacement) : (Map)this.getCollection(options, cs).findOneAndReplace(bsonFilter, replacement, findOneAndReplaceOptions)) : (findOneAndReplaceOptions == null ? (Map)this.collection.findOneAndReplace(cs, bsonFilter, replacement) : (Map)this.collection.findOneAndReplace(cs, bsonFilter, replacement, findOneAndReplaceOptions));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"findOneAndReplace", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map findOneAndUpdate(Object filter, Object update) {
        return this.findOneAndUpdate(filter, update, null);
    }

    public Map findOneAndUpdate(Object filter, Object update, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"findOneAndUpdate", (boolean)true);
        Bson bsonFilter = BsonUtils.to(filter);
        Bson bsonUpdate = BsonUtils.to(update);
        FindOneAndUpdateOptions findOneAndReplaceOptions = MongoUtils.getFindOneAndUpdateOptions(options);
        ClientSession cs = this.getClientSession(options);
        Map res = cs == null ? (findOneAndReplaceOptions == null ? (Map)this.getCollection(options, cs).findOneAndUpdate(bsonFilter, bsonUpdate) : (Map)this.getCollection(options, cs).findOneAndUpdate(bsonFilter, bsonUpdate, findOneAndReplaceOptions)) : (findOneAndReplaceOptions == null ? (Map)this.collection.findOneAndUpdate(cs, bsonFilter, bsonUpdate) : (Map)this.collection.findOneAndUpdate(cs, bsonFilter, bsonUpdate, findOneAndReplaceOptions));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"findOneAndUpdate", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection drop() {
        RequestMonitorEventProcessor.onFunctionStart((String)"drop", (boolean)true);
        if (this.csDelegate != null) {
            this.collection.drop(this.csDelegate.getClientSession());
        } else {
            this.collection.drop();
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"drop", (String)"delete", null, (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoCollection drop(Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"drop", (boolean)true);
        ClientSession cs = this.getClientSession(options);
        if (cs == null) {
            this.getCollection(options, cs).drop();
        } else {
            this.collection.drop(cs);
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"drop", (String)"delete", null, (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public String createIndex(Object keys) {
        return this.createIndex(keys, null);
    }

    public String createIndex(Object keys, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createIndex", (boolean)true);
        Bson bsonKeys = BsonUtils.to(keys);
        IndexOptions indexOptions = MongoUtils.getIndexOptions(options);
        ClientSession cs = this.getClientSession(options);
        String res = cs == null ? (indexOptions == null ? this.getCollection(options, cs).createIndex(bsonKeys) : this.getCollection(options, cs).createIndex(bsonKeys, indexOptions)) : (indexOptions == null ? this.collection.createIndex(cs, bsonKeys) : this.collection.createIndex(cs, bsonKeys, indexOptions));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createIndex", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public List<String> createIndexes(List keyPatterns) {
        return this.createIndexes(keyPatterns, null);
    }

    public List<String> createIndexes(List keyPatterns, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createIndexes", (boolean)true);
        ArrayList indexModels = new ArrayList();
        IndexOptions indexOptions = MongoUtils.getIndexOptions(options);
        keyPatterns.forEach(entryObj -> {
            if (!(entryObj instanceof Map)) {
                throw new MongoException("CreateIndexesError", "The keyPatterns list contains an invalid entry which is not a structure");
            }
            BsonDocument keyPattern = BsonUtils.to((Map)entryObj);
            indexModels.add(new IndexModel((Bson)keyPattern, indexOptions != null ? indexOptions : new IndexOptions()));
        });
        CreateIndexOptions createIndexOptions = MongoUtils.getCreateIndexOptions(options);
        ClientSession cs = this.getClientSession(options);
        if (cs == null) {
            List res = this.getCollection(options, cs).createIndexes(indexModels, createIndexOptions != null ? createIndexOptions : new CreateIndexOptions());
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createIndexes", (TagAttributeList)this.tagAttributeList);
            return res;
        }
        List res = this.collection.createIndexes(cs, indexModels, createIndexOptions != null ? createIndexOptions : new CreateIndexOptions());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createIndexes", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public List getIndexes() {
        return this.getIndexes(null);
    }

    public List getIndexes(Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getIndexes", (boolean)true);
        ClientSession cs = this.getClientSession(options);
        ListIndexesIterable itr = cs == null ? this.getCollection(options, cs).listIndexes(Map.class) : this.getCollection(options, cs).listIndexes(cs, Map.class);
        itr = MongoUtils.getListIndexesIterable(options, itr);
        Array a = new Array(1);
        itr.iterator().forEachRemaining(arg_0 -> ((Array)a).add(arg_0));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getIndexes", (TagAttributeList)this.tagAttributeList);
        return a;
    }

    public CFMongoCollection dropIndex(Object index) {
        return this.dropIndex(index, null);
    }

    public CFMongoCollection dropIndex(Object index, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropIndex", (boolean)true);
        if (index instanceof String) {
            CFMongoCollection res = this._dropIndex((String)index, options);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"dropIndex", (TagAttributeList)this.tagAttributeList);
            return res;
        }
        CFMongoCollection res = this._dropIndex(index, options);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropIndex", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private CFMongoCollection _dropIndex(Object keys, Map<?, ?> options) {
        Bson bsonKeys = BsonUtils.to(keys);
        DropIndexOptions dropIndexOptions = MongoUtils.getDropIndexOptions(options);
        ClientSession cs = this.getClientSession(options);
        if (cs == null) {
            if (dropIndexOptions == null) {
                this.getCollection(options, cs).dropIndex(bsonKeys);
            } else {
                this.getCollection(options, cs).dropIndex(bsonKeys, dropIndexOptions);
            }
        } else if (dropIndexOptions == null) {
            this.collection.dropIndex(cs, bsonKeys);
        } else {
            this.collection.dropIndex(cs, bsonKeys, dropIndexOptions);
        }
        return this;
    }

    public CFMongoCollection dropIndexes() {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropIndexes", (boolean)true);
        CFMongoCollection res = this._dropIndexes(null, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropIndexes", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection dropIndexes(Object indexes) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropIndexes", (boolean)true);
        CFMongoCollection res = this._dropIndexes(indexes, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropIndexes", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoCollection dropIndexes(Object indexes, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropIndexes", (boolean)true);
        CFMongoCollection res = this._dropIndexes(indexes, options);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropIndexes", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    private CFMongoCollection _dropIndexes(Object indexes, Map<?, ?> options) {
        DropIndexOptions dropIndexOptions = MongoUtils.getDropIndexOptions(options);
        if (indexes == null) {
            ClientSession cs = this.getClientSession(options);
            if (cs == null) {
                if (dropIndexOptions == null) {
                    this.getCollection(options, cs).dropIndexes();
                } else {
                    this.getCollection(options, cs).dropIndexes(dropIndexOptions);
                }
            } else if (dropIndexOptions == null) {
                this.collection.dropIndexes(cs);
            } else {
                this.collection.dropIndexes(cs, dropIndexOptions);
            }
        } else if (indexes instanceof String) {
            CFMongoCollection res = this._dropIndex((String)indexes, options);
        } else if (indexes instanceof List) {
            for (Object index : (List)indexes) {
                CFMongoCollection res = this._dropIndex((String)index, options);
            }
        } else if (indexes instanceof Map) {
            CFMongoCollection cFMongoCollection = this._dropIndex(indexes, options);
        }
        return this;
    }

    public Map reIndex() {
        return this.reIndex(null);
    }

    public Map reIndex(Map writeConcern) {
        RequestMonitorEventProcessor.onFunctionStart((String)"reIndex", (boolean)true);
        BsonDocument commandDocument = new BsonDocument();
        commandDocument.put("reIndex", (BsonValue)new BsonString(this.getName()));
        if (writeConcern != null) {
            commandDocument.put("writeConcern", (BsonValue)BsonUtils.to(writeConcern));
        }
        Map res = this.db.__runCommand(commandDocument, null, CFMongoDatabase.DOCUMENT_CLASS);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"reIndex", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private CFMongoCollection _dropIndex(String indexName, Map<?, ?> options) {
        DropIndexOptions dropIndexOptions = MongoUtils.getDropIndexOptions(options);
        ClientSession cs = this.getClientSession(options);
        if (cs == null) {
            if (dropIndexOptions == null) {
                this.getCollection(options, cs).dropIndex(indexName);
            } else {
                this.getCollection(options, cs).dropIndex(indexName, dropIndexOptions);
            }
        } else if (dropIndexOptions == null) {
            this.collection.dropIndex(cs, indexName);
        } else {
            this.collection.dropIndex(cs, indexName, dropIndexOptions);
        }
        return this;
    }

    public CFMongoCollection withWriteConcern(Map<?, ?> wConcernMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withWriteConcern", (boolean)true);
        WriteConcern wConcern = MongoUtils.getWriteConcern(wConcernMap);
        this.collection = this.collection.withWriteConcern(wConcern);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withWriteConcern", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoCollection withReadPreference(Map<?, ?> prefMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withReadPreference", (boolean)true);
        ReadPreference readPreference = MongoUtils.getReadPreference(prefMap);
        this.collection = this.collection.withReadPreference(readPreference);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withReadPreference", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoCollection withReadConcern(String readConcern) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withReadConcern", (boolean)true);
        this.collection = this.collection.withReadConcern(new ReadConcern(ReadConcernLevel.fromString((String)readConcern)));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withReadConcern", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoCollection withSession(CFMongoClientSession session) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withSession", (boolean)true);
        this.csDelegate = session;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withSession", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoCollection clearSession() {
        RequestMonitorEventProcessor.onFunctionStart((String)"clearSession", (boolean)true);
        this.csDelegate = null;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"clearSession", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoClientSession getSession() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getSession", (boolean)true);
        CFMongoClientSession res = this.csDelegate;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getSession", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private MongoCollection getCollection(Map<?, ?> configMap, ClientSession cs) {
        return this.getCollection(configMap, cs, false);
    }

    private MongoCollection getCollection(Map<?, ?> configMap, ClientSession cs, boolean seeReadConcernAlso) {
        WriteConcern wConcern;
        if (cs == null && configMap != null && (wConcern = MongoUtils.getWriteConcern(configMap)) != null) {
            MongoCollection withWriteConcern = this.collection.withWriteConcern(wConcern);
            if (seeReadConcernAlso) {
                return this.getCollection(configMap, withWriteConcern);
            }
            return withWriteConcern;
        }
        if (seeReadConcernAlso) {
            return this.getCollection(configMap, this.collection);
        }
        return this.collection;
    }

    private MongoCollection getCollection(Map<?, ?> configMap, MongoCollection collection) {
        ReadConcern readConcern = MongoUtils.getReadConcern(configMap);
        if (readConcern != null) {
            return collection.withReadConcern(readConcern);
        }
        return collection;
    }

    private ClientSession getClientSession(Map<?, ?> configMap) {
        CFMongoClientSession clientSession = MongoUtils.getSession(configMap);
        clientSession = clientSession == null ? (this.csDelegate != null ? this.csDelegate : null) : clientSession;
        return clientSession != null ? clientSession.getClientSession() : null;
    }

    public String getName() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getName", (boolean)true);
        String res = this.collection.getNamespace().getCollectionName();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getName", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object getMetadata() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getMetadata", (boolean)true);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", this.collection.getNamespace().getCollectionName());
        metadata.put("database", this.collection.getNamespace().getDatabaseName());
        ReadConcern readConcern = this.collection.getReadConcern();
        String readConcernLevel = "DEFAULT";
        if (readConcern != null && readConcern.getLevel() != null) {
            readConcernLevel = readConcern.getLevel().toString();
        }
        metadata.put("readConcern", readConcernLevel);
        metadata.put("writeConcern", MongoUtils.toMap(this.collection.getWriteConcern()));
        metadata.put("readPreference", MongoUtils.toMap(this.collection.getReadPreference()));
        if (this.csDelegate != null) {
            metadata.put("session", this.csDelegate.getMetadata());
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getMetadata", (TagAttributeList)this.tagAttributeList);
        return metadata;
    }

    public Map stats() {
        RequestMonitorEventProcessor.onFunctionStart((String)"stats", (boolean)true);
        BsonDocument collStatsDoc = new BsonDocument("collStats", (BsonValue)new BsonString(this.getName()));
        Map res = this.db.__runCommand((Bson)collStatsDoc, this.collection.getReadPreference(), this.csDelegate);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"stats", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map stats(Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"stats", (boolean)true);
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("collStats", (BsonValue)new BsonString(this.getName()));
        if (options != null) {
            BsonUtils.to(options, bsonDocument);
        }
        Map res = this.db.__runCommand((Bson)bsonDocument, this.collection.getReadPreference(), this.csDelegate);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"stats", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Array latencyStats() {
        return this.latencyStats(null);
    }

    public Array latencyStats(Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"latencyStats", (boolean)true);
        if (options == null) {
            options = Collections.emptyMap();
        }
        HashMap latencyStatsMap = new HashMap();
        latencyStatsMap.put("latencyStats", options);
        HashMap pipeline = new HashMap();
        pipeline.put("$collStats", latencyStatsMap);
        Array res = this.aggregate(Collections.singletonList(pipeline));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"latencyStats", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public boolean isCapped() {
        RequestMonitorEventProcessor.onFunctionStart((String)"isCapped", (boolean)true);
        Object cappedField = this.getStatsField("capped");
        boolean res = cappedField != null && (cappedField.equals(1) || cappedField.equals(true));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"isCapped", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object storageSize() {
        RequestMonitorEventProcessor.onFunctionStart((String)"storageSize", (boolean)true);
        Object res = this.getStatsField("storageSize");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"storageSize", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object totalIndexSize() {
        RequestMonitorEventProcessor.onFunctionStart((String)"totalIndexSize", (boolean)true);
        Object res = this.getStatsField("totalIndexSize");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"totalIndexSize", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public long totalSize() {
        RequestMonitorEventProcessor.onFunctionStart((String)"totalSize", (boolean)true);
        BsonDocument collStatsDoc = new BsonDocument("collStats", (BsonValue)new BsonString(this.getName()));
        Map stats = this.db.__runCommand((Bson)collStatsDoc, this.collection.getReadPreference(), this.csDelegate);
        long res = Cast._long(stats.get("storageSize")) + Cast._long(stats.get("totalIndexSize"));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"totalSize", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object dataSize() {
        RequestMonitorEventProcessor.onFunctionStart((String)"dataSize", (boolean)true);
        Object res = this.getStatsField("size");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dataSize", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object avgObjSize() {
        RequestMonitorEventProcessor.onFunctionStart((String)"avgObjSize", (boolean)true);
        Object res = this.getStatsField("avgObjSize");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"avgObjSize", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object max() {
        RequestMonitorEventProcessor.onFunctionStart((String)"max", (boolean)true);
        Object res = this.getStatsField("max");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"max", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object indexSizes() {
        RequestMonitorEventProcessor.onFunctionStart((String)"indexSizes", (boolean)true);
        Object res = this.getStatsField("indexSizes");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"indexSizes", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private Object getStatsField(String name) {
        BsonDocument collStatsDoc = new BsonDocument("collStats", (BsonValue)new BsonString(this.getName()));
        Map stats = this.db.__runCommand((Bson)collStatsDoc, this.collection.getReadPreference(), this.csDelegate);
        return stats.get(name);
    }

    public Map getWriteConcern() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getWriteConcern", (boolean)true);
        Map res = MongoUtils.toMap(this.collection.getWriteConcern());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getWriteConcern", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public String getReadConcern() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getReadConcern", (boolean)true);
        String res = this.collection.getReadConcern().toString();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getReadConcern", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getReadPreference() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getReadPreference", (boolean)true);
        Map res = MongoUtils.toMap(this.collection.getReadPreference());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getReadPreference", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public String getLabel() {
        return "MongoDB Collection";
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    private static /* synthetic */ void lambda$getBulkResult$4(Map upsertedIds, BulkWriteUpsert upsert) {
        upsertedIds.put(upsert.getIndex(), BsonUtils.getValue(upsert.getId()));
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"getDb", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDb();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDb", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"count", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.count();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query"}, args);
                    return obj.count(argColl.get((Object)"query"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "countOptionsMap"}, args);
                    return obj.count(argColl.get((Object)"query"), Cast._Map((Object)argColl.get((Object)"countOptionsMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("count", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"countDocuments", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.countDocuments();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query"}, args);
                    return obj.countDocuments(argColl.get((Object)"query"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "countOptionsMap"}, args);
                    return obj.countDocuments(argColl.get((Object)"query"), Cast._Map((Object)argColl.get((Object)"countOptionsMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("countDocuments", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"__count", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"countOptions", "queryFilter"}, args);
                    return obj.__count((CountOptions)Cast._castForInvokeGen((Object)argColl.get((Object)"countOptions"), CountOptions.class), (Bson)Cast._castForInvokeGen((Object)argColl.get((Object)"queryFilter"), Bson.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("__count", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"estimatedDocumentCount", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.estimatedDocumentCount();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"optionsMap"}, args);
                    return obj.estimatedDocumentCount(Cast._Map((Object)argColl.get((Object)"optionsMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("estimatedDocumentCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"distinct", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"field"}, args);
                    return obj.distinct(Cast._String((Object)argColl.get((Object)"field")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"field", "query"}, args);
                    return obj.distinct(Cast._String((Object)argColl.get((Object)"field")), argColl.get((Object)"query"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"field", "query", "options"}, args);
                    return obj.distinct(Cast._String((Object)argColl.get((Object)"field")), argColl.get((Object)"query"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("distinct", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"find", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.find();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query"}, args);
                    return obj.find(Cast._Map((Object)argColl.get((Object)"query")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "projection"}, args);
                    return obj.find(Cast._Map((Object)argColl.get((Object)"query")), Cast._Map((Object)argColl.get((Object)"projection")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("find", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"findOne", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.findOne();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query"}, args);
                    return obj.findOne(Cast._Map((Object)argColl.get((Object)"query")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "projection"}, args);
                    return obj.findOne(Cast._Map((Object)argColl.get((Object)"query")), Cast._Map((Object)argColl.get((Object)"projection")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("findOne", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"aggregate", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"pipeline"}, args);
                    return obj.aggregate(Cast._List((Object)argColl.get((Object)"pipeline")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"pipeline", "options"}, args);
                    return obj.aggregate(Cast._List((Object)argColl.get((Object)"pipeline")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("aggregate", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"watch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.watch();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"pipeline"}, args);
                    return obj.watch(Cast._List((Object)argColl.get((Object)"pipeline")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"pipeline", "options"}, args);
                    return obj.watch(Cast._List((Object)argColl.get((Object)"pipeline")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("watch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"mapReduce", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"mapFunc", "reduceFunc"}, args);
                    return obj.mapReduce(Cast._String((Object)argColl.get((Object)"mapFunc")), Cast._String((Object)argColl.get((Object)"reduceFunc")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"mapFunc", "reduceFunc", "options"}, args);
                    return obj.mapReduce(Cast._String((Object)argColl.get((Object)"mapFunc")), Cast._String((Object)argColl.get((Object)"reduceFunc")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("mapReduce", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"insertOne", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"document"}, args);
                    return obj.insertOne(argColl.get((Object)"document"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"document", "insertOptions"}, args);
                    return obj.insertOne(argColl.get((Object)"document"), Cast._Map((Object)argColl.get((Object)"insertOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("insertOne", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"insertMany", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"document"}, args);
                    return obj.insertMany(argColl.get((Object)"document"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"document", "insertOptions"}, args);
                    return obj.insertMany(argColl.get((Object)"document"), Cast._Map((Object)argColl.get((Object)"insertOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("insertMany", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"insert", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"document"}, args);
                    return obj.insert(argColl.get((Object)"document"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"document", "insertOptions"}, args);
                    return obj.insert(argColl.get((Object)"document"), Cast._Map((Object)argColl.get((Object)"insertOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("insert", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteOne", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"Filter"}, args);
                    return obj.deleteOne(argColl.get((Object)"Filter"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"Filter", "options"}, args);
                    return obj.deleteOne(argColl.get((Object)"Filter"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteOne", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteMany", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"Filter"}, args);
                    return obj.deleteMany(argColl.get((Object)"Filter"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"Filter", "options"}, args);
                    return obj.deleteMany(argColl.get((Object)"Filter"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteMany", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"updateOne", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "update"}, args);
                    return obj.updateOne(argColl.get((Object)"filter"), argColl.get((Object)"update"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "update", "options"}, args);
                    return obj.updateOne(argColl.get((Object)"filter"), argColl.get((Object)"update"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("updateOne", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"updateMany", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "update"}, args);
                    return obj.updateMany(argColl.get((Object)"filter"), argColl.get((Object)"update"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "update", "options"}, args);
                    return obj.updateMany(argColl.get((Object)"filter"), argColl.get((Object)"update"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("updateMany", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"update", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "update"}, args);
                    return obj.update(argColl.get((Object)"query"), argColl.get((Object)"update"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "update", "options"}, args);
                    return obj.update(argColl.get((Object)"query"), argColl.get((Object)"update"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("update", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"replaceOne", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "replacement"}, args);
                    return obj.replaceOne(argColl.get((Object)"filter"), argColl.get((Object)"replacement"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "replacement", "options"}, args);
                    return obj.replaceOne(argColl.get((Object)"filter"), argColl.get((Object)"replacement"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("replaceOne", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"bulkWrite", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"operations"}, args);
                    return obj.bulkWrite(Cast._List((Object)argColl.get((Object)"operations")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"operations", "writeOptions"}, args);
                    return obj.bulkWrite(Cast._List((Object)argColl.get((Object)"operations")), Cast._Map((Object)argColl.get((Object)"writeOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("bulkWrite", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"renameCollection", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"target"}, args);
                    return obj.renameCollection(Cast._String((Object)argColl.get((Object)"target")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"target", "dropTarget"}, args);
                    return obj.renameCollection(Cast._String((Object)argColl.get((Object)"target")), Cast._boolean((Object)argColl.get((Object)"dropTarget")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"target", "dropTarget", "options"}, args);
                    return obj.renameCollection(Cast._String((Object)argColl.get((Object)"target")), Cast._boolean((Object)argColl.get((Object)"dropTarget")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("renameCollection", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"findOneAndDelete", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter"}, args);
                    return obj.findOneAndDelete(argColl.get((Object)"filter"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "options"}, args);
                    return obj.findOneAndDelete(argColl.get((Object)"filter"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("findOneAndDelete", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"findOneAndReplace", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "replacement"}, args);
                    return obj.findOneAndReplace(argColl.get((Object)"filter"), argColl.get((Object)"replacement"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "replacement", "options"}, args);
                    return obj.findOneAndReplace(argColl.get((Object)"filter"), argColl.get((Object)"replacement"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("findOneAndReplace", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"findOneAndUpdate", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "update"}, args);
                    return obj.findOneAndUpdate(argColl.get((Object)"filter"), argColl.get((Object)"update"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "update", "options"}, args);
                    return obj.findOneAndUpdate(argColl.get((Object)"filter"), argColl.get((Object)"update"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("findOneAndUpdate", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"drop", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.drop();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.drop(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("drop", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createIndex", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"keys"}, args);
                    return obj.createIndex(argColl.get((Object)"keys"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"keys", "options"}, args);
                    return obj.createIndex(argColl.get((Object)"keys"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createIndex", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createIndexes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"keyPatterns"}, args);
                    return obj.createIndexes(Cast._List((Object)argColl.get((Object)"keyPatterns")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"keyPatterns", "options"}, args);
                    return obj.createIndexes(Cast._List((Object)argColl.get((Object)"keyPatterns")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createIndexes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getIndexes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getIndexes();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.getIndexes(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getIndexes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dropIndex", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"index"}, args);
                    return obj.dropIndex(argColl.get((Object)"index"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"index", "options"}, args);
                    return obj.dropIndex(argColl.get((Object)"index"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dropIndex", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dropIndexes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.dropIndexes();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"indexes"}, args);
                    return obj.dropIndexes(argColl.get((Object)"indexes"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"indexes", "options"}, args);
                    return obj.dropIndexes(argColl.get((Object)"indexes"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dropIndexes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"reIndex", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.reIndex();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"writeConcern"}, args);
                    return obj.reIndex(Cast._Map((Object)argColl.get((Object)"writeConcern")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("reIndex", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withWriteConcern", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"wConcernMap"}, args);
                    return obj.withWriteConcern(Cast._Map((Object)argColl.get((Object)"wConcernMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withWriteConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withReadPreference", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"prefMap"}, args);
                    return obj.withReadPreference(Cast._Map((Object)argColl.get((Object)"prefMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withReadPreference", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withReadConcern", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"readConcern"}, args);
                    return obj.withReadConcern(Cast._String((Object)argColl.get((Object)"readConcern")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withReadConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withSession", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"session"}, args);
                    return obj.withSession((CFMongoClientSession)((Object)((Object)Cast._castForInvokeGen((Object)argColl.get((Object)"session"), CFMongoClientSession.class))));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withSession", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"clearSession", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.clearSession();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("clearSession", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSession", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSession();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSession", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getName", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getName();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getName", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getMetadata", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getMetadata();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getMetadata", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"stats", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.stats();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.stats(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("stats", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"latencyStats", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.latencyStats();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.latencyStats(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("latencyStats", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"isCapped", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.isCapped();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("isCapped", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"storageSize", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.storageSize();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("storageSize", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"totalIndexSize", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.totalIndexSize();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("totalIndexSize", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"totalSize", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.totalSize();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("totalSize", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dataSize", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.dataSize();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dataSize", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"avgObjSize", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.avgObjSize();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("avgObjSize", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"max", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.max();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("max", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"indexSizes", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.indexSizes();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("indexSizes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getWriteConcern", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getWriteConcern();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getWriteConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getReadConcern", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getReadConcern();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getReadConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getReadPreference", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getReadPreference();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getReadPreference", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getLabel", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getLabel();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getLabel", obj);
        });
    }
}

