/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.es;

import coldfusion.monitor.beans.NonRequestData;
import coldfusion.monitor.beans.RequestData;
import coldfusion.monitor.datastore.JSONConverter;
import java.time.LocalDate;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.xcontent.XContentType;

public class RingBufferESRequestEvent {
    private IndexRequest request;
    private RequestData requestData;
    private NonRequestData nonRequestData;

    public NonRequestData getNonRequestData() {
        return this.nonRequestData;
    }

    public void setNonRequestData(NonRequestData nonRequestData) {
        this.nonRequestData = nonRequestData;
    }

    public RequestData getRequestData() {
        return this.requestData;
    }

    public void setRequestData(RequestData requestData) {
        this.requestData = requestData;
    }

    public IndexRequest getRequest() {
        return this.request;
    }

    public void setRequest(IndexRequest request) {
        this.request = request;
    }

    public void converReqestDataToIndexRequest() {
        IndexRequest request;
        RequestData requestData = this.getRequestData();
        String json = JSONConverter.toJson((Object)requestData);
        this.request = request = new IndexRequest(this.getLatestRequestIndex(), "request", requestData.getRequestId()).source(json, XContentType.JSON);
    }

    public void converNonReqestDataToIndexRequest() {
        IndexRequest request;
        NonRequestData nonRequestData = this.getNonRequestData();
        String json = JSONConverter.toJson((Object)nonRequestData);
        this.request = request = new IndexRequest(this.getLatestRequestIndex(), "non-request").source(json, XContentType.JSON);
    }

    private String getLatestRequestIndex() {
        LocalDate date = LocalDate.now();
        String index = "request-data-" + date.toString();
        return index;
    }
}

