/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.es;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.RestClient;

public class IndexTask
implements Callable<Boolean> {
    private String json;
    private RestClient restClient;
    private String index;
    private String type;
    private String id;
    private Logger logger = CFLogs.SERVER_LOG;

    public IndexTask() {
    }

    public IndexTask(String json, RestClient restClient, String index, String type) {
        this.json = json;
        this.restClient = restClient;
        this.type = type;
        this.index = index;
        this.logger.debug((Object)("Indexing Json :--> Index: " + index + " type " + type + "   " + json));
    }

    public IndexTask(String json, RestClient restClient, String index, String type, String id) {
        this.json = json;
        this.restClient = restClient;
        this.type = type;
        this.index = index;
        this.id = id;
    }

    @Override
    public Boolean call() {
        try {
            NStringEntity entity = new NStringEntity(this.json, ContentType.APPLICATION_JSON);
            if (this.id != null) {
                this.restClient.performRequest("POST", this.index + this.type + "/" + this.id, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            } else {
                this.restClient.performRequest("POST", this.index + this.type + "/", Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Fatal transport error: " + e.getMessage()));
            this.logger.debug((Object)("Detailed error: " + e.getStackTrace()));
            return false;
        }
        return true;
    }
}

