/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import coldfusion.util.URLDecoder;
import coldfusion.vfs.s3.S3FileName;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class S3FileNameParser
extends AbstractFileNameParser {
    private static S3FileNameParser instance = new S3FileNameParser();

    public static S3FileNameParser getInstance() {
        return instance;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        S3Info s3Info = this.extractS3Info(filename, name);
        UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
        if (name.indexOf("%") != -1) {
            StringBuilder temp = new StringBuilder();
            temp.append(name.charAt(0)).append(URLDecoder.decode((String)name.substring(1)));
            name = temp;
        }
        UriParser.fixSeparators((StringBuilder)name);
        FileType fileType = UriParser.normalisePath((StringBuilder)name);
        String path = name.toString();
        return new S3FileName(s3Info.scheme, path, fileType, s3Info.bucket, s3Info.accessKeyId, s3Info.secretAccessKey);
    }

    private S3Info extractS3Info(String uri, StringBuilder name) throws FileSystemException {
        S3Info s3Info = new S3Info();
        s3Info.scheme = UriParser.extractScheme((String)uri, (StringBuilder)name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)uri);
        }
        name.delete(0, 2);
        this.extractUserInfo(name, s3Info);
        this.extractBucketName(name, s3Info);
        return s3Info;
    }

    private void extractBucketName(StringBuilder name, S3Info s3Info) {
        int len = name.length();
        String bucketName = null;
        for (int pos = 0; pos < len; ++pos) {
            if (name.charAt(pos) != '/') continue;
            bucketName = name.substring(0, pos);
            name.delete(0, pos);
            break;
        }
        if (bucketName == null) {
            bucketName = name.toString();
            name.delete(0, name.length());
        }
        s3Info.bucket = bucketName;
    }

    private void extractUserInfo(StringBuilder name, S3Info s3Info) {
        int atIndex;
        String userInfo = null;
        int colonIndex = name.indexOf(":");
        if (colonIndex > 0 && (atIndex = name.indexOf("@", colonIndex)) > -1) {
            userInfo = name.substring(0, atIndex);
            name.delete(0, atIndex + 1);
        }
        this.parseUserInfo(userInfo, s3Info);
    }

    private void parseUserInfo(String userInfo, S3Info s3Info) {
        if (userInfo != null) {
            int idx = userInfo.indexOf(58);
            if (idx == -1) {
                s3Info.accessKeyId = userInfo;
                s3Info.secretAccessKey = null;
            } else {
                s3Info.accessKeyId = userInfo.substring(0, idx);
                s3Info.secretAccessKey = userInfo.substring(idx + 1);
            }
        } else {
            s3Info.secretAccessKey = null;
            s3Info.secretAccessKey = null;
        }
    }

    private static class S3Info {
        String accessKeyId;
        String secretAccessKey;
        String bucket;
        String scheme;

        private S3Info() {
        }
    }
}

