/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CloudSolrClient
extends SolrClient {
    protected static final Logger log = LoggerFactory.getLogger(CloudSolrClient.class);
    private volatile ZkStateReader zkStateReader;
    private String zkHost;
    private int zkConnectTimeout = 10000;
    private int zkClientTimeout = 10000;
    private volatile String defaultCollection;
    private final LBHttpSolrClient lbClient;
    private final boolean shutdownLBHttpSolrServer;
    private HttpClient myClient;
    private final boolean clientIsInternal;
    private static final int MAX_STALE_RETRIES = 5;
    Random rand = new Random();
    private final boolean updatesToLeaders;
    private boolean parallelUpdates = true;
    private ExecutorService threadPool = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("CloudSolrClient ThreadPool"));
    private String idField = "id";
    public static final String STATE_VERSION = "_stateVer_";
    private final Set<String> NON_ROUTABLE_PARAMS = new HashSet<String>();
    private volatile long timeToLive;
    private volatile List<Object> locks;
    protected final Map<String, ExpiringCachedDocCollection> collectionStateCache;

    public CloudSolrClient(String zkHost) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.timeToLive = 60000L;
        this.locks = CloudSolrClient.objectList(3);
        this.collectionStateCache = new ConcurrentHashMap<String, ExpiringCachedDocCollection>(){

            @Override
            public ExpiringCachedDocCollection get(Object key) {
                ExpiringCachedDocCollection val = (ExpiringCachedDocCollection)super.get(key);
                if (val == null) {
                    return null;
                }
                if (val.isExpired(CloudSolrClient.this.timeToLive)) {
                    super.remove(key);
                    return null;
                }
                return val;
            }
        };
        this.zkHost = zkHost;
        this.clientIsInternal = true;
        this.myClient = HttpClientUtil.createClient(null);
        this.lbClient = new LBHttpSolrClient(this.myClient, new String[0]);
        this.lbClient.setRequestWriter(new BinaryRequestWriter());
        this.lbClient.setParser(new BinaryResponseParser());
        this.updatesToLeaders = true;
        this.shutdownLBHttpSolrServer = true;
        this.lbClient.addQueryParams(STATE_VERSION);
    }

    public CloudSolrClient(String zkHost, HttpClient httpClient) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.timeToLive = 60000L;
        this.locks = CloudSolrClient.objectList(3);
        this.collectionStateCache = new /* invalid duplicate definition of identical inner class */;
        this.zkHost = zkHost;
        this.clientIsInternal = httpClient == null;
        this.myClient = httpClient == null ? HttpClientUtil.createClient(null) : httpClient;
        this.lbClient = new LBHttpSolrClient(this.myClient, new String[0]);
        this.lbClient.setRequestWriter(new BinaryRequestWriter());
        this.lbClient.setParser(new BinaryResponseParser());
        this.updatesToLeaders = true;
        this.shutdownLBHttpSolrServer = true;
        this.lbClient.addQueryParams(STATE_VERSION);
    }

    public CloudSolrClient(Collection<String> zkHosts, String chroot) {
        this(zkHosts, chroot, null);
    }

    public CloudSolrClient(Collection<String> zkHosts, String chroot, HttpClient httpClient) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.timeToLive = 60000L;
        this.locks = CloudSolrClient.objectList(3);
        this.collectionStateCache = new /* invalid duplicate definition of identical inner class */;
        StringBuilder zkBuilder = new StringBuilder();
        int lastIndexValue = zkHosts.size() - 1;
        int i = 0;
        for (String zkHost : zkHosts) {
            zkBuilder.append(zkHost);
            if (i < lastIndexValue) {
                zkBuilder.append(",");
            }
            ++i;
        }
        if (chroot != null) {
            if (chroot.startsWith("/")) {
                zkBuilder.append(chroot);
            } else {
                throw new IllegalArgumentException("The chroot must start with a forward slash.");
            }
        }
        log.info("Final constructed zkHost string: " + zkBuilder.toString());
        this.zkHost = zkBuilder.toString();
        this.clientIsInternal = httpClient == null;
        this.myClient = httpClient == null ? HttpClientUtil.createClient(null) : httpClient;
        this.lbClient = new LBHttpSolrClient(this.myClient, new String[0]);
        this.lbClient.setRequestWriter(new BinaryRequestWriter());
        this.lbClient.setParser(new BinaryResponseParser());
        this.updatesToLeaders = true;
        this.shutdownLBHttpSolrServer = true;
    }

    public CloudSolrClient(String zkHost, boolean updatesToLeaders) {
        this(zkHost, updatesToLeaders, null);
    }

    public CloudSolrClient(String zkHost, boolean updatesToLeaders, HttpClient httpClient) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.timeToLive = 60000L;
        this.locks = CloudSolrClient.objectList(3);
        this.collectionStateCache = new /* invalid duplicate definition of identical inner class */;
        this.zkHost = zkHost;
        this.clientIsInternal = httpClient == null;
        this.myClient = httpClient == null ? HttpClientUtil.createClient(null) : httpClient;
        this.lbClient = new LBHttpSolrClient(this.myClient, new String[0]);
        this.lbClient.setRequestWriter(new BinaryRequestWriter());
        this.lbClient.setParser(new BinaryResponseParser());
        this.updatesToLeaders = updatesToLeaders;
        this.shutdownLBHttpSolrServer = true;
        this.lbClient.addQueryParams(STATE_VERSION);
    }

    public void setCollectionCacheTTl(int seconds) {
        assert (seconds > 0);
        this.timeToLive = (long)seconds * 1000L;
    }

    public CloudSolrClient(String zkHost, LBHttpSolrClient lbClient) {
        this(zkHost, lbClient, true);
    }

    public CloudSolrClient(String zkHost, LBHttpSolrClient lbClient, boolean updatesToLeaders) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.timeToLive = 60000L;
        this.locks = CloudSolrClient.objectList(3);
        this.collectionStateCache = new /* invalid duplicate definition of identical inner class */;
        this.zkHost = zkHost;
        this.lbClient = lbClient;
        this.updatesToLeaders = updatesToLeaders;
        this.shutdownLBHttpSolrServer = false;
        this.clientIsInternal = false;
        lbClient.addQueryParams(STATE_VERSION);
    }

    public ResponseParser getParser() {
        return this.lbClient.getParser();
    }

    public void setParser(ResponseParser processor) {
        this.lbClient.setParser(processor);
    }

    public RequestWriter getRequestWriter() {
        return this.lbClient.getRequestWriter();
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.lbClient.setRequestWriter(requestWriter);
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getIdField() {
        return this.idField;
    }

    public void setDefaultCollection(String collection) {
        this.defaultCollection = collection;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setZkConnectTimeout(int zkConnectTimeout) {
        this.zkConnectTimeout = zkConnectTimeout;
    }

    public void setZkClientTimeout(int zkClientTimeout) {
        this.zkClientTimeout = zkClientTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.zkStateReader == null) {
            CloudSolrClient cloudSolrClient = this;
            synchronized (cloudSolrClient) {
                if (this.zkStateReader == null) {
                    ZkStateReader zk = null;
                    try {
                        zk = new ZkStateReader(this.zkHost, this.zkClientTimeout, this.zkConnectTimeout);
                        zk.createClusterStateWatchersAndUpdate();
                        this.zkStateReader = zk;
                    }
                    catch (InterruptedException e) {
                        zk.close();
                        Thread.currentThread().interrupt();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (KeeperException e) {
                        zk.close();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (Exception e) {
                        if (zk != null) {
                            zk.close();
                        }
                        throw e;
                    }
                }
            }
        }
    }

    public void connect(long duration, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        log.info("Waiting for {} {} for cluster at {} to be ready", new Object[]{duration, timeUnit, this.zkHost});
        long timeout = System.nanoTime() + timeUnit.toNanos(duration);
        while (System.nanoTime() < timeout) {
            try {
                this.connect();
                log.info("Cluster at {} ready", (Object)this.zkHost);
                return;
            }
            catch (RuntimeException runtimeException) {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
        }
        throw new TimeoutException("Timed out waiting for cluster");
    }

    public void setParallelUpdates(boolean parallelUpdates) {
        this.parallelUpdates = parallelUpdates;
    }

    public void uploadConfig(Path configPath, String configName) throws IOException {
        this.connect();
        this.zkStateReader.getConfigManager().uploadConfigDir(configPath, configName);
    }

    public void downloadConfig(String configName, Path downloadPath) throws IOException {
        this.connect();
        this.zkStateReader.getConfigManager().downloadConfigDir(configName, downloadPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedList<Object> directUpdate(AbstractUpdateRequest request, String collection, ClusterState clusterState) throws SolrServerException {
        DocCollection col;
        DocRouter router;
        Map<String, String> collectionAliases;
        UpdateRequest updateRequest = (UpdateRequest)request;
        ModifiableSolrParams params = request.getParams();
        ModifiableSolrParams routableParams = new ModifiableSolrParams();
        ModifiableSolrParams nonRoutableParams = new ModifiableSolrParams();
        if (params != null) {
            nonRoutableParams.add(params);
            routableParams.add(params);
            for (String param : this.NON_ROUTABLE_PARAMS) {
                routableParams.remove(param);
            }
        }
        if (collection == null) {
            throw new SolrServerException("No collection param specified on request and no default collection has been set.");
        }
        Aliases aliases = this.zkStateReader.getAliases();
        if (aliases != null && (collectionAliases = aliases.getCollectionAliasMap()) != null && collectionAliases.containsKey(collection)) {
            collection = collectionAliases.get(collection);
        }
        if ((router = (col = this.getDocCollection(clusterState, collection, null)).getRouter()) instanceof ImplicitDocRouter) {
            return null;
        }
        Map<String, List<String>> urlMap = this.buildUrlMap(col);
        if (urlMap == null) {
            return null;
        }
        NamedList<Throwable> exceptions = new NamedList<Throwable>();
        NamedList<Object> shardResponses = new NamedList<Object>();
        Map<String, LBHttpSolrClient.Req> routes = updateRequest.getRoutes(router, col, urlMap, routableParams, this.idField);
        if (routes == null) {
            return null;
        }
        long start = System.nanoTime();
        if (this.parallelUpdates) {
            String url;
            HashMap responseFutures = new HashMap(routes.size());
            for (Map.Entry<String, LBHttpSolrClient.Req> entry : routes.entrySet()) {
                url = entry.getKey();
                final LBHttpSolrClient.Req lbRequest = entry.getValue();
                try {
                    MDC.put((String)"CloudSolrClient.url", (String)url);
                    responseFutures.put(url, this.threadPool.submit(new Callable<NamedList<?>>(){

                        @Override
                        public NamedList<?> call() throws Exception {
                            return CloudSolrClient.this.lbClient.request(lbRequest).getResponse();
                        }
                    }));
                }
                finally {
                    MDC.remove((String)"CloudSolrClient.url");
                }
            }
            for (Map.Entry entry : responseFutures.entrySet()) {
                url = (String)entry.getKey();
                Future responseFuture = (Future)entry.getValue();
                try {
                    shardResponses.add(url, responseFuture.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    exceptions.add(url, e.getCause());
                }
            }
            if (exceptions.size() > 0) {
                Throwable throwable = (Throwable)exceptions.getVal(0);
                if (throwable instanceof SolrException) {
                    SolrException solrException = (SolrException)throwable;
                    throw new RouteException(SolrException.ErrorCode.getErrorCode(solrException.code()), exceptions, routes);
                }
                throw new RouteException(SolrException.ErrorCode.SERVER_ERROR, exceptions, routes);
            }
        } else {
            for (Map.Entry entry : routes.entrySet()) {
                String string = (String)entry.getKey();
                LBHttpSolrClient.Req lbRequest = (LBHttpSolrClient.Req)entry.getValue();
                try {
                    NamedList<Object> rsp = this.lbClient.request(lbRequest).getResponse();
                    shardResponses.add(string, rsp);
                }
                catch (Exception e) {
                    if (e instanceof SolrException) {
                        throw (SolrException)e;
                    }
                    throw new SolrServerException(e);
                }
            }
        }
        UpdateRequest nonRoutableRequest = null;
        List<String> list = updateRequest.getDeleteQuery();
        if (list != null && list.size() > 0) {
            UpdateRequest updateRequest2 = new UpdateRequest();
            updateRequest2.setDeleteQuery(list);
            nonRoutableRequest = updateRequest2;
        }
        Set<String> set = nonRoutableParams.getParameterNames();
        HashSet<String> intersection = new HashSet<String>(set);
        intersection.retainAll(this.NON_ROUTABLE_PARAMS);
        if (nonRoutableRequest != null || intersection.size() > 0) {
            if (nonRoutableRequest == null) {
                nonRoutableRequest = new UpdateRequest();
            }
            nonRoutableRequest.setParams(nonRoutableParams);
            ArrayList<String> urlList = new ArrayList<String>();
            urlList.addAll(routes.keySet());
            Collections.shuffle(urlList, this.rand);
            LBHttpSolrClient.Req req = new LBHttpSolrClient.Req(nonRoutableRequest, urlList);
            try {
                LBHttpSolrClient.Rsp rsp = this.lbClient.request(req);
                shardResponses.add((String)urlList.get(0), rsp.getResponse());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (String)urlList.get(0), (Throwable)e);
            }
        }
        long end = System.nanoTime();
        RouteResponse rr = this.condenseResponse(shardResponses, (end - start) / 1000000L);
        rr.setRouteResponses(shardResponses);
        rr.setRoutes(routes);
        return rr;
    }

    private Map<String, List<String>> buildUrlMap(DocCollection col) {
        HashMap<String, List<String>> urlMap = new HashMap<String, List<String>>();
        Collection<Slice> slices = col.getActiveSlices();
        for (Slice slice : slices) {
            String name = slice.getName();
            ArrayList<String> urls = new ArrayList<String>();
            Replica leader = slice.getLeader();
            if (leader == null) {
                return null;
            }
            ZkCoreNodeProps zkProps = new ZkCoreNodeProps(leader);
            String url = zkProps.getCoreUrl();
            urls.add(url);
            Collection<Replica> replicas = slice.getReplicas();
            for (Replica replica : replicas) {
                if (replica.getNodeName().equals(leader.getNodeName()) || replica.getName().equals(leader.getName())) continue;
                ZkCoreNodeProps zkProps1 = new ZkCoreNodeProps(replica);
                String url1 = zkProps1.getCoreUrl();
                urls.add(url1);
            }
            urlMap.put(name, urls);
        }
        return urlMap;
    }

    public RouteResponse condenseResponse(NamedList response, long timeMillis) {
        RouteResponse condensed = new RouteResponse();
        int status = 0;
        Integer rf = null;
        Integer minRf = null;
        for (int i = 0; i < response.size(); ++i) {
            Object rfObj;
            NamedList shardResponse = (NamedList)response.getVal(i);
            NamedList header = (NamedList)shardResponse.get("responseHeader");
            Integer shardStatus = (Integer)header.get("status");
            int s = shardStatus;
            if (s > 0) {
                status = s;
            }
            if ((rfObj = header.get("rf")) != null && rfObj instanceof Integer) {
                Integer routeRf = (Integer)rfObj;
                if (rf == null || routeRf < rf) {
                    rf = routeRf;
                }
            }
            minRf = (Integer)header.get("min_rf");
        }
        NamedList<Number> cheader = new NamedList<Number>();
        cheader.add("status", status);
        cheader.add("QTime", timeMillis);
        if (rf != null) {
            cheader.add("rf", rf);
        }
        if (minRf != null) {
            cheader.add("min_rf", minRf);
        }
        condensed.add("responseHeader", cheader);
        return condensed;
    }

    @Override
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        SolrParams reqParams = request.getParams();
        if (collection == null) {
            collection = reqParams != null ? reqParams.get("collection", this.getDefaultCollection()) : this.getDefaultCollection();
        }
        return this.requestWithRetryOnStaleState(request, 0, collection);
    }

    protected NamedList<Object> requestWithRetryOnStaleState(SolrRequest request, int retryCount, String collection) throws SolrServerException, IOException {
        this.connect();
        String stateVerParam = null;
        ArrayList<DocCollection> requestedCollections = null;
        if (collection != null && !request.getPath().startsWith("/admin")) {
            Set<String> requestedCollectionNames = this.getCollectionNames(this.getZkStateReader().getClusterState(), collection);
            StringBuilder stateVerParamBuilder = null;
            for (String string : requestedCollectionNames) {
                DocCollection docCollection = this.getDocCollection(this.getZkStateReader().getClusterState(), string, null);
                int collVer = docCollection.getZNodeVersion();
                if (docCollection.getStateFormat() <= 1) continue;
                if (requestedCollections == null) {
                    requestedCollections = new ArrayList<DocCollection>(requestedCollectionNames.size());
                }
                requestedCollections.add(docCollection);
                if (stateVerParamBuilder == null) {
                    stateVerParamBuilder = new StringBuilder();
                } else {
                    stateVerParamBuilder.append("|");
                }
                stateVerParamBuilder.append(docCollection.getName()).append(":").append(collVer);
            }
            if (stateVerParamBuilder != null) {
                stateVerParam = stateVerParamBuilder.toString();
            }
        }
        if (request.getParams() instanceof ModifiableSolrParams) {
            ModifiableSolrParams params = (ModifiableSolrParams)request.getParams();
            if (stateVerParam != null) {
                params.set(STATE_VERSION, stateVerParam);
            } else {
                params.remove(STATE_VERSION);
            }
        }
        NamedList<Object> resp = null;
        try {
            resp = this.sendRequest(request, collection);
            Object o = resp.get(STATE_VERSION, resp.size() - 1);
            if (o != null && o instanceof Map) {
                resp.remove(resp.size() - 1);
                Map invalidStates = (Map)o;
                Iterator iterator = invalidStates.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry e = entry = iterator.next();
                    this.getDocCollection(this.getZkStateReader().getClusterState(), (String)e.getKey(), (Integer)e.getValue());
                }
            }
        }
        catch (Exception exc) {
            Throwable rootCause = SolrException.getRootCause(exc);
            if (collection == null || request.getPath().startsWith("/admin")) {
                if (exc instanceof SolrServerException) {
                    throw (SolrServerException)exc;
                }
                if (exc instanceof IOException) {
                    throw (IOException)exc;
                }
                if (exc instanceof RuntimeException) {
                    throw (RuntimeException)exc;
                }
                throw new SolrServerException(rootCause);
            }
            int n = rootCause instanceof SolrException ? ((SolrException)rootCause).code() : SolrException.ErrorCode.UNKNOWN.code;
            log.error("Request to collection {} failed due to (" + n + ") {}, retry? " + retryCount, (Object)collection, (Object)rootCause.toString());
            boolean bl = rootCause instanceof ConnectException || rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException || rootCause instanceof SocketException;
            boolean stateWasStale = false;
            if (retryCount < 5 && requestedCollections != null && !requestedCollections.isEmpty() && SolrException.ErrorCode.getErrorCode(n) == SolrException.ErrorCode.INVALID_STATE) {
                stateWasStale = true;
                for (DocCollection ext : requestedCollections) {
                    this.collectionStateCache.remove(ext.getName());
                }
            }
            if (retryCount < 5 && !stateWasStale && requestedCollections != null && !requestedCollections.isEmpty() && bl) {
                for (DocCollection ext : requestedCollections) {
                    DocCollection latestStateFromZk = this.getDocCollection(this.zkStateReader.getClusterState(), ext.getName(), null);
                    if (latestStateFromZk.getZNodeVersion() == ext.getZNodeVersion()) continue;
                    stateWasStale = true;
                    this.collectionStateCache.put(ext.getName(), new ExpiringCachedDocCollection(latestStateFromZk));
                }
            }
            if (requestedCollections != null) {
                requestedCollections.clear();
            }
            if (stateWasStale) {
                log.warn("Re-trying request to  collection(s) " + collection + " after stale state error from server.");
                resp = this.requestWithRetryOnStaleState(request, retryCount + 1, collection);
            }
            if (exc instanceof SolrException) {
                throw exc;
            }
            if (exc instanceof SolrServerException) {
                throw (SolrServerException)exc;
            }
            if (exc instanceof IOException) {
                throw (IOException)exc;
            }
            throw new SolrServerException(rootCause);
        }
        return resp;
    }

    protected NamedList<Object> sendRequest(SolrRequest request, String collection) throws SolrServerException, IOException {
        SolrParams reqParams;
        this.connect();
        ClusterState clusterState = this.zkStateReader.getClusterState();
        boolean sendToLeaders = false;
        ArrayList<String> replicas = null;
        if (request instanceof IsUpdateRequest) {
            NamedList<Object> response;
            if (request instanceof UpdateRequest && (response = this.directUpdate((AbstractUpdateRequest)request, collection, clusterState)) != null) {
                return response;
            }
            sendToLeaders = true;
            replicas = new ArrayList<String>();
        }
        if ((reqParams = request.getParams()) == null) {
            reqParams = new ModifiableSolrParams();
        }
        ArrayList<String> theUrlList = new ArrayList<String>();
        if (request.getPath().equals("/admin/collections") || request.getPath().equals("/admin/cores")) {
            Set<String> liveNodes = clusterState.getLiveNodes();
            for (String liveNode : liveNodes) {
                theUrlList.add(this.zkStateReader.getBaseUrlForNodeName(liveNode));
            }
        } else {
            if (collection == null) {
                throw new SolrServerException("No collection param specified on request and no default collection has been set.");
            }
            Set<String> collectionNames = this.getCollectionNames(clusterState, collection);
            if (collectionNames.size() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection: " + collection);
            }
            String shardKeys = reqParams.get("_route_");
            HashMap<String, Slice> slices = new HashMap<String, Slice>();
            for (String collectionName : collectionNames) {
                DocCollection col = this.getDocCollection(clusterState, collectionName, null);
                Collection<Slice> routeSlices = col.getRouter().getSearchSlices(shardKeys, reqParams, col);
                ClientUtils.addSlices(slices, collectionName, routeSlices, true);
            }
            Set<String> liveNodes = clusterState.getLiveNodes();
            ArrayList<String> leaderUrlList = null;
            ArrayList<String> urlList = null;
            ArrayList<String> replicasList = null;
            HashMap<String, ZkNodeProps> nodes = new HashMap<String, ZkNodeProps>();
            ArrayList<String> urlList2 = new ArrayList<String>();
            for (Slice slice : slices.values()) {
                for (ZkNodeProps zkNodeProps : slice.getReplicasMap().values()) {
                    String url;
                    ZkCoreNodeProps coreNodeProps = new ZkCoreNodeProps(zkNodeProps);
                    String node = coreNodeProps.getNodeName();
                    if (!liveNodes.contains(coreNodeProps.getNodeName()) || Replica.State.getState(coreNodeProps.getState()) != Replica.State.ACTIVE || nodes.put(node, zkNodeProps) != null) continue;
                    if (!sendToLeaders || coreNodeProps.isLeader()) {
                        url = reqParams.get("collection") == null ? ZkCoreNodeProps.getCoreUrl(zkNodeProps.getStr("base_url"), collection) : coreNodeProps.getCoreUrl();
                        urlList2.add(url);
                        continue;
                    }
                    url = reqParams.get("collection") == null ? ZkCoreNodeProps.getCoreUrl(zkNodeProps.getStr("base_url"), collection) : coreNodeProps.getCoreUrl();
                    replicas.add(url);
                }
            }
            if (sendToLeaders) {
                leaderUrlList = urlList2;
                replicasList = replicas;
            } else {
                urlList = urlList2;
            }
            if (sendToLeaders) {
                theUrlList = new ArrayList(leaderUrlList.size());
                theUrlList.addAll(leaderUrlList);
            } else {
                theUrlList = new ArrayList(urlList.size());
                theUrlList.addAll(urlList);
            }
            if (theUrlList.isEmpty()) {
                for (String s : collectionNames) {
                    if (s == null) continue;
                    this.collectionStateCache.remove(s);
                }
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Not enough nodes to handle the request");
            }
            Collections.shuffle(theUrlList, this.rand);
            if (sendToLeaders) {
                ArrayList<String> theReplicas = new ArrayList<String>(replicasList.size());
                theReplicas.addAll(replicasList);
                Collections.shuffle(theReplicas, this.rand);
                theUrlList.addAll(theReplicas);
            }
        }
        LBHttpSolrClient.Req req = new LBHttpSolrClient.Req(request, theUrlList);
        LBHttpSolrClient.Rsp rsp = this.lbClient.request(req);
        return rsp.getResponse();
    }

    private Set<String> getCollectionNames(ClusterState clusterState, String collection) {
        List<String> rawCollectionsList = StrUtils.splitSmart(collection, ",", true);
        HashSet<String> collectionNames = new HashSet<String>();
        for (String collectionName : rawCollectionsList) {
            if (!clusterState.getCollections().contains(collectionName)) {
                Aliases aliases = this.zkStateReader.getAliases();
                String alias = aliases.getCollectionAlias(collectionName);
                if (alias != null) {
                    List<String> aliasList = StrUtils.splitSmart(alias, ",", true);
                    collectionNames.addAll(aliasList);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not found: " + collectionName);
            }
            collectionNames.add(collectionName);
        }
        return collectionNames;
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void shutdown() {
        if (this.zkStateReader != null) {
            CloudSolrClient cloudSolrClient = this;
            synchronized (cloudSolrClient) {
                if (this.zkStateReader != null) {
                    this.zkStateReader.close();
                }
                this.zkStateReader = null;
            }
        }
        if (this.shutdownLBHttpSolrServer) {
            this.lbClient.shutdown();
        }
        if (this.clientIsInternal && this.myClient != null) {
            HttpClientUtil.close(this.myClient);
        }
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
        }
    }

    public LBHttpSolrClient getLbClient() {
        return this.lbClient;
    }

    public boolean isUpdatesToLeaders() {
        return this.updatesToLeaders;
    }

    public void setParallelCacheRefreshes(int n) {
        this.locks = CloudSolrClient.objectList(n);
    }

    private static ArrayList<Object> objectList(int n) {
        ArrayList<Object> l = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            l.add(new Object());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocCollection getDocCollection(ClusterState clusterState, String collection, Integer expectedVersion) throws SolrException {
        Object lock;
        ClusterState.CollectionRef ref;
        if (collection == null) {
            return null;
        }
        DocCollection col = this.getFromCache(collection);
        if (col != null) {
            if (expectedVersion == null) {
                return col;
            }
            if (expectedVersion.intValue() == col.getZNodeVersion()) {
                return col;
            }
        }
        if ((ref = clusterState.getCollectionRef(collection)) == null) {
            return null;
        }
        if (!ref.isLazilyLoaded()) {
            return ref.get();
        }
        List<Object> locks = this.locks;
        Object object = lock = locks.get(Math.abs(Hash.murmurhash3_x86_32(collection, 0, collection.length(), 0) % locks.size()));
        synchronized (object) {
            col = this.getFromCache(collection);
            if (col != null) {
                if (expectedVersion == null) {
                    return col;
                }
                if (expectedVersion.intValue() == col.getZNodeVersion()) {
                    return col;
                }
                this.collectionStateCache.remove(collection);
            }
            col = ref.get();
        }
        if (col == null) {
            return null;
        }
        if (col.getStateFormat() > 1) {
            this.collectionStateCache.put(collection, new ExpiringCachedDocCollection(col));
        }
        return col;
    }

    private DocCollection getFromCache(String c) {
        ExpiringCachedDocCollection cachedState = this.collectionStateCache.get(c);
        return cachedState != null ? cachedState.cached : null;
    }

    public int getMinAchievedReplicationFactor(String collection, NamedList resp) {
        NamedList header = (NamedList)resp.get("responseHeader");
        Integer achRf = (Integer)header.get("rf");
        if (achRf != null) {
            return achRf;
        }
        Map<String, Integer> shardRf = this.getShardReplicationFactor(collection, resp);
        for (Integer rf : shardRf.values()) {
            if (achRf != null && rf >= achRf) continue;
            achRf = rf;
        }
        return achRf != null ? achRf : -1;
    }

    public Map<String, Integer> getShardReplicationFactor(String collection, NamedList resp) {
        this.connect();
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        if (resp instanceof RouteResponse) {
            NamedList routes = ((RouteResponse)resp).getRouteResponses();
            ClusterState clusterState = this.zkStateReader.getClusterState();
            HashMap<String, String> leaders = new HashMap<String, String>();
            for (Slice slice : clusterState.getActiveSlices(collection)) {
                Replica leader = slice.getLeader();
                if (leader == null) continue;
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(leader);
                String leaderUrl = zkProps.getBaseUrl() + "/" + zkProps.getCoreName();
                leaders.put(leaderUrl, slice.getName());
                String altLeaderUrl = zkProps.getBaseUrl() + "/" + collection;
                leaders.put(altLeaderUrl, slice.getName());
            }
            for (Map.Entry next : routes) {
                String host = next.getKey();
                NamedList hostResp = (NamedList)next.getValue();
                Integer rf = (Integer)((NamedList)hostResp.get("responseHeader")).get("rf");
                if (rf == null) continue;
                String shard = (String)leaders.get(host);
                if (shard == null) {
                    if (host.endsWith("/")) {
                        shard = (String)leaders.get(host.substring(0, host.length() - 1));
                    }
                    if (shard == null) {
                        shard = host;
                    }
                }
                results.put(shard, rf);
            }
        }
        return results;
    }

    public static class RouteException
    extends SolrException {
        private NamedList<Throwable> throwables;
        private Map<String, LBHttpSolrClient.Req> routes;

        public RouteException(SolrException.ErrorCode errorCode, NamedList<Throwable> throwables, Map<String, LBHttpSolrClient.Req> routes) {
            super(errorCode, throwables.getVal(0).getMessage(), throwables.getVal(0));
            this.throwables = throwables;
            this.routes = routes;
        }

        public NamedList<Throwable> getThrowables() {
            return this.throwables;
        }

        public Map<String, LBHttpSolrClient.Req> getRoutes() {
            return this.routes;
        }
    }

    public static class RouteResponse
    extends NamedList {
        private NamedList routeResponses;
        private Map<String, LBHttpSolrClient.Req> routes;

        public void setRouteResponses(NamedList routeResponses) {
            this.routeResponses = routeResponses;
        }

        public NamedList getRouteResponses() {
            return this.routeResponses;
        }

        public void setRoutes(Map<String, LBHttpSolrClient.Req> routes) {
            this.routes = routes;
        }

        public Map<String, LBHttpSolrClient.Req> getRoutes() {
            return this.routes;
        }
    }

    class ExpiringCachedDocCollection {
        final DocCollection cached;
        long cachedAt;

        ExpiringCachedDocCollection(DocCollection cached) {
            this.cached = cached;
            this.cachedAt = System.currentTimeMillis();
        }

        boolean isExpired(long timeToLive) {
            return System.currentTimeMillis() - this.cachedAt > timeToLive;
        }
    }
}

