/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.consumer.SharedAccessBlobHeadersConsumer;
import coldfusion.azure.blob.consumer.SharedAccessBlobPolicyConsumer;
import coldfusion.azure.blob.request.GenerateSasRequest;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import com.microsoft.azure.storage.IPRange;
import com.microsoft.azure.storage.SharedAccessProtocols;
import com.microsoft.azure.storage.blob.SharedAccessBlobHeaders;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import java.util.Collections;

public class GenerateBlobSasRequestConsumer
extends ConsumerMap<GenerateSasRequest> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public GenerateBlobSasRequestConsumer() {
        this.put("blobName", new ConsumerValidator((generateSasRequest, value) -> generateSasRequest.setBlob(this.cast.getStringProperty(value)), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("policy", new ConsumerValidator((generateSasRequest, value) -> {
            SharedAccessBlobPolicy policy = new SharedAccessBlobPolicy();
            ValidatorFiller.INSTANCE.fillObject((Object)policy, this.cast.getMapProperty(value), (ConsumerMap)SharedAccessBlobPolicyConsumer.getInstance());
            generateSasRequest.setPolicy(policy);
        }, Collections.emptyList()));
        this.put("headers", new ConsumerValidator((generateSasRequest, value) -> {
            SharedAccessBlobHeaders headers = new SharedAccessBlobHeaders();
            ValidatorFiller.INSTANCE.fillObject((Object)headers, this.cast.getMapProperty(value), (ConsumerMap)new SharedAccessBlobHeadersConsumer());
            generateSasRequest.setHeaders(headers);
        }, Collections.emptyList()));
        this.put("groupPolicyIdentifier", new ConsumerValidator((generateSasRequest, value) -> generateSasRequest.setGroupPolicyIdentifier(this.cast.getStringProperty(value)), Collections.emptyList()));
        this.put("ipRange", new ConsumerValidator((generateSasRequest, value) -> {
            String ipRangeString = this.cast.getStringProperty(value);
            String[] ips = ipRangeString.split("-");
            if (ips.length != 2) {
                throw new ValidationException("Invalid ipRange it should be like xxx.xxx.xxx.xxx-zzz.zzz.zzz.zzz");
            }
            IPRange ipRange = new IPRange(ips[0].trim(), ips[1].trim());
            generateSasRequest.setIpRange(ipRange);
        }, Collections.emptyList()));
        this.put("protocols", new ConsumerValidator((generateSasRequest, value) -> generateSasRequest.setProtocols(SharedAccessProtocols.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
    }
}

