/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.presentation;

import coldfusion.document.DocumentMargin;
import coldfusion.document.DocumentPageLayout;
import coldfusion.document.DocumentProcessor;
import coldfusion.document.presentation.core.PresentationExceptions;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.Exporter;
import coldfusion.document.spi.core.URLConnectionSettings;
import coldfusion.log.CFLogs;
import coldfusion.osgi.services.PresentationService;
import coldfusion.presentation.PPTDocumentProperties;
import coldfusion.presentation.PowerPointProcessor;
import coldfusion.presentation.PowerPointReader;
import coldfusion.presentation.SlideExporter;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.presentation.PresentationTag;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;

public class PresentationServiceImpl
implements PresentationService {
    private static final String SUBJECT = "Subject";
    private static final String KEYWORDS = "Keywords";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readPPT(File pptfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            PowerPointExtractor extractor = new PowerPointExtractor((InputStream)new FileInputStream(pptfile));
            content = extractor.getText();
            author = extractor.getSummaryInformation().getAuthor();
            title = extractor.getSummaryInformation().getTitle();
            String subject = extractor.getSummaryInformation().getSubject();
            String keywords = extractor.getSummaryInformation().getKeywords();
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.ms-powerpoint");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString(PresentationServiceImpl.class, (String)"Search.LucenePDFDocumentWarn", (Object)pptfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        finally {
            return metadata;
        }
    }

    public boolean isInstanceOfPresentationTag(Object obj) {
        return obj instanceof PresentationTag;
    }

    public Map<String, String> readPPTX(File pptfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            XSLFPowerPointExtractor extractor = new XSLFPowerPointExtractor(OPCPackage.open((InputStream)new FileInputStream(pptfile)));
            content = extractor.getText();
            author = extractor.getCoreProperties().getCreator();
            title = extractor.getCoreProperties().getTitle();
            String subject = extractor.getCoreProperties().getSubject();
            String keywords = "";
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString(PresentationServiceImpl.class, (String)"Search.LucenePDFDocumentWarn", (Object)pptfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        return metadata;
    }

    public String getBaseName(File sourceFile) {
        PowerPointProcessor pptprocessor = new PowerPointProcessor();
        return PowerPointProcessor.getBaseName(sourceFile);
    }

    public Object[] getPageContents(File sourceFile, File htmlDir) {
        Object[] ary = new Object[3];
        PowerPointProcessor pptprocessor = new PowerPointProcessor();
        pptprocessor.setOutputDirectory(htmlDir);
        String[] contents = pptprocessor.processPPT(sourceFile);
        ary[0] = pptprocessor.getPageHeight();
        ary[1] = pptprocessor.getPageWidth();
        ary[2] = contents;
        return ary;
    }

    public String[] processPPT(File presodir, String slides, String src) {
        String[] html;
        PowerPointProcessor pptprocessor = new PowerPointProcessor();
        pptprocessor.setOutputDirectory(presodir);
        File pptfile = VFSFileFactory.getFileObject((String)src);
        if (slides == null) {
            html = pptprocessor.processPPT(pptfile);
        } else if (slides.contains(",")) {
            ArrayList<Integer> slidenumbers = PresentationServiceImpl.doProcessList(slides);
            html = new String[slidenumbers.size()];
            for (int i = 0; i < slidenumbers.size(); ++i) {
                html[i] = pptprocessor.processPPT(pptfile, slidenumbers.get(i));
            }
        } else if (slides.contains("-") && !slides.contains(",")) {
            int[] v = PresentationServiceImpl.doProcessRange(slides);
            int startslide = v[0];
            int endslide = v[1];
            int index = 0;
            html = new String[endslide - startslide + 1];
            for (int i = startslide; i <= endslide; ++i) {
                html[index] = pptprocessor.processPPT(pptfile, i);
                ++index;
            }
        } else {
            int slidenumber = new Integer(slides);
            html = new String[]{pptprocessor.processPPT(pptfile, slidenumber)};
        }
        return html;
    }

    public void exportToPPT(String content, Object o, String title, String backgroundColor, double scale, String src, String encoding, URLConnectionSettings connSettings, URL baseUrl, String resolveurl) {
        HSLFSlideShow ppt = (HSLFSlideShow)o;
        try {
            Dimension pgsize = ppt.getPageSize();
            DocumentPageLayout pageLayout = new DocumentPageLayout();
            boolean marginBottom = false;
            boolean marginLeft = false;
            boolean marginRight = false;
            int marginTop = 0;
            if (title != null) {
                marginTop = 50;
            }
            DocumentMargin margin = new DocumentMargin();
            margin.setTop((double)marginTop);
            margin.setBottom((double)marginBottom);
            margin.setLeft((double)marginLeft);
            margin.setRight((double)marginRight);
            int height = pgsize.height - marginTop;
            pageLayout.setPageheight((double)height);
            pageLayout.setPagewidth((double)pgsize.width);
            pageLayout.setMargin(margin);
            Color color = null;
            if (backgroundColor != null) {
                color = Color.decode(backgroundColor);
            }
            PPTDocumentProperties docPPTProps = new PPTDocumentProperties(pageLayout, ppt, title, color);
            docPPTProps.setScale(scale);
            this.processDocument(content, docPPTProps, src, encoding, connSettings, baseUrl, resolveurl);
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
    }

    public static int[] doProcessRange(String range) {
        int[] v = new int[2];
        int start = 0;
        int end = 0;
        try {
            if (range.contains("-")) {
                int dot = range.indexOf("-");
                start = new Integer(range.substring(0, dot));
                end = new Integer(range.substring(dot + 1, range.length()));
            }
            v[0] = start;
            v[1] = end;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v;
    }

    public static ArrayList<Integer> doProcessList(String list) {
        ArrayList<Integer> rangeval = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(list, "\t\n,");
            rangeval = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreElements()) {
                String token = stringTokenizer.nextToken();
                if (token.contains("-")) {
                    int[] v = PresentationServiceImpl.doProcessRange(token);
                    int start = v[0];
                    int end = v[1];
                    for (int i = start; i <= end; ++i) {
                        rangeval.add(i);
                    }
                    continue;
                }
                rangeval.add(new Integer(token.trim()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rangeval;
    }

    public String[] exportSlides(String filename, String slides, File outdir) {
        String[] files;
        PowerPointReader pptreader = new PowerPointReader(filename);
        pptreader.setupOutputDir(outdir);
        if (slides == null) {
            files = pptreader.exportSlides();
        } else if (slides.contains(",")) {
            ArrayList<Integer> slidenumbers = PresentationServiceImpl.doProcessList(slides);
            files = pptreader.exportSlides(slidenumbers);
        } else if (slides.contains("-") && !slides.contains(",")) {
            int[] v = PresentationServiceImpl.doProcessRange(slides);
            int startslide = v[0];
            int endslide = v[1];
            files = pptreader.exportSlides(startslide, endslide);
        } else {
            int slidenum = new Integer(slides);
            files = new String[]{pptreader.exportSlides(slidenum)};
        }
        return files;
    }

    public URLConnectionSettings getURLConnectionSettings(String authUser, String authPassword, String userAgent, URLConnectionSettings urlConnectionSettings) {
        if (authUser != null || userAgent != null) {
            urlConnectionSettings = (URLConnectionSettings)urlConnectionSettings.clone();
            if (authUser != null) {
                urlConnectionSettings.setAuthUserName(authUser);
                urlConnectionSettings.setAuthPassword(authPassword);
            }
            if (userAgent != null) {
                urlConnectionSettings.setUserAgent(userAgent);
            }
        }
        return urlConnectionSettings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDocument(String content, DocumentProperties docprop, String src, String encoding, URLConnectionSettings urlConnectionSettings, URL baseurl, String resolveUrl) throws Exception {
        boolean hasContent;
        boolean bl = hasContent = content != null && content.length() > 0;
        if (!hasContent && src == null) {
            throw new PresentationExceptions.EmptySlideException();
        }
        DocumentProcessor processor = new DocumentProcessor(urlConnectionSettings);
        processor.setDocumentProperties(docprop);
        processor.setExporter((Exporter)new SlideExporter());
        if (ServiceFactory.getRuntimeService().timeoutRequests()) {
            long requestTimeOut = ServiceFactory.getRuntimeService().getRequestTimeoutLimit() * 1000L;
            processor.setRequestTimeOut(requestTimeOut);
        }
        String charset = null;
        charset = encoding;
        if (charset == null) {
            charset = RuntimeServiceImpl.getDefaultCharset();
        }
        if (hasContent) {
            processor.processContent(content, baseurl, charset, null);
            return;
        }
        File file = VFSFileFactory.getFileObject((String)src);
        if (file.isAbsolute()) {
            if (!file.isFile()) throw new PresentationExceptions.InvalidSrcException(src);
            processor.processContent(file, charset, "text/html", null, null);
            return;
        }
        try {
            URL srcUrl = new URL(resolveUrl);
            processor.processContent(srcUrl, charset, "text/html", null, null);
            return;
        }
        catch (MalformedURLException e) {
            throw new PresentationExceptions.InvalidSrcException(src);
        }
    }

    public Object createSlideShow() {
        return new HSLFSlideShow();
    }

    public void writePPT(Object o, String destination) {
        HSLFSlideShow ppt = (HSLFSlideShow)o;
        OutputStream pptout = null;
        try {
            pptout = VFSFileFactory.getOutputStream((String)destination);
            if (ppt != null) {
                ppt.write(pptout);
            }
        }
        catch (Exception e) {
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
        finally {
            if (pptout != null) {
                try {
                    pptout.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

