/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseColumns;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplResultSet;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BasePreparedStatement;
import macromedia.jdbc.slbase.BaseStatement;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.jdbc.slbase.BaseWarnings;
import macromedia.slutil.UtilVectorUnsynced;

public final class BaseResultSet
implements ResultSet {
    BaseWarnings warnings;
    private BaseExceptions exceptions;
    BaseStatement statement;
    BaseConnection connection;
    boolean databaseMetaDataResultSet = false;
    private int resultSetType;
    private int resultSetConcurrency;
    private boolean lastGetWasNull;
    BaseColumns columns;
    private int lastColumnOrdinal;
    private int rowsFetchSize;
    private int fetchDirection = 1002;
    BaseImplResultSet implResultSet;
    private boolean onInsertRow;
    int lastColumnAccessed = -1;
    private UtilVectorUnsynced streamsReturned;
    private int maxFieldSize = Integer.MAX_VALUE;
    private Object synchronizer;
    private boolean forwardReadOnly_Opt = false;
    private boolean inOrderFieldAccessOnly;
    private boolean inOrderFieldAccessOnlyIsNotSet = true;
    private boolean validateCursorPosition = true;

    public BaseResultSet(BaseStatement baseStatement, BaseColumns baseColumns, BaseImplResultSet baseImplResultSet) throws SQLException {
        this.exceptions = baseStatement.exceptions;
        this.statement = baseStatement;
        this.columns = baseColumns;
        this.lastColumnOrdinal = baseColumns.count(1);
        if (baseImplResultSet.warnings == null) {
            this.warnings = new BaseWarnings(this.exceptions.getMessages());
            baseImplResultSet.setWarnings(this.warnings);
        } else {
            this.warnings = baseImplResultSet.warnings;
        }
        this.implResultSet = baseImplResultSet;
        if (baseStatement.maxRows > 0) {
            baseImplResultSet.setMaxCursorPosition(baseStatement.maxRows);
        }
        this.rowsFetchSize = baseStatement.getFetchSize();
        this.resultSetType = baseImplResultSet.getScrollType();
        this.resultSetConcurrency = baseImplResultSet.getConcurrency();
        if (this.resultSetType == 1003 && this.resultSetConcurrency == 1007) {
            this.forwardReadOnly_Opt = true;
        }
        this.fetchDirection = baseStatement.getFetchDirection();
        this.connection = baseStatement.connection;
        baseImplResultSet.postSetupInitialize();
        this.synchronizer = this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.implResultSet == null || this.connection.implConnection == null;
        }
    }

    void validateScrollable(String string) throws SQLException {
        if (this.resultSetType == 1003) {
            String[] stringArray = new String[]{string};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    void validateUpdateable(int n2) throws SQLException {
        if (this.resultSetConcurrency != 1008) {
            throw this.connection.exceptions.getException(6054);
        }
        if (n2 != -1 && !this.columns.get((int)n2).isWritable) {
            throw this.connection.exceptions.getException(6055);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.streamsReturned != null) {
                this.closeStreams(false);
            }
            if (this.implResultSet != null) {
                this.implResultSet.close();
                this.implResultSet = null;
            }
            this.statement.resultSetClosed(this);
        }
    }

    private void closeStreams(boolean bl2) {
        if (this.streamsReturned == null) {
            return;
        }
        if (this.inOrderFieldAccessOnlyIsNotSet) {
            this.inOrderFieldAccessOnlyIsNotSet = false;
            boolean bl3 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
        }
        if (bl2 && !this.inOrderFieldAccessOnly) {
            return;
        }
        int n2 = this.streamsReturned.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.streamsReturned.elementAt(i2);
            try {
                if (object instanceof InputStream) {
                    ((InputStream)object).close();
                    continue;
                }
                ((Reader)object).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.streamsReturned = null;
    }

    private void commonFetchInitialize() throws SQLException {
        if (this.implResultSet == null || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.warnings.clear();
        if (this.streamsReturned != null) {
            this.closeStreams(false);
        }
        this.lastColumnAccessed = 0;
    }

    public void cancelPendingUpdates() throws SQLException {
        if (this.resultSetConcurrency == 1008) {
            this.implResultSet.cancelUpdates();
            if (this.onInsertRow) {
                this.moveToCurrentRow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.lastGetWasNull;
        }
    }

    void validateCursorPosition() throws SQLException {
        if (!this.onInsertRow) {
            if (!this.implResultSet.isCursorPositionValid()) {
                throw this.exceptions.getException(6004, "24000");
            }
            if (this.implResultSet.onDeletedRow()) {
                throw this.exceptions.getException(6089, "24000");
            }
        }
    }

    void validateCursorPositionForUpdate() throws SQLException {
        if (!this.onInsertRow) {
            if (!this.implResultSet.isCursorPositionValid()) {
                throw this.exceptions.getException(6004, "24000");
            }
            if (this.implResultSet.onDeletedRow()) {
                throw this.exceptions.getException(6089, "24000");
            }
        }
    }

    void validateInsertRow() throws SQLException {
        if (this.onInsertRow) {
            throw this.exceptions.getException(6058);
        }
    }

    int getColumnOrdinal(String string) throws SQLException {
        int n2 = this.columns.getOrdinal(string);
        if (n2 == 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6005, stringArray, "42S22");
        }
        return n2;
    }

    private void throwBadOrdinal(int n2) throws SQLException {
        Integer n3 = new Integer(n2);
        String[] stringArray = new String[]{n3.toString()};
        throw this.exceptions.getException(6006, stringArray, "42S22");
    }

    private void throwBadOrdinalReRead(int n2) throws SQLException {
        Integer n3 = new Integer(n2);
        String[] stringArray = new String[]{n3.toString()};
        throw this.exceptions.getException(6007, stringArray, "HY010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 10);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getString(this.maxFieldSize, this.exceptions);
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 9);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBoolean(this.exceptions);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 1);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getByte(this.exceptions);
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 3);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getShort(this.exceptions);
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 4);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getInteger(this.exceptions);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 5);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getLong(this.exceptions);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 6);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getFloat(this.exceptions);
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 7);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getDouble(this.exceptions);
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 8);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBigDecimal(this.exceptions);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 8);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBigDecimal(n3, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 2);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBytes(this.maxFieldSize, this.columns.get(n2).getTransliterator(), this.exceptions);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 11);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getDate(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 12);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getTime(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 13);
            this.lastGetWasNull = baseData.isNull;
            BaseTimestamp baseTimestamp = baseData.getTimestamp(this.exceptions);
            if (baseTimestamp == null) {
                return null;
            }
            return baseTimestamp.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            InputStream inputStream;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((inputStream = (baseData = this.implResultSet.getData(n2, 15)).getASCIIStream(this.maxFieldSize, this.connection, this.exceptions, true)) != null) {
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            InputStream inputStream;
            if (!this.connection.implConnection.shouldExposeGetSetUnicodeStream()) {
                String[] stringArray = new String[]{"ResultSet.getUnicodeStream"};
                throw this.connection.exceptions.getException(6003, stringArray);
            }
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((inputStream = (baseData = this.implResultSet.getData(n2, 17)).getUCS2InputStream(this.maxFieldSize, this.connection, this.exceptions)) != null) {
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            InputStream inputStream;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((inputStream = (baseData = this.implResultSet.getData(n2, 14)).getBinaryStream(this.maxFieldSize, this.connection, this.exceptions, true)) != null) {
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            return inputStream;
        }
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.getColumnOrdinal(string), n2);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnOrdinal(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnOrdinal(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnOrdinal(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnOrdinal(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnOrdinal(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.warnings.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.warnings.clear();
        }
    }

    public String getCursorName() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            String[] stringArray = new String[]{"ResultSet.getCursorName"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.connection.implConnection.createResultSetMetaData(this, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            int n3 = BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n2).type);
            BaseData baseData = this.implResultSet.getData(n2, n3);
            this.lastGetWasNull = baseData.isNull;
            if (this.lastGetWasNull) {
                return null;
            }
            return baseData.getObject(n3, this.maxFieldSize, this.connection, this.exceptions);
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            int n2 = this.columns.getOrdinal(string);
            if (n2 == 0) {
                throw this.exceptions.getException(6005, "42S22");
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            Reader reader;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((reader = (baseData = this.implResultSet.getData(n2, 18)).getCharacterStreamReader(this.maxFieldSize, this.connection, this.exceptions, true)) != null) {
                this.lastGetWasNull = false;
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(reader);
            } else {
                this.lastGetWasNull = true;
            }
            return reader;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            boolean bl2 = this.implResultSet.next();
            if (this.forwardReadOnly_Opt) {
                this.validateCursorPosition = !bl2;
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.previous");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.previous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.absolute");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.absolute(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.relative");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.relative(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.first");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.last");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.beforeFirst");
            this.commonFetchInitialize();
            this.implResultSet.beforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.afterLast");
            this.commonFetchInitialize();
            this.implResultSet.afterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isFirst");
            return this.implResultSet.isFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isLast");
            return this.implResultSet.isLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isBeforeFirst");
            return this.implResultSet.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isAfterLast");
            return this.implResultSet.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implResultSet.getRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxFieldSize(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.maxFieldSize = n2 == 0 ? Integer.MAX_VALUE : n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.setFetchDirection");
            this.fetchDirection = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.fetchDirection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 < 0 || this.statement.maxRows > 0 && n2 > this.statement.maxRows) {
                String[] stringArray = new String[]{"setFetchSize"};
                throw this.exceptions.getException(6002, stringArray);
            }
            this.rowsFetchSize = n2;
            this.implResultSet.setFetchSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.rowsFetchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.resultSetType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.resultSetConcurrency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowUpdated() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowInserted() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowDeleted() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.implResultSet.onDeletedRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n2).type), null, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(9, new Boolean(bl2), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(int n2, byte by2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(1, new Byte(by2), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(int n2, short s2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(3, new Short(s2), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(4, new Integer(n3), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(int n2, long l2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(5, new Long(l2), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(int n2, float f2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(6, new Float(f2), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(int n2, double d2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(7, new Double(d2), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(8, bigDecimal, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int n2, String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(10, string, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(2, byArray, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(int n2, Date date) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(11, date, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(int n2, Time time) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(12, time, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = timestamp == null ? new BaseData(13, null, this.connection) : new BaseData(13, new BaseTimestamp(timestamp, null), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(15, new BaseInputStreamWrapper(inputStream, n3, this.connection, this.exceptions), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(14, new BaseInputStreamWrapper(inputStream, n3, this.connection, this.exceptions), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(18, new BaseCharacterStreamWrapper(reader, n3, this.connection, this.exceptions), this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(object, this.connection);
            BigDecimal bigDecimal = baseData.getBigDecimal(n3, this.exceptions);
            baseData.setBigDecimal(bigDecimal);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n2, Object object) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(object, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnOrdinal(string));
    }

    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.updateBoolean(this.getColumnOrdinal(string), bl2);
    }

    public void updateByte(String string, byte by2) throws SQLException {
        this.updateByte(this.getColumnOrdinal(string), by2);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.getColumnOrdinal(string), s2);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.getColumnOrdinal(string), n2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.getColumnOrdinal(string), l2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.getColumnOrdinal(string), f2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.getColumnOrdinal(string), d2);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnOrdinal(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnOrdinal(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnOrdinal(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnOrdinal(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnOrdinal(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnOrdinal(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.getColumnOrdinal(string), inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.getColumnOrdinal(string), inputStream, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.getColumnOrdinal(string), reader, n2);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.getColumnOrdinal(string), object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnOrdinal(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateUpdateable(-1);
            if (!this.onInsertRow) {
                throw this.exceptions.getException(6061);
            }
            this.implResultSet.insertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateUpdateable(-1);
            this.validateCursorPosition();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            this.implResultSet.updateRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateUpdateable(-1);
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateInsertRow();
            this.implResultSet.deleteRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateInsertRow();
            this.validateScrollable("ResultSet.refreshRow");
            if (this.implResultSet.isBeforeFirst() || this.implResultSet.isAfterLast()) {
                throw this.exceptions.getException(6004);
            }
            this.implResultSet.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateUpdateable(-1);
            this.validateCursorPositionForUpdate();
            this.implResultSet.cancelUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.onInsertRow = true;
            this.implResultSet.prepareInsertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.onInsertRow = false;
            this.implResultSet.cancelInsertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.databaseMetaDataResultSet) {
                if (this.statement instanceof BasePreparedStatement) {
                    return ((BasePreparedStatement)this.statement).getExternalReference();
                }
                return this.statement;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.getObject(n2);
        }
    }

    public Ref getRef(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getRef"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n3;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if (!((n3 = this.columns.get((int)n2).type) == 2004 || n3 == -4 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            BaseData baseData = this.implResultSet.getData(n2, 19);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBlob(this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n3;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if (!((n3 = this.columns.get((int)n2).type) == 2005 || n3 == -1 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            BaseData baseData = this.implResultSet.getData(n2, 20);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getClob(this.connection, this.exceptions);
        }
    }

    public Array getArray(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getArray"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Map map) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.getObject(string);
        }
    }

    public Ref getRef(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getRef"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnOrdinal(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnOrdinal(string));
    }

    public Array getArray(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getArray"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 11);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getDate(calendar, this.exceptions);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnOrdinal(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 12);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getTime(calendar, this.exceptions);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnOrdinal(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n2 <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n2);
            }
            this.lastColumnAccessed = n2;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n2, 13);
            this.lastGetWasNull = baseData.isNull;
            this.lastGetWasNull = baseData.isNull;
            BaseTimestamp baseTimestamp = baseData.getTimestamp(calendar, this.exceptions);
            if (baseTimestamp == null) {
                return null;
            }
            return baseTimestamp.getTimestamp();
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnOrdinal(string), calendar);
    }

    public URL getURL(int n2) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public URL getURL(String string) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int n2, Blob blob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(19, blob, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColumnOrdinal(string), blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int n2, Clob clob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 <= 0 || n2 > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n2);
            }
            this.validateUpdateable(n2);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(20, clob, this.connection);
            this.implResultSet.updateData(n2, baseData);
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColumnOrdinal(string), clob);
    }

    public void updateArray(int n2, Array array) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateArray"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void updateArray(String string, Array array) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateArray"};
        throw this.exceptions.getException(6003, stringArray);
    }
}

