/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import macromedia.jdbc.slbase.BaseLocalMessages;

public final class BaseMessages {
    private static BaseLocalMessages baseLocalMessages;
    private BaseLocalMessages implLocalMessages;
    private String driverName;

    public BaseMessages(String string) throws SQLException {
        this.driverName = string;
        this.loadImplLocalMessages();
    }

    private void loadImplLocalMessages() throws SQLException {
        String string = "macromedia.jdbc." + this.driverName.toLowerCase() + "." + this.driverName + "Local";
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            this.implLocalMessages = (BaseLocalMessages)Class.forName(string + "Messages").newInstance();
            this.implLocalMessages.setResourceBundle(resourceBundle);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public final BaseLocalMessages getImplLocalMessages() {
        return this.implLocalMessages;
    }

    public final BaseLocalMessages getBaseLocalMessages() {
        return baseLocalMessages;
    }

    public String getMessage(int n2, String[] stringArray, boolean bl2) {
        String string = null;
        if (this.implLocalMessages != null) {
            try {
                string = this.implLocalMessages.getString(n2, stringArray);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string == null) {
            try {
                string = baseLocalMessages.getString(n2, stringArray);
            }
            catch (MissingResourceException missingResourceException) {
                string = "(Internal Error) Message " + n2 + " not found.";
                stringArray = null;
            }
        }
        return this.formatMessage(string, stringArray, bl2);
    }

    protected String formatMessage(String string, String[] stringArray, boolean bl2) {
        String string2 = "[DataDirect][" + this.driverName + " JDBC Driver]";
        if (bl2) {
            string2 = string2 + "[" + this.driverName + "]";
        }
        string2 = string2 + string;
        if (stringArray != null) {
            string2 = MessageFormat.format(string2, stringArray);
        }
        return string2;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("macromedia.jdbc.slbase.BaseLocal");
        baseLocalMessages = new BaseLocalMessages();
        baseLocalMessages.setResourceBundle(resourceBundle);
    }
}

