/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.gmss;

import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.Digest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.gmss.GMSSDigestProvider;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.gmss.GMSSPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.gmss.GMSSSigner;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Memoable;

public class GMSSStateAwareSigner
implements StateAwareMessageSigner {
    private final GMSSSigner gmssSigner;
    private GMSSPrivateKeyParameters key;

    public GMSSStateAwareSigner(Digest digest) {
        if (!(digest instanceof Memoable)) {
            throw new IllegalArgumentException("digest must implement Memoable");
        }
        final Memoable memoable = ((Memoable)((Object)digest)).copy();
        this.gmssSigner = new GMSSSigner(new GMSSDigestProvider(){

            @Override
            public Digest get() {
                return (Digest)((Object)memoable.copy());
            }
        });
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.key = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.key = (GMSSPrivateKeyParameters)cipherParameters;
            }
        }
        this.gmssSigner.init(bl2, cipherParameters);
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        if (this.key == null) {
            throw new IllegalStateException("signing key no longer usable");
        }
        byte[] byArray2 = this.gmssSigner.generateSignature(byArray);
        this.key = this.key.nextKey();
        return byArray2;
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        return this.gmssSigner.verifySignature(byArray, byArray2);
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this.key;
        this.key = null;
        return gMSSPrivateKeyParameters;
    }
}

