/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.BufferedBlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.Digest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.KeyEncoder;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.KeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement.XDHBasicAgreement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.engines.AESEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.engines.DESedeEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.engines.IESEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.macs.HMac;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.modes.CBCBlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ECKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.IESWithCipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.parsers.XIESPublicKeyParser;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.util.DigestFactory;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.interfaces.XDHKey;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.edec.EdECUtil;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.util.BaseCipherSpi;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.util.IESUtil;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.util.BadBlockException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.util.BCJcaJceHelper;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.util.JcaJceHelper;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jce.spec.IESParameterSpec;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Strings;

public class IESCipher
extends BaseCipherSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private int ivLength;
    private IESEngine engine;
    private int state = -1;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private AlgorithmParameters engineParam = null;
    private IESParameterSpec engineSpec = null;
    private AsymmetricKeyParameter key;
    private SecureRandom random;
    private boolean dhaesMode = false;
    private AsymmetricKeyParameter otherKeyParameter = null;

    public IESCipher(IESEngine iESEngine) {
        this.engine = iESEngine;
        this.ivLength = 0;
    }

    public IESCipher(IESEngine iESEngine, int n2) {
        this.engine = iESEngine;
        this.ivLength = n2;
    }

    @Override
    public int engineGetBlockSize() {
        BufferedBlockCipher bufferedBlockCipher = this.engine.getCipher();
        return bufferedBlockCipher == null ? 0 : bufferedBlockCipher.getBlockSize();
    }

    @Override
    public int engineGetKeySize(Key key) {
        if (key instanceof XDHKey) {
            String string = ((XDHKey)key).getAlgorithm();
            if ("X25519".equalsIgnoreCase(string)) {
                return 256;
            }
            if ("X448".equalsIgnoreCase(string)) {
                return 448;
            }
            throw new IllegalArgumentException("unknown XDH key algorithm " + string);
        }
        throw new IllegalArgumentException("not an XDH key");
    }

    @Override
    public byte[] engineGetIV() {
        if (this.engineSpec != null) {
            return this.engineSpec.getNonce();
        }
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.engineParam == null && this.engineSpec != null) {
            try {
                this.engineParam = this.helper.createAlgorithmParameters("IES");
                this.engineParam.init(this.engineSpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParam;
    }

    @Override
    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NONE")) {
            this.dhaesMode = false;
        } else if (string2.equals("DHAES")) {
            this.dhaesMode = true;
        } else {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    @Override
    public int engineGetOutputSize(int n2) {
        int n3;
        int n4;
        if (this.key == null) {
            throw new IllegalStateException("cipher not initialised");
        }
        int n5 = this.engine.getMac().getMacSize();
        if (this.otherKeyParameter == null) {
            ECCurve eCCurve = ((ECKeyParameters)this.key).getParameters().getCurve();
            int n6 = (eCCurve.getFieldSize() + 7) / 8;
            n4 = 2 * n6;
        } else {
            n4 = 0;
        }
        int n7 = this.buffer.size() + n2;
        if (this.engine.getCipher() == null) {
            n3 = n7;
        } else if (this.state == 1 || this.state == 3) {
            n3 = this.engine.getCipher().getOutputSize(n7);
        } else if (this.state == 2 || this.state == 4) {
            n3 = this.engine.getCipher().getOutputSize(n7 - n5 - n4);
        } else {
            throw new IllegalStateException("cipher not initialised");
        }
        if (this.state == 1 || this.state == 3) {
            return n5 + n4 + n3;
        }
        if (this.state == 2 || this.state == 4) {
            return n3;
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (!(string2.equals("NOPADDING") || string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING"))) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    @Override
    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IESParameterSpec iESParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                iESParameterSpec = algorithmParameters.getParameterSpec(IESParameterSpec.class);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + exception.toString());
            }
        }
        this.engineParam = algorithmParameters;
        this.engineInit(n2, key, iESParameterSpec, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.otherKeyParameter = null;
        if (algorithmParameterSpec == null && this.ivLength == 0) {
            this.engineSpec = IESUtil.guessParameterSpec(this.engine.getCipher(), null);
        } else {
            if (!(algorithmParameterSpec instanceof IESParameterSpec)) throw new InvalidAlgorithmParameterException("must be passed IES parameters");
            this.engineSpec = (IESParameterSpec)algorithmParameterSpec;
        }
        byte[] byArray = this.engineSpec.getNonce();
        if (this.ivLength != 0 && (byArray == null || byArray.length != this.ivLength)) {
            throw new InvalidAlgorithmParameterException("NONCE in IES Parameters needs to be " + this.ivLength + " bytes long");
        }
        if (n2 == 1 || n2 == 3) {
            if (!(key instanceof PublicKey)) throw new InvalidKeyException("must be passed recipient's public XDH key for encryption");
            this.key = EdECUtil.generatePublicKeyParameter((PublicKey)key);
        } else {
            if (n2 != 2 && n2 != 4) throw new InvalidKeyException("must be passed XDH key");
            if (!(key instanceof PrivateKey)) throw new InvalidKeyException("must be passed recipient's private XDH key for decryption");
            this.key = EdECUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        this.random = secureRandom;
        this.state = n2;
        this.buffer.reset();
    }

    @Override
    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("cannot handle supplied parameter spec: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.buffer.write(byArray, n2, n3);
        return null;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.buffer.write(byArray, n2, n3);
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        int n4;
        if (n3 != 0) {
            this.buffer.write(byArray, n2, n3);
        }
        byte[] byArray2 = this.buffer.toByteArray();
        this.buffer.reset();
        CipherParameters cipherParameters = new IESWithCipherParameters(this.engineSpec.getDerivationV(), this.engineSpec.getEncodingV(), this.engineSpec.getMacKeySize(), this.engineSpec.getCipherKeySize());
        byte[] byArray3 = this.engineSpec.getNonce();
        if (byArray3 != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, byArray3);
        }
        if (this.otherKeyParameter != null) {
            try {
                if (this.state == 1 || this.state == 3) {
                    this.engine.init(true, this.otherKeyParameter, this.key, cipherParameters);
                } else {
                    this.engine.init(false, this.key, this.otherKeyParameter, cipherParameters);
                }
                return this.engine.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        final boolean bl2 = this.key instanceof X25519PublicKeyParameters || this.key instanceof X25519PrivateKeyParameters;
        int n5 = n4 = bl2 ? 256 : 448;
        if (this.state == 1 || this.state == 3) {
            AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator = bl2 ? new X25519KeyPairGenerator() : new X448KeyPairGenerator();
            asymmetricCipherKeyPairGenerator.init(new KeyGenerationParameters(this.random, n4));
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(asymmetricCipherKeyPairGenerator, new KeyEncoder(){

                @Override
                public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                    return bl2 ? ((X25519PublicKeyParameters)asymmetricKeyParameter).getEncoded() : ((X448PublicKeyParameters)asymmetricKeyParameter).getEncoded();
                }
            });
            try {
                this.engine.init(this.key, cipherParameters, ephemeralKeyPairGenerator);
                return this.engine.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        if (this.state == 2 || this.state == 4) {
            try {
                this.engine.init(this.key, cipherParameters, new XIESPublicKeyParser(bl2));
                return this.engine.processBlock(byArray2, 0, byArray2.length);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadBlockException("unable to process block", invalidCipherTextException);
            }
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }

    public static class XIES
    extends IESCipher {
        public XIES() {
            this(DigestFactory.createSHA1(), DigestFactory.createSHA1());
        }

        public XIES(Digest digest, Digest digest2) {
            super(new IESEngine(new XDHBasicAgreement(), new KDF2BytesGenerator(digest), new HMac(digest2)));
        }
    }

    public static class XIESwithAESCBC
    extends XIESwithCipher {
        public XIESwithAESCBC() {
            super(CBCBlockCipher.newInstance(AESEngine.newInstance()), 16);
        }
    }

    public static class XIESwithCipher
    extends IESCipher {
        public XIESwithCipher(BlockCipher blockCipher, int n2) {
            this(blockCipher, n2, DigestFactory.createSHA1(), DigestFactory.createSHA1());
        }

        public XIESwithCipher(BlockCipher blockCipher, int n2, Digest digest, Digest digest2) {
            super(new IESEngine(new XDHBasicAgreement(), new KDF2BytesGenerator(digest), new HMac(digest2), new PaddedBufferedBlockCipher(blockCipher)), n2);
        }
    }

    public static class XIESwithDESedeCBC
    extends XIESwithCipher {
        public XIESwithDESedeCBC() {
            super(CBCBlockCipher.newInstance(new DESedeEngine()), 8);
        }
    }

    public static class XIESwithSHA256
    extends XIES {
        public XIESwithSHA256() {
            super(DigestFactory.createSHA256(), DigestFactory.createSHA256());
        }
    }

    public static class XIESwithSHA256andAESCBC
    extends XIESwithCipher {
        public XIESwithSHA256andAESCBC() {
            super(CBCBlockCipher.newInstance(AESEngine.newInstance()), 16, DigestFactory.createSHA256(), DigestFactory.createSHA256());
        }
    }

    public static class XIESwithSHA256andDESedeCBC
    extends XIESwithCipher {
        public XIESwithSHA256andDESedeCBC() {
            super(CBCBlockCipher.newInstance(new DESedeEngine()), 8, DigestFactory.createSHA256(), DigestFactory.createSHA256());
        }
    }

    public static class XIESwithSHA384
    extends XIES {
        public XIESwithSHA384() {
            super(DigestFactory.createSHA384(), DigestFactory.createSHA384());
        }
    }

    public static class XIESwithSHA384andAESCBC
    extends XIESwithCipher {
        public XIESwithSHA384andAESCBC() {
            super(CBCBlockCipher.newInstance(AESEngine.newInstance()), 16, DigestFactory.createSHA384(), DigestFactory.createSHA384());
        }
    }

    public static class XIESwithSHA384andDESedeCBC
    extends XIESwithCipher {
        public XIESwithSHA384andDESedeCBC() {
            super(CBCBlockCipher.newInstance(new DESedeEngine()), 8, DigestFactory.createSHA384(), DigestFactory.createSHA384());
        }
    }

    public static class XIESwithSHA512
    extends XIES {
        public XIESwithSHA512() {
            super(DigestFactory.createSHA512(), DigestFactory.createSHA512());
        }
    }

    public static class XIESwithSHA512andAESCBC
    extends XIESwithCipher {
        public XIESwithSHA512andAESCBC() {
            super(CBCBlockCipher.newInstance(AESEngine.newInstance()), 16, DigestFactory.createSHA512(), DigestFactory.createSHA512());
        }
    }

    public static class XIESwithSHA512andDESedeCBC
    extends XIESwithCipher {
        public XIESwithSHA512andDESedeCBC() {
            super(CBCBlockCipher.newInstance(new DESedeEngine()), 8, DigestFactory.createSHA512(), DigestFactory.createSHA512());
        }
    }
}

