/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.asn1;

import java.io.IOException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1OutputStream;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1String;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1UniversalType;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DEROctetString;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DERUniversalString;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;

public abstract class ASN1UniversalString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1UniversalString.class, 28){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1UniversalString.createPrimitive(dEROctetString.getOctets());
        }
    };
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final byte[] contents;

    public static ASN1UniversalString getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1UniversalString) {
            return (ASN1UniversalString)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1UniversalString) {
            return (ASN1UniversalString)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1UniversalString)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1UniversalString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return (ASN1UniversalString)TYPE.getContextInstance(aSN1TaggedObject, bl2);
    }

    ASN1UniversalString(byte[] byArray, boolean bl2) {
        this.contents = bl2 ? Arrays.clone(byArray) : byArray;
    }

    @Override
    public final String getString() {
        int n2 = this.contents.length;
        StringBuffer stringBuffer = new StringBuffer(3 + 2 * (ASN1OutputStream.getLengthOfDL(n2) + n2));
        stringBuffer.append("#1C");
        ASN1UniversalString.encodeHexDL(stringBuffer, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1UniversalString.encodeHexByte(stringBuffer, this.contents[i2]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }

    public final byte[] getOctets() {
        return Arrays.clone(this.contents);
    }

    @Override
    final boolean encodeConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean bl2) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl2, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl2, 28, this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UniversalString)) {
            return false;
        }
        ASN1UniversalString aSN1UniversalString = (ASN1UniversalString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1UniversalString.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1UniversalString createPrimitive(byte[] byArray) {
        return new DERUniversalString(byArray, false);
    }

    private static void encodeHexByte(StringBuffer stringBuffer, int n2) {
        stringBuffer.append(table[n2 >>> 4 & 0xF]);
        stringBuffer.append(table[n2 & 0xF]);
    }

    private static void encodeHexDL(StringBuffer stringBuffer, int n2) {
        if (n2 < 128) {
            ASN1UniversalString.encodeHexByte(stringBuffer, n2);
            return;
        }
        byte[] byArray = new byte[5];
        int n3 = 5;
        do {
            byArray[--n3] = (byte)n2;
        } while ((n2 >>>= 8) != 0);
        int n4 = byArray.length - n3;
        byArray[--n3] = (byte)(0x80 | n4);
        do {
            ASN1UniversalString.encodeHexByte(stringBuffer, byArray[n3++]);
        } while (n3 < byArray.length);
    }
}

