/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.spi.HttpURLConnection;
import coldfusion.document.spi.core.URLConnectionSettings;
import ice.net.proxy.Proxy;
import ice.storm.ContentLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class CFContentLoader
extends ContentLoader {
    private Proxy proxy;
    private URLConnectionSettings connSettings;
    private static boolean useIce = Boolean.getBoolean("coldfusion.document.useIceHttpConnection");

    public CFContentLoader(URL url, String contentType, Proxy proxy, URLConnectionSettings connSettings) {
        super(url, contentType);
        this.init(proxy, connSettings);
    }

    private void init(Proxy proxy, URLConnectionSettings connSettings) {
        this.proxy = proxy;
        this.connSettings = connSettings;
    }

    public CFContentLoader(String url, String contentType, Proxy proxy, URLConnectionSettings connSettings) {
        super(url, contentType);
        this.init(proxy, connSettings);
    }

    public CFContentLoader(URL base, String loc, String contentType, Proxy proxy, URLConnectionSettings connSettings) {
        super(base, loc, contentType);
        this.init(proxy, connSettings);
    }

    public CFContentLoader(URLConnection urlc, String contentType, Proxy proxy, URLConnectionSettings connSettings) {
        super(urlc, contentType);
        this.init(proxy, connSettings);
    }

    public CFContentLoader(URL base, InputStream in, String contentType, Proxy proxy, URLConnectionSettings connSettings) {
        super(base, in, contentType);
        this.init(proxy, connSettings);
    }

    protected URLConnection openConnection(URL url) throws IOException {
        if (url.getProtocol().equalsIgnoreCase("http") && (this.proxy != null || this.connSettings.getAuthUserName() != null)) {
            if (useIce) {
                ice.net.HttpURLConnection httpURLConnection = new ice.net.HttpURLConnection(url);
                if (this.proxy != null) {
                    httpURLConnection.setProxy(this.proxy);
                }
                return httpURLConnection;
            }
            HttpURLConnection.setCurrentConnectionSettings(this.connSettings);
            HttpURLConnection httpConn = new HttpURLConnection(url);
            httpConn.connect();
            return httpConn;
        }
        return super.openConnection(url);
    }
}

