/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.rds.MetaHeader;
import coldfusion.debugger.rds.RdsHttpResponseFormatter;
import coldfusion.rds.RdsGlobals;
import coldfusion.rds.RdsResponse;
import coldfusion.util.RB;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

class RdsResponseImpl
implements RdsResponse,
RdsGlobals {
    private HttpServletResponse _response;
    private final MetaHeader _meta = new MetaHeader("utf-8");
    private String _errorMessage;
    private boolean _errorOccurred;
    private Throwable _error;
    private int _errorCode = -1;

    RdsResponseImpl() {
    }

    final void init(HttpServletResponse resp) {
        this._response = resp;
    }

    final void finish() throws ServletException, IOException {
        try {
            RdsHttpResponseFormatter formatter = new RdsHttpResponseFormatter();
            if (this.errorOccurred()) {
                formatter.setError(this._errorCode, this._errorMessage, this._error);
            } else {
                Enumeration enum1 = this.enumerateMetaData();
                while (enum1.hasMoreElements()) {
                    Object obj = enum1.nextElement();
                    if (obj instanceof String) {
                        formatter.add((String)obj);
                        continue;
                    }
                    if (obj instanceof byte[]) {
                        formatter.add((byte[])obj);
                        continue;
                    }
                    throw new IOException(RB.getString((Object)this, (String)"RdsServlet.UnsupportedType", (Object)obj.getClass().getName()));
                }
            }
            byte[] bytes = formatter.getMessageBytes();
            this._response.setContentType("text/html");
            ServletOutputStream out = this._response.getOutputStream();
            out.write(bytes);
            out.close();
        }
        catch (IOException e) {
            CFDebuggerLogger.log(e);
            throw e;
        }
        catch (Exception e) {
            CFDebuggerLogger.log(e);
            throw new ServletException((Throwable)e);
        }
    }

    final void reset() {
        this._response = null;
        this._error = null;
        this._errorMessage = null;
        this._errorOccurred = false;
    }

    public final void addMetaData(String metaString) {
        this._meta.add(metaString);
    }

    public final void addMetaData(byte[] metaBytes) {
        this._meta.add(metaBytes);
    }

    public final void setMetaData(int index, String metaString) {
        this._meta.set(index, metaString);
    }

    public final void setMetaData(int index, byte[] metaBytes) {
        this._meta.set(index, metaBytes);
    }

    public final String getMetaString(int index) {
        return this._meta.getString(index);
    }

    public final byte[] getMetaBytes(int index) {
        return this._meta.getBytes(index);
    }

    public final int getMetaCount() {
        return this._meta.size();
    }

    public final Enumeration enumerateMetaData() {
        return this._meta.enumerate();
    }

    public final HttpServletResponse getHttpServletResponse() {
        return this._response;
    }

    public final void setError(int errorCode, String message, Throwable th) {
        this._errorCode = errorCode;
        this._errorMessage = message;
        this._error = th;
        this._errorOccurred = true;
    }

    public final void setError(String message, Throwable th) {
        this.setError(-1, message, th);
    }

    public final void setError(Throwable th) {
        this.setError(-1, th.getMessage(), th);
    }

    public final void setError(String message) {
        this.setError(message, new ServletException(message));
    }

    Throwable getError() {
        return this._error;
    }

    boolean errorOccurred() {
        return this._errorOccurred;
    }
}

