/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.ClientDebugSession;
import coldfusion.debugger.DebugEventHandler;
import coldfusion.debugger.JVMDebugThread;
import coldfusion.debugger.JVMDebugThreadManager;
import com.sun.jdi.Location;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.util.Map;

public class BreakPointHandler
extends DebugEventHandler {
    BreakpointEvent bpEvent;

    public BreakPointHandler(BreakpointEvent event, CFJVMDebugManager debugManager) {
        super(debugManager);
        this.bpEvent = event;
    }

    @Override
    public void handleEvent(Event evt, Map eventContext) throws Throwable {
        BreakpointEvent realBPEvent = (BreakpointEvent)evt;
        LocatableEvent bpe = BreakPointHandler.getLocatableEventForLocation(realBPEvent.location(), realBPEvent);
        Location loc = bpe.location();
        String sourcePath = loc.sourcePath();
        int lineNum = loc.lineNumber();
        JVMDebugThread debugThread = JVMDebugThreadManager.setThread(bpe.thread());
        if (loc.method().declaringType().name().equals("coldfusion.debug.DummyDeubgRequestHandler")) {
            debugThread.onCFRequestEnd();
            return;
        }
        ClientDebugSession clientSession = this.findClientSession(bpe.thread(), bpe, true);
        if (clientSession == null) {
            JVMDebugThread th = JVMDebugThreadManager.getThread(bpe.thread().name());
            if (th != null) {
                th.resumeExecution();
            } else {
                bpe.thread().resume();
            }
            return;
        }
        if (clientSession.isSkipBreakpoint(sourcePath, bpe.thread().name(), lineNum, true)) {
            return;
        }
        JVMDebugThreadManager.setLastLocation(bpe.thread().name(), bpe.location());
        clientSession.onBreakpointHit(bpe);
    }
}

