/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.consumer.AbstractAwsServiceConfigConsumer;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.s3.S3ServiceConfig;
import coldfusion.s3.consumer.S3ConfigurationConsumer;
import coldfusion.s3.consumer.metadata.AWSApacheHttpClientConfigMetadata;
import coldfusion.s3.consumer.metadata.AWSClientOverrideConfigMetadata;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.s3.S3Configuration;

public class S3ServiceConfigConsumer
extends AbstractAwsServiceConfigConsumer<S3ServiceConfig> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private final ValidatorFiller filler = ValidatorFiller.INSTANCE;

    public S3ServiceConfigConsumer() {
        this.put("s3Configuration", new ConsumerValidator((s3ServiceConfig, value) -> {
            Map map = this.cast.getMapProperty(value);
            S3Configuration.Builder builder = S3Configuration.builder();
            this.filler.fillObject((Object)builder, map, (ConsumerMap)new S3ConfigurationConsumer());
        }, Collections.emptyList()));
        this.put("clientOverrideConfig", new ConsumerValidator((awsServiceConfig, val) -> {
            ClientOverrideConfiguration.Builder clientConfigurationBuilder = ClientOverrideConfiguration.builder();
            this.filler.fillObject((Object)clientConfigurationBuilder, FieldTypecastUtil.INSTANCE.getMapProperty(val), AWSClientOverrideConfigMetadata.getInstance().getConsumerMap());
            awsServiceConfig.setClientOverrideConfiguration((ClientOverrideConfiguration)clientConfigurationBuilder.build());
        }, null));
        this.put("httpClientConfig", new ConsumerValidator((filler, val) -> {
            ApacheHttpClient.Builder apacheClientBuilder = ApacheHttpClient.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)apacheClientBuilder, FieldTypecastUtil.INSTANCE.getMapProperty(val), AWSApacheHttpClientConfigMetadata.getInstance().getConsumerMap());
            filler.setHttpClientBuilder(apacheClientBuilder);
        }, null));
    }
}

