/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.consumer.PublicAccessBlockConfigurationConsumer;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.services.s3.model.PublicAccessBlockConfiguration;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockRequest;

public class PutPublicAccessBlockRequestConsumer
extends ConsumerMap<PutPublicAccessBlockRequest.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public PutPublicAccessBlockRequestConsumer() {
        this.put("bucket", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"bucket");
            builder.bucket(input);
        }, Collections.emptyList()));
        this.put("contentMD5", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentMD5");
            builder.contentMD5(input);
        }, Collections.emptyList()));
        this.put("publicAccessBlockConfiguration", new ConsumerValidator((builder, value) -> {
            Map map = this.cast.getMapProperty(value);
            PublicAccessBlockConfiguration.Builder publicAccessBuilder = PublicAccessBlockConfiguration.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)publicAccessBuilder, map, (ConsumerMap)new PublicAccessBlockConfigurationConsumer());
            builder.publicAccessBlockConfiguration((PublicAccessBlockConfiguration)publicAccessBuilder.build());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

