/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Struct;
import coldfusion.s3.consumer.LifecycleExpirationConsumer;
import coldfusion.s3.consumer.LifecycleRuleFilterConsumer;
import coldfusion.s3.consumer.NoncurrentVersionTransitionConsumer;
import coldfusion.s3.consumer.TransitionConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload;
import software.amazon.awssdk.services.s3.model.ExpirationStatus;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;
import software.amazon.awssdk.services.s3.model.LifecycleRule;
import software.amazon.awssdk.services.s3.model.LifecycleRuleFilter;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.Transition;

public class LifecycleRuleConsumer
extends ConsumerMap<LifecycleRule.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static LifecycleRuleConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LifecycleRuleConsumer getInstance() {
        if (instance != null) return instance;
        Class<LifecycleRuleConsumer> clazz = LifecycleRuleConsumer.class;
        synchronized (LifecycleRuleConsumer.class) {
            instance = new LifecycleRuleConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LifecycleRuleConsumer() {
        this.put("id", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"id");
            builder.id(input);
        }, Collections.emptyList()));
        this.put("prefix", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"prefix");
            builder.prefix(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("status", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"status");
            builder.status(ExpirationStatus.valueOf((String)input));
        }, Collections.emptyList()));
        this.put("expiration", new ConsumerValidator((builder, value) -> {
            LifecycleExpiration.Builder expiration = LifecycleExpiration.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)expiration, this.cast.getMapProperty(value), (ConsumerMap)LifecycleExpirationConsumer.getInstance());
            builder.expiration((LifecycleExpiration)expiration.build());
        }, Collections.emptyList()));
        this.put("noncurrentVersionExpirationDays", new ConsumerValidator((builder, value) -> {
            int nonCurrentDays = this.cast.getIntegerProperty(value);
            builder.noncurrentVersionExpiration((NoncurrentVersionExpiration)NoncurrentVersionExpiration.builder().noncurrentDays(Integer.valueOf(nonCurrentDays)).build());
        }, Collections.emptyList()));
        this.put("noncurrentVersionTransitions", new ConsumerValidator((builder, value) -> {
            List list = this.cast.getListProperty(value);
            List noncurrentVersionTransitions = list.stream().map(object -> {
                NoncurrentVersionTransition.Builder transition = NoncurrentVersionTransition.builder();
                ValidatorFiller.INSTANCE.fillObject((Object)transition, this.cast.getMapProperty(object), (ConsumerMap)NoncurrentVersionTransitionConsumer.getInstance());
                return (NoncurrentVersionTransition)transition.build();
            }).collect(Collectors.toList());
            builder.noncurrentVersionTransitions(noncurrentVersionTransitions);
        }, Collections.emptyList()));
        this.put("abortIncompleteMultipartUploadInDays", new ConsumerValidator((builder, value) -> builder.abortIncompleteMultipartUpload((AbortIncompleteMultipartUpload)AbortIncompleteMultipartUpload.builder().daysAfterInitiation(Integer.valueOf(this.cast.getIntegerProperty(value))).build()), Collections.emptyList()));
        this.put("transitions", new ConsumerValidator((builder, value) -> {
            List list = this.cast.getListProperty(value);
            List transitions = list.stream().map(object -> {
                Transition.Builder transition = Transition.builder();
                ValidatorFiller.INSTANCE.fillObject((Object)transition, this.cast.getMapProperty(object), (ConsumerMap)TransitionConsumer.getInstance());
                return (Transition)transition.build();
            }).collect(Collectors.toList());
            builder.transitions(transitions);
        }, Collections.emptyList()));
        this.put("lifecycleRuleFilter", new ConsumerValidator((builder, value) -> {
            LifecycleRuleFilter.Builder lifecycleRuleFilter = LifecycleRuleFilter.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)lifecycleRuleFilter, this.cast.getMapProperty(value), (ConsumerMap)LifecycleRuleFilterConsumer.getInstance());
            builder.filter((LifecycleRuleFilter)lifecycleRuleFilter.build());
        }, Collections.emptyList()));
    }

    public Struct getRuleStruct(LifecycleRule rule) {
        Struct struct = new Struct();
        Optional.ofNullable(rule).ifPresent(lifecycleRule -> {
            struct.put((Object)"id", (Object)rule.id());
            struct.put((Object)"prefix", (Object)rule.prefix());
            if (Objects.nonNull(rule.status())) {
                struct.put((Object)"status", (Object)rule.status().name());
            }
            struct.put((Object)"expiration", (Object)LifecycleExpirationConsumer.getInstance().getLifecycleExpirationStruct(rule.expiration()));
            if (Objects.nonNull(rule.noncurrentVersionExpiration())) {
                struct.put((Object)"noncurrentVersionExpirationDays", (Object)rule.noncurrentVersionExpiration().noncurrentDays());
            }
            struct.put((Object)"noncurrentVersionTransitions", NoncurrentVersionTransitionConsumer.getInstance().getStruct(rule.noncurrentVersionTransitions()));
            if (Objects.nonNull(rule.abortIncompleteMultipartUpload())) {
                struct.put((Object)"abortIncompleteMultipartUploadInDays", (Object)rule.abortIncompleteMultipartUpload().daysAfterInitiation());
            }
            struct.put((Object)"transitions", TransitionConsumer.getInstance().getStruct(rule.transitions()));
            struct.put((Object)"lifecycleRuleFilter", (Object)LifecycleRuleFilterConsumer.getInstance().getStruct(rule.filter()));
        });
        return struct;
    }
}

