/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.presentation;

import coldfusion.document.presentation.core.PresentationExceptions;
import coldfusion.vfs.VFSFileFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.usermodel.HSLFAutoShape;
import org.apache.poi.hslf.usermodel.HSLFBackground;
import org.apache.poi.hslf.usermodel.HSLFFill;
import org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFLine;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.StrokeStyle;
import org.apache.poi.sl.usermodel.TextParagraph;

public class PowerPointProcessor {
    private static final String htmlheader = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
    private static final String htmltop = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO8859-1\" />\n";
    private static final String htmlbottom = "</body>\n</html>\n";
    private static final String htmlstylestart = "<style type=\"text/css\">\n";
    private static final String htmlstyleend = "</style>\n</head>\n<body>\n";
    private String htmlstyle = "";
    private String htmlbody = "";
    private String basepath = "";
    private String directory = null;
    boolean bulletclose = true;
    private int slideno;
    private int picindex = 0;
    private int bulletstyleindex = 0;
    private int shapeindex = 0;
    private int styleindex = 0;
    private int height;
    private int width;
    private HashMap bulletmap = new HashMap();

    private void reset() {
        this.htmlstyle = "";
        this.htmlbody = "";
        this.picindex = 0;
        this.styleindex = 0;
        this.bulletstyleindex = 0;
        this.shapeindex = 0;
    }

    public void setOutputDirectory(File directory) {
        String dirname = directory.getAbsolutePath();
        new File(dirname + "/images").mkdir();
        this.directory = dirname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processPictureData(HSLFPictureData pic, String name, int index) {
        StringBuffer fname = new StringBuffer("");
        FileOutputStream out = null;
        try {
            PictureData.PictureType type = pic.getType();
            byte[] data = pic.getData();
            String ext = "";
            switch (type) {
                case JPEG: {
                    ext = ".jpg";
                    break;
                }
                case PNG: {
                    ext = ".png";
                    break;
                }
                case WMF: {
                    ext = ".wmf";
                    break;
                }
                case EMF: {
                    ext = ".emf";
                    break;
                }
                case PICT: {
                    ext = ".pict";
                    break;
                }
            }
            fname.append(this.getCurrentSlideNumber()).append(name).append("_").append(index).append(ext);
            out = new FileOutputStream(this.directory + "/images/" + fname);
            out.write(data);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return fname.toString();
    }

    protected String getHexString(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    protected int getFontPercent(int size) {
        int ref = 16;
        return 100 * size / ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLine(HSLFShape s) {
        FileOutputStream out = null;
        try {
            HSLFLine l = (HSLFLine)s;
            Rectangle a = l.getAnchor().getBounds();
            double w = Math.max(a.getWidth(), l.getLineWidth());
            double h = Math.max(a.getHeight(), l.getLineWidth());
            int x = a.x;
            int y = a.y;
            BufferedImage img = new BufferedImage((int)Math.round(w), (int)Math.round(h), 2);
            Graphics2D graphics = img.createGraphics();
            Color fillcolor = null;
            fillcolor = l.getFillColor();
            String fontcolorInHex = "#000000";
            if (fillcolor != null) {
                fontcolorInHex = this.getHexString(fillcolor);
            } else {
                Color linecolor = l.getLineColor();
                fontcolorInHex = this.getHexString(linecolor);
            }
            double linew = l.getLineWidth();
            StrokeStyle.LineDash dashing = l.getLineDash();
            String pos = "border-top";
            pos = w > h ? "border-top:" : "border-left:";
            StringBuffer divstart = new StringBuffer("<div style='position:absolute;top:").append(y).append("pt;left:").append(x).append("pt;").append("width:").append(w).append("pt;height:").append(h).append("pt;").append(pos).append(linew).append("px solid ").append(fontcolorInHex).append("'>");
            String divend = "</div>";
            String temphtml = "";
            temphtml = divstart + temphtml + divend;
            this.htmlbody = this.htmlbody + temphtml;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String processRichTextRuns(HSLFTextRun rt) {
        PaintStyle.SolidPaint fontcolor = rt.getFontColor();
        String fontname = rt.getFontFamily();
        int fontsize = rt.getFontSize().intValue();
        int indentlevel = rt.getTextParagraph().getIndentLevel();
        boolean bold = rt.isBold();
        boolean italic = rt.isItalic();
        boolean shadowed = rt.isShadowed();
        boolean strikethrough = rt.isStrikethrough();
        boolean underlined = rt.isUnderlined();
        HSLFTextShape ts = rt.getTextParagraph().getParentShape();
        String text = ts.getText();
        String textsave = ts.getText();
        TextParagraph.TextAlign alignment = rt.getTextParagraph().getTextAlign();
        String alignmentstring = "";
        if (alignment != null) {
            switch (alignment) {
                case LEFT: {
                    alignmentstring = "left";
                    break;
                }
                case CENTER: {
                    alignmentstring = "center";
                    break;
                }
                case RIGHT: {
                    alignmentstring = "right";
                    break;
                }
                default: {
                    alignmentstring = "";
                }
            }
        }
        String divstart = "";
        String divend = "";
        boolean adddiv = false;
        if (!alignmentstring.equalsIgnoreCase("") && !alignmentstring.equalsIgnoreCase("left")) {
            adddiv = true;
            ++this.styleindex;
            String divstyle = "\n<!-- .style" + this.styleindex + " {\ntext-align:" + alignmentstring + ";\n}\n";
            this.htmlstyle = this.htmlstyle + divstyle;
            divstart = "<div class='style" + this.styleindex + "'>";
            divend = "</div>";
        }
        String fontcolorInHex = this.getHexString(fontcolor.getSolidColor().getColor());
        ++this.styleindex;
        String temphtml = "<!--\n.style" + this.styleindex + " {\n\tfont-family: \"" + fontname + "\";\n\tfont-size: " + fontsize + "px;\n\tcolor: " + fontcolorInHex + ";\n\ttext-align: " + alignmentstring + ";\n\ttext-indent: " + indentlevel + "pt;\n";
        if (text.contains("\t")) {
            temphtml = temphtml + "\twhite-space: pre;\n\twhite-space: pre-wrap;\n\twidth: 2em;\n";
        }
        temphtml = temphtml + "} \n-->\n";
        this.htmlstyle = this.htmlstyle + temphtml;
        String stylename = "style" + this.styleindex;
        String bf = "";
        if (!text.trim().equalsIgnoreCase("")) {
            int i;
            Object s;
            text = text.replaceAll(" ", "&nbsp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
            text = text.replaceAll("\t", "&#09;");
            textsave = textsave.replaceAll(" ", "&nbsp;");
            textsave = textsave.replaceAll("<", "&lt;");
            textsave = textsave.replaceAll(">", "&gt;");
            textsave = textsave.replaceAll("\t", "&#09;");
            if (rt.getTextParagraph().isBullet()) {
                bf = this.getBulletFormat(rt);
                if (textsave.contains("\n")) {
                    s = textsave.split("\n");
                    for (i = 0; i < ((String[])s).length; ++i) {
                        this.bulletmap.put(s[i], bf);
                    }
                } else {
                    this.bulletmap.put(textsave.trim(), bf);
                }
            }
            if (textsave.contains("\n")) {
                String tempsave;
                String[] temp = textsave.split("\n");
                for (i = 0; i < temp.length; ++i) {
                    tempsave = temp[i];
                    if (tempsave.equalsIgnoreCase("")) continue;
                    temp[i] = Matcher.quoteReplacement(temp[i]);
                    temp[i] = adddiv ? divstart + "<span class='" + stylename + "'>" + temp[i] + "</span>" + divend : "<span class='" + stylename + "'>" + temp[i] + "</span>";
                    text = text.replaceAll("\\Q" + tempsave + "\\E", temp[i]);
                }
                if (strikethrough || underlined || bold || italic || indentlevel > 0) {
                    temp = textsave.split("\n");
                    for (i = 0; i < temp.length; ++i) {
                        tempsave = temp[i];
                        if (tempsave.equalsIgnoreCase("")) continue;
                        temp[i] = Matcher.quoteReplacement(temp[i]);
                        if (strikethrough) {
                            temp[i] = "<s>" + temp[i] + "</s>";
                        }
                        if (bold) {
                            temp[i] = "<strong>" + temp[i] + "</strong>";
                        }
                        if (underlined) {
                            temp[i] = "<u>" + temp[i] + "</u>";
                        }
                        if (italic) {
                            temp[i] = "<em>" + temp[i] + "</em>";
                        }
                        if (!rt.getTextParagraph().isBullet()) {
                            String s2 = "";
                            for (int j = 0; j < indentlevel; ++j) {
                                s2 = s2 + "&nbsp;";
                            }
                            temp[i] = s2 + temp[i];
                        }
                        text = text.replaceAll("\\Q" + tempsave + "\\E", temp[i]);
                    }
                }
            } else {
                if (strikethrough) {
                    text = "<s>" + text + "</s>";
                }
                if (bold) {
                    text = "<strong>" + text + "</strong>";
                }
                if (underlined) {
                    text = "<u>" + text + "</u>";
                }
                if (italic) {
                    text = "<em>" + text + "</em>";
                }
                text = adddiv ? divstart + "<span class='" + stylename + "'>" + text + "</span>" + divend : "<span class='" + stylename + "'>" + text + "</span>";
                if (!rt.getTextParagraph().isBullet()) {
                    s = "";
                    for (int j = 0; j < indentlevel; ++j) {
                        s = (String)s + "&nbsp;";
                    }
                    text = (String)s + text;
                }
            }
        }
        return text;
    }

    private String getBulletFormat(HSLFTextRun rt) {
        String bulletstylehtml = "";
        String a = "";
        int bulletoffset = 0;
        int fontsize = rt.getFontSize().intValue();
        char c = rt.getTextParagraph().getBulletChar().charValue();
        a = Integer.toHexString(c);
        Color bulletcolor = rt.getFontColor().getSolidColor().getColor();
        bulletoffset = rt.getTextParagraph().getIndent().intValue();
        String c1 = this.getHexString(bulletcolor);
        ++this.bulletstyleindex;
        bulletstylehtml = "<!-- .bulletstyle" + this.bulletstyleindex + "{\nfont-size: " + fontsize + "px;color: " + c1 + ";} -->\n";
        this.htmlstyle = this.htmlstyle + bulletstylehtml;
        String s = "";
        for (int i = 0; i < bulletoffset / 4; ++i) {
            s = s + "&nbsp;";
        }
        return s + "<span class='bulletstyle" + this.bulletstyleindex + "'>&#x" + a + ";&nbsp;</span>";
    }

    private void processTextRun(HSLFTextRun r, double x, double y, int h, int w) {
        List runs = r.getTextParagraph().getTextRuns();
        StringBuffer divstart = new StringBuffer("<div style='position:absolute;top:").append(y).append("pt;left:").append(x).append("pt;").append("width:").append(w).append("pt;height:").append(h).append("pt'>");
        String divend = "</div>\n";
        String temphtml = "";
        String fulltext = "";
        this.bulletmap.clear();
        for (int i = 0; i < runs.size(); ++i) {
            HSLFTextRun run = (HSLFTextRun)runs.get(i);
            if (run.getTextParagraph().getParentShape().getText().equalsIgnoreCase(" ") && run.getLength() <= 1) continue;
            fulltext = fulltext + this.processRichTextRuns(run);
        }
        if (this.bulletmap.size() > 0) {
            String[] temp = fulltext.split("\n");
            for (int i = 0; i < temp.length; ++i) {
                String bulletstyle;
                String orig = temp[i];
                String[] s = temp[i].split("</");
                String pattern = "<span class='style[0-9]*'>[\\s]*(<[a-z,A-Z]*>[\\s]*)*(.*)[<.*>]*";
                Pattern p = Pattern.compile(pattern);
                Matcher m = p.matcher(s[0]);
                String strippedtext = "";
                String replacetext = "";
                if (m.find()) {
                    strippedtext = m.group(2);
                    replacetext = m.group(0);
                }
                if (strippedtext.equalsIgnoreCase("") || (bulletstyle = (String)this.bulletmap.get(strippedtext)) == null) continue;
                temp[i] = temp[i].replaceAll("\\Q" + replacetext + "\\E", Matcher.quoteReplacement(bulletstyle + replacetext));
                fulltext = fulltext.replaceAll("\\Q" + orig + "\\E", Matcher.quoteReplacement(temp[i]));
            }
        }
        fulltext = fulltext.replaceAll("\n", "<br/>");
        temphtml = divstart + fulltext + divend;
        String text = r.getTextParagraph().getParentShape().getText();
        List links = r.getTextParagraph().getParentShape().getHyperlinks();
        if (links != null) {
            for (int i = 0; i < links.size(); ++i) {
                HSLFHyperlink link = (HSLFHyperlink)links.get(i);
                String title = link.getLabel();
                String address = link.getAddress();
                String substring = text.substring(link.getStartIndex(), link.getEndIndex());
                String htmlhref = "<a href=\"" + address + "\">" + title + "</a>";
                temphtml = temphtml.replaceAll(substring, htmlhref);
            }
        }
        this.htmlbody = this.htmlbody + "\n<br/>\n" + temphtml + "\n";
    }

    private void processBGFill(HSLFFill fill) {
        HSLFPictureData pic = fill.getPictureData();
        fill.getFillType();
        Color fgcolor = fill.getForegroundColor();
        String bgstyle = "";
        String bgstylestart = "\nbody{ ";
        String bgstyleend = "\n}\n";
        if (fgcolor != null) {
            String color = this.getHexString(fgcolor);
            bgstyle = "background-color: " + color + " ;\n";
        }
        if (pic != null) {
            String filename = this.processPictureData(pic, "name", this.picindex);
            bgstyle = bgstyle + "background-image: url(images/" + filename + ");\n";
            bgstyle = bgstyle + "background-repeat: no-repeat;\n";
            bgstyle = bgstyle + "background-position-x: center;\n";
            bgstyle = bgstyle + "background-position-y: top;\n";
        }
        if (!bgstyle.equalsIgnoreCase("")) {
            bgstyle = bgstylestart + bgstyle + bgstyleend;
        }
        this.htmlstyle = this.htmlstyle + bgstyle;
    }

    private void processFill(HSLFFill fill) {
        String bgstyle = "";
        HSLFPictureData pic = fill.getPictureData();
        if (pic != null) {
            String string = this.processPictureData(pic, "name", this.picindex);
        }
        Color fgfillcolor = fill.getForegroundColor();
        Color bgfillcolor = fill.getBackgroundColor();
        if (fgfillcolor != null || bgfillcolor != null) {
            bgstyle = "\nbody { background: ";
        }
        if (fgfillcolor != null) {
            String fgcolor = this.getHexString(fgfillcolor);
            bgstyle = bgstyle + "foreground-color:" + fgcolor + ";";
        }
        if (bgfillcolor != null) {
            String bgcolor = this.getHexString(bgfillcolor);
            bgstyle = bgstyle + "background-color:" + bgcolor + ";";
        }
        bgstyle = bgstyle + "}\n";
        int filltype = fill.getFillType();
        switch (filltype) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    private void processTextBox(HSLFTextBox textbox) {
        HSLFTextRun textrun;
        HSLFFill f = textbox.getFill();
        Rectangle rect = textbox.getAnchor().getBounds();
        double x = rect.getX();
        double y = rect.getY();
        int w = rect.width;
        int h = rect.height;
        if (f != null) {
            this.processFill(f);
        }
        if ((textrun = (HSLFTextRun)((HSLFTextParagraph)textbox.getTextParagraphs().get(0)).getTextRuns().get(0)) != null) {
            this.processTextRun(textrun, x, y, rect.height, rect.width);
        }
    }

    private String getLineStyle(int style) {
        return "";
    }

    private void processTableCell(HSLFTableCell tableCell) {
        HSLFFill fill = tableCell.getFill();
        if (fill != null) {
            this.processFill(fill);
        }
        Rectangle r = tableCell.getAnchor().getBounds();
        double x = r.getX();
        double y = r.getY();
        StrokeStyle linestyle = tableCell.getStrokeStyle();
        HSLFTextRun text = (HSLFTextRun)((HSLFTextParagraph)tableCell.getTextParagraphs().get(0)).getTextRuns().get(0);
        if (text != null) {
            this.processTextRun(text, x, y, r.height, r.width);
        }
    }

    private void processRectangle(HSLFAutoShape rect) {
        HSLFFill fill = rect.getFill();
        if (fill != null) {
            this.processFill(fill);
        }
        Rectangle r = rect.getAnchor().getBounds();
        double x = r.getX();
        double y = r.getY();
        StrokeStyle linestyle = rect.getStrokeStyle();
        HSLFTextRun text = (HSLFTextRun)((HSLFTextParagraph)rect.getTextParagraphs().get(0)).getTextRuns().get(0);
        if (text != null) {
            this.processTextRun(text, x, y, r.height, r.width);
        }
    }

    private void processBackground(HSLFBackground bg) {
        HSLFFill bgfill = bg.getFill();
        this.processBGFill(bgfill);
    }

    private String getImageHTML(String name, double x, double y, int w, int h) {
        StringBuffer divstart = new StringBuffer("<div style='position:absolute;top:").append(y).append("pt;left:").append(x).append("pt;").append("width:").append(w).append("pt;height:").append(h).append("pt'>");
        String divend = "</div>";
        StringBuffer str = new StringBuffer("<img src='images/").append(name).append("' width=").append(w).append(" height=").append(h).append("/>");
        divstart.append(str).append(divend);
        return divstart.toString();
    }

    private void processRectangle(HSLFShape s) {
        try {
            HSLFAutoShape autos = (HSLFAutoShape)s;
            Rectangle a = autos.getAnchor().getBounds();
            int w = a.width;
            int h = a.height;
            double x = a.getX();
            double y = a.getY();
            HSLFTextRun r = (HSLFTextRun)((HSLFTextParagraph)autos.getTextParagraphs().get(0)).getTextRuns().get(0);
            if (r != null) {
                this.processTextRun(r, x, y, h, w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void markPoint(Path2D path, float x, float y) {
        path.moveTo(x, y);
        path.lineTo(x, y);
        path.lineTo(x, y);
        path.lineTo(x, y);
        path.closePath();
    }

    public Shape createStrokedShape(HSLFFreeformShape shape, float strokewidth, AffineTransform tx) {
        Path2D strokedShape = shape.getPath();
        float[] coords = new float[6];
        PathIterator i = shape.getPath().getPathIterator(null);
        while (!i.isDone()) {
            int type = i.currentSegment(coords);
            switch (type) {
                case 3: {
                    this.markPoint(strokedShape, coords[4], coords[5]);
                }
                case 2: {
                    this.markPoint(strokedShape, coords[2], coords[3]);
                }
                case 0: 
                case 1: {
                    this.markPoint(strokedShape, coords[0], coords[1]);
                }
            }
            i.next();
        }
        return strokedShape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAutoShape(HSLFShape s) {
        FileOutputStream out = null;
        try {
            HSLFAutoShape autoshape = (HSLFAutoShape)s;
            Rectangle a = autoshape.getAnchor().getBounds();
            int w = a.width;
            int h = a.height;
            double x = a.getX();
            double y = a.getY();
            BufferedImage img = new BufferedImage(w, h, 2);
            Graphics2D graphics = img.createGraphics();
            double linew = autoshape.getLineWidth();
            BasicStroke stroke = new BasicStroke((float)linew);
            graphics.setStroke(stroke);
            Color c = autoshape.getFillColor();
            Color linecolor = autoshape.getLineColor();
            if (c != null) {
                graphics.setColor(c);
            } else {
                graphics.setColor(linecolor);
            }
            ++this.shapeindex;
            String name = "Slide_" + this.slideno + "_shape_" + this.shapeindex + ".png";
            String fname = this.directory + "/images/" + name;
            out = new FileOutputStream(fname);
            ImageIO.write((RenderedImage)img, "png", out);
            graphics.dispose();
            StringBuffer divstart = new StringBuffer("<div style='position:absolute;top:").append(y).append("pt;left:").append(x).append("pt;").append("width:").append(w).append("pt;height:").append(h).append("pt'>");
            String divend = "</div>";
            String temphtml = "<img src='images/" + name + "' width=" + w + " height=" + h + "/>";
            temphtml = divstart + temphtml + divend;
            this.htmlbody = this.htmlbody + temphtml;
            HSLFTextRun r = (HSLFTextRun)((HSLFTextParagraph)autoshape.getTextParagraphs().get(0)).getTextRuns().get(0);
            if (r != null) {
                this.processTextRun(r, x, y, h, w);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void processShape(HSLFShape s) {
        ShapeType type = s.getShapeType();
        Rectangle anchor = s.getAnchor().getBounds();
        double x = anchor.getX();
        double y = anchor.getY();
        int w = anchor.width;
        int h = anchor.height;
        if (type == ShapeType.FRAME || s instanceof HSLFPictureShape) {
            HSLFPictureShape pict = (HSLFPictureShape)s;
            HSLFPictureData pic = pict.getPictureData();
            if (pic != null) {
                String name;
                String picname = pict.getPictureName();
                if (picname != null) {
                    int index = picname.lastIndexOf(92);
                    if (index != -1) {
                        picname = picname.substring(index + 1, picname.length());
                    }
                    name = this.processPictureData(pic, picname, pict.getPictureIndex());
                } else {
                    name = this.processPictureData(pic, "image", this.picindex);
                }
                String temphtml = this.getImageHTML(name, x, y, w, h);
                this.htmlbody = this.htmlbody + "<BR/>\n" + temphtml + "\n";
            }
        } else if (type == ShapeType.TEXT_BOX) {
            HSLFTextBox textbox = (HSLFTextBox)s;
            this.processTextBox(textbox);
        } else if (type == ShapeType.RECT) {
            if (s instanceof HSLFAutoShape) {
                HSLFAutoShape rect = (HSLFAutoShape)s;
                this.processRectangle(rect);
            } else if (s instanceof HSLFTableCell) {
                HSLFTableCell tableCell = (HSLFTableCell)s;
                this.processTableCell(tableCell);
            }
        } else if (type == ShapeType.LINE) {
            this.processLine(s);
        } else if (type == ShapeType.NOT_PRIMITIVE) {
            if (s instanceof HSLFGroupShape) {
                HSLFGroupShape shapegroup = (HSLFGroupShape)s;
                List shapes = shapegroup.getShapes();
                for (int i = 0; i < shapes.size(); ++i) {
                    this.processShape((HSLFShape)shapes.get(i));
                }
            }
        } else if (s instanceof HSLFAutoShape) {
            this.processAutoShape(s);
        } else {
            System.out.println(" shape name not processed " + s.getShapeName() + " of class " + s.toString() + " in slide " + this.slideno);
        }
    }

    private void setCurrentSlideNumber(int slideno) {
        this.slideno = slideno;
    }

    private int getCurrentSlideNumber() {
        return this.slideno;
    }

    private void setPageWidth(int width) {
        this.width = width;
    }

    private void setPageHeight(int height) {
        this.height = height;
    }

    public int getPageHeight() {
        return this.height;
    }

    public int getPageWidth() {
        return this.width;
    }

    public static String getBaseName(File fname) {
        String name = fname.getName();
        int tindex = name.indexOf(".");
        return name.substring(0, tindex);
    }

    public String processPPTSlide(HSLFSlide s, int slidenumber) {
        this.reset();
        this.setCurrentSlideNumber(slidenumber);
        HSLFBackground bg = s.getBackground();
        this.processBackground(bg);
        List shapes = s.getShapes();
        for (int j = 0; j < shapes.size(); ++j) {
            HSLFShape slideshape = (HSLFShape)shapes.get(j);
            this.processShape(slideshape);
        }
        return this.buildHTMLString();
    }

    public String processPPT(File pptfile, int slidenumber) {
        String htmlstring = "";
        FileInputStream is = null;
        try {
            this.setPath(pptfile);
            is = new FileInputStream(pptfile);
            HSLFSlideShow ppt = new HSLFSlideShow((InputStream)is);
            Dimension d = ppt.getPageSize();
            this.setPageWidth((int)d.getWidth());
            this.setPageHeight((int)d.getHeight());
            List slides = ppt.getSlides();
            HSLFSlide s = (HSLFSlide)slides.get(slidenumber - 1);
            htmlstring = this.processPPTSlide(s, slidenumber - 1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new PresentationExceptions.InvalidSlideNumberException(slidenumber);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new PresentationExceptions.InvalidSlideNumberException(slidenumber);
        }
        catch (Exception e) {
            throw new PresentationExceptions.PowerPointProcessorException(e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return htmlstring;
    }

    public String[] processPPT(File pptfile) {
        HSLFSlideShow ppt;
        String[] html_slides = new String[]{};
        FileInputStream is = null;
        try {
            is = (FileInputStream)VFSFileFactory.getInputStream((File)pptfile);
            ppt = new HSLFSlideShow((InputStream)is);
        }
        catch (Exception e) {
            throw new PresentationExceptions.PowerPointProcessorException(e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        List slides = ppt.getSlides();
        String basename = PowerPointProcessor.getBaseName(pptfile);
        Dimension d = ppt.getPageSize();
        this.setPageWidth((int)d.getWidth());
        this.setPageHeight((int)d.getHeight());
        if (this.directory == null) {
            this.setDefaultDirectory(pptfile, basename);
        }
        html_slides = new String[slides.size()];
        for (int i = 0; i < slides.size(); ++i) {
            html_slides[i] = this.processPPTSlide((HSLFSlide)slides.get(i), i);
        }
        return html_slides;
    }

    private void setDefaultDirectory(File file, String basename) {
        this.setPath(file);
        this.directory = this.basepath + "/htmlfiles/" + basename;
    }

    private String buildHTMLString() {
        StringBuffer htmlbuffer = new StringBuffer(htmlheader).append(htmltop).append(htmlstylestart).append(this.htmlstyle).append(htmlstyleend).append(this.htmlbody).append(htmlbottom);
        return htmlbuffer.toString();
    }

    protected void setPath(File file) {
        this.basepath = file.getParentFile().getAbsolutePath();
    }
}

