/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange;

import coldfusion.exchange.webdav.Utils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class RecurrenceInfo {
    public static final int DAILY = 1;
    public static final int WEEKLY = 2;
    public static final int MONTHLY = 3;
    public static final int YEARLY = 4;
    public static final int RECURR_NO_END_DATE = 1;
    public static final int RECURR_END_AFTER_COUNT = 2;
    public static final int RECURR_END_BY_DATE = 3;
    private int recurrenceRangeType = 1;
    private int recurrencePatternType = 1;
    private boolean noRecurrenceEndDate;
    private int endRecurrenceAfterCount;
    private Date endRecurrenceByDate = null;
    private int everyNumDays = 1;
    private boolean everyWeekday = false;
    private int everyNumWeeks = 1;
    private String weekDays = null;
    private int everyNumMonths = 1;
    private String recurrenceWeek = null;
    private String weeklyRecurranceDay = null;
    private int recurranceMonth = 1;

    public int getRecurranceMonth() {
        return this.recurranceMonth;
    }

    public String getRecurrenceWeek() {
        return this.recurrenceWeek;
    }

    public String getWeeklyRecurranceDay() {
        return this.weeklyRecurranceDay;
    }

    public void setRecurranceMonth(int recurranceMonth) {
        this.recurranceMonth = recurranceMonth;
    }

    public void setRecurrenceWeek(String recurrenceWeek) {
        this.recurrenceWeek = recurrenceWeek;
    }

    public void setWeeklyRecurranceDay(String weeklyRecurranceDay) {
        this.weeklyRecurranceDay = weeklyRecurranceDay;
    }

    public int getRecurrenceRangeType() {
        return this.recurrenceRangeType;
    }

    public int getRecurrencePatternType() {
        return this.recurrencePatternType;
    }

    public int getEndRecurrenceAfterCount() {
        return this.endRecurrenceAfterCount;
    }

    public Date getEndRecurrenceByDate() {
        return this.endRecurrenceByDate;
    }

    public boolean isNoRecurrenceEndDate() {
        return this.noRecurrenceEndDate;
    }

    public void setEndRecurrenceAfterCount(int endRecurrenceAfterCount) {
        this.recurrenceRangeType = 2;
        this.endRecurrenceByDate = null;
        this.noRecurrenceEndDate = false;
        this.endRecurrenceAfterCount = endRecurrenceAfterCount;
    }

    public void setEndRecurrenceByDate(Date endRecurrenceByDate) {
        this.recurrenceRangeType = 3;
        this.endRecurrenceByDate = endRecurrenceByDate;
        this.noRecurrenceEndDate = false;
        this.endRecurrenceAfterCount = -1;
    }

    public void setNoRecurrenceEndDate() {
        this.recurrenceRangeType = 1;
        this.noRecurrenceEndDate = true;
        this.endRecurrenceAfterCount = -1;
        this.endRecurrenceByDate = null;
    }

    public void setDailyRecurrence(int everyNumDays) {
        this.recurrencePatternType = 1;
        this.everyNumDays = everyNumDays;
        this.everyWeekday = false;
    }

    public void setRecurrenceEveryWeekDay() {
        this.recurrencePatternType = 1;
        this.everyWeekday = true;
    }

    public void setWeeklyRecurrence(int everyNumWeeks, String weekDays) {
        this.recurrencePatternType = 2;
        this.everyNumWeeks = everyNumWeeks;
        this.weekDays = weekDays;
    }

    public void setMonthlyRecurrence(int everyNumMonths) {
        this.recurrencePatternType = 3;
        this.everyNumMonths = everyNumMonths;
    }

    public void setMonthlyRecurrence(String weekNum, String weekDay, int monthFreq) {
        this.recurrencePatternType = 3;
        this.recurrenceWeek = weekNum;
        this.weekDays = weekDay;
        this.everyNumMonths = monthFreq;
    }

    public void setYearlyRecurrence(String weekNum, String weekDay, int recurrMonth) {
        this.recurrencePatternType = 4;
        this.recurrenceWeek = weekNum;
        this.weekDays = weekDay;
        this.recurranceMonth = recurrMonth;
    }

    public void setYearlyRecurrence() {
        this.recurrencePatternType = 4;
    }

    public int getEveryNumDays() {
        return this.everyNumDays;
    }

    public int getEveryNumMonths() {
        return this.everyNumMonths;
    }

    public int getEveryNumWeeks() {
        return this.everyNumWeeks;
    }

    public boolean isEveryWeekday() {
        return this.everyWeekday;
    }

    public String getRecurrenceWeekDays() {
        return this.weekDays;
    }

    public Object[] recurrenceInfoToRuleString(Date startDate, Date endDate) {
        String infoStr = "";
        Date aNewStartDate = null;
        String[] weekDays = new String[]{"MO", "TU", "WE", "TH", "FR", "SA", "SU"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        switch (this.getRecurrencePatternType()) {
            case 1: {
                infoStr = "FREQ=DAILY;";
                if (this.isEveryWeekday()) {
                    infoStr = infoStr + "INTERVAL=1;BYDAY=MO, TU, WE, TH, FR;";
                    break;
                }
                infoStr = infoStr + "INTERVAL=" + this.getEveryNumDays() + ";";
                break;
            }
            case 2: {
                infoStr = infoStr + "FREQ=WEEKLY;INTERVAL=" + this.getEveryNumWeeks() + ";BYDAY=" + this.getRecurrenceWeekDays() + ";";
                break;
            }
            case 3: {
                String strWeekNum;
                if (this.getRecurrenceWeek() != null) {
                    strWeekNum = this.getRecurrenceWeek();
                    String weekDay = this.getRecurrenceWeekDays();
                    if (weekDay == null) {
                        int day = startDate.getDay();
                        weekDay = weekDays[day - 1];
                    }
                    int weekNum = 1;
                    if (strWeekNum.equalsIgnoreCase("second")) {
                        weekNum = 2;
                    } else if (strWeekNum.equalsIgnoreCase("third")) {
                        weekNum = 3;
                    } else if (strWeekNum.equalsIgnoreCase("fourth")) {
                        weekNum = 4;
                    } else if (strWeekNum.equalsIgnoreCase("last")) {
                        weekNum = -1;
                    }
                    infoStr = infoStr + "FREQ=MONTHLY;INTERVAL=" + this.getEveryNumMonths() + ";BYDAY=" + weekNum + weekDay + ";";
                    aNewStartDate = RecurrenceInfo.validateRecurrenceStartDate(startDate, strWeekNum, weekDay);
                    break;
                }
                infoStr = infoStr + "FREQ=MONTHLY;INTERVAL=" + this.getEveryNumMonths() + ";BYMONTHDAY=" + cal.get(5) + ";";
                break;
            }
            case 4: {
                String strWeekNum;
                if (this.getRecurrenceWeek() != null) {
                    strWeekNum = this.getRecurrenceWeek();
                    int recurrMonth = this.getRecurranceMonth();
                    String weekDay = this.getRecurrenceWeekDays();
                    if (weekDay == null) {
                        int day = startDate.getDay();
                        weekDay = weekDays[day - 1];
                    }
                    int weekNum = 1;
                    if (strWeekNum.equalsIgnoreCase("second")) {
                        weekNum = 2;
                    } else if (strWeekNum.equalsIgnoreCase("third")) {
                        weekNum = 3;
                    } else if (strWeekNum.equalsIgnoreCase("fourth")) {
                        weekNum = 4;
                    } else if (strWeekNum.equalsIgnoreCase("last")) {
                        weekNum = -1;
                    }
                    infoStr = infoStr + "FREQ=YEARLY;INTERVAL=1;BYMONTH=" + recurrMonth + ";BYDAY=" + weekNum + weekDay + ";";
                    aNewStartDate = RecurrenceInfo.validateRecurrenceStartDate(startDate, strWeekNum, weekDay, recurrMonth);
                    break;
                }
                infoStr = infoStr + "FREQ=YEARLY;INTERVAL=1;BYMONTHDAY=" + cal.get(5) + ";BYMONTH=" + (cal.get(2) + 1) + ";";
            }
        }
        switch (this.getRecurrenceRangeType()) {
            case 1: {
                break;
            }
            case 3: {
                Date recurEndDate = this.getEndRecurrenceByDate();
                if (recurEndDate.getHours() != 23) {
                    recurEndDate.setHours(23);
                    recurEndDate.setMinutes(59);
                    recurEndDate.setSeconds(59);
                }
                String endDateStr = Utils.localDateToRuleDateString(recurEndDate);
                infoStr = infoStr + "UNTIL=" + endDateStr + ";";
                break;
            }
            case 2: {
                infoStr = infoStr + "COUNT=" + this.getEndRecurrenceAfterCount() + ";";
            }
        }
        infoStr = infoStr + "WKST=SU";
        String xmlRecurInfo = "<cal:rrule dt:dt=\"mv.string\"><x:v>" + infoStr + "</x:v></cal:rrule>";
        return new Object[]{xmlRecurInfo, aNewStartDate};
    }

    public static Date validateRecurrenceStartDate(Date startDate, String week, String weekDay, int month) {
        GregorianCalendar aDateCal = new GregorianCalendar();
        aDateCal.setTime(startDate);
        int aDateMonth = aDateCal.get(2);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        int requiredMonth = month - 1;
        cal.set(2, requiredMonth);
        cal.set(1, aDateCal.get(1));
        if (requiredMonth < aDateMonth) {
            ((Calendar)cal).roll(1, true);
        }
        if (weekDay.equalsIgnoreCase("MO")) {
            cal.set(7, 2);
        } else if (weekDay.equalsIgnoreCase("TU")) {
            cal.set(7, 3);
        } else if (weekDay.equalsIgnoreCase("WE")) {
            cal.set(7, 4);
        } else if (weekDay.equalsIgnoreCase("TH")) {
            cal.set(7, 5);
        } else if (weekDay.equalsIgnoreCase("FR")) {
            cal.set(7, 6);
        } else if (weekDay.equalsIgnoreCase("SA")) {
            cal.set(7, 7);
        } else if (weekDay.equalsIgnoreCase("SU")) {
            cal.set(7, 1);
        } else {
            throw new IllegalArgumentException();
        }
        int requiredWeek = 1;
        if (week.equalsIgnoreCase("first")) {
            requiredWeek = 1;
        } else if (week.equalsIgnoreCase("second")) {
            requiredWeek = 2;
        } else if (week.equalsIgnoreCase("third")) {
            requiredWeek = 3;
        } else if (week.equalsIgnoreCase("fourth") || week.equalsIgnoreCase("last")) {
            requiredWeek = 4;
        } else {
            throw new IllegalArgumentException();
        }
        cal.set(8, requiredWeek);
        if (requiredWeek == 4 && cal.get(5) + 7 <= ((Calendar)cal).getActualMaximum(5)) {
            ((Calendar)cal).roll(5, 7);
        }
        if (startDate.after(cal.getTime())) {
            cal.set(5, 1);
            ((Calendar)cal).roll(1, true);
            return RecurrenceInfo.validateRecurrenceStartDate(cal.getTime(), week, weekDay, month);
        }
        return cal.getTime();
    }

    public static Date validateRecurrenceStartDate(Date startDate, String week, String weekDay) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startDate);
        if (weekDay.equalsIgnoreCase("MO")) {
            cal.set(7, 2);
        } else if (weekDay.equalsIgnoreCase("TU")) {
            cal.set(7, 3);
        } else if (weekDay.equalsIgnoreCase("WE")) {
            cal.set(7, 4);
        } else if (weekDay.equalsIgnoreCase("TH")) {
            cal.set(7, 5);
        } else if (weekDay.equalsIgnoreCase("FR")) {
            cal.set(7, 6);
        } else if (weekDay.equalsIgnoreCase("SA")) {
            cal.set(7, 7);
        } else if (weekDay.equalsIgnoreCase("SU")) {
            cal.set(7, 1);
        } else {
            throw new IllegalArgumentException();
        }
        int requiredWeek = 1;
        if (week.equalsIgnoreCase("first")) {
            requiredWeek = 1;
        } else if (week.equalsIgnoreCase("second")) {
            requiredWeek = 2;
        } else if (week.equalsIgnoreCase("third")) {
            requiredWeek = 3;
        } else if (week.equalsIgnoreCase("fourth") || week.equalsIgnoreCase("last")) {
            requiredWeek = 4;
        } else {
            throw new IllegalArgumentException();
        }
        cal.set(8, requiredWeek);
        if (requiredWeek == 4 && cal.get(5) + 7 <= ((Calendar)cal).getActualMaximum(5)) {
            ((Calendar)cal).roll(5, 7);
        }
        if (startDate.after(cal.getTime())) {
            cal.set(5, 1);
            if (cal.get(2) == 11) {
                ((Calendar)cal).roll(1, true);
            }
            ((Calendar)cal).roll(2, true);
            return RecurrenceInfo.validateRecurrenceStartDate(cal.getTime(), week, weekDay);
        }
        return cal.getTime();
    }
}

